clear all;
% first row are 
% second row are  level 1 5 7 8
%nodes_avail={[357,20769,82497,328833];...
%             [81, 16641, 263169, 1050625]};
nodes_avail={[20763, 251481, 844682, 1622743];...
             [81, 16641, 263169, 1050625]};

sorter={'Cm', 'Px', 'Pxy', 'Prcm', 'PBrcm', 'frontm'};
ops=   {'multiply A*x', 'Gauss-Seidel fwd', 'Gauss-Seidel bwd'};


ncols=length(nodes_avail{1})

for prob=1:1
  for tnodes=1:ncols
    for i=1:length(sorter)
      nm{prob,tnodes,i}= sprintf('visual/visual_svn/cache_effects_Lame_Mats/Lame_Mat_%s_%07d_nodes.txt', ...
                     sorter{i}, nodes_avail{prob}(tnodes)); 
      
      %[bla,result]=system(['./test_sparse_cache_effects ',nm{prob,tnodes,i}]);
      [bla,result]=system(['./test_sparse_cache_effects ',nm{prob,tnodes,i}]);
      pattern=sprintf('time/multiply=[ ]*([0-9.e+-]*) [ ]*time/GS_fwd=[ ]*([0-9.e+-]*) [ ]*time/GS_bwd=[ ]*([0-9.e+-]*) [ ]*.*');
      for op=1:length(ops)
        t{prob,tnodes,op,i} = str2num(regexprep(result, pattern, ...
                                                sprintf('$%d',op)));
      end
    end    
  end
end

tfile=fopen('visual/Lame_cache_tables.tex','w');

for prob=1:1
  fprintf(tfile,'\\begin{tabular}{|c | *{%d}{r|}}\n',ncols);
  % write table
  for op=1:length(ops)
    fprintf(tfile,'  \\hline \n');
    fprintf(tfile,'  \\multicolumn{%d}{|c|}{%s} \\\\ \n', ...
            ncols+1, ops{op});
    fprintf(tfile,'  \\hline \n');
    fprintf(tfile,'  & \\multicolumn{%d}{|c|}{for \\#nodes} \\\\ \n', ...
            ncols);
    fprintf(tfile,'  \\hline \n');
    fprintf(tfile,'  ');
    for tnodes=1:ncols
      fprintf(tfile,'& %7d', nodes_avail{prob}(tnodes));
    end
    fprintf(tfile,'  \\\\ \n  \\hline \n');
    fprintf(tfile,'  \\hline \n');

    % absolute times for unsorted matrix
    fprintf(tfile,'  $t_{%s}$ ',sorter{1});
    for tnodes=1:ncols
      fprintf(tfile,'& %9.2e', t{prob,tnodes,op,1});
    end
    fprintf(tfile,' \\\\ \n  \\hline \n');

    % relative times for sorted matrix
    for i=2:length(sorter)
      fprintf(tfile,'  $t_{%s}/t_{%s}$ ',sorter{i},sorter{1});
      for tnodes=1:ncols
        fprintf(tfile,'& %6.4f', t{prob,tnodes,op,i}/t{prob,tnodes,op,1});
      end
      fprintf(tfile,' \\\\ \n  \\hline \n');
    end
  end
  fprintf(tfile,'\\end{tabular} \\\\ \n');
end
fclose(tfile);




