/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2013, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
#include "cubature.h"

int main()
{
  struct int_data tf;
  int err;
  FIDX tsubtypes[2]={1,1}, i,j,k,l;

  err= cubature_bases(2, 1, tria, 2, tsubtypes, &tf );

  if (err==SUCCESS)
    {
      printf("dim %d, type %d, num_subtypes %d, degree %d, num_points %d\n",
	     (int) tf.dim, tf.type, (int) tf.num_subtypes,
	     (int) tf.degree, (int) tf.num_points);
      printf("weight, [point]\n");
      for (i=0; i<tf.num_points; i++)
	{
	  printf("%6f , [",tf.weights[i]);
	  for(j=0; j<tf.dim; j++)
	    printf(" %6f ", tf.points[i*tf.dim+j]);
	  printf("]\n");
	}

      for (i=0;i<tf.num_subtypes;i++)
	{
	  FIDX num_basis;
	  num_basis=tf.bases[i]->num_basis;
	  printf("subtype_nr %d, subtype %d, num_basis %d \n", 
		 (int) i, (int) tf.bases[i]->subtype, (int) num_basis);

	  for (l=0; l<num_basis; l++)
	    {
	      printf("basis %d\nphi, [gradphi]\n", l);
	      for (j=0; j<tf.num_points; j++)
		{
		  printf("%6f , [",tf.bases[i]->phi[j*num_basis+l]);
		  for(k=0; k<tf.dim; k++)
		    printf(" %6f ",
			   tf.bases[i]->gradphi[j*num_basis*tf.dim
						+l*tf.dim+k]);
		  printf("]\n");
		}
	    }
	}
    }
  else
    {
      printf("error in cubature basis\n");
    }

  return 1;
}
    
