// modified from
// from http://www.vtk.org/pipermail/vtkusers/2006-July/085937.html
// to get closest point on stl surface
// compile and link with
// g++ -I/usr/include/vtk-5.8/ vtk_stl_closest_point.cpp  -lvtkCommon -lvtkIO -lvtkFiltering -o vtk_stl_closest_point
// -----------------------

#include "vtkCellLocator.h"
#include "vtkSTLReader.h"
#include "vtkSTLWriter.h"
#include "vtkPolyData.h"
#include "vtkPolyDataReader.h"
#include "vtkPolyDataNormals.h"
#include "vtkThinPlateSplineTransform.h"
#include "vtkTransformPolyDataFilter.h"
#include "vtkPointDataToCellData.h"
#include "vtkMath.h"

#include <fstream>
#include <iostream>


int main( int argc, char *argv[] )
{
  if (argc != 4) {
    cout << argv[0] <<": needs three filenames ..." << endl;
    cout << argv[0] <<" <.stl file In> <querry.qrx In> <querry.pnt Out>" << endl;
    cout << "Performs: for each point in querry file, locate closest point on .stl Surface and write modified points to file" << endl;
    return 1;
  }  

  int valid;
  
  ifstream ifile (argv[2]);
  if (! ifile.is_open())
    { cerr << argv[0] <<": Error opening querry file "<< argv[2] ; exit (1); }
  ofstream ofile (argv[3]);
  if (! ofile.is_open())
    { cerr << argv[0] <<": Error opening result file "<< argv[3] ; exit (1); }
  //out.open(strncat(argv[1],".txt",4), ios::out);

  // Read the surface to locate cloest points on.
  vtkSTLReader *stlReader = vtkSTLReader::New();
  stlReader->SetFileName(argv[1]);
  stlReader->Update();

  vtkCellLocator *cellLocator = vtkCellLocator::New();
  cellLocator->SetDataSet(stlReader->GetOutput());
  cellLocator->BuildLocator();


  ofile << std::scientific;

  int npoints=0;

  // two runs: edge-points, then face points 
  for (int run = 0; run<2 ; run++)
    {
      ifile >> npoints;

      ofile << npoints << endl;
      
      for (int i = 0; i < npoints; i++) 
	{
	  //  float dist, clospoint[3];
	  double dist, clospoint[3];
	  vtkIdType cellId;
	  int subId;

	  // read the point
	  double orig_point[3]={0.0, 0.0, 0.0};
	  int ID, geoTAG;
	  
	  ifile >> ID >> geoTAG >> orig_point[0] >> orig_point[1] >> orig_point[2];  
      
	  // Find closest point
	  cellLocator->FindClosestPoint(orig_point, clospoint, cellId, subId, dist); 

	  
	  // write result
	  ofile << ID << " ";
	  ofile << clospoint[0] << " " << clospoint[1] << " " <<  clospoint[2] ;
	  ofile << endl;
	} // for i=0; i<npoints
    } // for runs

  ifile.close();
  ofile.close(); 

  return 0;
}
