/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2013, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
elements.h
*/
#ifndef __ELEMENTS_H__
#define __ELEMENTS_H__ 1



#include "feins_macros.h"

#include "datastruc.h"


int eval_basis(FIDX dim, enum elemtype type, FIDX subtype, 
	       FIDX num_points, double points[], 
	       FIDX *num_basis, double **phi, double **gradphi,
	       double **hessphi
/* evaluate the basisfunctions phi and their gradients gradphi for the
   element type type at the given points points (which have to be in
   the appropriate masterelement) 

   Input:  dim    - dimension of space
           type   - type of the element (e.g. tria, see element types)
	   subtype- sub-type of the element, e.g. 1 for P_1 triangles,
 	            while 2 for P_2 triangles
	   num_points
	          - number of points for which the evaluation is wanted
	   points - array of dimension [num_points*dim] containing the
	            points where the basis function has to evaluated,
		    usage: points[i*dim+j] = j-th component of i-th point

   Output: num_basis
	          - number of basis functions for this element type,
		    via reference
	   phi    - pointer to array of dimension [num_points*num_basis]
                    containing the j-th basis function evaluated at
                    the i-th point as phi[i*num_basis+j],
		    via reference, array is created
	   gradphi- pointer to array of dimension [num_points*num_basis*dim]
                    containing the gradient of phi,
		    gradphi[i*num_basis*dim +j*dim +k],
		    the k-th component of the gradient of the j-th
		    basis function evaluated at the i-th point,
		    via reference, array is created
	   hessphi- pointer to array of dimension
	            [num_points*num_basis*dim*dim] containing the
	            Hessian of phi, 
		    hessphi[i*num_basis*dim*dim +j*dim*dim +k*dim +l],
		    is the derivative of the j-th basis function with
		    respect to the k-th and l-th spacial dimension,
		    evaluated at the i-th point, provided via
		    reference 

   Return: SUCCESS- succes
           FAIL   - failure, see error message
*/);
#endif
