/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2013, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
cubature.h
*/
#ifndef __CUBATURE_H__
#define __CUBATURE_H__ 1



#include "feins_macros.h"

#include "datastruc.h"


int cubature_formula(FIDX dim, FIDX degree, enum elemtype type, 
		     struct int_data *form
/* set int_data form to contain a integration formula for given
   dimension such that the formula integrates polynomials up to degree
   degree exact on the master element of element type type 

   Input:  dim    - dimension of space
           degree - up to which the formula has to be exact
           type   - type of the master element (see element types)

   Output: form   - the quadrature formula, given via reference

   Return: SUCCESS- success
           FAIL   - failure, see error message

   after succesful return form contains a formula such that

   I_elem = sum[i=1..num_points] weight[i]*func(points[i])
          = integral[master element] func(x)

   exact for all polynomials "func" of degree up to degree

   this can also be used to approximate this integral for other
   functions "func".
*/);

int cubature_bases(FIDX dim, FIDX degree, enum elemtype type,
		   FIDX num_subtypes, FIDX subtype[],  
		   struct int_data *form
/* set int_data form to contain a integration formula for given
   dimension such that the formula integrates polynomials up to degree
   degree exact on the master element of element type type, compute
   int_data_basis for the two element subtypes subtype1, subtype2

   Input:  dim    - dimension of space
           degree - up to which the formula has to be exact
           type   - type of the master element (see element types)
	   num_subtypes
                  - number of subtypes
	   subtype- vector of length num_subtypes, containing the
    	            subtypes to be considered, e.g. for triangular
    	            elements when the basis pair P_2 P_1 needed is
    	            then this would be the vector [2,1]

   Output: form   - the quadrature formula, given via reference
           form.bases 
	          - will contain a array of pointers to struct
              	    int_data_basis such that form.bases[i] points to a
              	    struct which holds the basis functions and their
              	    derivatives the subtype[i], evaluated at the
              	    quadrature points for 

   Return: SUCCESS- succes
           FAIL   - failure, see error message

   after succesful return form contains everything necessary to
   compute certain types of integrals on the elements by mapping the
   integrand to the master element and computing the integral there
*/);

int free_intdata( struct int_data *form 
/* free the elements of this data type such that the form itself can
   be deleted */);
#endif
