svg_string=['M 218.84375 104.65625 L 182.21875 108.78125 L 147.25 ' ...
            ' 108.78125 L 147.25 160.3125 L 157.65625 160.3125 ' ...
            'L 157.65625 138.40625 L 179.1875 138.40625 L 179.1875 ' ...
            '129.6875 L 157.65625 129.6875 L 157.65625 117.5 L ' ...
            '181.8125 117.5 L 186.65625 160.15625 L 224.90625 ' ...
            '155.8125 L 225.59375 160.71875 L 234.46875 159.46875 ' ...
            'L 243.53125 160.28125 L 246.5625 126.78125 L 264.25 ' ...
            '162.125 L 274.625 163.0625 L 275.34375 155.15625 C ' ...
            '276.2576 157.18164 277.4598 158.96537 279 160.4375 C ' ...
            '282.34031 163.60573 287.27351 165.33559 293.78125 ' ...
            '165.65625 C 298.25237 165.87654 302.00497 165.43681 ' ...
            '305.0625 164.34375 C 308.12112 163.22729 310.54696 ' ...
            '161.43177 312.3125 158.9375 C 314.07796 156.44325 ' ...
            '315.0109 153.7308 315.15625 150.78125 C 315.31652 ' ...
            '147.52738 314.77268 144.76852 313.5 142.5 C 312.25179 ' ...
            '140.20927 310.43472 138.35281 308.0625 136.96875 C ' ...
            '305.71475 135.56247 302.06001 134.16176 297.0625 ' ...
            '132.71875 C 292.06493 131.27579 288.91293 129.9461 ' ...
            '287.65625 128.78125 C 286.6689 127.86441 286.22095 ' ...
            '126.81105 286.28125 125.59375 C 286.34697 124.25946 ' ...
            '286.9543 123.21049 288.09375 122.46875 C 289.86372 ' ...
            '121.31232 292.26146 120.82002 295.28125 120.96875 C ' ...
            '298.20736 121.11295 300.35628 121.78934 301.75 123.03125 ' ...
            'C 303.16823 124.25101 304.02927 126.20791 304.34375 ' ...
            '128.875 L 314.75 128.9375 C 314.81907 124.20083 313.29392 ' ...
            '120.33777 310.15625 117.34375 C 307.04188 114.35104 ' ...
            '302.27337 112.69337 295.8125 112.375 C 291.85634 ' ...
            '112.18013 288.43038 112.60083 285.5625 113.65625 C ' ...
            '282.71798 114.7129 280.4862 116.34227 278.875 118.5625 ' ...
            'C 278.77837 118.69636 278.68497 118.83332 278.59375 ' ...
            '118.96875 L 279.25 111.71875 L 269.625 110.875 L ' ...
            '266.53125 145.15625 L 248.59375 108.96875 L 238.53125 ' ...
            '108.0625 L 234.6875 150.65625 L 228.71875 108.21875 L ' ...
            '219.40625 109.5625 L 218.84375 104.65625 z M 218.9375 ' ...
            '113.40625 L 223.6875 147.21875 L 196.03125 150.34375 ' ...
            'L 194.4375 136.40625 L 220.15625 133.5 L 219.1875 ' ...
            '124.875 L 193.46875 127.78125 L 192.1875 116.4375 L ' ...
            '218.9375 113.40625 z M 277.4375 131.96875 C 278.14501 ' ...
            '133.55347 279.15649 135.04628 280.53125 136.40625 C ' ...
            '282.67932 138.53018 286.49666 140.40691 292 142.0625 ' ...
            'C 296.2776 143.35272 299.02221 144.23744 300.21875 ' ...
            '144.71875 C 301.96667 145.43847 303.18412 146.25554 ' ...
            '303.84375 147.15625 C 304.52788 148.03475 304.84155 ' ...
            '149.06402 304.78125 150.28125 C 304.6878 152.17741 ' ...
            '303.74793 153.81251 301.96875 155.15625 C 300.21406 ' ...
            '156.47776 297.65997 157.07121 294.3125 156.90625 C ' ...
            '291.15225 156.75055 288.66927 155.80909 286.875 154.125 ' ...
            'C 285.10409 152.44208 284.00389 149.89307 283.5625 ' ...
            '146.46875 L 276.09375 146.84375 L 277.4375 131.96875 z'];
fname='feins_logo.f1m';

level0=0; level=0; ref_stop=0; ref_vx_max=1.0e6;

% break string up:
i=0;
while length(svg_string)>0
  % pull letter and all following numbers from string
  i=i+1;
  svg_obj.type{i}=svg_string(1);
  svg_string=svg_string(3:end);
  [A, count, errmsg, nextindex]=sscanf(svg_string, '%f');
  svg_obj.data{i}=A;
  svg_string=svg_string(nextindex:end);
end
svg_obj.len=i;

% turn every y-coordinate
for i=1:svg_obj.len
  C=svg_obj.data{i};
  C(2:2:end)=-C(2:2:end);
  svg_obj.data{i}=C;
end

% get bounding box
minC=[];
maxC=[];
for i=1:svg_obj.len
  D=svg_obj.data{i};
  C=[D(1:2:end),D(2:2:end)];
  minC=min([minC;C],[],1);
  maxC=max([maxC;C],[],1);
end

% determine shift and scale
shift=-minC;
if (maxC(1)-minC(1)<maxC(2)-minC(2))
  scale=1.0/(maxC(1)-minC(1));
else
  scale=1.0/(maxC(2)-minC(2));
end
  
% shift and scale to get bounding box close to [0,1]^2
for i=1:svg_obj.len
  D=svg_obj.data{i};
  if ~isempty(D)
    C=[D(1:2:end),D(2:2:end)];
    k=size(C,1);
    C=scale*(C+ones(k,1)*shift);
    D=reshape(C',[],1);
    svg_obj.data{i}=D;
  end
end


% plot for reverse engineering of format
figure(1); clf; hold on;
last=[];
for i=1:svg_obj.len
  C= svg_obj.data{i};
  if ~isempty(C) 
    plot(C(1:2:end),C(2:2:end),'*-');
    text(C(1)+2,C(2)+2,sprintf('%i %s', i, svg_obj.type{i}));
    new_last=C(end-1:end); 
    if ~isempty(last)
      plot([last(1),new_last(1)],[last(2),new_last(2)],'r-');
    end
    last=new_last;
  elseif (svg_obj.type{i}=='z')
      last=[];
  end
  %pause(1)
end

% store into mesh format
mesh.vertex=[];
mesh.shapepar=[];
mesh.boundary=[];
mesh.sseg=cell(0,1);
mesh.holes=[];
for i=1:svg_obj.len
  C= svg_obj.data{i};
  switch(svg_obj.type{i})
    case 'M',
      if (length(C)~=2) error('M: size C wrong'); end;
      mesh.vertex=[mesh.vertex;C'];
      last_vx=size(mesh.vertex,1);
      first_vx=last_vx;
      mesh.shapepar=[mesh.shapepar;C];
      last_sps=size(mesh.shapepar,1)-1;
      first_sps=last_sps;
    case 'L',
      if (length(C)~=2) error('L: size C wrong'); end;
      if (svg_obj.type{i+1}~='z')
        mesh.vertex=[mesh.vertex;C'];
        new_vx=size(mesh.vertex,1);
        mesh.shapepar=[mesh.shapepar;C];
        new_sps=size(mesh.shapepar,1)-1;
      else
        % end of loop, use first point of loop
        new_vx=first_vx;
        new_sps=first_sps;
      end
      
      mesh.sseg=[mesh.sseg; [last_sps, last_sps+1, new_sps, new_sps+1,...
                   last_vx]];
      new_seg=size(mesh.sseg,1);
      
      mesh.boundary=[mesh.boundary;[last_vx,new_vx,new_seg]];
      last_vx=new_vx;
      last_sps=new_sps;
    case 'C',
      if (length(C)~=6) error('C: size C wrong'); end;
      if (svg_obj.type{i+1}~='z')
        mesh.vertex=[mesh.vertex;C(5:6)'];
        new_vx=size(mesh.vertex,1);
        
        mesh.shapepar=[mesh.shapepar;...
                       C(1:2)-mesh.shapepar(last_sps:last_sps+1);...
                       C(5:6)-C(3:4);...
                       C(5:6)];
        new_inner=size(mesh.shapepar,1)-5;
        new_sps=size(mesh.shapepar,1)-1;
      else
        % end of loop, use first point of loop
        new_vx=first_vx;
        mesh.shapepar=[mesh.shapepar;...
                       C(1:2)-mesh.shapepar(last_sps:last_sps+1);...
                       C(5:6)-C(3:4)];
        new_inner=size(mesh.shapepar,1)-3;
        new_sps=first_sps;
      end
      
      mesh.sseg=[mesh.sseg; [last_sps, last_sps+1, new_sps, new_sps+1,...
                          new_inner:new_inner+3,...
                          last_vx ]];
      new_seg=size(mesh.sseg,1);
      
      mesh.boundary=[mesh.boundary;[last_vx,new_vx,new_seg]];
      last_vx=new_vx;
      last_sps=new_sps;    
    case 'z',
      if (length(C)~=0) error('z: size C wrong'); end;
      if (first_vx~=1)
        % this sub-path is a hole
        mesh.holes=[mesh.holes;1/3*(mesh.vertex(first_vx,:)+mesh.vertex(first_vx+1,:)+mesh.vertex(first_vx+2,:))];
      end
    otherwise,
      error('unknown type');
  end
end

for i=1:size(mesh.holes,1)
  adjust=1;
  while adjust
    plot(mesh.holes(i,1),mesh.holes(i,2),'go');
    text(mesh.holes(i,1)+2,mesh.holes(i,2)+2,sprintf('H %d',i));
    new_hole=input(sprintf(['Adjust position of hole #%d [%10.3e,%10.3e] ' ...
                        '(press only enter to skip/continue)?'],...
                          i, mesh.holes(i,1),mesh.holes(i,2)));
    if isempty(new_hole)
      adjust=0;
    else
      if (length(new_hole)==2)
        mesh.holes(i,:)=new_hole;
        adjust=1;
      else
        disp(['could not interpret input! enter new hole coordinates ' ...
              'as [x,y], or press enter to finish this hole']);
        adjust=1;
      end
    end
  end
end


% open the meshfile
mf=fopen(fname,'w');

fprintf(mf,[...
  '<!--mesh file for flow around an obstacle \n',...
  '-->\n',...
  '<header>\n',...y
  '	<format			 0 >\n',...
  '	<dim			 2>\n',...
  '	<problem		 0>\n',...
  '	<meshgen		 1>\n',...
  '	<vertex			 %d>\n',...
  '	<elements		 0>\n',...
  '	<boundary		 %d>\n',...
  '	<holes			 %d>\n',...
  '	<pcsurf			 0>\n',...
  '	<pcvol			 0>\n',...
  '	<pccrit			 0>\n',...
  '	<function		 2>\n',...
  '	<parameter		 0>\n',...
  '	<shape_seg		 %d>\n',...
  '	<shape_par		 %d>\n',...
  '</header>\n',...
  '\n'],...
        size(mesh.vertex,1),...
        size(mesh.boundary,1),...
        size(mesh.holes,1),...
        size(mesh.sseg,1),...
        size(mesh.shapepar,1));

fprintf(mf,[
  '<solver_settings>\n',...
  '	<refine_ini			 %d>\n',...
  '	<refine_type		 1>\n',...
  '	<refine_steps		 %d>\n',...
  '	<refine_stop		 %e>\n',...
  '	<refine_max_vx		 %e>\n',...
  '	<adap_mark			 2>\n',...
  '	<adap_mark_par		 0.700000>\n',...
  '	<solver				 1>\n',...
  '	<solver_atol		 1.000000e-12>\n',...
  '	<solver_ini_rtol	 1.000000e-06>\n',...
  '	<solver_ref_rtol	 1.000000e-02>\n',...
  '	<write_mesh			 1>\n',...
  '	<write_ssegs		 1>\n',...
  '</solver_settings>\n'],...
        level0, level, ref_stop, ref_vx_max);

fprintf(mf,[
  '\n',...
  '<!-- syntax of a vertex entry is:\n',...
  '				 id x y [z]\n',...
    '-->\n',...
  '<vertex>\n']);
for i=1:size(mesh.vertex,1)
  fprintf(mf,' %3d %22.15e %22.15e\n',   i-1, mesh.vertex(i,:));
end
fprintf(mf,[
  '</vertex>\n',...
    '\n',...
  '<!-- syntax of a element entry is:\n',...
  '		 id typ func nod1 nod2 ... nodk\n',...
  '-->\n',...
  '<elements>\n',...
  '</elements>\n',...
  '\n',...
  '\n',...
  '<!-- syntax of a boundary entry is:\n',...
  '		 id bctyp type func orient sseg nod1 ... nodk\n',...
  '-->\n',...
  '<boundary>\n']);
for i=1:size(mesh.boundary,1)
  fprintf(mf,'  %3d 1 0  0 1   %3d    %3d %3d\n',...
          i-1, mesh.boundary(i,3)-1,...
          mesh.boundary(i,1)-1, mesh.boundary(i,2)-1);
end
fprintf(mf,[
  '</boundary>\n',...
  '\n',...
  '<!-- syntax of a holes entry is:\n',...
  '		 id x y [z]\n',...
  '-->\n',...
  '<holes>\n']);
for i=1:size(mesh.holes,1)
  fprintf(mf,'  %3d   %22.15e %22.15e\n', ...
          i-1, mesh.holes(i,:));
end
fprintf(mf,[
  '</holes>\n',...
    '\n',...
  '\n',...
  '<!-- syntax of a pcsurf entry is:\n',...
  '		 id c_id orient nod1 ... nodk\n',...
  '-->\n',...
  '<pcsurf>\n']);
fprintf(mf,[
  '</pcsurf>\n',...
  '\n',...
  '<!-- syntax of a pcvol entry is:\n',...
  '		 id c_id elem\n',...
  '-->\n',...
  '<pcvol>\n',...
  '</pcvol>\n',...
  '\n',...
  '\n',...
  '<!-- syntax of a pccrit entry is:\n',...
  '		 id type data1 ...datak\n',...
    '-->\n',...
  '<pccrit>\n',...
  '</pccrit>\n',...
    '\n',...
  '\n',...
    '\n',...
  '<!-- syntax of a function entry is:\n',...
  '		 id type data1 ... datak\n',...
  '-->\n',...
  '<function>\n',...
  '  0 0  0.000000000000000e+00\n',...
           ]);
fprintf(mf,...
        '  1 0  %23.16e\n',...
        1.0);
fprintf(mf,[
  '</function>\n',...
  '\n',...
  '<rhsf>\n',...
  '  1\n',...
  '</rhsf>\n',...  
  '\n',...
  '<!-- syntax of a parameter entry is:\n',...
  '		 data1 ... datak\n',...
  '-->\n',...
  '<parameter>\n',...
  '</parameter>\n',...
  '\n\n',...
  '<!-- syntax of a shape_seg entry is:\n',...
  '	 id type nod1 para1 ... parak\n',...
  '-->\n',...
  '<shape_seg>\n']);
% oben
for i=1:size(mesh.sseg,1)
  switch (size(mesh.sseg{i},2))
    case 5,
      fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
              i-1, 1,...
              mesh.sseg{i}(5)-1,...
              mesh.sseg{i}(1)-1, mesh.sseg{i}(2)-1, mesh.sseg{i}(3)-1,...
              mesh.sseg{i}(4)-1);
    case 9,
      fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
              i-1, 2,...
              mesh.sseg{i}(9)-1,...
              mesh.sseg{i}(1)-1, mesh.sseg{i}(2)-1, mesh.sseg{i}(3)-1,...
              mesh.sseg{i}(4)-1, mesh.sseg{i}(5)-1, mesh.sseg{i}(6)-1,...
              mesh.sseg{i}(7)-1, mesh.sseg{i}(8)-1);
    otherwise,
      error(sprintf('unknown size, %d', size(mesh.sseg{i},2)));
  end
end
%			 id node1 x0,y0 x1,y1 sx0,sy0 sx1,sy1

fprintf(mf,[
  '</shape_seg>\n',...
  '\n']);
fprintf(mf,[
  '<!-- syntax of the shape_para entry is:\n',...
  '		 id data\n',...
  '-->\n',...
  '<shape_par>\n']);
for i=1:size(mesh.shapepar,1)
  fprintf(mf,' %3d %22.15e \n',  i-1,mesh.shapepar(i));
end
fprintf(mf,[
  '</shape_par>\n',...
  '\n' ]);
fclose(mf);
