
clear all;

na=1; nb=3;

level=3;  nu=0.1; % later
%level=4; nu=0.05;
  
 
histfile=sprintf('../build/visual/tobs_eval_hist_%d_%d_%d_%f_movie1.mat',...
                 na,nb,level,nu);


disp('load histfile');
load(histfile);
disp('done load histfile');
 

n=length(crit_evals)

disp('warning: limit to first 153 evals'),
n=min([n,153]);

crit_vec=zeros(n,2);
% make vector from cell
for i=1:n
  crit_vec(i,:)=crit_evals{i}';
end



figure(1)
clf;
plot(1:n,crit_vec(1:n,1))

% filter out decreasing sequence (successful steps)

% list of successful indices, initialise to -1, length=:ns=0
crit_success=-ones(n,1);
ns=0;

last=crit_vec(1,1)+100;
for i=1:n;
  if crit_vec(i,1)<last
    ns=ns+1;
    
    crit_success(ns)=i;
    last=crit_vec(i,1);
  end
end

crit_success=crit_success(1:ns);

hold on;
plot(crit_success,crit_vec(crit_success,1),'r+-')
legend({'all evals';'successful steps'})
title(sprintf('tobst history, nu=%7.1e',nu));
xlabel('evaluation number')
ylabel('performance criterion')
figfontifier(gcf,15)

figure(2)
plot(crit_success,crit_vec(crit_success,1),'r+-')
legend({'successful steps'})
title(sprintf('tobst history, nu=%7.1e',nu));
xlabel('evaluation number')
ylabel('performance criterion')
figfontifier(gcf,15)

time_list_name=[histfile,'__time_list'];
tfile=fopen(time_list_name,'w');
for i=1:ns
  fprintf(tfile,'        <Element index="%d" value="%d"/>\n',i-1,crit_success(i));
end
fclose(tfile);

file_list_name=[histfile,'__file_list'];
ffile=fopen(file_list_name,'w');
for i=1:ns
  fprintf(ffile,'        <Element index="%d" value="tobs_movie_%d_%d_%d_%f_%03d.vtk"/>\n',i-1,na,nb,level,nu,crit_success(i));
end
fclose(ffile);
 
!cp tobst_movie_1_3_3_0.100000_template.pvsm ../build/visual/tobst_movie_1_3_3_0.100000_gen.pvsm

command=sprintf(...
'pushd ../build/visual; sed -e"s+##_FILE_LIST_##+$(sed -e"s_\\"_\\\\\\\\\\"_g" -e"s_\\$_\\\\n_" tobs_eval_hist_1_3_3_0.100000_movie1.mat__file_list|tr -d "\\n")+" tobst_movie_1_3_3_0.100000_gen.pvsm -e"s+##_TIME_LIST_##+$(sed -e"s_\\"_\\\\\\\\\\"_g" -e"s_\\$_\\\\n_" tobs_eval_hist_1_3_3_0.100000_movie1.mat__time_list|tr -d "\\n")+" -e"s+##_END_STEP_##+%d+" -e"s+##_END_TIME_##+%d+" >output.pvsm ;popd',...
    ns, crit_success(ns)),
system(command);


