% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************


global write_fem_fvm;

n=length(xi);

if n<2
  error('n<2 not supported in this version');
end

dc_dxi=zeros(1,n);

if write_fem_fvm==1
  global fem_par;
  
  crit=load('divider_n.f1m_crit');
  DIDF=load('divider_n.f1m_grad');
  paras=fem_par-1;
else
  % load the output of the solver
  crit=load('visual/crit.txt');
  DIDF=load('visual/DIDF.txt');
  paras=load('visual/paras.txt');
end

% each parameter is uniquely defined as the top parameter of the
% bid-5 block, where bid marks a criterion defining block,
% !! attention !! the blocks bid-(1:4) top parameters depend on
%                 xi(i-1) as well for i>1, but the bid-4 one is
%                 already accounted for 
bid=14;
for i=1:n
  for j=2:i
    bid=bid+3;
  end
  % paras stores in order [left, bottom, right, top]

  dc_dxi(i)=DIDF(paras(bid-5+1,4)+1);
  
  if i>1    
    dc_dxi(i-1)=dc_dxi(i-1)+sum(DIDF(paras(bid-(1:3)+1,4)+1));
  end
  
  bid=bid+11;
end


