function [rpar0,Aspar,bspar]=projekt_probek4_gen(fname,level0,level,ref_stop,...
	 ref_vx_max,alpha,rpar_in,Aspar,bspar)

%generates a mesh file fname
%return:
%	 rpar0	-	 the initial parameters of the geometry, the vector to be optimised
%	 Aspar
%	 bspar	-	 spar=Aspar*rpar+bspar gives the parameter in the meshfile in depandence on the actual parameters


if nargout>1
	 rpar0=[
		  5.323029366306029e+00
		  6.460587326120555e-01
		  4.647089129314796e-01
		 -3.853683668212260e-01
		  5.561051004636787e+00
		 -5.440494590417311e-01
		  3.853683668212282e-01
		 -3.513652756311183e-01
		  5.096342091705307e+00
		 -6.573930963420915e-01
		 -1.926841834106110e-01
		  4.420401854714067e-01
		  4.903657908294695e+00
		  3.967027305512625e-01
		 -4.193714580113346e-01
		  9.067490984028881e-02
			];

	 Aspar=spalloc(52,16,16);
	 bspar=spalloc(52,1,36);
	 Aspar(9,1)= 1.000000000000000e+00;
	 Aspar(10,2)= 1.000000000000000e+00;
	 Aspar(11,3)= 1.000000000000000e+00;
	 Aspar(12,4)= 1.000000000000000e+00;
	 Aspar(13,5)= 1.000000000000000e+00;
	 Aspar(14,6)= 1.000000000000000e+00;
	 Aspar(15,7)= 1.000000000000000e+00;
	 Aspar(16,8)= 1.000000000000000e+00;
	 Aspar(37,9)= 1.000000000000000e+00;
	 Aspar(38,10)= 1.000000000000000e+00;
	 Aspar(39,11)= 1.000000000000000e+00;
	 Aspar(40,12)= 1.000000000000000e+00;
	 Aspar(41,13)= 1.000000000000000e+00;
	 Aspar(42,14)= 1.000000000000000e+00;
	 Aspar(43,15)= 1.000000000000000e+00;
	 Aspar(44,16)= 1.000000000000000e+00;

	 bspar(2,1)= 1.000000000000000e+00;
	 bspar(5,1)= 2.000000000000000e+00;
	 bspar(6,1)= 1.000000000000000e+00;
	 bspar(7,1)= 1.000000000000000e+00;
	 bspar(17,1)= 8.000000000000000e+00;
	 bspar(18,1)= 1.000000000000000e+00;
	 bspar(19,1)= 1.000000000000000e+00;
	 bspar(21,1)= 1.000000000000000e+01;
	 bspar(22,1)= 1.000000000000000e+00;
	 bspar(25,1)= 1.000000000000000e+01;
	 bspar(28,1)=-5.000000000000000e-01;
	 bspar(29,1)= 1.000000000000000e+01;
	 bspar(30,1)=-1.000000000000000e+00;
	 bspar(33,1)= 8.000000000000000e+00;
	 bspar(34,1)=-1.000000000000000e+00;
	 bspar(35,1)=-1.000000000000000e+00;
	 bspar(45,1)= 2.000000000000000e+00;
	 bspar(46,1)=-1.000000000000000e+00;
	 bspar(47,1)=-1.849562081401340e+00;
	 bspar(48,1)= 0.0;
	 bspar(50,1)=-1.000000000000000e+00;



else

	 rpar=rpar_in;

	 nspar=size(Aspar,1);
	 spar= Aspar*rpar+bspar;

	 % open the meshfile
	 mf=fopen(fname,'w');

	 fprintf(mf,[...
		 '<!--mesh file for flow around an obstacle \n',...
		 '-->\n',...
		 '<header>\n',...y
		 '	<format			 0 >\n',...
		 '	<dim			 2>\n',...
		 '	<problem		 3>\n',...
		 '	<meshgen		 1>\n',...
		 '	<vertex			 13>\n',...
		 '	<elements		 0>\n',...
		 '	<boundary		 15>\n',...
		 '	<holes			 0>\n',...
		 '	<pcsurf			 0>\n',...
		 '	<pcvol			 0>\n',...
		 '	<pccrit			 1>\n',...
		 '	<function		 2>\n',...
		 '	<parameter		 2>\n',...
		 '	<shape_seg		15>\n',...
		 '	<shape_par		 %d>\n',...
		 '</header>\n',...
		'\n'],...
		 nspar);

		 fprintf(mf,[
		 '<solver_settings>\n',...
		 '	<refine_ini			 %d>\n',...
		 '	<refine_type		 1>\n',...
		 '	<refine_steps		 %d>\n',...
		 '	<refine_stop		 %e>\n',...
		 '	<refine_max_vx		 %e>\n',...
		 '	<adap_mark			 2>\n',...
		 '	<adap_mark_par		 0.700000>\n',...
		 '	<solver				 3>\n',...
		 '	<solver_atol		 1.000000e-12>\n',...
		 '	<solver_ini_rtol	 1.000000e-06>\n',...
		 '	<solver_ref_rtol	 1.000000e-02>\n',...
		 '	<write_mesh			 1>\n',...
		 '	<write_ssegs		 1>\n',...
		 '</solver_settings>\n'],...
				 level0, level, ref_stop, ref_vx_max);

		 fprintf(mf,[
		 '\n',...
		 '<!-- syntax of a vertex entry is:\n',...
		 '				 id x y [z]\n',...
		 '-->\n',...
		 '<vertex>\n']);
		 fprintf(mf,' %3d %22.15e %22.15e\n',   0, spar(  1),spar(  2));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   1, spar(  5),spar(  6));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   2, spar(  9),spar( 10));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   3, spar( 13),spar( 14));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   4, spar( 17),spar( 18));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   5, spar( 21),spar( 22));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   6, spar( 25),spar( 26));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   7, spar( 29),spar( 30));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   8, spar( 33),spar( 34));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   9, spar( 37),spar( 38));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  10, spar( 41),spar( 42));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  11, spar( 45),spar( 46));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  12, spar( 49),spar( 50));
		 fprintf(mf,[
		 '</vertex>\n',...
		 '\n',...
		 '<!-- syntax of a element entry is:\n',...
		 '		 id typ func nod1 nod2 ... nodk\n',...
		 '-->\n',...
		 '<elements>\n',...
		 '</elements>\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a boundary entry is:\n',...
		 '		 id bctyp type func orient sseg nod1 ... nodk\n',...
		 '-->\n',...
		 '<boundary>\n']);
		 fprintf(mf,'  0 0 0  -1 1   0   0   1\n');
		 fprintf(mf,'  1 0 0  -1 1   1   1   2\n');
		 fprintf(mf,'  2 0 0  -1 1   2   2   3\n');
		 fprintf(mf,'  3 0 0  -1 1   3   3   4\n');
		 fprintf(mf,'  4 0 0  -1 1   4   4   5\n');
		 fprintf(mf,'  5 2 0   1 1   5   5   6\n');
		 fprintf(mf,'  6 2 0   1 1   6   6   7\n');
		 fprintf(mf,'  7 0 0  -1 1   7   7   8\n');
		 fprintf(mf,'  8 0 0  -1 1   8   8   9\n');
		 fprintf(mf,'  9 0 0  -1 1   9   9  10\n');
		 fprintf(mf,' 10 0 0  -1 1  10  10  11\n');
		 fprintf(mf,' 11 0 0  -1 1  11  11  12\n');
		 fprintf(mf,' 12 1 0   0 1  12  12   0\n');
		 fprintf(mf,' 13 -1 0  -1 1  13   2  10\n');
		 fprintf(mf,' 14 -1 0  -1 1  14   3   9\n');
		 fprintf(mf,[
		 '</boundary>\n',...
		 '\n',...
		 '<!-- syntax of a holes entry is:\n',...
		 '		 id x y [z]\n',...
		 '-->\n',...
		 '<holes>\n']);
		 fprintf(mf,[
		 '</holes>\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a pcsurf entry is:\n',...
		 '		 id c_id orient nod1 ... nodk\n',...
		 '-->\n',...
		 '<pcsurf>\n']);
		 fprintf(mf,[
		 '</pcsurf>\n',...
		 '\n',...
		 '<!-- syntax of a pcvol entry is:\n',...
		 '		 id c_id elem\n',...
		 '-->\n',...
		 '<pcvol>\n',...
		 '</pcvol>\n',...
				 '\n',...
		 '\n',...
		 '<!-- syntax of a pccrit entry is:\n',...
		 '		 id type data1 ...datak\n',...
		 '-->\n',...
		 '<pccrit>\n',...
         '   0 14   13 14   1.0e6  1.0e6  0.0 \n',...
		 '</pccrit>\n',...
		 '\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a function entry is:\n',...
		 '		 id type data1 ... datak\n',...
		 '-->\n',...
		 '<function>\n',...
		 '  0 100  0.000000000000000e+00  0.000000000000000e+00\n',...
		 '  1 100  1.000000000000000e+04  0.000000000000000e+00\n',...
		 '</function>\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a parameter entry is:\n',...
		 '		 data1 ... datak\n',...
		 '-->\n',...
		 '<parameter>\n',...
		 ' 1.150000000000000e+05 	 7.700000000000000e+04 	\n',...
		 '</parameter>\n',...
		 '\n\n',...
		 '<!-- syntax of a shape_seg entry is:\n',...
		 '		 id type nod1 para1 ... parak\n',...
		 '-->\n',...
		 '<shape_seg>\n']);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						   0, 1,   0,   0,   1,   4,   5);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
						   1, 2,   1,   4,   5,   8,   9,   6,   7,  10,  11);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
						   2, 2,   2,   8,   9,  12,  13,  10,  11,  14,  15);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
						   3, 2,   3,  12,  13,  16,  17,  14,  15,  18,  19);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						   4, 1,   4,  16,  17,  20,  21);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						   5, 1,   5,  20,  21,  24,  25);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						   6, 1,   6,  24,  25,  28,  29);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						   7, 1,   7,  28,  29,  32,  33);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
						   8, 2,   8,  32,  33,  36,  37,  34,  35,  38,  39);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
						   9, 2,   9,  36,  37,  40,  41,  38,  39,  42,  43);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
						  10, 2,  10,  40,  41,  44,  45,  42,  43,  46,  47);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						  11, 1,  11,  44,  45,  48,  49);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						  12, 1,  12,  48,  49,   0,   1);
         fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						  13, 1,   2,   8,   9,  40,  41);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
						  14, 1,   3,  12,  13,  36,  37);
         
%			 id node1 x0,y0 x1,y1 sx0,sy0 sx1,sy1

		 fprintf(mf,[
		 '</shape_seg>\n',...
		 '\n']);
		 fprintf(mf,[
		 '<!-- syntax of the shape_para entry is:\n',...
		 '		 id data\n',...
		 '-->\n',...
		 '<shape_par>\n']);
		 fprintf(mf,' %3d %22.15e \n',  0,spar(  1));
		 fprintf(mf,' %3d %22.15e \n',  1,spar(  2));
		 fprintf(mf,' %3d %22.15e \n',  2,spar(  3));
		 fprintf(mf,' %3d %22.15e \n',  3,spar(  4));
		 fprintf(mf,' %3d %22.15e \n',  4,spar(  5));
		 fprintf(mf,' %3d %22.15e \n',  5,spar(  6));
		 fprintf(mf,' %3d %22.15e \n',  6,spar(  7));
		 fprintf(mf,' %3d %22.15e \n',  7,spar(  8));
		 fprintf(mf,' %3d %22.15e \n',  8,spar(  9));
		 fprintf(mf,' %3d %22.15e \n',  9,spar( 10));
		 fprintf(mf,' %3d %22.15e \n', 10,spar( 11));
		 fprintf(mf,' %3d %22.15e \n', 11,spar( 12));
		 fprintf(mf,' %3d %22.15e \n', 12,spar( 13));
		 fprintf(mf,' %3d %22.15e \n', 13,spar( 14));
		 fprintf(mf,' %3d %22.15e \n', 14,spar( 15));
		 fprintf(mf,' %3d %22.15e \n', 15,spar( 16));
		 fprintf(mf,' %3d %22.15e \n', 16,spar( 17));
		 fprintf(mf,' %3d %22.15e \n', 17,spar( 18));
		 fprintf(mf,' %3d %22.15e \n', 18,spar( 19));
		 fprintf(mf,' %3d %22.15e \n', 19,spar( 20));
		 fprintf(mf,' %3d %22.15e \n', 20,spar( 21));
		 fprintf(mf,' %3d %22.15e \n', 21,spar( 22));
		 fprintf(mf,' %3d %22.15e \n', 22,spar( 23));
		 fprintf(mf,' %3d %22.15e \n', 23,spar( 24));
		 fprintf(mf,' %3d %22.15e \n', 24,spar( 25));
		 fprintf(mf,' %3d %22.15e \n', 25,spar( 26));
		 fprintf(mf,' %3d %22.15e \n', 26,spar( 27));
		 fprintf(mf,' %3d %22.15e \n', 27,spar( 28));
		 fprintf(mf,' %3d %22.15e \n', 28,spar( 29));
		 fprintf(mf,' %3d %22.15e \n', 29,spar( 30));
		 fprintf(mf,' %3d %22.15e \n', 30,spar( 31));
		 fprintf(mf,' %3d %22.15e \n', 31,spar( 32));
		 fprintf(mf,' %3d %22.15e \n', 32,spar( 33));
		 fprintf(mf,' %3d %22.15e \n', 33,spar( 34));
		 fprintf(mf,' %3d %22.15e \n', 34,spar( 35));
		 fprintf(mf,' %3d %22.15e \n', 35,spar( 36));
		 fprintf(mf,' %3d %22.15e \n', 36,spar( 37));
		 fprintf(mf,' %3d %22.15e \n', 37,spar( 38));
		 fprintf(mf,' %3d %22.15e \n', 38,spar( 39));
		 fprintf(mf,' %3d %22.15e \n', 39,spar( 40));
		 fprintf(mf,' %3d %22.15e \n', 40,spar( 41));
		 fprintf(mf,' %3d %22.15e \n', 41,spar( 42));
		 fprintf(mf,' %3d %22.15e \n', 42,spar( 43));
		 fprintf(mf,' %3d %22.15e \n', 43,spar( 44));
		 fprintf(mf,' %3d %22.15e \n', 44,spar( 45));
		 fprintf(mf,' %3d %22.15e \n', 45,spar( 46));
		 fprintf(mf,' %3d %22.15e \n', 46,spar( 47));
		 fprintf(mf,' %3d %22.15e \n', 47,spar( 48));
		 fprintf(mf,' %3d %22.15e \n', 48,spar( 49));
		 fprintf(mf,' %3d %22.15e \n', 49,spar( 50));
		 fprintf(mf,' %3d %22.15e \n', 50,spar( 51));
		 fprintf(mf,' %3d %22.15e \n', 51,spar( 52));
		 fprintf(mf,[
		 '</shape_par>\n',...
		 '\n' ]);
		 fclose(mf);
end

return;