function [rpar0,Aspar,bspar]=probek5_gen(fname,level0,level,ref_stop,...
	 ref_vx_max,alpha,rpar_in,Aspar,bspar)

%generates a mesh file fname
%return:
%	 rpar0	-	 the initial parameters of the geometry, the vector to be optimised
%	 Aspar
%	 bspar	-	 spar=Aspar*rpar+bspar gives the parameter in the meshfile in depandence on the actual parameters

fix_spar_6=1;
%fix_spar_7=-fix_spar_6

if nargout>1
	 rpar0=[
           80
           5
           65
           15
           5
           0
           0.4
           83
           0.3
           90
           3
           1
           2
           3
           1
           1
               ];

	 Aspar=spalloc(40,16,17);
	 bspar=spalloc(40,1,7+4);
	 Aspar(9:14,1:6)= speye(6);
         Aspar(17,8) = 1.0;
	 Aspar(20:24,10:14)= speye(5);
         
         Aspar(40,1)     = -1.0;
	 Aspar(25:29,2:6)= -speye(5);
         Aspar(32,8) = -1.0;
	 Aspar(35:39,10:14)= -speye(5);
         
	 bspar(26,1)= 150;
	 bspar(32,1)= 150;
	 bspar(35,1)= 150;
	 bspar(40,1)= 150;

	 bspar(2,1) =  10;
	 bspar(3,1) = -10;
	 bspar(4,1) =  50;
	 bspar(5,1) = 100;
         bspar(6,1) = 150;
	 bspar(7,1) = fix_spar_6;
	 bspar(8,1) = -fix_spar_6;
else

	 rpar=rpar_in;

	 nspar=size(Aspar,1);
	 spar= Aspar*rpar+bspar;

         spar(15:16)=  rpar(7)*[rpar(8)-rpar(1); -2*fix_spar_6];
         spar(30:31)= -spar(15:16);

         spar(18:19)=  rpar(9)*[rpar(8)-rpar(1); -2*fix_spar_6];
         spar(33:34)= -spar(18:19);
         
         spar=spar/10;
         
         BC_force=rpar(15:16);

	 % open the meshfile
	 mf=fopen(fname,'w');

	 fprintf(mf,[...
		 '<!--mesh file for flow around an obstacle \n',...
		 '-->\n',...
		 '<header>\n',...y
		 '	<format			 0 >\n',...
		 '	<dim			 2>\n',...
		 '	<problem		 3>\n',...
		 '	<meshgen		 1>\n',...
		 '	<vertex			 16>\n',...
		 '	<elements		 0>\n',...
		 '	<boundary		 18>\n',...
		 '	<holes			 0>\n',...
		 '	<pcsurf			 0>\n',...
		 '	<pcvol			 0>\n',...
		 '	<pccrit			 1>\n',...
		 '	<function		 2>\n',...
		 '	<parameter		 2>\n',...
		 '	<shape_seg		 18>\n',...
		 '	<shape_par		 %d>\n',...
		 '</header>\n',...
		'\n'],...
		 nspar);

		 fprintf(mf,[
		 '<solver_settings>\n',...
		 '	<refine_ini			 %d>\n',...
		 '	<refine_type		 1>\n',...
		 '	<refine_steps		 %d>\n',...
		 '	<refine_stop		 %e>\n',...
		 '	<refine_max_vx		 %e>\n',...
		 '	<adap_mark			 2>\n',...
		 '	<adap_mark_par		 0.700000>\n',...
		 '	<solver				 3>\n',...
		 '	<solver_atol		 1.000000e-12>\n',...
		 '	<solver_ini_rtol	 1.000000e-06>\n',...
		 '	<solver_ref_rtol	 1.000000e-02>\n',...
		 '	<write_mesh			 1>\n',...
		 '	<write_ssegs		 1>\n',...
		 '</solver_settings>\n'],...
				 level0, level, ref_stop, ref_vx_max);

		 fprintf(mf,[
		 '\n',...
		 '<!-- syntax of a vertex entry is:\n',...
		 '				 id x y [z]\n',...
		 '-->\n',...
		 '<vertex>\n']);
		 fprintf(mf,' %3d %22.15e %22.15e\n',   0, spar(  1),spar(  2));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   1, spar(  4),spar(  2));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   2, spar( 11),spar( 12));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   3, spar(  9),spar(  7));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   4, spar( 17),spar(  8));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   5, spar( 20),spar( 21));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   6, spar(  5),spar(  2));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   7, spar(  6),spar(  2));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   8, spar(  6),spar(  3));
		 fprintf(mf,' %3d %22.15e %22.15e\n',   9, spar(  5),spar(  3));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  10, spar( 26),spar( 27));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  11, spar( 40),spar(  8));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  12, spar( 32),spar(  7));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  13, spar( 35),spar( 36));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  14, spar(  4),spar(  3));
		 fprintf(mf,' %3d %22.15e %22.15e\n',  15, spar(  1),spar(  3));
		 fprintf(mf,[
		 '</vertex>\n',...
		 '\n',...
		 '<!-- syntax of a element entry is:\n',...
		 '		 id typ func nod1 nod2 ... nodk\n',...
		 '-->\n',...
		 '<elements>\n',...
		 '</elements>\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a boundary entry is:\n',...
		 '		 id bctyp type func orient sseg nod1 ... nodk\n',...
		 '-->\n',...
		 '<boundary>\n']);
		 fprintf(mf,'  0 0 0  -1 1   0   0   1\n');
		 fprintf(mf,'  1 0 0  -1 1   1   1   2\n');
		 fprintf(mf,'  2 0 0  -1 1   2   2   3\n');
		 fprintf(mf,'  3 0 0  -1 1   3   3   4\n');
		 fprintf(mf,'  4 0 0  -1 1   4   4   5\n');
		 fprintf(mf,'  5 0 0  -1 1   5   5   6\n');
		 fprintf(mf,'  6 0 0  -1 1   6   6   7\n');
		 fprintf(mf,'  7 0 0  -1 1   7   8   9\n');
		 fprintf(mf,'  8 0 0  -1 1   8   9  10\n');
		 fprintf(mf,'  9 0 0  -1 1   9  10  11\n');
		 fprintf(mf,' 10 0 0  -1 1  10  11  12\n');
		 fprintf(mf,' 11 0 0  -1 1  11  12  13\n');
		 fprintf(mf,' 12 0 0  -1 1  12  13  14\n');
		 fprintf(mf,' 13 0 0  -1 1  13  14  15\n');
                 %Diri:
		 fprintf(mf,' 14 1 0   0 1  14  15   0\n');
                 %Neumann:
		 fprintf(mf,' 15 2 0   1 1  15   7   8\n');
                 %Fake:
		 fprintf(mf,' 16 -1 0 -1 1  16   3  12\n');
		 fprintf(mf,' 17 -1 0 -1 1  17   4  11\n');
		 fprintf(mf,[
		 '</boundary>\n',...
		 '\n',...
		 '<!-- syntax of a holes entry is:\n',...
		 '		 id x y [z]\n',...
		 '-->\n',...
		 '<holes>\n']);
		 fprintf(mf,[
		 '</holes>\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a pcsurf entry is:\n',...
		 '		 id c_id orient nod1 ... nodk\n',...
		 '-->\n',...
		 '<pcsurf>\n']);
		 fprintf(mf,[
		 '</pcsurf>\n',...
		 '\n',...
		 '<!-- syntax of a pcvol entry is:\n',...
		 '		 id c_id elem\n',...
		 '-->\n',...
		 '<pcvol>\n',...
		 '</pcvol>\n',...
				 '\n',...
		 '\n',...
		 '<!-- syntax of a pccrit entry is:\n',...
		 '		 id type data1 ...datak\n',...
		 '-->\n',...
		 '<pccrit>\n',...
                   '   0 14   16 17   0.0e2  0.0e2  1.0e2 \n',...
		 '</pccrit>\n',...
		 '\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a function entry is:\n',...
		 '		 id type data1 ... datak\n',...
		 '-->\n',...
		 '<function>\n',...
		 '  0 100  0.000000000000000e+00  0.000000000000000e+00\n',...
                            ]);
		 fprintf(mf,...
                 '  1 100  %23.16e  %23.16e\n',...
                         BC_force(1), BC_force(2)); 
		 fprintf(mf,[
		 '</function>\n',...
		 '\n',...
		 '\n',...
		 '<!-- syntax of a parameter entry is:\n',...
		 '		 data1 ... datak\n',...
		 '-->\n',...
		 '<parameter>\n',...
		 ' 1.150000000000000e+05 	 7.700000000000000e+04 	\n',...
		 '</parameter>\n',...
		 '\n\n',...
		 '<!-- syntax of a shape_seg entry is:\n',...
		 '	 id type nod1 para1 ... parak\n',...
		 '-->\n',...
		 '<shape_seg>\n']);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         0, 1,   0,   0,   1,   3,   1);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         1, 2,   1,   3,   1,  10,  11,    9,   0,  12,  13);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         2, 2,   2,  10,  11,   8,   6,   12,  13,  14,  15);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         3, 1,   3,   8,   6,  16,   7);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         4, 2,   4,  16,   7,  19,  20,   17,  18,  21,  22);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         5, 2,   5,  19,  20,   4,   1,   21,  22,  23,   0);
                 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         6, 1,   6,   4,   1,   5,   1);

                 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         7, 1,   8,   5,   2,   4,   2);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         8, 2,   9,   4,   2,  25,  26,   24,   0,  27,  28);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         9, 2,  10,  25,  26,  39,   7,   27,  28,  29,  30);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         10, 1, 11,  39,   7,  31,   6);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         11, 2, 12,  31,   6,  34,  35,   32,  33,  36,  37);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n',...
                         12, 2, 13,  34,  35,   3,   2,   36,  37,  38,   0);
                 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         13, 1, 14,   3,   2,   0,   2);
                 

                 % Diri and Neumann
                 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         14, 1,  0,   0,   1,   0,   2);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         15, 1,  7,   5,   1,   5,   2);
                 
                 % Fake boundary
                 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         16, 1,  3,   8,   6,  31,   6);
		 fprintf(mf,' %3d %d %3d %3d %3d %3d %3d\n',...
                         17, 1,  4,  16,   7,  39,   7);
                 
%			 id node1 x0,y0 x1,y1 sx0,sy0 sx1,sy1

		 fprintf(mf,[
		 '</shape_seg>\n',...
		 '\n']);
		 fprintf(mf,[
		 '<!-- syntax of the shape_para entry is:\n',...
		 '		 id data\n',...
		 '-->\n',...
		 '<shape_par>\n']);
                 for i=1:nspar
                   fprintf(mf,' %3d %22.15e \n',  i-1,spar(  i));
                 end
		 fprintf(mf,[
		 '</shape_par>\n',...
		 '\n' ]);
		 fclose(mf);
end

return;