% ***********************************************************************
%
%    This file is part of
%    FEINS-GUI, a Matlab GUI for defining 2D parametric shape
%    optimisation problems for the Finite Element solver suite
%    FEINS,   http://feins.org
%
%    Copyright (C) 2011, Tom Waldenburger 
%    <tom.waldenburger@s2006.tu-chemnitz.de>
% 
%    Start it with "Feins" from inside Matlab.
%
%    Tom Waldenburger wrote this programm as part of his Diploma
%    thesis, supervised by Rene Schneider (main author of FEINS)
%    <rene.schneider@mathematik.tu-chemnitz.de>.
% 
%    This program is released into the PUBLIC DOMAIN:
%    you can use, redistribute and/or modify it in any way you
%    like. However, you should not remove or obscure this copyright
%    notice.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
% 
% ***********************************************************************

function [crit]=generic_eval(rpar)
%
%evaluates the criteria + derivatives for the support with hole problem 
%
%if rpar is empty a setup step is done instead, setting global
%variables: rpar0, Aspar, bspar, Crpar, drpar,
%					 creating a meshfile and reference solution
%

%problem defining globals, don't change
global Aspar; global bspar; 
global level0; global level; global ref_stop; global ref_vx_max; global alpha;
global histfile;


%changing globals
global last_c; global last_dc;
global rpar0; global rpar1; global last_reinit;


global gen_name; % bsp: gen_name='projekt_pedcrank2_gen';
global basedir;


global P; global s;
global az_ges; global az_constr; global az_large; global az_old;

max_step=1000,%1e-0;

%basedir='/tmp/';
basedir='/LOCAL/rschneid/tmp/';


az_ges=az_ges+1;
if isempty(rpar)
    % create directory
    mkdircommand=['mkdir -p ',basedir,gen_name,'/visual/'];
    system(mkdircommand);
    
    %copy test_lame_adj
    %cpcommand=['cp ~/test_lame_adj ',basedir,gen_name];
    cpcommand=['cp ~/test_lame_adj ',basedir,gen_name];
    bla=system(cpcommand);
    if (bla~=0)
      error(['copy command failed: ', cpcommand]);
    end
    
    
	 [rpar0,Aspar,bspar]=feval(gen_name,[basedir,gen_name,'/visual/',gen_name,'_eval.f1m'],...
					 level0,level,ref_stop,ref_vx_max,alpha);
     file_sys=[basedir,gen_name,'/system.mat'];
     save(file_sys,'P','s','Aspar','bspar');           
                 
	 rpar=rpar0;

	 pause(0);

	 histfile=sprintf([basedir,gen_name,'/visual/',gen_name,'_hist_%d_%d_%f.mat'],...
					 level0,level,alpha);

	 if(exist(histfile,'file'))
		 load(histfile);
	 else
		 rpar_evals=zeros(length(rpar),0);
		 rpar0_evals=zeros(length(rpar),0);
		 success_evals=zeros(1,0);
		 crit_evals=cell(10,1);
		 dcrit_evals=cell(10,1);
		 save(histfile,'-MAT','rpar_evals','rpar0_evals','success_evals',...
				'crit_evals','dcrit_evals');
	 end

	 [success,crit,dcrit]=internal_eval(rpar);
	 if(success~=1)
		error('initial eval failed ???');
	 end
	 last_reinit=0;
else
	 init=0;


	 if norm(rpar-rpar0)>max_step
		 disp('step to large, penalise');

		 crit=last_c+abs(last_c);
		 dcrit=-last_dc;
         az_large=az_large+1;
		 return;
	 end


	 %find out if we are still on the same line search, or if the last
	 %reinit step was accepted
	 if last_reinit==1
		 if (nargout==2)
			 disp('last reinit was successful');
			 rpar0=rpar1;
		 else
			 disp('still on the same line search, use old rpar0');
		 end
	 end
	 last_reinit=0;

	 % attempt evaluation
	 [success,crit,dcrit]=internal_eval(rpar);
     
     
	 if (success~=1)
		 disp('the solver failed, return penalisation values!')

		 Vol_eval_rpar=rpar;
		 pen=2;

		 crit=last_c+pen*abs(last_c);
		 dcrit=-pen*last_dc;
		 return;
	end %test if successful
end
% save last successful eval
last_c=crit;
last_dc=dcrit;

rpar0=rpar;
pause(0);

return



function [success,crit,dcrit]=internal_eval(rpar);

global histfile;
global level0;global level;global ref_stop;global ref_vx_max;global alpha;
global Aspar;global bspar;
global Crpar,global drpar;
global rpar0

global gen_name;

global basedir;
global az_suc; global az_no;global az_old;
 
 
load(histfile);
nth=size(rpar_evals,2);
found=-1;

for i=1:nth
	 if ((norm(rpar-rpar_evals(:,i))<1e-13)...
			 &&(norm(rpar0-rpar0_evals(:,i))<1e-13))
		 found=i;
	 end
end

if (found==-1)
	 % new eval
	 feval(gen_name, [basedir,gen_name,'/visual/',gen_name,'_eval.f1m'],...
					 level0,level,ref_stop,ref_vx_max,alpha,rpar,Aspar,bspar);%,Crpar,drpar););

    command=['pushd ',basedir,gen_name,' >>/dev//null; ./test_lame_adj ', basedir,gen_name,'/visual/',gen_name,'_eval.f1m >>visual/solver_out|| rm ',basedir,gen_name,'/visual/',gen_name,'_eval.f1m_[cg]*; popd >>/dev/null'];

    system(command);
	
	 % see if this was successful
	 if (~exist([basedir,gen_name,'/visual/',gen_name,'_eval.f1m_crit'],'file'))
		% was failure:
		 success=0;
		 crit=zeros(1,1);
		 dcrit=zeros(1, length(rpar));
         az_no=az_no+1;
		 return;
	 else
		 %was success
		 success=1;

		 % new evaluation
		 crit=load([basedir,gen_name,'/visual/',gen_name,'_eval.f1m_crit']);

		 dc_dspar=load([basedir,gen_name,'/visual/',gen_name,'_eval.f1m_grad']);
		 dcrit=(Aspar'*dc_dspar)';
	 end

	 %build and maintain a database of successful evaluations
	 rpar_evals=[rpar_evals,rpar];
	 rpar0_evals=[rpar0_evals,rpar0];
	 success_evals=[success_evals,success];

	 nth=size(rpar_evals,2);
	 crit_evals{nth}=crit;
	 dcrit_evals{nth}=dcrit;

	 save(histfile,'-MAT','rpar_evals','rpar0_evals','success_evals',...
					 'crit_evals','dcrit_evals');
    if success==1
     az_suc=az_suc+1;   
	 moviefile_command=sprintf(['mv ',basedir,gen_name,'/visual/Lame_sol.vtk ',basedir,gen_name,'/visual/',gen_name,'_movie_%d_%d_%f__%03d.vtk'],...
					 level0,level,alpha,nth);

	 [status,result]=system(moviefile_command);
	 svgfile_command=sprintf(['mv ',basedir,gen_name,'/visual/shape_segs_all.svg ',basedir,gen_name,'/visual/',gen_name,'_movie_%d_%d_%f__%03d.svg'],...
					 level0,level,alpha,nth);

	 [status,result]=system(svgfile_command);
    end
else
	 %been there, done that
     az_old=az_old+1;	 
     disp('use old, avoid evaluation')
	 success=success_evals(found);
	 crit=crit_evals{found};
	 dcrit=dcrit_evals{found};
end

return
