#!/bin/bash

outfile="${1%.svg}_wRB.svg"
if test -e "$outfile"; then
  echo error file "$outfile" exists
  exit 1 
fi

cat $1 |sed -e"s-</svg>--" \
  -e"s/stroke-width:0.1/stroke-width:1.6/g" \
  -e"s/stroke-width:0.3/stroke-width:4.8/g" \
  >"$outfile"

# append RB markers
cat pedcrank2_RB_marker.svg_inc >>"$outfile"
# close file
echo "</svg>"  >>"$outfile"

#now edit $outfile to achieve:
#  move path1 to be first path
#  change fill in path1 from "none" to #bababa
#  change fill in path0 from "none" to #ffffff
#  change fill in path2 from "none" to #ffffff

# the necessary commands have been recorded in vim using the macro
# record function:
#   press "q" then "b" to record into register "b"
#   perform the edditing as usuall, try to use line numbers for movement,
#     e.g. ":16" to go to line 16
#   when you're done editing, press q again to stop the recording
# 
# After quiting you find the recorded characters in ~/.viminfo (or
# .vimrc ?) in a line starting with "b".

vim -s pedcrank2_add_RB_marker.sh_vim_commands "$outfile"

