function convert_f1m_boundary_gmsh_geo(basename)

name_in=[basename,'.f1m']
fin=fopen(name_in,'r');

if (fin==-1)
  error(sprintf('could not open file %s for read',name_in));
end

name_out=[basename,'.geo']
fout=fopen(name_out,'w');

if (fout==-1)
  error(sprintf('could not open file %s for write',name_out));
end

% read the header, assumme order:
% vertex ... boundary ... shape_seg ... shape_par
function nr=read_header(name,hfin)
string=''; count=1;
while ((strcmp(string,['<',name])==0)&&(count~=0))
  [string,count]=fscanf(hfin,'%s',1);
end

if ((strcmp(string,['<',name])==1))
  [nr,count]=fscanf(fin,'%d',1);
else 
  error(['could not find ',name,' header']);
end
end % function read_header

vx_nr=read_header('vertex', fin);
bd_nr=read_header('boundary', fin);
sg_nr=read_header('shape_seg', fin);
sp_nr=read_header('shape_par', fin);

function goto_block(name,hfin)
string=''; count=1;
while ((strcmp(string,['<',name,'>'])==0)&&(count~=0))
  [string,count]=fscanf(hfin,'%s',1);
end

if ((strcmp(string,['<',name,'>'])==1))
  %
else 
  error(['could not find start of ',name,' block']);
end
end % function goto_block


% first search the vertex block, read it
goto_block('vertex',fin);
Cvertex=textscan(fin,'%d%f%f',vx_nr);
vertex=[Cvertex{2},Cvertex{3}];

% then the boundary block, read it
goto_block('boundary',fin);
Cboundary=textscan(fin,'%d%d%d%d%d%d%d%d',bd_nr);
boundary_nodes=[Cboundary{7},Cboundary{8}];
boundary_sseg =Cboundary{6};

% then the shape_seg block, read it
goto_block('shape_seg',fin);
shape_seg=fscanf(fin,'%d',[3+8,sg_nr])';
shape_seg_par=shape_seg(:,4:11);

% then the shape_par block, read it
goto_block('shape_par',fin);
shape_par_scan=fscanf(fin,'%f',[2,sp_nr])';
shape_par=shape_par_scan(:,2);


% start the geo file
fprintf(fout,['// gmsh .geo file generated by ' ...
              'convert_f1m_boundary_gmsh_geo.m\n']);
fprintf(fout,'// form %s\n\n', name_in);

fprintf(fout,'lc = 1.0 ; // characteristic length \n\n');

% write the parameters to the geo file
fprintf(fout,'// shape parameters\n');
for i=1:sp_nr
  fprintf(fout,'spar[%d] = %23.15e ;\n', i, shape_par(i) );
end
fprintf(fout,'// end shape parameters\n\n');

fprintf(fout,'// points \n');

% we only take those vertices into the geo file, that are uses in
% boundary definition
point_nr=0;
vx2points=-ones(vx_nr,1);
for i=1:bd_nr
  if (boundary_sseg(i)==-1)
    for j=1:2
      node=boundary_nodes(i,j)+1;
      if (vx2points(node)==-1)
        point_nr=point_nr+1;
        fprintf(fout,'Point(%d) = { %23.15e, %23.15e, 0.0, lc } ;\n',...
                point_nr,vertex(node,1),vertex(node,2));
        vx2points(node)=point_nr;
      end
    end % for j
  end % if no sseg
end % loop over boundary

% now add points that are required for the B-splines
spar2point=-ones(sp_nr,1);
sseg_points=zeros(sg_nr,4);
for i=1:bd_nr
  sg=boundary_sseg(i)+1;
  if (sg~=0)
    % the first two pairs of parameters define endpoints, these
    % have to be added if not yet present.
    for j=0:1
      spix=shape_seg_par(sg,j*2+1)+1;
      spiy=shape_seg_par(sg,j*2+2)+1;
      if ((spar2point(spix)==-1)||(spar2point(spiy)==-1))
        point_nr=point_nr+1;
        fprintf(fout,'Point(%d) = { spar[%d], spar[%d], 0.0, lc } ;\n',...
                point_nr,spix,spiy);
        spar2point(spix)=point_nr;
        spar2point(spiy)=point_nr;
        tpoint=point_nr;
      else 
        % already known point
        tpoint=spar2point(spix);
      end
      sseg_points(sg,j+1)=tpoint;
    end % for j
    
    % the third and fourth are differences to the points, so the
    % resulting points have to be added no matter what, since they
    % are used only once, in this
    
    % third pair, (first inner point) 
    point_nr=point_nr+1;
    fprintf(fout,'Point(%d) = { spar[%d]+spar[%d], spar[%d]+spar[%d], 0.0, lc } ;\n',...
            point_nr,...
            shape_seg_par(sg,0*2+1)+1,shape_seg_par(sg,2*2+1)+1,...
            shape_seg_par(sg,0*2+2)+1,shape_seg_par(sg,2*2+2)+1);
    sseg_points(sg,3)=point_nr;

    % fourth pair, (second inner point) 
    point_nr=point_nr+1;
    fprintf(fout,'Point(%d) = { spar[%d]-spar[%d], spar[%d]-spar[%d], 0.0, lc } ;\n',...
            point_nr,...
            shape_seg_par(sg,1*2+1)+1,shape_seg_par(sg,3*2+1)+1,...
            shape_seg_par(sg,1*2+2)+1,shape_seg_par(sg,3*2+2)+1);
    sseg_points(sg,4)=point_nr;
  end % if sseg
end % loop over boundary
fprintf(fout,'// end points \n\n');

fprintf(fout,'// Lines / BSplines \n');

line_nr=point_nr;
for i=1:bd_nr
  if (boundary_sseg(i)==-1)
    fprintf(fout,'Line(%d)    = { %d, %d } ;\n',...
            line_nr+i,...
            vx2points(boundary_nodes(i,1)+1),...
            vx2points(boundary_nodes(i,2)+1) );
  else % if sseg
    sg=boundary_sseg(i)+1;
    fprintf(fout,'BSpline(%d) = { %d, %d, %d, %d } ;\n',...
            line_nr+i,...
            sseg_points(sg,1),sseg_points(sg,3), ...
            sseg_points(sg,4),sseg_points(sg,2) );
  end % if sseg
end % loop over boundary

fprintf(fout,'// end lines / Bsplines \n\n');

fclose(fin);
fclose(fout);
end