<!-- simple gmsh example, FEINS settings file -->
<header>
  <format    0 >
  <dim       3 >
  <problem   5 >
  <meshgen   2 >
  <curved    0 >
  <boundary  2 >
  <rhsf      0 >
  <pcsurf    0 >
  <pcvol     0 >
  <pccrit    0 >
  <function  2 >
  <parameter 2 >
</header>

<solver_settings>
  <refine_ini      0 >
  <refine_type     0 >
  <refine_steps    15 >
  <refine_stop     0 >
  <refine_max_vx   1e5 >
  <adap_mark       2 >
  <adap_mark_par   0.6 >
  <solver          1       >
  <solver_atol     1.0e-12 >
  <solver_ini_rtol 1.0e-6  >
  <solver_ref_rtol 1.0e-2  >
  <is_instat       0 >
  <instat_delta_t0 0.0e+0 >
  <instat_delta_t_fix -1.0 >
  <instat_Time0    0.0 >
  <instat_Tend     0.0 >
  <instat_write_steps 1 >
  <instat_write_delta 1.0e-0 >
  <write_mesh      1 >
  <write_ssegs     1 >
</solver_settings>



<!-- syntax of a boundary entry is:
       id bctype func geotag
     each face with this geotag will be marked as boundary face
  surface 13-16 is diamond box hole
  surface 17-20 is round hole
-->
<boundary>
   0   1   0   203
   1   2   1   220
</boundary>

<!-- syntax of a rhsf entry is:
       id type func geotag
     each volume with this geotag will be marked to have the 
     specified rhs function 
-->
<rhsf>
</rhsf>


<!-- syntax of a pcsurf entry is:
       id c_id geotag
-->
<pcsurf>
</pcsurf>


<!-- syntax of a pcvol entry is:
       id c_id geotag
-->
<pcvol>
</pcvol>
   

<!-- syntax of a pccrit entry is:
       id type data1 ... datak
-->
<pccrit>
</pccrit>



<!-- syntax of a function entry is:
       id type data1 ... datak
     where
     - id is the identifier of the function entry (consecutive numbers
       starting from 0),
     - type is the type of the function, e.g.
          0  - constant scalar,
          1  - scalar linear function
          2  - scalar quadratic function
        100  - constant vector,
        101  - vector valued linear function,
        102  - vector valued quadratic function,
     - data1 ... datak are the data values for this type of function,
       the number and meaning of them is determined by the type of the
       function and the dimension, e.g. for constant scalars there is
       only one data field, which is the constant itself
-->
<function>
   0    100   0.0  0.0    0.0
   1    100   0.0  0.0    1.0
</function>


<!-- syntax of the parameter entry is:
       data1 ... datak
     where
     - data1 ... datak are the k data values, where k is the number of
       parameters as given in the header, the meaning of them is
       determined by the problem, e.g. for stokes flow there is only one
       parameter, the kinematic viscosity nu (=(mu*U*l)/rho)
-->
<parameter>
   1.15e5  7.7e4
</parameter>

