function [x] = poissoncontrol_chebsi(Matrix,rhs,NoIter,order)
% John Pearson - 2009

if order == 1 
    lammin = 1/2;
    lammax = 2;
end

Len = length(Matrix(:,1));
ymid = zeros(Len,1); b = rhs;
yold = ymid;
omega = 1;
      
rho = (lammax-lammin)/(lammax+lammin); 
diagMatrix = (lammin+lammax)/2*diag(Matrix); 

for k = 1:NoIter
   omega = 1/(1-(omega*rho^2)/4);
   r = b-Matrix*ymid;
   z = diagMatrix.\r; 
   ynew = omega*(z+ymid-yold)+yold;
   yold = ymid; ymid = ynew;
end

x = ynew;
