# - Try to find GooglePerftools headers and libraries
#
# Usage of this module as follows:
#
#   find_package(GooglePerftools)
#
# Variables used by this module, they can change the default behaviour and need
# to be set before calling find_package:
#
#  GooglePerftools_ROOT_DIR  Set this variable to the root installation of
#                            GooglePerftools if the module has problems finding
#                            the proper installation path.
#
# Variables defined by this module:
#
#  GooglePerftools_FOUND              System has GooglePerftools libs/headers
#  GooglePerftools_LIBRARIES          The GooglePerftools libraries
#  GooglePerftools_PROFILER_LIBRARY   The GooglePerftools profiler library
#  GooglePerftools_INCLUDE_DIR        The location of GooglePerftools headers

find_path(GooglePerftools_ROOT_DIR
  NAMES include/google/profiler.h
)

find_path(GooglePerftools_INCLUDE_DIR
  NAMES google/profiler.h
  HINTS ${GooglePerftools_ROOT_DIR}
)

find_library(GooglePerftools_PROFILER_LIBRARY
  NAMES profiler
  HINTS ${GooglePerftools_ROOT_DIR}
)

set(GooglePerftools_LIBRARIES ${GooglePerftools_PROFILER_LIBRARY})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(GooglePerftools
  "Try setting GooglePerftools_ROOT_DIR to root of your gperftools installation"
  GooglePerftools_LIBRARIES
  GooglePerftools_INCLUDE_DIR
)

mark_as_advanced(
  GooglePerftools_ROOT_DIR
  GooglePerftools_LIBRARIES
  GooglePerftools_PROFILER_LIBRARY
  GooglePerftools_INCLUDE_DIR
)