/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2013, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
linsolve_hypre_AMG.h
*/
#ifndef __LINSOLVE_HYPRE_AMG_H__
#define __LINSOLVE_HYPRE_AMG_H__ 1



#include "feins_macros.h"

#include "sparse_struct.h"


int gen_hypre_AMG_setup(struct sparse *K, 
			FIDX nr_diri, FIDX *diris, int diri_copy_dims,
			void **AMGdata, int symm
/* setup of hypre AMG solver for sparse matrix problem
   
   Input:  K       - the stiffness matrix
           nr_diri - number of degrees of freedom (DOFs) which are
                     subject to Dirichlet boundary conditions, such
                     that the according rows and columns of the
                     matrix have to be deleted 
           diris   - vector of length nr_diri, stating which DOFs
                     these are
           diri_copy_dims
                   - if all dofs are specified in diris, 
		     this should be set to 1, 
		     if only the node numbers are specified, and a
		     multidimensional quantity is used, this may be
		     set to dim, then vx_nr=K.row_nr/diri_copy_dims
		     and for i=0<nr_diri, for d=0<diri_copy_dims 
		       DOF=diris[i]+d*vx_nr
		     is also defined to be Dirichlet DOF
           symm    - if preco should use symmetric smoothers
                     ==0 use simple GS, ==1 use symmetric GS

   Output: AMGdata - (given by reference) on output it will contain
                     the data for the AMG solver/preconditioner

   Return: SUCCESS - success,
           FAIL    - failure, see error message
*/);

int gen_hypre_AMG_preco(void *notused, struct vector *in,
			void *arg3, struct vector *out
/* performs
     out = C^-1*in
   where C^-1 is AMG multigrid operator as defined in
   gen_hypre_AMG_setup, 

   Input:  notused - well, it is not used but included in the
                     interface to allow this function to be used as a
                     preconditioner,
           in      - input vector
	   arg3=
	   Hdat    - AMGdata as returned by gen_hypre_AMG_setup,

   Output: out    - (given by reference), the C^-1*in

   Return: SUCCESS - success,
           FAIL    - failure, see error message
*/);

int gen_hypre_AMG_free(void **AMGdata
/* free the hypre AMG solver data
   
   In/Out: AMGdata - (given by reference) 
                     the data for the AMG solver/preconditioner,
		     all content will be freed, on return this will
		     hold a NULL pointer

   Return: SUCCESS - success,
           FAIL    - failure, see error message
*/);
#endif
