#ifndef FEINS_LAPACK_H
#define FEINS_LAPACK_H

/* BLAS stuff: */
void dgemm_ ( char *transa, char *transb, int *m, int *n, int *k,
	      double *alpha,  double *a,  int *lda,
	      double *b,  int *ldb,
	      double *beta, double *c, int *ldc );

/* LAPACK stuff: */
void dgetrf_ ( int *M, int *N, double *A, int *LDA,
	       int *IPIV, int *INFO );

void dgetri_ ( int *N, double *A, int *LDA, int *IPIV, 
               double *WORK, int *LWORK, int *INFO );

void dpbtrf_ ( char *UPLO, int *N, int *KD, double *AB, int *LDAB,
	       int *INFO );

void dpbtrs_ ( char *UPLO, int *N, int *KD, int *NRHS,
	       double *AB, int *LDAB, double *B, int *LDB, int *INFO );

void dgbtrf_ ( int *M, int *N, int *KL, int *KU, double *AB, int *LDAB,
	       int *IPIV, int *INFO );

void dgbtrs_ ( char *TRANS, int *N, int *KL, int *KU, int *NRHS,
	       double *AB, int *LDAB, int *IPIV, double *B, int *LDB,
	       int *INFO );



/* DGESV( N, NRHS, A, LDA, IPIV, B, LDB, INFO ) */
void dgesv_( int* N, int* NRHS, double* A, int* LDA, int* IPIV,
	     double* B, int* LDB, int* INFO );

/* DSYEV( JOBZ, UPLO, N, A, LDA, W, WORK, LWORK, INFO )
   LWORK >= (NB+2)*N  */
void dsyev_( char* JOBZ, char* UPLO, int* N, double* A, int* LDA, 
	     double* W, double* WORK, int* LWORK, int* INFO );



#endif
