% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************


function [crit,dcrit]=tobst_eval(rpar);
%
% evaluates the criteria+constraints+derivatives for the wing problem
%
% if rpar is empty a setup step is done instead, setting global
% variables: na, nb, nu, rpar0, Aspar, bspar, Crpar, drpar, Vol0,
%            creating a meshfile and reference solution
%

% problem defining globals, don't change
global na; global nb; global nu; global level;
global Aspar; global bspar; global Crpar; global drpar;
global Vol0; 
global histfile;

% changing globals
global Vol_eval; global dVol_eval; global Vol_eval_rpar;
global last_c; global last_dc;
global rpar0; global rpar1; global last_reinit;


if isempty(rpar)
  init=1;
  na=1; nb=3;
  %na=2; nb=4;
  %level=1;  nu=1;
  %level=3;  nu=0.1; %
  level=4;  nu=0.1; % finer mesh
  %level=4; nu=0.05;
  
  [rpar0,Aspar,bspar,Crpar,drpar]=tobst_gen(['../../build/visual/' ...
                      'tobs_eval.f1m'],nu,[], 0, level);

  rpar=rpar0;
  
  pause(1);
  
  histfile=sprintf('../../build/visual/tobs_eval_hist_%d_%d_%d_%f_v2.mat',...
      na,nb,level,nu);
  
  if (exist(histfile,'file'))
    load(histfile);
  else
    rpar_evals    = zeros(length(rpar),0);
    rpar0_evals   = zeros(length(rpar),0);
    success_evals = zeros(1,0);
    crit_evals  = cell(10,1);
    dcrit_evals = cell(10,1);
    save(histfile,'-MAT','rpar_evals','rpar0_evals','success_evals',...
	'crit_evals','dcrit_evals');
  end

  [success,crit,dcrit]=internal_eval(rpar0,rpar,na,nb);
  if (success~=1)
    error('initial eval failed ???');
  end
  last_reinit=0;
else
  init=0;
  
  % before we do an eval, test if the constraints are in their
  % tollerances
  gin=Crpar*rpar+drpar;
  if sum(gin<-1e-3)>0
    disp('constraints violation, penalisation')
    
    Vol_eval_rpar=rpar;
    
    crit=last_c+abs(last_c);
    dcrit=-last_dc;
    return;
  end

  
  % find out if we are still on the same line search, or if the last
  % reinit step was accepted
  if (last_reinit==1)
    if (nargout==2)
      disp('last reinit was successful')
      rpar0=rpar1;
    else
      disp('still on the same line search, use old rpar0');
    end
  end
  last_reinit=0;
    
  % attempt evaluation
  [success,crit,dcrit]=internal_eval(rpar0,rpar,na,nb);
  
  if (success~=1)
    disp('eval failed, attempt reinit');
    
    rpar1=rpar;
    [success,crit,dcrit]=internal_eval(rpar1,rpar,na,nb);
    last_reinit=1;
      
    % see if still un-successful
    if (success~=1)
      disp('the solver failed again, return penalisation values!')

      Vol_eval_rpar=rpar;
      pen=2;
    
      crit=last_c+pen*abs(last_c);
      dcrit=-pen*last_dc;
      return;
    end % test still un-successful
  end % test if successful 
end
  
if (init==1)
  Vol0=-crit(2);
end


Vol_eval      = Vol0+crit(2);
dVol_eval     = dcrit(:,2);
Vol_eval_rpar = rpar;

f_eval=[crit(1),Vol_eval ]

% hide the volume from donlp2
crit=crit(1);
dcrit=dcrit(:,1)';

% save last successful eval;
last_c  = crit;
last_dc = dcrit;

return




function [success,crit,dcrit]=internal_eval(rpar0,rpar,na,nb);

global histfile;
global nu; global level;
global Aspar; global bspar; 

load(histfile);
nth=size(rpar_evals,2);
found=-1;

for i=1:nth
  if (    (norm(rpar-rpar_evals(:,i))<1e-13)...
	&&(norm(rpar0-rpar0_evals(:,i))<1e-13))
    found=i;
  end
end

if (found==-1)
  % new eval
  tobst_gen('../../build/visual/tobs_eval.f1m', nu,rpar0, 0,level);

  spar=Aspar*rpar+bspar;
  save('../../build/visual/tobs_eval_new_spar','spar','-ASCII');

  args=fopen('../../build/visual/tobs_eval_args.txt','w');
  fprintf(args,'\n %s','visual/tobs_eval_new_spar'); fclose(args);

  !pushd  ../../build; pwd; cat visual/tobs_eval_args.txt | xargs ./test_navsto_solver visual/tobs_eval.f1m >>visual/solver_out|| rm visual/tobs_eval.f1m_[cg]*; popd
  
  % see if this was successful
  if (~exist('../../build/visual/tobs_eval.f1m_crit','file'))
    % was failure:
    success=0;
    crit=zeros(2,1);
    dcrit=zeros(2, length(rpar));
    return;
  else
    % was success
    success=1;

    % new evaluation
    crit=load('../../build/visual/tobs_eval.f1m_crit');

    dc_dspar=load('../../build/visual/tobs_eval.f1m_grad');
    dcrit = Aspar'*dc_dspar;

    crit(2)   =-crit(2);
    dcrit(:,2)=-dcrit(:,2);
  end

  % build and maintain a database of successful evaluations
  rpar_evals    = [rpar_evals,    rpar    ];
  rpar0_evals   = [rpar0_evals,   rpar0   ];
  success_evals = [success_evals, success ];
  
  nth=size(rpar_evals,2);
  crit_evals{nth}  = crit;
  dcrit_evals{nth} = dcrit;

  save(histfile,'-MAT','rpar_evals','rpar0_evals','success_evals',...
      'crit_evals','dcrit_evals');
  
  moviefile_command=sprintf('mv ../../build/visual/2d_mesh_vtk_.vtk ../../build/visual/tobs_movie_%d_%d_%d_%f_%03d.vtk && mv  ../../build/visual/tobs_eval.f1m ../../build/visual/tobs_movie_%d_%d_%d_%f_%03d.f1m && mv ../../build/visual/tobs_eval_new_spar ../../build/visual/tobs_movie_%d_%d_%d_%f_%03d.new_spar',...
      na,nb,level,nu,nth,  na,nb,level,nu,nth,  na,nb,level,nu,nth);
  
  [status,result]=system(moviefile_command);
  
else
  % been there, done that
  disp('use old, avoid evaluation')
  success = success_evals(found);
  crit    = crit_evals{found};
  dcrit   = dcrit_evals{found};
end

return;
