% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************


function [rpar0,Aspar,bspar,Crpar,drpar]=shole_gen(fname,rpar_in,Aspar,bspar,Crpar,drpar);
%
% generates a mesh file fname for the support with hole
%
% +--+
% |O/
% |/
% +
%
% return:
%   rpar0  - the initial parameters of the geometry, the vector to be
%            optimised
%   Aspar  
%   bspar  - spar=Aspar*rpar+bspar gives the parameter in the meshfile
%            in dependance on the actual parameters
%   Crpar
%   drpar  - Crpar*rpar+drpar >=0 form the constraints on the actual
%            parameters 
%

if nargout>1
  nspar=16;
  Aspar=speye(nspar,nspar);
  bspar=zeros(nspar,1);

  rpar0=[
     0.1666
    -0.3333
     0.0
     0.091991462599717
     0.3333
    -0.1666
     0.091991462599717
     0.0
     0.5000
    -0.3333
     0.0
    -0.091991462599717
     0.3333
    -0.5
    -0.091991462599717
     0.0];

  Crpar=zeros(3*(3*4),nspar);
  drpar=zeros(size(Crpar,1),1);
  keepdist=0.05;
  % constraints
  % first, the four direct poits
  for i=0:3
    row=i*3+1;Crpar(row,i*4+1)= 1;  drpar(row)=-keepdist;
    row=i*3+2;Crpar(row,i*4+2)=-1;  drpar(row)=-keepdist;
    row=i*3+3;Crpar(row,i*4+1)=-1;
              Crpar(row,i*4+2)= 1;  drpar(row)=1-keepdist;
  end
  % copy these costraints to remaining lines, so we only have to
  % add/substract sx,sy
  Crpar(1*12+(1:12),:)=Crpar(1:12,:); 
  Crpar(2*12+(1:12),:)=Crpar(1:12,:); 
  drpar(1*12+(1:12),:)=drpar(1:12,:); 
  drpar(2*12+(1:12),:)=drpar(1:12,:); 
  % add/substract sx,sy
  for i=0:3
    % add
    row=1*12+i*3+1;Crpar(row,i*4+3)= 1; 
    row=1*12+i*3+2;Crpar(row,i*4+4)=-1; 
    row=1*12+i*3+3;Crpar(row,i*4+3)=-1;
                   Crpar(row,i*4+4)= 1; 
    % substract
    row=2*12+i*3+1;Crpar(row,i*4+3)=-1; 
    row=2*12+i*3+2;Crpar(row,i*4+4)= 1; 
    row=2*12+i*3+3;Crpar(row,i*4+3)= 1;
                   Crpar(row,i*4+4)=-1; 
  end
else
  rpar=rpar_in;
  
  spar = Aspar*rpar + bspar;
  nspar=size(spar,1);
  
  % test constraints
  constr=Crpar*rpar+drpar;
  if sum(constr<-1e-7)>1
    violated_constr=(constr<0)'*constr
  end
  
  % copy unmodified part of meshfile
  system(sprintf('cp support_hole_0strip.f1m %s',fname));
  
  % append to the meshfile
  mf=fopen(fname,'a');

  fprintf(mf,[
      '<!-- syntax of the shape_para entry is:\n',...
      '       id  data\n',...
      '-->\n',...
      '<shape_par>\n']);

  for i=1:nspar
    fprintf(mf, '   %3d   %22.15e\n', i-1,  spar(i)); 
  end

  fprintf(mf,[
      '</shape_par>\n',...
      '\n' ]);

  fclose(mf);
end

return;
