function[err] = balken_0_create(par,lvl)

%	create the mesh-file 'balken_0.f1m' for FEINS using the given shape parameters
%
%	input:	par	 	shapeparameters, components must be in the same order
%				as they appear in the meshfile
%
%	output	err 		= 1 for SUCCESS, err = 0 for ERROR
%		balken_0.f1m 	meshfile




% set the burden on the top
q=200.0;

sp_nr = size (par,1);
par(9)=0.0;

file = fopen('balken_0.f1m','w');

% header

fprintf(file,'<Net File for the model porblem, created by balken_0_create.m>\n');
fprintf(file,'<header>\n');
fprintf(file,'  <format    0 >\n');
fprintf(file,'  <dim       2 >\n');
fprintf(file,'  <problem   2 >\n');
fprintf(file,'  <meshgen   1 >\n');
fprintf(file,'  <vertex    10>\n');
fprintf(file,'  <elements  0 >\n');
fprintf(file,'  <boundary  10>\n');
fprintf(file,'  <holes     0 >\n');
fprintf(file,'  <pcsurf    0 >\n');
fprintf(file,'  <pcvol     0 >\n');
fprintf(file,'  <pccrit    1 >\n');
fprintf(file,'  <function  2 >\n');
fprintf(file,'  <parameter 4 >\n');
fprintf(file,'  <shape_seg 2 >\n');
fprintf(file,'  <shape_par 12>\n');
fprintf(file,'</header>\n\n');

% vertex
fprintf(file,'<vertex>\n');
fprintf(file,'   0  8.0  2.0\n');
fprintf(file,'   1  0.0  2.0\n');
fprintf(file,'   2  0.0  0.0\n');
fprintf(file,'   3  1.0  0.1\n');
fprintf(file,'   4  2.0  0.2\n');
fprintf(file,'   5  3.0  0.3\n');
fprintf(file,'   6  4.0  0.4\n');
fprintf(file,'   7  5.0  0.6\n');
fprintf(file,'   8  6.0  1.0\n');
fprintf(file,'   9  7.0  2.0\n');
fprintf(file,'</vertex>\n\n');

% elements - empty, cause meshgenerator is used 
fprintf(file,'<elements>\n</elements>\n\n');

% boundary 
fprintf(file,'<boundary>\n');
fprintf(file,'   0   2   0    1  -1 -1    0  1\n');
fprintf(file,'   1   1   0    0  -1 -1    1  2\n');
fprintf(file,'   2   0   0   -1  -1  0    2  3\n');
fprintf(file,'   3   0   0   -1  -1  0    3  4\n');
fprintf(file,'   4   0   0   -1  -1  0    4  5\n');
fprintf(file,'   5   0   0   -1  -1  0    5  6\n');
fprintf(file,'   6   0   0   -1  -1  1    6  7\n');
fprintf(file,'   7   0   0   -1  -1  1    7  8\n');
fprintf(file,'   8   0   0   -1  -1  1    8  9\n');
fprintf(file,'   9   0   0   -1  -1  1    9  0\n');

fprintf(file,'</boundary>\n\n');

% holes - empty, no holes here
fprintf(file,'<holes>\n</holes>\n\n');

% pcsurf - empty
fprintf(file,'<pcsurf>\n</pcsurf>\n\n');

% pcvol - empty
fprintf(file,'<pcvol>\n</pcvol>\n\n');

% pccrit - empty
fprintf(file,'<pccrit>\n  0  11 1 0\n</pccrit>\n\n');

% function
%   0 - Dirichlet on the two side boundaries - mounting
%   1 - tension on the upper boundary - burden 
fprintf(file,'<function>\n');
fprintf(file,'   0    100    0    0\n');
fprintf(file,'   1    100    0    %f\n',-q);
fprintf(file,'</function>\n\n');

% parameter
fprintf(file,'<parameter>\n  1.15e5  7.7e4 10.0 %d\n</parameter>\n\n',lvl);

% shape segments
fprintf(file,'<shape_seg>\n');
fprintf(file,'  0    2   2    8  9   2  3   0  1   4  5\n');
fprintf(file,'  1    2   6    2  3  10 11   4  5   6  7\n');
fprintf(file,'</shape_seg>\n\n');



% shape parameters
fprintf(file,'<shape_par>\n');

for i=1:sp_nr
fprintf(file,'  %d  %f\n',i-1,par(i));
end

fprintf(file,' 10  8.0\n');
fprintf(file,' 11  2.0E\n');

fprintf(file,'</shape_par>\n\n');




err=1;
return;