# convert gmsh mesh generator output .msh files  (Tetrahedrons only) to
# FEINS .f1m file, usage:
# awk -f gmsh_output_filter.awk input.msh >output.f1m
# then edit output.f1m to put header back to the front,  remove rubish

## to further integrate FEINS with gmsh, there appear two options:
##   1. define FEINS as one of the solvers for gmsh,
##      - this would require use of the tcp/ip solver interface of gmsh 
##      - not sure which possibilities this offers 
##        (i.e. may solver ask for refinement? project points to geometry?)
##   2. create a gmsh interface in FEINS
##      - necessary to read .MSH mesh files directly, store geo-info in FEINS
##      - create gmsh-library routine that allows to project points to their 
##        original geometry,
##        all gmsh primitives have a function "closestPoint", that might allow this



# see http://geuz.org/gmsh/doc/texinfo/gmsh.html#MSH-ASCII-file-format
BEGIN{
  
  # RS_simpl1.geo: select inner surface of the cylindrical hole
  #            "bctype type func orient shape_seg"
  #bd_trans[72]="   1    0    0    -1      -1";
  #bd_trans[76]="   1    0    0    -1      -1";
  #bd_trans[80]="   1    0    0    -1      -1";
  #bd_trans[84]="   1    0    0    -1      -1";

  # v6_ProE.igs: select one surface of the flange at the end
  #            "bctype type func orient shape_seg"
  #bd_trans[89]="   1    0    0    -1      -1";

  # halbkroepfung1.igs: select one surface at the end
  #            "bctype type func orient shape_seg"
  #bd_trans[40]="   1    0    0    -1      -1";

  # halbkroepfung1.igs: select one surface at the end
  #            "bctype type func orient shape_seg"
  #bd_trans[85]="   1    0    0    -1      -1";

  # brick_10x1x1.geo
  #bd_trans[27]="   1    0    0    -1      -1";
  
  # Ushape_2x3x1.geo
  #bd_trans[43]="   1    0    0    -1      -1";
  
  # escher_steps_helix_5times_3x1x1.geo
  bd_trans[203]="   1    0    0    -1      -1";

  block=0;
  nelem=0;
  error=0;
  nbound=0;
}

{
  #print "orig: " $0;
  if ($1 =="$Nodes") 
    {
      block=-1;
      print ""
      print "<vertex>";
    }
  else if ($1 =="$EndNodes") 
    {
      block=0;
      print "</vertex>";
      print ""
    }
  else if ($1 =="$Elements") 
    {
      block=-2;
      print ""
      print "<elements>";
    }
  else if ($1 =="$EndElements") 
    {
      block=0;
      print "</elements>";
      print ""
    }
  else
    {
      if (block==+1) {
	print "  " $1-1 "      " $2 "  " $3 "  " $4 
      }
      else if (block==+2) {
	# msh: elm-number elm-type number-of-tags < tag > ... node-number-list
	# f1m: id         type     func                   nod1 ... nodk
	

	if ($2==4) {
	  # msh: elem-type==4  (Tetrahedron)
	  split($0, t_fields);
	  strtn=4+$3

	  printf(" %7d   31  -1    %6d  %6d  %6d  %6d\n", 
		 nelem, t_fields[strtn]-1, t_fields[strtn+1]-1,
		 t_fields[strtn+2]-1,  t_fields[strtn+3]-1);
	  nelem++;
	}
	else if ($2==15) {
	  # msh: elem-type==15  (1 node point, ignore)
	}
	else if ($2==1) {
	  # msh: elem-type==1   (2 node line, ignore)
	}
	else if ($2==2) {
	  # msh: elem-type==2   (3 node triangle)
	  # if the triangle has a tag contained in bd_trans[] 
	  # it will be remembered to form a boundary section later on
	  # awk -v var=val
	  split($0, t_fields);
	  numtags=t_fields[3];
	  strtn=4+$3
	  for (i=1; i<=numtags; i++)
	    {
	      if (t_fields[3+i] in bd_trans)
		{
		  # remember this entry
		  boundary[nbound]=\
		    sprintf(" %7d   %s  %6d  %6d  %6d", 
			    nbound, bd_trans[t_fields[3+i]], 
			    t_fields[strtn]-1, t_fields[strtn+1]-1,
			    t_fields[strtn+2]-1);
		  nbound++;
		}
	    }
	}
	else
	  {
	    print "error:" $0
	    error++;
	  }
      }
      else if (block==-1) { vertex=$1; block=+1; }
      else if (block==-2) { elem=$1;   block=+2; }
      else print $0;
    }
}

END {
  print ""
  print ""
  print "<boundary>"
  for (i=0; i<nbound; i++) print boundary[i];
  print "</boundary>"
  print ""
  print "<holes>"
  print "</holes>"
  print ""
  print "<pcsurf>"
  print "</pcsurf>"
  print ""
  print "<pcvol>"
  print "</pcvol>"
  print ""
  print "<pccrit>"
  print "</pccrit>"
  print ""
  print "<function>"
  print "</function>"
  print ""
  print "<parameter>"
  print "</parameter>"
  print ""
  print "<shape_seg>"
  print "</shape_seg>"
  print ""
  print "<shape_par>"
  print "</shape_par>"
  print ""


  print ""
  print ""
  print ""
  print "<!-- meshfile converted from gmsh output (msh-ascii format) using"
  print "     gmsh_output_filter.awk, "
  print "     input file: " FILENAME
  print "-->"
  print "<header>"
  print "   <format    0 >"
  print "   <dim       3 >"
  print "   <problem   0 >"
  print "   <meshgen   0 >"
  print "   <vertex    " vertex ">"
  print "   <elements  " nelem  ">"
  print "   <boundary  " nbound ">"
  print "   <holes     0 >"
  print "   <pcsurf    0 >"
  print "   <pcvol     0 >"
  print "   <pccrit    0 >"
  print "   <function  0 >"
  print "   <parameter 0 >"
  print "   <shape_seg 0 >"
  print "   <shape_par 0 >"
  print "</header>"
  print "errors:" error
}
