// original model from Zaqueu Ernesto da Silva (zaqueu at les.ufpb.br)
// rewritten by CG
// modified by RS

lc = 1;
e = 3; // thickness
w = 10; // width
r = 5; // interior radius
c = 15; // half length
h = 4; // hole center dist
rh = 2; // home radius

Point(1) = {0, w, 0, lc};
Point(2) = {c-w/2, w, 0, lc};
Point(3) = {0, w, e, lc};
Point(4) = {c-Sqrt((r+e)^2-e^2), w, e, lc};
Point(5) = {c, w, w/2, lc};
Point(6) = {c, w, w/2+e, lc};
Point(7) = {c, w, 0, lc};
Line(1) = {1,2};
Line(2) = {3,4};
Line(3) = {1,3};
Circle(4) = {2,7,5};
Circle(5) = {4,7,6};
Line(6) = {5,6};
Line Loop(11) = {4,6,-5,-2,-3,1};
Plane Surface(12) = {11};
v[] = Extrude {0,-w,0}{ Surface{12}; };
Delete { Volume{v[1]}; }
Delete { Surface{43,35}; }

Point(100) = {h, w/2, 0, lc};
Point(101) = {h+rh, w/2, 0, lc};
Point(102) = {h-rh, w/2, 0, lc};
Point(103) = {h, w/2+rh, 0, lc};
Point(104) = {h, w/2-rh, 0, lc};
Circle(65) = {101,100,103};
Circle(66) = {103,100,102};
Circle(67) = {102,100,104};
Circle(68) = {104,100,101};
Extrude {0,0,e}{ Line{65:68}; }

Line Loop(104) = {2,30,17,-34};
Line Loop(105) = {73,77,81,69};
Plane Surface(106) = {104,105};

Line Loop(107) = {1,21,-19,-38};
Line Loop(108) = {65,66,67,68};
Plane Surface(109) = {107,108};

Surface Loop(110) = {31, 12, 23, 27, 44, 106, 39, 109, 84, 72, 76, 80};
Volume(111) = {110};
