% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************

ghia_u=[
% x        Re100     Re1000
  1.0      1.0       1.0
  0.9766   0.84123   0.65928
  0.9688   0.78871   0.57492
  0.9609   0.73722   0.51117
  0.9531   0.68717   0.46604
  0.8516   0.23151   0.33304
  0.7344   0.00332   0.18719
  0.6172  -0.13641   0.05702
  0.5     -0.20581  -0.06080
  0.4531  -0.21090  -0.10648
  0.2813  -0.15662  -0.27785
  0.1719  -0.10150  -0.38289
  0.1016  -0.06434  -0.29730
  0.0703  -0.04775  -0.22220
  0.0625  -0.04192  -0.20196
  0.0547  -0.03717  -0.18109
  0.0      0.0       0.0];

ghia_v=[
% y        Re100     Re1000
  1.0      0.0       0.0
  0.9688  -0.05906  -0.21288
  0.9609  -0.07391  -0.27669
  0.9531  -0.08864  -0.33714
  0.9453  -0.10313  -0.39188
  0.9063  -0.16914  -0.51550
  0.8594  -0.22445  -0.42665
  0.8047  -0.24533  -0.31966
  0.5      0.05454   0.02526
  0.2344   0.17527   0.32235
  0.2266   0.17507   0.33075
  0.1563   0.16077   0.37095
  0.0938   0.12317   0.32627
  0.0781   0.10890   0.30353
  0.0703   0.10091   0.29012
  0.0625   0.09233   0.27485
  0.0      0.0       0.0];

cols=cell(8,1);
%cols{1}='k:'; cols{2}='k-.'; cols{3}='k--'; cols{4}='k-';
cols{1}='m:'; cols{2}='m-.'; cols{3}='m--'; cols{4}='m-';
cols{5}='k:'; cols{6}='k-.'; cols{7}='k--'; cols{8}='k-';



tre=10; % the Reynolds number
cl=2; % coarsest level
fl=9; % finest level  
% override for other meshes:
%tre=100;cl=2;fl=9;
%tre=0;cl=1;fl=4;

legs=cell(fl-cl+2,1);
legs{1}='Ghia et. al.';
switch tre
  case 10
    tdir='visual_cav_re10'; % directory with the files
    ghia_col=-1;
  case 100
    tdir='visual_cav_re100'; % directory with the files
    ghia_col=2;
  case 1000;
    tdir='visual_cav_re1000'; % directory with the files
    ghia_col=3;
  otherwise,
    tdir='visual'; % directory with the files
    ghia_col=3;
end
%tdir='visual'
%tdir='visual133_noPstab_delta_0.003'; % directory with the files
%tdir='visual106_Pstab_delta_0.003'; % directory with the files
    

figure(1);
clf;
%subplot(2,1,1);
if ghia_col>0
  plot(ghia_v(:,1),ghia_v(:,ghia_col),'k*');
end
hold on;
for i=cl:fl
  name=sprintf([tdir,'/line.y.%d.txt'],i);
  td  =load(name,'-ASCII');

  thecol=[cols{i-cl+1}];
  plot(td(:,1),td(:,3),thecol);
  legs{i-cl+2}=sprintf('feins  %d^2 nodes', size(td,1));
end
h1=xlabel('x');h2=ylabel('v');
h3=title(sprintf('v-velocity component along the line y=0.5 for Re=%d',tre));
if ghia_col>0
  h4=legend(legs,3);
else
  h4=legend(legs{2:length(legs)},3);
end
set(h1,'FontSize',15);
set(h2,'FontSize',15);
set(h3,'FontSize',15);
set(h4,'FontSize',15);

figure(2);
%subplot(2,1,2);
clf;
if ghia_col>0
  plot(ghia_u(:,ghia_col),ghia_u(:,1),'k*');
end
hold on;

for i=cl:fl
  name=sprintf([tdir,'/line.x.%d.txt'],i);
  td  =load(name,'-ASCII');
 
  thecol=[cols{i-cl+1}];
  plot(td(:,2),td(:,1),thecol);
  legs{i-cl+2}=sprintf('feins  %d^2 nodes', size(td,1));
end
h1=xlabel('u');h2=ylabel('y');
h3=title(sprintf('u-velocity component along the line x=0.5 for Re=%d',tre));
if ghia_col>0
  h4=legend(legs,3);
else
  h4=legend(legs{2:length(legs)},3);
end
set(h1,'FontSize',15);
set(h2,'FontSize',15);
set(h3,'FontSize',15);
set(h4,'FontSize',15);

