% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************

for lvl=2:4

%basename=sprintf('visual_Re20_Picard/savemat_%d',lvl);
%basename=sprintf('visual_Re20/savemat_%d',lvl);
basename=sprintf('visual_mat/savemat_%d',lvl);

F_dat=load([basename,'_F.txt']);
F=spconvert(F_dat); clear F_dat;

B1_dat=load([basename,'_B1.txt']);
B1=spconvert(B1_dat); clear B1_dat;

B2_dat=load([basename,'_B2.txt']);
B2=spconvert(B2_dat); clear B2_dat;

B=[B1,B2];

Ap_dat=load([basename,'_A_p.txt']);
Ap=spconvert(Ap_dat); clear Ap_dat;

Cp_dat=load([basename,'_C_p.txt']);
Cp=spconvert(Cp_dat); clear Cp_dat;

Fp=Ap+Cp;

Mp_dat=load([basename,'_M_p.txt']);
Mp=spconvert(Mp_dat); clear Mp_dat;

w=load([basename,'_w.txt']);
w=w(w(:,1),2); % proper ordering of w
n=size(w,1);

Dir=load([basename,'_Dir.txt']);
% apply the Dir to F
nv=size(F,1)/2;
F([Dir,nv+Dir],[Dir,nv+Dir])=speye(size(Dir,1)*2);


e=ones(n,1);
P=eye(n)-e*w';

disp('size(Ap)=');
disp(size(Ap));

pause(0);

switch 3
  case 1
    [VAp,DAp]=eig(full(Ap));
  case 2
    [VAp,DAp]=eig(full([Ap,w;w',0]));
    j=find(diag(DAp)<0)

    index=[1:j-1,j+1:n+1];
    VAp=VAp(index,index);
    DAp=DAp(index,index);
  case 3
    SC=B*full(inv(F))*B';
    Am1=P'*inv(Ap-e'*w); % Ap^-1
    Mm1=P'*inv(Mp-e'*w); % Mp^-1
    preco=Mm1*(Fp*Am1); % Mp^-1 * Fp * Ap^-1
    
    prod=preco*SC;
    
    [VAp,DAp]=eig(prod);
  case 4
    SC=B*full(inv(F))*B';
    
    [VAp,DAp]=eig(SC);
  case 5
    SC=B*full(inv(F))*B';
    Am1=P*inv(Ap-e'*w); % Ap^-1
    preco=inv(Mp)*(Fp*Am1); % M^-1 * Fp * Ap^-1
    
    prod=SC;
%    prod=preco;
%    prod=preco*SC;
    
    [VAp,DAp]=eig(prod);
  case 5
    [VAp,DAp]=eig(full(F));
end

EAp=diag(DAp);
[bla,index]=sort(abs(EAp));clear bla;
EAps=EAp(index);
VAps=VAp(:,index);

figure(1); clf;
plot(EAps,'d');

h1=title(sprintf('FEM level %d, %5d pressure nodes',lvl,n));
h2=xlabel('Real');
h3=ylabel('Imag');
set(h1,'FontSize',15);
set(h2,'FontSize',15);
set(h3,'FontSize',15);

pause(0);
print(gcf,'-depsc',sprintf('nopreco_SC_FEM_lvl_%d.eps',lvl));


%for i=1:20
%  figure(2); clf;
%  plot(VAps(:,i));
%
%  eApsi=EAps(i)
%  pause
%end

end;
