# - Find the UFconfig include
#
# This module defines
#  UFCONFIG_INCLUDE_DIR, where to find UFconfig.h, etc.
#  UFCONFIG_FOUND, If false, do not try to use UFconfig.

#=============================================================================
# Copyright 2010, Martin Koehler
# http://www-user.tu-chemnitz.de/~komart/
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================

find_path(UFCONFIG_UFCONFIG_INCLUDE_DIR UFconfig.h
	/usr/include
	/usr/local/include
	/usr/local/include/suitesparse 	#FreeBSD
	/usr/include/suitesparse	#Debian
	${SUITESPARSE}/UFconfig  #Local Setup
  )

if (UFCONFIG_UFCONFIG_INCLUDE_DIR )
      SET(UFCONFIG_INCLUDE_DIR ${UFCONFIG_UFCONFIG_INCLUDE_DIR} )
endif (UFCONFIG_UFCONFIG_INCLUDE_DIR)


# handle the QUIETLY and REQUIRED arguments and set UFconfig_FOUND to TRUE if
# all listed variables are TRUE
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(UFCONFIG  DEFAULT_MSG  UFCONFIG_UFCONFIG_INCLUDE_DIR)

mark_as_advanced(UFCONFIG_UFCONFIG_INCLUDE_DIR )
