# - Find the AMD includes and library
#
# This module defines
#  AMD_INCLUDE_DIR, where to find umfpack.h, etc.
#  AMD_LIBRARIES, the libraries to link against to use AMD.
#  AMD_FOUND, If false, do not try to use AMD.
# also defined, but not for general use are
#  AMD_LIBRARY, where to find the AMD library.
# None of the above will be defined unless UFconfig can be found.
# AMD depends on  UFConfig

#=============================================================================
# Copyright 2010, Martin Koehler
# http://www-user.tu-chemnitz.de/~komart/
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================

if(AMD_FIND_QUIETLY)
  set(_FIND_UFCONFIG_ARG QUIET)
endif(AMD_FIND_QUIETLY)
find_package(UFCONFIG ${_FIND_UFCONFIG_ARG})


if (UFCONFIG_FOUND) 
find_path(AMD_AMD_INCLUDE_DIR amd.h
	/usr/include
	/usr/local/include
	/usr/local/include/suitesparse 	#FreeBSD
	/usr/include/suitesparse	#Debian
	${SUITESPARSE}/AMD/Include  #Local Setup
  )

set(AMD_NAMES ${AMD_NAMES} libamd amd libamd.a amd.a)
set(AMD_PATH /usr/local/lib /usr/lib ${SUITESPARSE}/AMD/Lib)
find_library(AMD_LIBRARY NAMES ${AMD_NAMES} PATHS ${AMD_PATH} )

if (AMD_LIBRARY AND AMD_AMD_INCLUDE_DIR)
      SET(AMD_INCLUDE_DIR ${AMD_AMD_INCLUDE_DIR} ${UFCONFIG_INCLUDE_DIR} )
      SET(AMD_LIBRARIES ${AMD_LIBRARY} )
endif (AMD_LIBRARY AND AMD_AMD_INCLUDE_DIR)

endif (UFCONFIG_FOUND)

# handle the QUIETLY and REQUIRED arguments and set AMD_FOUND to TRUE if
# all listed variables are TRUE
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(AMD  DEFAULT_MSG AMD_LIBRARY AMD_AMD_INCLUDE_DIR)

mark_as_advanced(AMD_AMD_INCLUDE_DIR AMD_LIBRARY )
