/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
#include <math.h>
#ifdef fmax
#warning "math.h"
#endif

#include "feins_macros.h"
#include "datastruc.h"
#include "mesh.h"
#include "navsto_solver.h"

//#include <unistd.h>
#include <string.h>


int main(int argc, char *argv[])
{
  struct mesh msh1;

  struct solver_settings set;

  char *buffer;

  int  err;

  if (argc<1+1) 
    {
      printf("\n"
	     "%s: not enough arguments\n\n"
	     "usage:\n\n"
	     "   %s meshfile.f1m [para_file]\n"
	     "\n", argv[0], argv[0]);
      return FAIL;
    }

  printf("meshfile: %s", argv[1]);
  
  TRY_MALLOC(buffer, strlen(argv[1])+10, char, main);

  
  err=mesh_read_file_t1( &msh1, &set, argv[1] ); /* */
  FUNCTION_FAILURE_HANDLE( err, mesh_read_file_t1, main);

  err=mesh_write_ssegs_svg_tx( &msh1, 18, "visual/shape_segs", 1);
  FUNCTION_FAILURE_HANDLE( err, mesh_write_ssegs_svg_tx, main);  
  
  mesh_free(&msh1);
  free(buffer);

  return SUCCESS;
}
