/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
mesh_deform.h
*/
#ifndef __MESH_DEFORM_H__
#define __MESH_DEFORM_H__ 1

int mesh_deform_t1_t2(struct mesh *msh1, FIDX lvlm,
		      double **vx_new, FIDX *vx_max,
		      FIDX nI, struct vector *dIdx
/* computes a deformation of refined T2 versions of T1 mesh msh1,
   stores the resulting node positions in vx_new (if vx_new!=NULL)
   OR
   corrects dIdx to take into account that the position of the
   interior nodes are only a function of the nodes on the boundary
   (if dIdx!=NULL)

   Input:  msh1    - the coarse mesh (T1), hierarchy has to be reset,
                     i.e. msh1.edge[j*msh1.eg_w+MCT1EGLVL]=-1
		     for all j
	   nI      - size of dIdx (number of criteria)
           
   Output: vx_new  - reference to a pointer (vector) containing the
                     node positions for the finest mesh (T2), for
                     connectivity as resulting from mesh_t1_to_t2 and
                     then lvlm uniform refinements of the T2 mesh,
                     this vector can be straight plugged into each
                     mesh derived this way by     msh2.vertex=vx_new
                     so long as msh2.vx_nr<=vx_max, memory is
                     allocated here and has to be freed by the calling
                     routine, ignored if (vx_new==NULL)
	   vx_max  - number of nodes in vx_new (by reference), ignored
	             if (vx_new==NULL)

   In/Out: dIdx    - array of nI vectors of lentgh dim*vx_nr (finest
                     mesh), such that dIdx[i].V[d*vx_nr+j] is the
                     derivative of the i-th criterion wrt the
                     d-coordinate of the j-th node, if (dIdx!=NULL),
                     the values are corrected to reflect that the
                     position of the interior nodes is a function of
                     the position of the boundary nodes

   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid
	   10      - element orientation or area changed too much,
	             (detA_new/detA_old < 0.1)
*/);

int mesh_deform_start_t2(struct mesh *m, struct sparse *K
/* computes a deformation of T2 mesh msh according to the bezier splines,
    applies this deformation to the node positions


  Input/Output m    	- the coarse mesh (T1), hierarchy has to be reset,
			i.e. msh1.edge[j*msh1.eg_w+MCT1EGLVL]=-1
			for all j
  Input   K	- stiffness matrices of the coarser meshes

   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid
	   10      - element orientation or area changed too much,
	             (detA_new/detA_old < 0.1)
*/);
#endif
