/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
assem_conv_diff.h
*/
#ifndef __ASSEM_CONV_DIFF_H__
#define __ASSEM_CONV_DIFF_H__ 1



#include "feins_macros.h"

#include "datastruc.h"
#include "sparse_struct.h"


int assem_conv_diff_tx(struct sparse *M, struct sparse *K,
                       struct vector *rhs,  struct vector *rhsdot,
		       double *maxPe, double *eps,
		       struct sparse *A, struct sparse *B,
		       double cA_K, double cA_M, 
		       double cB_K, double cB_M, 
		       struct mesh *m, int stab, double time,
		       int type
/* performs the assembly of the stiffness matrix K and the right hand
   side vector rhs which result from SUPG stabelised finite element
   discretisation of the convection-diffusion equation on the
   triangular mesh m, such that

           K x = rhs

   or for time dependent problems 
        
           M \dot{x} + K x = rhs

   defines the (approximate) solution x=(u) of

     [du/dt]  -\nabla \dot eps \nabla(u) + b * grad u = f

   with where eps is a matrix of diffusion coefficients,
   b=m.function[0] and boundary conditions as given in the mesh m 

   In addition or alternatively the matrices 
               A= cA_K*K + cA_M*M, 
               B= cB_K*K + cB_M*M
   can be computed, where the coefficients c*_* are user defined. This
   is designed in order to allow the computation of the matrices for
   time stepping schemes, e.g. the backward Euler scheme can be
   written as
               (1/tau M + K) u(k+1) = b(t) + 1/tau M u(k)
              =           A  u(k+1) = b(t) +       B u(k).            

   Input:  eps     - matrix of diffusion coefficients, eps should be
                     symmetric positive definite, eps_i,j=eps[i*dim+j]
           m       - the mesh
	   stab    - to indicate wether stabilization shall be used
	             for the advection term or not, stab==0: use no
	             stabilisation, stab==1: use SUPG stabilisation
           type    - type of mesh, ==1 means linear (P1) elements, 
                     ==2 means quadratic (P2) elements,
           cA_K, cA_M, cB_K, cB_M
                   - coefficients for assembling K and M to the
                     matrices A and B, as described above. ignored if
                     the pointer to the correspoding matrix (A or B)
                     is ==NULL     
	   time    - for time dependent problems this is the time at
	             which K,M,A,B,rhs,rhsdot are to be evaluated. for
	             stationary problems just use time=0.0
           
   In/Out: M       - mass matrix as struct sparse, initialisation
                     and finalisation should be done by the caling
                     routine, ignored if ==NULL
           K       - stiffness matrix as struct sparse, initialisation
                     and finalisation should be done by the caling
                     routine, ignored if ==NULL
           A       - A=cA_K*K+cA_M*M, as struct sparse, initialisation
                     and finalisation should be done by the caling
                     routine, ignored if ==NULL
           B       - B=cB_K*K+cB_M*M, as struct sparse, initialisation
                     and finalisation should be done by the caling
                     routine, ignored if ==NULL
	   rhs     - righthand side vector, has to be initialised by
                     the calling routine
	   rhsdot  - time derivative of the righthand side vector, has
	             to be initialised by the calling routine

   Output: maxPe   - maximum Peclet number observed in the mesh

   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid
*/);
#endif
