
clear all;

problem='pedcrank';
switch problem
 case 'tobs'
  na=1; nb=3;
  level=3;  nu=0.1; % later
  %level=4; nu=0.05;
  movie_dir='../build/visual/';
  histfile=sprintf('tobs_eval_hist_%d_%d_%d_%f_movie1.mat',...
                   na,nb,level,nu);
  plot_title=sprintf('tobst history, nu=%7.1e',nu);
  movie_basename=sprintf('tobs_movie_%d_%d_%d_%f',na,nb,level,nu);
  nmax=153;
 case 'pedcrank'
  level0=0; level=25;  alpha=10; 
  movie_dir='/tmp/pedcrank/visual/';
  histfile=sprintf('pedcrank2_eval_hist_%d_%d_%f.mat',...
      level0,level,alpha);
  plot_title=sprintf('pedcrank history, alpha=%7.1e',alpha);
  movie_basename=sprintf('pedcrank2_movie_%d_%d_%f_',...
      level0,level,alpha);
  nmax=200;
 otherwise
  error('swtich for unknown problem')
end

disp('load histfile');
load([movie_dir,histfile]);
disp('done load histfile');
 

n=length(crit_evals)

disp(sprintf('warning: limit to first %d evals',nmax)),
n=min([n,nmax]);

crit_vec=zeros(n,2);
% make vector from cell
for i=1:n
  crit_vec(i,:)=crit_evals{i}';
end



% filter out decreasing sequence (successful steps)

% list of successful indices, initialise to -1, length=:ns=0
crit_success=-ones(n,1);
ns=0;

last=crit_vec(1,1)+100;
for i=1:n;
  if crit_vec(i,1)<last
    ns=ns+1;
    
    crit_success(ns)=i;
    last=crit_vec(i,1);
  end
end

crit_success=crit_success(1:ns);

if (0==1)
  figure(1)
  clf;
  plot(1:n,crit_vec(1:n,1))
  hold on;
  plot(crit_success,crit_vec(crit_success,1),'r+-')
  legend({'all evals';'successful steps'})
  title(plot_title);
  xlabel('evaluation number')
  ylabel('performance criterion')
  figfontifier(gcf,15)

  figure(2)
  plot(crit_success,crit_vec(crit_success,1),'r+-')
  legend({'successful steps'})
  title(plot_title);
  xlabel('evaluation number')
  ylabel('performance criterion')
  figfontifier(gcf,15)
end

time_list_name=[movie_dir,histfile,'__time_list'];
tfile=fopen(time_list_name,'w');
for i=1:ns
  fprintf(tfile,'        <Element index="%d" value="%d"/>\n',i-1,crit_success(i));
end
fclose(tfile);

file_list_name=[movie_dir,histfile,'__file_list'];
ffile=fopen(file_list_name,'w');
for i=1:ns
  fprintf(ffile,'        <Element index="%d" value="%s_%03d.vtk"/>\n',i-1,movie_basename,crit_success(i));
end
fclose(ffile);

% generate directory with filtered files
if (1==1)
  filter_dir=sprintf('%s/%s_movie_filter', movie_dir,histfile);
  command=sprintf('mkdir %s', filter_dir);
  system(command);
  for i=1:ns
    command=sprintf('cp %s/%s_%03d.vtk %s/', ...
                    movie_dir,movie_basename, crit_success(i), ...
                    filter_dir);
    system(command);
  end
end


command=sprintf('cp movie_template.pvsm %s/%s_gen.pvsm', movie_dir,histfile);
system(command);

command=sprintf(...
'pushd %s; sed -e"s+##_FILE_LIST_##+$(sed -e"s_\\"_\\\\\\\\\\"_g" -e"s_\\$_\\\\n_" %s__file_list|tr -d "\\n")+" %s_gen.pvsm -e"s+##_TIME_LIST_##+$(sed -e"s_\\"_\\\\\\\\\\"_g" -e"s_\\$_\\\\n_" %s__time_list|tr -d "\\n")+" -e"s+##_END_STEP_##+%d+" -e"s+##_END_TIME_##+%d+" >output.pvsm ;popd',...
    movie_dir,histfile, histfile, histfile, ns, crit_success(ns)),
system(command);


