/* @Hdr */

#include <stdio.h>
#include "grape.h"


/* @DOC read_ebsel_fe2d */

/* grape-methode "read-ebsel-2d"
 *  
 * Call              : (FE2D *)GRAPE(Fe2d, "read-ebsel-2d")
 *                                  (inst_name,filename,geoflag)
 *                            
 * Parameters        : CLASS *Fe2d
 *                     char *inst_name, *filename
 *                     int geoflag
 * 
 * Description       : erzeuge Fe2d Instanz aus Ebsel Datei mit druck
 *                     geoflag = 0 ( lies keine geometrie ein)
 *                     geoflag = 1 ( lies geometrie mit ein  )
 *                              
 * Keywords          : read-ebsel fe2d
 *
 * Author            : matthias schrul
 *
 * Copyright (c) 1990     by Universitaet Bonn
 *                           Institut fuer Angewandte Mathematik
 *                           Sonderforschungsbereich 256
 *                           D-5300 Bonn 1
 *
 * history           : 19.07.94 erstellt
 *
 */



/* @SRC f2d_rd_ebsel.c */

typedef double DOUBLE3[3];
typedef double DOUBLE2[2];

void gaga(fe,k,bary,vec)

FE2D *fe;
int k;
double bary[3],vec[];
{
  int i,j,jj,j_count;
  VEC3 p;
  INT3 *triange;
    
  triange = (INT3 *)(&fe->vertex[fe->number_of_elements][0]);

  if(fe->dimension_of_value == 2) 
    for(i=0;i<2;i++)
      {
	for(vec[i] = 0.0, j = 0;j<3;j++) 
	  {
	    vec[i] += bary[j] * (2.*bary[j]-1.) * 
	      ((DOUBLE3 *)fe->data)[fe->vertex[k][j]][i];
	  }

	vec[i] += 4* bary[0] * bary[1] *((DOUBLE3 *)fe->data)[triange[k][0]][i];
	vec[i] += 4* bary[1] * bary[2] *((DOUBLE3 *)fe->data)[triange[k][1]][i];
	vec[i] += 4* bary[0] * bary[2] *((DOUBLE3 *)fe->data)[triange[k][2]][i];

/*      for(j=j_count=0;j<3;j++){
	for(jj=j+1;jj<3;jj++) {
	vec[i] += 4 * bary[j] * bary[jj] * 
	((DOUBLE3 *)fe->data)[triange[k][j_count]][i];
	j_count++;
	}
	}  */
      
      }
  else
    for(vec[0] = 0, j = 0;j<3;j++) {
      vec[0] += bary[j] * ((DOUBLE3 *)fe->data)[fe->vertex[k][j]][2];
    }
}


FE2D *fe2d_read_ebsel_2d(inst_name, filename, geoflag)
     char *inst_name, *filename;
     int geoflag;

{
  FILE *geom_file;
  int nnode,ntriang;
  double *x, *y;
  INT3 *triangp, *triangd, intt3, *triange, int3;
  DOUBLE2 real2;
  DOUBLE3 real3;
  CLASS *class;
  FE2D *fe;
  int i,j;
  int geo;

  fe = NIL;
  class = (CLASS *)START_METHOD(G_CLASS);
  ASSURE(class,
	 "read-ebsel : can't manage instances",
	 END_METHOD(NIL));

  /* read in the triangulation.
     x,y become the vertex coorinates,
     fe->data become the vertex values.

     triangp[][3] become the vertex numbers for each triangeders 
     triange[][3] become the vertex numbers for a mid point of an edge 
     triangd[][3] become the neighbour numbers for each triangeders */

  fe = (FE2D *)GRAPE(class,"new-instance")(inst_name);
  ASSURE(fe,
	 "read-ebsel-2d : cannot create Fe2d instance",
	 END_METHOD(NIL));
  
  ASSURE(((geom_file=fopen(filename,"r")) != NULL),
	 "read-ebsel-2d: cannot open input file",
	 END_METHOD(NIL));

  fread(&geo,1,sizeof(int),geom_file);

  ASSURE((!geoflag || geo),
	 "read-ebsel-2d : can't read geometry\n",
	 END_METHOD(NIL));
	 

  fread(&nnode,1,sizeof(int),geom_file);
  fread(&ntriang,1,sizeof(int),geom_file);

  ASSURE( ((ntriang>0) && (nnode>0)),
	 "empty tetrangulation",
	 END_METHOD(NIL) );
  
  fe->number_of_points = nnode;
  fe->max_number_of_points = nnode;
  fe->number_of_elements = ntriang;
  fe->max_number_of_elements = ntriang;

  if(geoflag) {
    fe->x = x = (double *)mem_alloc(nnode*sizeof(double));
    fe->y = y = (double *)mem_alloc(nnode*sizeof(double));
    fe->vertex = triangp = 
      (INT3 *)mem_alloc(ntriang*sizeof(INT3)+ntriang*sizeof(INT3));
    triange = (INT3 *)(&fe->vertex[fe->number_of_elements][0]);
    fe->neighbour = triangd = (INT3 *)mem_alloc(ntriang*sizeof(INT3));
  }
   
  fe->data = (char *)mem_alloc(nnode*sizeof(DOUBLE3));
  fe->size_of_data = nnode*sizeof(DOUBLE3);
  

  ASSURE( ((!geoflag || (x&&y&&triangp&&triangd)) && fe->data),
	 "read-ebsel-2d : can not allocate memory",
	 END_METHOD(NIL));




  for (i=0;i<nnode;i++) {

       if(geo)  fread(&real2,1,sizeof(DOUBLE2),geom_file);
       if(geoflag) { x[i] = real2[0]; y[i] = real2[1]; }

       fread(&real3,1,sizeof(DOUBLE3),geom_file);

       for(j=0;j<3;j++) ((DOUBLE3 *)fe->data)[i][j] = real3[j];


  }



  if(geoflag) {
    for (i=0;i<ntriang;i++) {
        fread(&intt3,1,sizeof(INT3),geom_file);
        for(j=0;j<3;j++) triangp[i][j] = intt3[j];

        fread(&int3,1,sizeof(INT3),geom_file);
        for(j=0;j<3;j++) triange[i][j] = int3[j];
    }


    fread(triangd,ntriang,sizeof(INT3),geom_file);


    }
  



  if(geoflag) {
    fe->vertex = triangp;
    fe->neighbour = triangd;
  }
  
  fe->f = gaga;
#ifndef PRESSURE_VERSION
  fe->dimension_of_value = 2;
  fe->polynomial_order = 2;
#else
  fe->dimension_of_value = 1;
  fe->polynomial_order = 1;
#endif


  GRAPE(fe, "fit2window-send")(); /**/

  fclose(geom_file);
  END_METHOD(fe);
  
  /* GRAPE(fe, "vect-disp")(); /* no idea where this should go */ 

}
