# - Find the UMFPACK includes and library
#
# This module defines
#  UMFPACK_INCLUDE_DIR, where to find umfpack.h, etc.
#  UMFPACK_LIBRARIES, the libraries to link against to use UMFPACK.
#  UMFPACK_FOUND, If false, do not try to use UMFPACK.
# also defined, but not for general use are
#  UMFPACK_LIBRARY, where to find the AMD library.
# None of the above will be defined unless AMD can be found.
# UMFPACK depends on AMD and UFConfig

#=============================================================================
# Copyright 2010, Martin Koehler
# http://www-user.tu-chemnitz.de/~komart/
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================

if(UMFPACK_FIND_QUIETLY)
  set(_FIND_UFCONFIG_ARG QUIET)
  set(_FIND_AMD_ARG QUIET)
endif(UMFPACK_FIND_QUIETLY)
find_package(UFCONFIG ${_FIND_UFCONFIG_ARG})
find_package(AMD ${_FIND_AMD_ARG})

if (UFCONFIG_FOUND AND AMD_FOUND) 
find_path(UMFPACK_UMFPACK_INCLUDE_DIR umfpack.h
	/usr/include
	/usr/local/include
	/usr/local/include/suitesparse 	#FreeBSD
	/usr/include/suitesparse	#Debian
	${SUITESPARSE}/UMFPACK/Include  #Local Setup
  )

set(UMFPACK_NAMES ${UMFPACK_NAMES} umfpack libumfpack)
set(UMFPACK_PATH /usr/local/lib /usr/lib ${SUITESPARSE}/UMFPACK/Lib)
find_library(UMFPACK_LIBRARY NAMES ${UMFPACK_NAMES} PATHS ${UMFPACK_PATH} )



if (UMFPACK_LIBRARY AND UMFPACK_UMFPACK_INCLUDE_DIR)
      SET(UMPFACK_INCLUDE_DIR ${UMFPACK_UMFPACK_INCLUDE_DIR} ${AMD_INCLUDE_DIR} ${UFconfig_INCLUDE_DIR} )
      SET(UMFPACK_LIBRARIES ${UMFPACK_LIBRARY} ${AMD_LIBRARIES} )
endif (UMFPACK_LIBRARY AND UMFPACK_UMFPACK_INCLUDE_DIR)

endif (UFCONFIG_FOUND AND AMD_FOUND)

# handle the QUIETLY and REQUIRED arguments and set UMFPACK_FOUND to TRUE if
# all listed variables are TRUE
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(UMFPACK  DEFAULT_MSG  UMFPACK_LIBRARY UMFPACK_UMFPACK_INCLUDE_DIR)

mark_as_advanced(UMFPACK_UMFPACK_INCLUDE_DIR UMFPACK_LIBRARY )
