# - Find the CXSPARSE includes and library
#
# This module defines
#  CSPARSE_INCLUDE_DIR, where to find umfpack.h, etc.
#  CSPARSE_LIBRARIES, the libraries to link against to use CSPARSE.
#  CSPARSE_FOUND, If false, do not try to use CSPARSE.
# also defined, but not for general use are
#  CSPARSE_LIBRARY, where to find the CSPARSE library.
#
#
# A system wide installed CSPARSE is mapped to CXSPARSE on nearly all systems
# (tested on FreeBSD, Debian GNU/Linux, Gentoo)

#=============================================================================
# Copyright 2010, Martin Koehler
# http://www-user.tu-chemnitz.de/~komart/
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================

find_path(CSPARSE_CSPARSE_INCLUDE_DIR cs.h
	/usr/include
	/usr/local/include
	/usr/local/include/suitesparse 	#FreeBSD
	/usr/include/suitesparse	#Debian
	${SUITESPARSE}/CXSparse/Include  #Local Setup
  )

set(CSPARSE_NAMES ${CSPARSE_NAMES} cxsparse libcxsparse)
set(CSPARSE_PATH /usr/local/lib /usr/lib ${SUITESPARSE}/CXSparse/Lib)
find_library(CSPARSE_LIBRARY NAMES ${CSPARSE_NAMES} PATHS ${CSPARSE_PATH} )

if (CSPARSE_LIBRARY AND CSPARSE_CSPARSE_INCLUDE_DIR)
      SET(CSPARSE_INCLUDE_DIR ${CSPARSE_CSPARSE_INCLUDE_DIR} )
      SET(CSPARSE_LIBRARIES ${CSPARSE_LIBRARY} )
endif (CSPARSE_LIBRARY AND CSPARSE_CSPARSE_INCLUDE_DIR)

# handle the QUIETLY and REQUIRED arguments and set AMD_FOUND to TRUE if
# all listed variables are TRUE
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(CSPARSE  DEFAULT_MSG CSPARSE_LIBRARY CSPARSE_CSPARSE_INCLUDE_DIR)

mark_as_advanced(CSPARSE_CSPARSE_INCLUDE_DIR CSPARSE_LIBRARY)
