/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
linsolve_umfpack.h
*/
#ifndef __LINSOLVE_UMFPACK_H__
#define __LINSOLVE_UMFPACK_H__ 1

int linsolver_init(struct linsolver *S
/* initialises S to be empty, such that it can be emptied or deleted without
   problems 
   
   Input:  (none)

   Output: S       - (S is given by reference), is initialised

   Return: SUCCESS - success,
           FAIL    - failure, see error message
*/);

int linsolver_free(struct linsolver *S  
/* frees memory in S 
   
   Input:  (none)

   Output: S       - (S is given by reference), is emptied/freed

   Return: SUCCESS - success,
           FAIL    - failure, see error message
*/
);
#endif
