/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
lame_adj.h
*/
#ifndef __LAME_ADJ_H__
#define __LAME_ADJ_H__ 1



#include "feins_macros.h"

#include "datastruc.h"

int lame_dIdu_t2( struct mesh *m,
                  struct vector *u,
		  struct vector *dIdu,
		  double *Is,
		  double lambda,
		  double mu
/* evaluates the performance criteria (given with the mesh) for the
   supplied solution vector sol, stores the values in pcvec

   Input:  m       - the mesh
           u       - vector containing the solution of a lame problem, 
	             calculated using the T2/T1 element pair
	   lambda,
           mu      - lame parameters

   Output: dIdu    - vector containing the values of the derivates 
                     of Is with respect to the solution u, ignored if ==NULL
           Is      - the value of the performance criteria (by
                     reference), ignored if ==NULL


   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid
*/);

int lame_DIDx_t2( struct mesh *m,
                   double lambda,
                   double mu,
		   struct vector *psi,
                   struct vector *u,
                   struct vector *DIDx
    
/* evaluates the derivatives of the performance criteria (given with
   the mesh) with respect to the nodal coordinates, using the adjoint
   solution psi

     DI   dI         dR
     -- = -- - psi^T --
     Dx   ds         ds

   Input:  m         - the mesh
           lambda    - Lame' constant 
           mu        - Lame' constant 
	   psi       - vector containing the solution of the adjoint equation
           u         - vector containing the solution of a lame problem

   Output: DIDx     - total gradient of I with espect to the node positions

   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid
*/);
#endif
