/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
assem_conv_diff.h
*/
#ifndef __ASSEM_CONV_DIFF_H__
#define __ASSEM_CONV_DIFF_H__ 1



#include "feins_macros.h"

#include "datastruc.h"
#include "sparse_struct.h"


int assem_conv_diff_tx(struct sparse *K, struct vector *rhs, double *maxPe,
		       struct mesh *m, int stab, FIDX type
/* performs the assembly of the stiffness matrix K and the right hand
   side vector rhs which result from SUPG stabelised finite element
   discretisation of the convection-diffusion equation on the
   triangular mesh m, such that

           K x = rhs

   defines the (approximate) solution x=(u) of

         -eps Laplace(u) + b * grad u = f

   with eps=m.para[MC2XPANUPO], b=m.function[0] and boundary conditions as
   given in the mesh m 

   Input:  m       - the mesh
	   stab    - to indicate wether stabilization shall be used
	             for the advection term or not, stab==0: use no
	             stabilisation, stab==1: use SUPG stabilisation
           type    - type of mesh, ==1 means linear (P1) elements, 
                     ==2 means quadratic (P2) elements
           
   In/Out: K       - stiffness matrix as struct sparse, initialisation
                     and finalisation should be done by the caling
                     routine  
	   rhs     - righthand side vector, has to be initialised by
                     the calling routine

   Output: maxPe   - maximum Peclet number observed in the mesh

   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid
*/);
#endif
