% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************


global nu; global beta; global level;
global divider_a; global divider_b; global divider_d; global divider_e;


%nu=1e-0; beta=200; level=1; %106 %d   505.5s
%nu=1e-0; beta=200; level=2; %106 %d  3064.5s
%nu=1e-0; beta=200; level=3; %106 %d 15888.7s
%nu=1e-0; beta=200; level=4; %106 %d 72948.9s
%nu=1e-0; beta=200; level=5; %106 ????????????????????

%nu=1e-0; beta=10; level=1;
%nu=10e-1; beta=10; level=1;
%nu=5e-1; beta=10; level=2;
%nu=2.5e-1; beta=10; level=3;
%nu=1.2e-1; beta=10; level=4;
nu=1e-1; beta=10; level=4; % 133
%nu=1e-2; beta=10; level=5; % out of reach ?

nu, beta, level

% a,b,d,e documented in mesh generation
divider_a=1; 
divider_b=2*divider_a;
divider_d=0.1;
divider_e=0.25;


%x0=[0.3; 0.6; 1.3]; 
x0=[0.6; 1.5]; 

divider_n_adjoint_eval(x0);

[xopt,fevals,hist]=donlp2(x0,...
    @divider_n_adjoint_eval,...
    @divider_n_adjoint_constr);

