/* GRAPE 5.4.2 header for gnu created */
#ifndef G_VERSION_ID
#define G_VERSION_ID "5.4.2"
#endif
#define G_DEFNTN_HOSTTYPE "gnu"
#define G_HEADER_TIMESTAMP 1075895759
#define G_HEADER_CODE (1187071689+18240)
#ifndef G_BUILD_ID
#define G_BUILD_ID "  17"
#endif
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <limits.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#ifdef mem_alloc
#undef mem_alloc
#undef mem_free
#endif
#ifdef ardent
#include <sys/types.h>
#endif
#ifdef G_CPP
#define G_DOTDOTDOT ...
#else
#define G_DOTDOTDOT
#endif
#ifdef NIL
#undef NIL
#endif
#define NIL 0L
#ifdef ERR
#undef ERR
#endif
#define ERR -1L
typedef enum {
  msNothing  = 0,
  msStatic   = 1,
  msOutdate  = 2,
  msUpdate   = 4
} METHSTAT;
typedef struct {
  char a_simple_dummy_char;
} *GRAPE_METHOD_RETURN;
typedef GRAPE_METHOD_RETURN(*GRAPE_METHOD_CODE)(G_DOTDOTDOT);
typedef struct method {
  struct method *left;
  struct method *right;
  short	 balance;
  char	 const*name;
  struct class *class;
  GRAPE_METHOD_CODE code;
  size_t namelen;
  METHSTAT status;
  void   *highscore;
  size_t mhcode;
} METHOD;
typedef enum {
  csNothing	 = 0,
  csStatic	 = 1,
  csNoTrace      = 2,
  csNoInodeTrace = 4
} CLASSSTAT;
typedef struct class {
  struct class *itself;
  char	*name;
  struct class *superclass;
  struct class *subclasses;
  struct class *next;
  struct instance *instances;
  struct method *methods;
  struct method *last_method;
  char const *last_called_name;
  CLASSSTAT status;
  size_t isize;
  void	 *mhtable;
  int	 mhtable_size;
  struct g_list *addons;
  struct g_list *used_addons;
  int	 number_of_addon_offsets;
  struct addon_offset *addon_offset;
} CLASS;
#define INSTANCE_STRUCT \
  struct class *class; \
  char *name; \
  struct instance *next_inst_of_class; \
  struct instance *prev_inst_of_class; \
  struct inode *inode; \
  unsigned int refcount
typedef struct instance {
  INSTANCE_STRUCT;
} INSTANCE;
#ifdef __i386__
#define G_SORT_METHODS_BY_LEN
#endif
#ifdef G_SORT_METHODS_BY_LEN
#ifdef __i386__
#define G_METHCMP(aname,alen,bname,blen)\
   (((alen)-(blen))?(signed)((alen)-(blen)):memcmp((aname),(bname),(alen)))
#define G_METHCMPTMP(aname,alen,bname,blen,tmp)\
   ((tmp=(int)((alen)-(blen)))?tmp:memcmp((aname),(bname),(alen)))
#else
#define G_METHCMP(aname,alen,bname,blen)\
   (((alen)-(blen))?(signed)((alen)-(blen)):strcmp((aname),(bname)))
#define G_METHCMPTMP(aname,alen,bname,blen,tmp)\
   ((tmp=(int)((alen)-(blen)))?tmp:strcmp((aname),(bname)))
#endif
#else
#define G_METHCMP(aname,alen,bname,blen) (strcmp((aname),(bname)))
#define G_METHCMPTMP(aname,alen,bname,blen,tmp)\
   (strcmp((aname),(bname)))
#endif
#define G_METHSTRCMP(aname, bname)\
   G_METHCMP ((aname), strlen (aname), (bname), strlen (bname))
#define ASSIGN(p,q) ((void)(((p)=(q))->refcount++))
#define DEASSIGN(p) do{INSTANCE**q=(INSTANCE**)&(p);\
   if(*q)*q=(INSTANCE*)GRAPE(*q,"delete")();}while(0)
#define G_EMPTY_ARG
#ifndef __FILE__
#  define __FILE__ NULL
#endif
#ifndef __LINE__
#  define __LINE__ 0
#endif
#define ASSURE(condition,message,error_exit) \
do{if(!(condition))  { \
  grape_error(message,__FILE__,__LINE__,0); \
  error_exit; \
}}while(0)
#ifdef DEBUG
#define MESSAGE(S) printf S
#else
#define MESSAGE(S)
#endif
void *g_mem_alloc (size_t const);
void g_mem_free (void *G_CONST, size_t const);
void *g_mem_realloc (void *,size_t const,size_t const);
#define G_BLOCKSIZE (~((size_t)17))
int g_get_mem_block_info (void *, void **, size_t *);
size_t g_get_memory_manager_used_size (void);
size_t g_get_memory_manager_used_max (void);
size_t g_get_memory_manager_free_size (void);
void g_print_memory_manager_info (void);
void g_print_lost_blocks (size_t, int);
#define mem_alloc g_mem_alloc
#define mem_free g_mem_free
#define mem_realloc g_mem_realloc
typedef struct {
long magic;
} *G_BMM;
G_BMM g_bmm_new      (size_t, size_t);
void  g_bmm_destroy  (G_BMM);
void  g_bmm_free_all (G_BMM);
int   g_bmm_is_empty (G_BMM);
void *g_bmm_alloc    (G_BMM);
void  g_bmm_free     (G_BMM, void *);
void  g_bmm_new_num  (G_BMM, size_t);
void  g_bmm_raise_num(G_BMM, size_t);
void  g_bmm_shrink   (G_BMM);
G_BMM g_bmm_get_std  (size_t);
char const*g_compressed_strdup (char const * const, const int);
int grape_error(const char*, const char*, int, int);
extern int g_trace;
#define _trace g_trace
INSTANCE *start_method(int const);
#ifdef __sun
int end_method(void const * const);
#else
void end_method(void const * const);
#endif
#ifdef G_CODE_CHECK
GRAPE_METHOD_CODE grape(void *const, char *const, \
                        const unsigned long, const char);
#else
GRAPE_METHOD_CODE grape(void *const, char *const, const char);
#endif
char *g_convert_method (char const * const);
char const*g_strip_method (char const * const);
void g_flush_const_method_cache (void);
extern int g_const_meth_hashing;
#define G_CLASS    1
#define G_INSTANCE 2
#ifdef __sgi
#define ZEROSTR "\0       "
#define ZEROSTR2 "\0     "
#else
#define ZEROSTR
#define ZEROSTR2
#endif
#define START_METHOD(mode) start_method((mode))
#ifdef __sun
#define END_METHOD(val) do{if(end_method((val)))return(val);}while(0)
#else
#define END_METHOD(val) do{end_method((val));return(val);}while(0)
#endif
#ifdef G_CODE_CHECK
#define GRAPE(obj,meth) (*grape((obj),(meth),G_HEADER_CODE,#meth ZEROSTR2[0]))
#else
#define GRAPE(obj,meth) (*grape((obj),(meth),#meth ZEROSTR2[0]))
#endif
typedef struct {CLASS *class; void *object;} G_CLASS_CAST_DESCRIPTOR;
extern G_CLASS_CAST_DESCRIPTOR g_class_cast_descriptor;
#define G_CAST_CLASS(obj,newclass)\
 (g_class_cast_descriptor.object = (obj),\
  g_class_cast_descriptor.class = (newclass),\
  &g_class_cast_descriptor)
typedef struct G_Node {
  struct G_Node *next;
  struct G_Node *prev;
  void *obj;
} G_NODE;
#define G_LIST_STRUCT \
  INSTANCE_STRUCT; \
  char *type; \
  G_NODE *head; \
  G_NODE *tail; \
  G_NODE *iter; \
  G_NODE **iter_stack; \
  int number_of_iter, max_number_of_iter
typedef struct g_list {
  G_LIST_STRUCT;
} G_LIST;
int g_list_add_head(G_LIST*, void*);
int g_list_add_tail(G_LIST*, void*);
int g_list_add_pre(G_LIST*, void*);
int g_list_add_post(G_LIST*, void*);
int g_list_insert(G_LIST*, void*, void*);
void*g_list_rem_head(G_LIST*);
void*g_list_rem_tail(G_LIST*);
void*g_list_rem_curr(G_LIST*);
void*g_list_remove(G_LIST*, void*);
void*g_list_first(G_LIST*);
void*g_list_last(G_LIST*);
void*g_list_next(G_LIST*);
void*g_list_previous(G_LIST*);
void*g_list_current(G_LIST const*);
int g_list_set_current(G_LIST*, void*);
int g_list_count_entries(G_LIST const*);
int g_list_push_iter(G_LIST*);
int g_list_dup_iter (G_LIST*, int);
int g_list_xchg_iter (G_LIST*, int);
int g_list_pop_iter(G_LIST*, int);
void*g_list_first_for(G_LIST*, int);
void*g_list_last_for(G_LIST*, int);
void*g_list_current_for(G_LIST const*, int);
void*g_list_next_for(G_LIST*, int);
void*g_list_previous_for(G_LIST*, int);
int g_list_get_curr_iter (G_LIST const*);
int g_has_superclass(INSTANCE *, CLASS *);
int g_is_subclass_of(CLASS *, CLASS *);
int g_is_kind_of (INSTANCE *, INSTANCE *);
G_LIST *g_get_all_instances(CLASS *, G_LIST *);
#define G_IS_A_CLASS(inst) ((inst)->class == (CLASS *)inst)
#define G_IS_AN_INSTANCE(inst) ((inst)->class != (CLASS *)inst)
#define G_CLASSIFY(inst) ((inst) ? G_IS_A_CLASS(inst) ? G_CLASS \
 : G_INSTANCE : 0)
#define ADDON_STRUCT \
  INSTANCE_STRUCT; \
  CLASS *base_class; \
  G_LIST *methods; \
  G_LIST *classes; \
  G_LIST *subs; \
  size_t adsize; \
  struct addon *parent, \
               *offs; \
  int shared_struct
typedef struct addon {
  ADDON_STRUCT;
} ADDON;
struct addon_offset {
  ADDON *addon;
  size_t offset;
  int refcount;
};
struct static_addon_class_descr {
  CLASS **class;
  size_t offset;
  int usecount;
};
struct static_addon_method_descr {
  char *name;
  GRAPE_METHOD_CODE code;
};
typedef struct static_addon {
  ADDON **self;
  CLASS **base_class;
  char *name;
  ADDON **parent;
  int shared_struct;
  int adsize;
  struct static_addon_class_descr *classes;
  struct static_addon_method_descr *methods;
} STATIC_ADDON;
void *g_get_addon_variables (INSTANCE *, ADDON *);
int g_uses_addon (INSTANCE *, ADDON *);
typedef enum {
  isUpToDate = 1,
  isUpDating = 2,
  isDeleting = 4
} INODESTATUS;
typedef struct inode {
  INSTANCE *obj;
  unsigned irefcount;
  INODESTATUS status;
  G_LIST *ingr;
  G_LIST *dep;
  G_LIST *update;
} INODE;
typedef enum {
  psMultiPort = 1,
  psReference = 2,
  psUpToDate  = 4,
  psDisabled  = 8,
  psHidden    = 16
} IPORTSTATUS;
typedef struct iconn {
  IPORTSTATUS status;
  struct iconn *conn;
} ICONN;
typedef struct {
  IPORTSTATUS status;
  void *private;
  INODE *node;
  char *id;
  CLASS *type;
} IPORT;
typedef struct {
  IPORTSTATUS status;
  ICONN *conn;
  INODE *node;
  char *id;
  CLASS *type;
} ISINGLEPORT;
typedef struct {
  IPORTSTATUS status;
  G_LIST *clist;
  INODE *node;
  char *id;
  CLASS *type;
} IMULTIPORT;
typedef struct {
  IPORTSTATUS status;
  ICONN *conn;
  IMULTIPORT *port;
} IMULTINODE;
extern int g_inode_trace;
int g_do_outdate_instance(INSTANCE *);
int g_do_update_instance(INSTANCE *);
#define g_outdate_instance(inst) \
  (!((inst)->inode) || \
   g_do_outdate_instance((INSTANCE *)(inst)))
#define g_update_instance(inst) \
  (!((inst)->inode) || \
   ((inst)->inode->status & (isUpToDate|isUpDating)) ||\
   g_do_update_instance((INSTANCE *)(inst)))
#define ANSI_PARM(X) X
#if defined (G_NO_CONST) || \
    (defined (__sgi) && defined (__mips) && __mips <= 2)
#define G_CONST
#else
#define G_CONST const
#endif
typedef double VEC2 [2], VEC3 [3], VEC4 [4];
#define CONST_ARG_VEC2 G_CONST double*
#define CONST_ARG_VEC3 G_CONST double*
#define CONST_ARG_VEC4 G_CONST double*
#define G_CONST_ARG_VEC2 G_CONST double*
#define G_CONST_ARG_VEC3 G_CONST double*
#define G_CONST_ARG_VEC4 G_CONST double*
typedef float  FVEC2[2], FVEC3[3], FVEC4[4];
#define CONST_ARG_FVEC2 G_CONST float*
#define CONST_ARG_FVEC3 G_CONST float*
#define CONST_ARG_FVEC4 G_CONST float*
#define G_CONST_ARG_FVEC2 G_CONST float*
#define G_CONST_ARG_FVEC3 G_CONST float*
#define G_CONST_ARG_FVEC4 G_CONST float*
typedef int    INT2 [2], INT3 [3], INT4 [4];
#define CONST_ARG_INT2 G_CONST int*
#define CONST_ARG_INT3 G_CONST int*
#define CONST_ARG_INT4 G_CONST int*
#define G_CONST_ARG_INT2 G_CONST int*
#define G_CONST_ARG_INT3 G_CONST int*
#define G_CONST_ARG_INT4 G_CONST int*
typedef double MATRIX22[2][2], MATRIX33[3][3], MATRIX44[4][4];
#define CONST_ARG_MATRIX22 G_CONST VEC2*
#define CONST_ARG_MATRIX33 G_CONST VEC3*
#define CONST_ARG_MATRIX44 G_CONST VEC4*
#define G_CONST_ARG_MATRIX22 G_CONST VEC2*
#define G_CONST_ARG_MATRIX33 G_CONST VEC3*
#define G_CONST_ARG_MATRIX44 G_CONST VEC4*
typedef double **MATRIXNN;
#define CONST_ARG_MATRIXNN double G_CONST*G_CONST*
#define G_CONST_ARG_MATRIXNN double G_CONST*G_CONST*
typedef struct lightsource_dev {
  int type;
  int on_off;
  VEC3 color;
  VEC3 position;
  VEC3 direction;
  double open_angle;
} LIGHTSOURCE_DEV;
typedef struct clipplane_dev {
  VEC3 normal;
  double distance;
  int enabled;
  int fixed;
  int plane_number;
} CLIPPLANE_DEV;
#define MAX_CLIPPLANE 7
#define MAX_LIGHT 9
typedef struct suprop_dev {
  VEC3 emission;
  VEC3 ambient;
  VEC3 diffuse;
  VEC3 specular;
  double specular_exp;
  double transparency;
} SUPROP_DEV;
typedef struct {
 long x, y;
} RESOLUTION_TYPE;
typedef struct {
  int on_off;
  double zmin,zmax;
  double dark;
} DEPTHCUE_TYPE;
#define G_STEREO_LEFT (-1)
#define G_STEREO_NONE   0
#define G_STEREO_RIGHT  1
typedef struct {
  int on_off;
  void (*select_projection) (int);
  int auto_stereo;
} STEREO_TYPE;
typedef struct {
  int version;
  char *owner;
  char *label;
  unsigned int flags;
  unsigned int status;
  unsigned int attrib_status, texture_status, matrix_status, colormap_status;
  int dimensions;
  int width, height, depth;
  int border;
  int color_format, internal_color_format, user_color_format;
  int data_format, user_data_format;
  void *context;
  void *data;
  int components;
  int minfilter;
  int magfilter;
  int wrap_x;
  int wrap_y;
  int wrap_z;
  VEC4 border_color;
  VEC4 env_color;
  int texture_mode;
  int handle;
  int parent;
  int *children;
  int children_present, children_allocated;
  INT3 upper_lefti, lower_righti;
  VEC3 upper_left, lower_right;
  int xsize, ysize, zsize;
  int pixelsize;
  int texturesize;
  MATRIX44 system_matrix,
    child_matrix,
    user_matrix, matrix;
  int ogl_attrib_list, ogl_texture_list,
    ogl_matrix_list, ogl_colormap_list;
  unsigned ogl_object_code;
  int colormap_data_format;
  int colormap_entries;
  int colormap_size;
  void *redmap, *greenmap, *bluemap, *alphamap;
} TEXTURE_CONTROL_BLOCK;
#define DEVICE_STRUCT \
  INSTANCE_STRUCT; \
  unsigned RW_flags
typedef struct device {
  DEVICE_STRUCT;
} DEVICE;
#define GRAPHICDEVICE_STRUCT \
  DEVICE_STRUCT; \
  int *info; \
  void (*update)(void); \
  void (*clear)(void); \
  void (*message)(long, char *); \
  int  (*attribute)(const int, const int, void *); \
  int  (*attribute_direct)(const int, const int, void *); \
  void (*transform)(const int, const int, void *); \
  void (*transform_direct)(const int, const int, void *); \
  void (*point)(const VEC3); \
  void (*point_direct)(const VEC3); \
  void (*point_color)(const VEC3); \
  void (*point_color_direct)(const VEC3); \
  void (*move)(const VEC3); \
  void (*move_direct)(const VEC3); \
  void (*draw)(const VEC3); \
  void (*draw_direct)(const VEC3); \
  void (*line_color)(const VEC3); \
  void (*line_color_direct)(const VEC3); \
  void (*begin_patch)(void); \
  void (*begin_patch_direct)(void); \
  void (*begin_patch3)(void); \
  void (*begin_patch3_direct)(void); \
  void (*begin_patch4)(void); \
  void (*begin_patch4_direct)(void); \
  void (*patch_color)(const VEC3); \
  void (*patch_color_direct)(const VEC3); \
  void (*color_alpha)(const VEC4); \
  void (*color_alpha_direct)(const VEC4); \
  void (*patch_normal)(const VEC3); \
  void (*patch_normal_direct)(const VEC3); \
  void (*patch_vertex)(const VEC3); \
  void (*patch_vertex_direct)(const VEC3); \
  void (*patch_vertex_index)(const int); \
  void (*patch_vertex_index_direct)(const int); \
  void (*end_patch)(void); \
  void (*end_patch_direct)(void); \
  void (*end_patch3)(void); \
  void (*end_patch3_direct)(void); \
  void (*end_patch4)(void); \
  void (*end_patch4_direct)(void); \
  void (*text)(const VEC3, const char *); \
  void (*text_direct)(const VEC3, const char *); \
  void (*dummy)(void); \
  int (*add_texture)(int, int, int, int, int, int, int, int, \
		     void *, unsigned int, void *); \
  int (*set_texture_data)(int, void *); \
  int (*texture_attribute)(int, int, int, void *); \
  void (*remove_texture)(int); \
  int (*begin_texture)(int); \
  void (*texture_coord)(const VEC3); \
  void (*texture_coordi)(INT3); \
  void (*end_texture)(void); \
  int (*texture_colormap)(int, int, int, void*); \
  int (*begin_list)(int); \
  void (*end_list)(void); \
  int (*call_list)(int); \
  void (*delete_list)(int); \
  int (*query_list)(int *); \
  int  (*generate_lightsource)(int); \
  void (*lightsource)(int, int, LIGHTSOURCE_DEV *); \
  void (*delete_lightsource)(int); \
  void (*set_full_screen)(int); \
  void (*video_record_function)(void); \
  int (*user_break)(void); \
  int grid_patch; \
  void *zbuff_info; \
  int interactive; \
  int global_grid_patch; \
  G_LIST *saved_states
typedef struct graphicdevice {
  GRAPHICDEVICE_STRUCT;
} GRAPHICDEVICE;
#define G_GRID  0x000003b8
#define G_PATCH 0x000003d8
#define G_TEXTURE 0x000003da
#define G_READONLY	1
#define G_WRITEONLY	2
#define G_READWRITE (G_READONLY | G_WRITEONLY)
#define G_MODE_QUERY   	  0
#define G_MODE_GET	  1
#define G_MODE_SET	  2
#define G_MODE_PRE	  3
#define G_MODE_POST	  4
#define G_MODE_SWAP	  5
#define G_MODE_ROTATE     6
#define G_MODE_INV_ROT    7
#define G_MODE_TRANSLATE  9
#define G_MODE_INV_TRANS  8
#define G_MODE_SCALE     10
#define G_MODE_INV_SCALE 11
#define G_MODE_CLIPPLANE_ENABLE 12
#define G_MODE_CLIPPLANE_FIX 13
void g_build_transform_matrix(int,MATRIX44,double *);
#define G_MATRIX_NONE    0
#define G_MATRIX_PROJECT 1
#define G_MATRIX_VIEW	 2
#define G_MATRIX_MODEL	 3
#define G_MATRIX_PVM	 4
#define G_MATRIX_IVM	 5
#define G_MATRIX_TEXTURE 6
#define G_LIGHT_FREE	0
#define G_LIGHT_AMBIENT 1
#define G_LIGHT_DIRECT	2
#define G_LIGHT_POINT	3
#define G_LIGHT_SPOT	4
#define G_RASTER_ABILITY	 1
#define G_COLOR_ABILITY		 2
#define G_ZBUFF_ABILITY		 3
#define G_RESOLUTION		 4
#define G_ASPECTRATIO		 5
#define G_BACKGROUND_COLOR	 6
#define G_LINE_COLOR		 7
#define G_LINE_WIDTH		 8
#define G_LINE_TYPE		 G_LINE_WIDTH
#define G_ANTIALIAS		 9
#define G_DEPTHCUE		10
#define G_PATCH_SUPROP		11
#define G_TEXT_COLOR		12
#define G_TEXT_TYPE		13
#define G_DOUBLEBUFFER		14
#define G_LIGHT_MODEL		15
#define G_LIGHT_NUMBER		16
#define G_HAS_DOUBLEBUFFER	17
#define G_PATCH_DRAW_EDGE	18
#define G_ORIGIN		19
#define G_TEXTURE_ABILITY	20
#define G_STEREO_ABILITY	21
#define G_STEREO		22
#define G_STEREO_BUFFER		23
#define G_CLIPPLANE_ABILITY     24
#define G_CLIPPLANE             25
#define G_ZBUFFER               26
#define G_MAX_TEXTURE_SIZE	27
#define G_AUTO_STEREO		28
#define G_FONT                  29
#define G_POINT_SIZE            30
#define G_POINT_COLOR           31
#define G_BLENDING		32
#define G_LOGIC_OP              33
#define G_LINE_STIPPLE          34
#define G_READDISPLAY           35
#define G_COLOR_MATERIAL        36
#define G_POINTS		0x0000
#define G_LINES			0x0001
#define G_LINE_LOOP		0x0002
#define G_LINE_STRIP		0x0003
#define G_TRIANGLES		0x0004
#define G_TRIANGLE_STRIP	0x0005
#define G_TRIANGLE_FAN		0x0006
#define G_QUADS			0x0007
#define G_QUAD_STRIP		0x0008
#define G_POLYGON		0x0009
void graphicdevice_define_stddev(GRAPHICDEVICE *, void (* )());
#define G_DEPTHSORT_DRAW_CUTTING_LINES 1
#define G_DEPTHSORT_CHECK_CUT 2
#define G_DEPTHSORT_RGB_PER_VERTEX 4
#define G_DEPTHSORT_OMIT_OBSCURED 8
#define G_DEPTHSORT_RAW_CLIPPING 16
#define G_DEPTHSORT_NORMAL_ACTION 0
#define G_DEPTHSORT_SHADED_ZSORT  1
#define G_DEPTHSORT_ZSORT         2
#define G_TEXTURE_MIN_FILTER    0
#define G_TEXTURE_MAG_FILTER    1
#define G_TEXTURE_WRAP_X        2
#define G_TEXTURE_WRAP_Y        3
#define G_TEXTURE_WRAP_Z        4
#define G_TEXTURE_BORDER_COLOR  5
#define G_TEXTURE_MODE          6
#define G_TEXTURE_ENV_COLOR     7
#define G_TEXTURE_MATRIX        8
#define G_TEXTURE_PARENT        9
#define G_TEXTURE_BIT_DEPTH     10
#define G_TEXTURE_DATA		11
#define G_TEXTURE_CLAMP_MODE                  0
#define G_TEXTURE_REPEAT_MODE                 1
#define G_TEXTURE_EDGE_CLAMP_MODE             2
#define G_TEXTURE_BORDER_CLAMP_MODE           3
#define G_TEXTURE_BEST_CLAMP_MODE	      4
#define G_TEXTURE_NEAREST_MODE                0
#define G_TEXTURE_LINEAR_MODE                 1
#define G_TEXTURE_NEAREST_MIPMAP_NEAREST_MODE 2
#define G_TEXTURE_LINEAR_MIPMAP_NEAREST_MODE  3
#define G_TEXTURE_NEAREST_MIPMAP_LINEAR_MODE  4
#define G_TEXTURE_LINEAR_MIPMAP_LINEAR_MODE   5
#define G_TEXTURE_DECAL_MODE                  0
#define G_TEXTURE_BLEND_MODE                  1
#define G_TEXTURE_MODULATE_MODE               2
#define G_TEXTURE_REPLACE_MODE		      3
#define G_TEXTURE_ADD_MODE		      4
#define G_NO_TEXTURE -1
#define G_COLOR_INDEX     0
#define G_RED             1
#define G_GREEN           2
#define G_BLUE            3
#define G_ALPHA           4
#define G_RGB             5
#define G_RGBA            6
#define G_LUMINANCE       7
#define G_LUMINANCE_ALPHA 8
#define G_INTENSITY       9
#define G_TEXTURE_NONE          -1
#define G_TEXTURE_UNSIGNED_CHAR  0
#define G_TEXTURE_SIGNED_CHAR    1
#define G_TEXTURE_UNSIGNED_SHORT 2
#define G_TEXTURE_SIGNED_SHORT   3
#define G_TEXTURE_UNSIGNED_INT   4
#define G_TEXTURE_SIGNED_INT     5
#define G_TEXTURE_INT            G_TEXTURE_SIGNED_INT
#define G_TEXTURE_FLOAT          6
#define G_TEXTURE_DOUBLE         7
#define G_TEXTURE_BUFFER_TEXTURE      1
#define G_TEXTURE_USE_DISPLAY_LIST    2
#define G_TEXTURE_UNBUFFERED_TEXTURE  0
#define G_TEXTURE_TEST_TEXTURE	      16
#define G_TEXTURE_USE_TEXTURE_OBJECT  32
#define G_TEXTURE_FORCE_TEXTURE       64
#define G_TEXTURE_OPTIMIZE (G_TEXTURE_USE_DISPLAY_LIST | G_TEXTURE_USE_TEXTURE_OBJECT)
#define G_TEXTURE_FIX_MASK	      8
#define G_TEXTURE_NO_FIX	      0
#define G_TEXTURE_O2_FIX              8
#define G_TEXTURE_BEGIN_TEXTURE_PENDING   1
#define G_TEXTURE_HAS_PARENT              2
#define G_TEXTURE_INDEXED                 4
#define G_TEXTURE_DEFAULT_COLORMAP        8
#define G_TEXTURE_SYSTEM_MATRIX_IDENTITY 16
#define G_TEXTURE_USER_MATRIX_IDENTITY   32
#define G_TEXTURE_MATRIX_IDENTITY       (G_TEXTURE_SYSTEM_MATRIX_IDENTITY+G_TEXTURE_USER_MATRIX_IDENTITY)
#define G_TEXTURE_FIRST_INIT             64
#define G_TEXS_CLEAN  0
#define G_TEXS_UPDATE 1
#define G_TEXS_RECALL 2
#define G_TEXS_RECORD 4
#define G_TEXS_DIRTY  (G_TEXS_UPDATE+G_TEXS_RECALL)
extern TEXTURE_CONTROL_BLOCK *g_global_textures;
extern int g_texture_current_handle;
extern void *g_texture_current_data;
extern int glbl_texture_matrix_modified;
int g_texture_get_handle (void);
int g_texture_remove_handle (int, void (*)(int));
int g_texture_check_handle (unsigned int);
int g_texture_set_current_texture (int);
int g_texture_get_current_texture (void);
int g_texture_is_current_texture (int);
void g_texture_invalidate_current_texture (void);
void g_texture_calc_texture_size (int);
int g_texture_reshape (int, void *, void **);
int g_texture_get_phys_handle (int);
void g_texture_build_matrix (int);
int g_texture_next_handle (int);
int g_texture_prev_handle (int);
int g_texture_set_colormap (int, int, int, void *);
void g_texture_init_texture (int, int, int, int, int, int, int, int, int, int, int,void*, unsigned, void*);
int g_texture_set_parent (int, int, VEC3, VEC3);
int g_texture_matrix_changed (void);
int g_texture_set_attribute (GRAPHICDEVICE *,int,int,int);
void g_texture_set_label (int, char *, char *);
void *g_texture_cnv_float_to_unsigned_short (int, void *);
void *g_texture_cnv_float_to_unsigned_char (int, void *);
void *g_texture_convert (int, int, int, int, int, int, int, int, int, void *);
int g_texture_copy (GRAPHICDEVICE *, int, int, int, int);
void g_texture_transform (int, int, void *);
float *g_texture_color_transition (int, int, int, VEC4, VEC4, VEC4, VEC4);
#define FORCE_TEXTURE(dev,handle,data) \
  if(!(dev)->begin_texture((handle))) \
    (dev)->set_texture_data((handle),(data)); \
  (dev)->end_texture()
#define GQ_NORMAL 0
#define GQ_BEST 1
#define GQ_FASTEST 2
extern unsigned long g_user_break_last_time;
#define G_USER_BREAK(dev) \
 (g_user_break_last_time == G_TIME ? FALSE : \
 (g_user_break_last_time = G_TIME, (dev)->user_break()))
#define OS_SAVE 0
#define OS_RESTORE 1
#define OS_FREE 2
#define G_LO_CLEAR 0
#define G_LO_SET 1
#define G_LO_COPY 2
#define G_LO_COPY_INVERTED 3
#define G_LO_NOOP 4
#define G_LO_INVERT 5
#define G_LO_AND 6
#define G_LO_NAND 7
#define G_LO_OR 8
#define G_LO_NOR 9
#define G_LO_XOR 10
#define G_LO_EQUIV 11
#define G_LO_AND_REVERSE 12
#define G_LO_AND_INVERTED 13
#define G_LO_OR_REVERSE 14
#define G_LO_OR_INVERTED 15
#define G_LO_DEFAULT G_LO_COPY
#define G_SR_KEEP_ASPECT 1
#define GRAPHICPS_STRUCT \
  GRAPHICDEVICE_STRUCT
typedef struct graphicps {
  GRAPHICPS_STRUCT;
} GRAPHICPS;
#define GRAPHICRAY_STRUCT \
  GRAPHICDEVICE_STRUCT
typedef struct graphicray {
  GRAPHICRAY_STRUCT;
} GRAPHICRAY;
#define TREEOBJECT_STRUCT \
  INSTANCE_STRUCT
typedef struct treeobject {
  TREEOBJECT_STRUCT;
} TREEOBJECT;
typedef enum {
  spefNothing   = 0,
  spefSupropDev = 1,
  spefGridPatch = 2,
  spefDefault   = 1 | 2,
  spefLineColor = 4,
  spefTextColor = 8,
  spefPointColor = 16,
  spefPointSize = 32
} SUPROP_ENABLE_FLAG;
#define SUPROP_STRUCT \
  INSTANCE_STRUCT; \
  SUPROP_DEV suprop_dev; \
  VEC3 linecolor, textcolor, pointcolor; \
  double pointsize; \
  int grid_patch; \
  SUPROP_ENABLE_FLAG enabled
typedef struct suprop {
  SUPROP_STRUCT;
} SUPROP;
#ifndef G_TRADITIONAL_SCENE
#define G_SCENE_OBJECT TREEOBJECT
#else
#define G_SCENE_OBJECT INSTANCE
#endif
#define SCENE_STRUCT \
  TREEOBJECT_STRUCT; \
  struct scene *next_scene; \
  G_SCENE_OBJECT *object; \
  MATRIX44 object_trans; \
  int matrix_flag; \
  char *method_name; \
  SUPROP *suprop
typedef struct scene {
  SCENE_STRUCT;
} SCENE;
bool_t g_xdr_suprop_dev(XDR *, SUPROP_DEV *);
#define CHAIN_STRUCT \
  SCENE_STRUCT; \
  int flag
typedef struct chain {
  CHAIN_STRUCT;
} CHAIN;
typedef enum stateflags{
  sfNoModKey      =  0x00010000,
  sfShiftKey      =  0x00000001,
  sfLockKey       =  0x00000002,
  sfControlKey    =  0x00000004,
  sfMod1Key       =  0x00000008,
  sfMod2Key       =  0x00000010,
  sfMod3Key       =  0x00000020,
  sfMod4Key       =  0x00000040,
  sfMod5Key       =  0x00000080,
  sfSomeModKey    =  0x000000FF,
  sfLeftMouse     =  0x00000100,
  sfMiddleMouse   =  0x00000200,
  sfRightMouse    =  0X00000400,
  sfOpt1Mouse     =  0x00000800,
  sfOpt2Mouse     =  0x00001000,
  sfSomeMouse     =  0x00001F00
} STATEFLAGS;
typedef enum controlkeys{
  ckReturn,
  ckEscape,
  ckBackspace,
  ckTab,
  ckDelete,
  ckHome,
  ckLeftArrow,
  ckUpArrow,
  ckRightArrow,
  ckDownArrow,
  ckPageUp,
  ckPageDown,
  ckEnd,
  ckBegin,
  ckF1,
  ckF2,
  ckF3,
  ckF4,
  ckF5,
  ckF6,
  ckF7,
  ckF8,
  ckF9,
  ckF10,
  ckF11,
  ckF12
} CONTROLKEYS;
typedef enum evtype{
  evNothing       = 0x00000000,
  evMousePressed  = 0x00000001,
  evMouseReleased = 0x00000002,
  evMouseHold     = 0x00000004,
  evMouseDragged  = 0x00000008,
  evMouse         = 0x0000000F,
  evNormalKey	  = 0x00000010,
  evCtrlKey	  = 0x00000020,
  evKey           = 0x00000070,
  evSpaceball     = 0x00000080,
  evRedraw        = 0x00000100,
  evResize        = 0x00000200,
  evMessage       = 0x0000FF00
} EVTYPE;
typedef enum whotype{
  evForCtl        = 0x00000001,
  evForGrph       = 0x00000002,
  evForMask       = 0x00000003,
  evSynthetic     = 0x10000000
} WHOTYPE;
typedef struct {
  double x1, y1, x2, y2;
} GRECT;
typedef struct grect_list{
  GRECT *rect;
  struct grect_list *next;
  int already_used;
} GRECT_LIST;
typedef struct event{
  EVTYPE what;
  unsigned int which;
  unsigned int state;
  double x, y;
  double deltax, deltay;
  GRECT_LIST *rect_list;
  WHOTYPE who;
  struct device *causer;
  struct layer *layer;
} EVENT;
typedef enum g_clip_type {
  g_ctNone        = 0x00000000,
  g_ctEnableRects = 0x00000001,
  g_ctDisableRects
} G_CLIP_TYPE;
typedef struct g_clip_descriptor {
  G_CLIP_TYPE which;
  int max_no_of_rects;
} G_CLIP_DESCRIPTOR;
#define CONTROLDEVICE_STRUCT \
  DEVICE_STRUCT; \
  int *info; \
  void  (*update)(void); \
  int   (*attribute)(int, int, int *); \
  void  (*clear)(void); \
  void  (*set_color)(int); \
  void  (*set_rgb_color)(const VEC3); \
  void  (*set_text_color)(int); \
  void  (*get_color)(int *); \
  void  (*change_color)(int, const VEC3); \
  void  (*moveto)(double, double); \
  void  (*drawto)(double, double); \
  void  (*relative_draw)(double, double); \
  void  (*draw_string)(double, double, const char *); \
  void  (*get_mouse)(double *, double *); \
  void  (*fix_mouse)(double, double, double, double, double, double); \
  void  (*free_mouse)(void); \
  void  (*set_mouse)(double, double); \
  void  (*rectangle)(double, double, double, double); \
  void  (*circle)(double, double, double); \
  void  (*reinit)(void); \
  void  (*get_control_size)(double *, double *); \
  void  (*wait)(double); \
  void  (*clear_event_queue)(void); \
  void  (*get_spaceball_data)(double *, double *, double *, double *, \
			      double *, double *, double *, int *); \
  int   (*handle_events)(EVENT *, int); \
  int   (*menu_button)(void); \
  int   (*read_string)(double, double, char *, double); \
  int   (*middle_button)(void); \
  int   (*get_free_color_index)(void); \
  G_CLIP_DESCRIPTOR *(*kind_of_clipping)(void); \
  void  (*set_clip_rects)(GRECT_LIST *); \
  double (*get_unit_per_pixel)(void); \
  double (*stringwidth)(const char *); \
  double (*stringheight)(const char *); \
  void  (*copy_string)(const char *)
typedef struct controldevice {
  CONTROLDEVICE_STRUCT;
} CONTROLDEVICE;
#define CTL_PATCH_X_MIN_SIZE     28
#define CTL_PATCH_Y_MIN_SIZE     18
#define CTL_PATCH_Y_STD_SIZE     CTL_PATCH_X_MIN_SIZE
#define MANAGER_REDRAW            0
#define MANAGER_DONT_REDRAW       1
#define MANAGER_DISPLIST_REDRAW   MANAGER_REDRAW
typedef enum {
  mfMouseRelative,
  mfCreatorRelative,
  mfNorthWest,
  mfNorthEast,
  mfEastNorth,
  mfEastSouth,
  mfSouthEast,
  mfSouthWest,
  mfWestSouth,
  mfWestNorth
} MENU_FILL_FLAG;
#define MENU_FILL_TOP             mfNorthWest
#define MENU_FILL_BOTTOM          mfSouthEast
#define MENU_MOUSE_RELATIVE       mfMouseRelative
#define MENU_FILL_LEFT            mfWestSouth
#define MENU_FILL_RIGHT           mfNorthEast
#define MENU_AUTO_POSITION        -100.0
#define MENU_MAX_SIZE		  -100.0
#define LINE_FLAT                 0
#define LINE_ELEVATED             1
#define NO_COLOR                  -1
#define BLACK_COLOR               0
#define RED_COLOR                 1
#define GREEN_COLOR               2
#define YELLOW_COLOR              3
#define BLUE_COLOR                4
#define MAGENTA_COLOR             5
#define CYAN_COLOR                6
#define WHITE_COLOR               7
#define FOREGROUND_COLOR          8
#define BACKGROUND_COLOR          9
#define PRESSED_UPPER_COLOR      10
#define PRESSED_LOWER_COLOR      11
#define TEXT_COLOR               12
#define LINE_COLOR               13
#define LIGHT_ON_COLOR           14
#define NUMBER_OF_USED_COLORS    15
#define NUMBER_OF_COLORS         64
#define RULER_FLOAT               dfFLOAT
#define RULER_INTEGER             dfINT
#define RULER_DOUBLE              dfDOUBLE
#define PLANE_DOUBLE              dfDOUBLE
#define PLANE_INTEGER             dfINT
#define SLIDER_DOUBLE             dfDOUBLE
#define SLIDER_INTEGER            dfINT
#define PRESSED                   0
#define UNPRESSED                 1
#define G_USER_SUPPLIED   30
#define G_SYSTEM_SUPPLIED  0
#define MARKED            23
#define NOT_MARKED        24
#define MXBUF                     256
#define MAX_STRLEN                256
#define MAX_STRING_LENGTH         MAX_STRLEN
#define ACTIVE     1
#define INACTIVE   2
#define INTERNAL_INACTIVE 4
#define INACTIVE_MASK (INACTIVE+INTERNAL_INACTIVE)
#define ON  1
#define OFF 0
#define NO  0
#define YES 1
#ifndef TRUE
#define FALSE  0
#define TRUE   1
#endif
#define G_CROSS_EMPTY   ' '
#define G_CROSS_PUSHED  'p'  /* instance is pushed,
			      * pop it to go there */
#define G_CROSS_DOWN    'd'  /* go down: current instance
			      * has to move left */
#define G_CROSS_NEXT    'n'  /* like next_scene: curr inst
			      * has to move up */
#define G_CROSS_CHAINED 'c'  /* next element in a doubly
			      * linked list, like timesteps.
			      * Since this instance will
			      * show curr inst in its follow,
			      * don't push current instance */
#define G_CHECKFIELD_CUSTOM 0
#define G_CHECKFIELD_RADIO  1
#define G_CHECKFIELD_CBOXES 2
#define G_CHECKFIELD_CHECK_AND 1
#define G_CHECKFIELD_CHECK_XOR 2
#define G_CHECKFIELD_UNCHECK_AND 4
#define G_CHECKFIELD_UNCHECK_XOR 8
typedef enum {
  mbfNone = 0,
  mbfYes = 1,
  mbfNo  = 2,
  mbfCancel = 4,
  mbfOk = 8,
  mbfAbort = 16,
 mbfRecursive = 128
} MSGBOX_FLAGS;
#define G_MSGBOX_BUTTON_YES    mbfYes
#define G_MSGBOX_BUTTON_NO     mbfNo
#define G_MSGBOX_BUTTON_CANCEL mbfCancel
#define G_MSGBOX_BUTTON_OK     mbfOk
#define G_MSGBOX_BUTTON_ABORT  mbfAbort
#define G_MSGBOX_RECURSIVE     mbfRecursive
#define ALERT(condition,message,error_exit) \
do{if(!(condition)){ \
  g_errorbox(message,__FILE__,__LINE__,#condition); \
  error_exit; \
}}while(0)
typedef enum {
  rfOff = OFF,
  rfOn = ON,
  rfDisplist
} REDRAW_FLAG;
typedef enum {
  afCenter = 0,
  afTop = 1,
  afBottom = 2,
  afLeft = 4,
  afRight = 8
} ALIGN_FLAGS;
typedef enum border_flags{
  bfNoBorder = 0x00000000,
  bfBorder   = 0x00000001,
  bfTitle    = 0x00000002
} BORDER_FLAGS;
typedef unsigned long G_HANDLE_FLAGS;
#define G_NOVICE_USER 0
#define G_EXPERT_USER 1
typedef union value_pointer {
  int *Int;
  float *Float;
  double *Double;
  char *String;
} VALUE_POINTER;
typedef union input_value {
  int Int;
  float Float;
  double Double;
  char *String;
} INPUT_VALUE;
typedef enum declaration_format{
  dfInt,
  dfFloat,
  dfDouble,
  dfString,
  dfGroup,
  dfRegexp
} DECLARATION_FORMAT;
#define dfINT dfInt
#define dfFLOAT dfFloat
#define dfDOUBLE dfDouble
#define dfSTRING dfString
#define dfREGULAR_EXPRESSION dfRegexp
struct vhdl {
  VALUE_POINTER ptr;
  DECLARATION_FORMAT df;
  char *conversion_format;
};
typedef struct vhdl *VHDL;
VHDL g_vhdl_new(void *, DECLARATION_FORMAT);
void g_vhdl_free(VHDL );
double g_vhdl_get_double(VHDL );
double g_vhdl_set_double(VHDL ,double );
double g_vhdl_add_double(VHDL ,double );
float g_vhdl_get_float(VHDL );
float g_vhdl_set_float(VHDL ,float );
int g_vhdl_get_int(VHDL );
int g_vhdl_set_int(VHDL ,int );
void g_vhdl_set_conversion_format(VHDL ,char *);
void *g_vhdl_get_value_pointer(VHDL );
DECLARATION_FORMAT g_vhdl_get_declaration_format(VHDL );
int g_vhdl_set_value (VHDL, void *);
#define ITEM_STRUCT \
  INSTANCE_STRUCT; \
  struct item *next_entry; \
  struct group *menu_ptr; \
  double sizex,sizey; \
  double posx,posy; \
  double constr_posx,constr_posy; \
  double constr_sizex, \
         constr_sizey; \
  int refresh; \
  G_HANDLE_FLAGS item_flags; \
  int fill; \
  VEC3 color; \
  int color_index; \
  int textcolor_index; \
  char *add_inter_action; \
  char *remove_inter_action; \
  char *help_text; \
  int user_level
typedef struct item {
  ITEM_STRUCT;
} ITEM;
#define RECTANGLE_STRUCT \
  ITEM_STRUCT
typedef struct rectangle {
  RECTANGLE_STRUCT;
} RECTANGLE;
#define TEXTMESSAGE_STRUCT \
  ITEM_STRUCT; \
  char *label; \
  int alignment_x, alignment_y; \
  BORDER_FLAGS border_flags
typedef struct textmessage {
  TEXTMESSAGE_STRUCT;
} TEXTMESSAGE;
#define STATICTEXT_STRUCT \
  TEXTMESSAGE_STRUCT
typedef struct statictext {
  STATICTEXT_STRUCT;
} STATICTEXT;
#define LINE_STRUCT \
  ITEM_STRUCT; \
  int type
typedef struct line {
  LINE_STRUCT;
} LINE;
typedef struct {
  unsigned int which;
  unsigned int state;
  char *method;
  REDRAW_FLAG redraw_flag;
} NONSTANDARD_METHOD;
#define INTERACTIVE_STRUCT \
  ITEM_STRUCT; \
  struct side_effect *effects; \
  char *action; \
  char *method; \
  unsigned state_mask; \
  G_LIST *more_methods; \
  INSTANCE *inst; \
  char *label; \
  struct layer_list *layers; \
  int active; \
  REDRAW_FLAG redraw_flag
typedef struct interactive {
  INTERACTIVE_STRUCT;
} INTERACTIVE;
typedef struct layer_list {
  struct layer *layer;
  struct layer_list *next;
} LAYER_LIST;
typedef struct side_effect {
  struct side_effect *next;
  INTERACTIVE *entry;
} SIDE_EFFECT;
#define BUTTON_STRUCT \
  INTERACTIVE_STRUCT; \
  int on_off; \
  char *draw_method
typedef struct button {
  BUTTON_STRUCT;
} BUTTON;
#define INPUT_STRUCT \
  INTERACTIVE_STRUCT; \
  char *evaluation_method; \
  char *inv_evaluation_method; \
  VHDL var; \
  INPUT_VALUE default_value; \
  char *prompt_entry; \
  int max_size; \
  int cursor_pos; \
  int offset; \
  int alignment; \
  char *print_format; \
  char *tab_action; \
  int is_keyactive; \
  int new_input
typedef struct input {
  INPUT_STRUCT;
} INPUT;
#define PROMPT_STRUCT \
  BUTTON_STRUCT; \
  char *prompt_display; \
  char *prompt_entry; \
  double reg_posx; \
  double reg_posy; \
  double reg_sizex; \
  double reg_sizey
typedef struct prompt {
  PROMPT_STRUCT;
} PROMPT;
#define XLIST_BUTTON_STRUCT \
  BUTTON_STRUCT
typedef struct xlist_button {
  XLIST_BUTTON_STRUCT;
} XLIST_BUTTON;
typedef struct string_list {
  struct string_list *next;
  char *str;
  int key;
} STRING_LIST;
#define PURELIST_STRUCT \
  INTERACTIVE_STRUCT; \
  int no_of_entries; \
  STRING_LIST *first_entry; \
  int first_row; \
  int last_chosen; \
  double max_width, \
        max_height
typedef struct purelist {
  PURELIST_STRUCT;
} PURELIST;
#define BIGBUTTON_STRUCT \
  BUTTON_STRUCT
typedef struct bigbutton {
  BIGBUTTON_STRUCT;
} BIGBUTTON;
#define STEP_BUTTON_STRUCT \
  BUTTON_STRUCT
typedef struct step_button {
  STEP_BUTTON_STRUCT;
} STEP_BUTTON;
typedef struct {
  int value;
  char *label;
} CYCLE_LABEL;
#define G_NEXT_LABEL 32000
#define CYCLE_BUTTON_STRUCT \
  BUTTON_STRUCT; \
  int current_label; \
  int nr_of_labels; \
  CYCLE_LABEL *label_list
typedef struct cycle_button {
  CYCLE_BUTTON_STRUCT;
} CYCLE_BUTTON;
#define COMBOBUTTON_STRUCT \
  CYCLE_BUTTON_STRUCT
typedef struct combobutton {
  COMBOBUTTON_STRUCT;
} COMBOBUTTON;
#define COMBOLIST_STRUCT \
  PURELIST_STRUCT
typedef struct combolist {
  COMBOLIST_STRUCT;
} COMBOLIST;
typedef struct instance_list {
  TREEOBJECT *inst;
  struct instance_list *next;
  char type;
} INSTANCE_LIST;
typedef struct method_list {
  void (*funct)();
  int no_of_item;
  struct method_list *next;
  struct item **item;
} METHOD_LIST;
typedef struct inst_meth_list {
  struct inst_meth_list *next;
  INSTANCE *inst;
  char *meth;
  int called;
} INST_METH_LIST;
#ifndef G_TRADITIONAL_SCENE
#define G_MANAGER_CURRENT_OBJECT TREEOBJECT
#else
#define G_MANAGER_CURRENT_OBJECT INSTANCE
#endif
#define MANAGER_STRUCT \
  INSTANCE_STRUCT; \
  struct group *menu; \
  struct graphicdevice *grdev; \
  struct controldevice *ctldev; \
  METHOD_LIST *meth_list; \
  INSTANCE_LIST *inst_list; \
  G_MANAGER_CURRENT_OBJECT *current_instance; \
  char *current_display_method; \
  INST_METH_LIST *cross_dep; \
  int cross_dep_changed; \
  int redraw; \
  int draw_on_off; \
  int item_removed; \
  int new_handle_flag; \
  int button_display_flag; \
  INTERACTIVE *active; \
  INTERACTIVE *keyactive; \
  ITEM *deleted; \
  G_LIST *hotkeys; \
  int ask_on_exit; \
  int number_of_invisible_layers; \
  double display_quality; \
  int low_display_quality; \
  int auto_display_quality; \
  double min_display_freq; \
  double max_display_freq; \
  double min_auto_quality; \
  double max_auto_quality; \
  int user_level; \
  G_LIST *display_object_list
typedef struct manager {
  MANAGER_STRUCT;
} MANAGER;
#define GROUP_STRUCT \
  INTERACTIVE_STRUCT; \
  MANAGER *mgr; \
  ITEM *entries; \
  ITEM *dirty_entry; \
  struct group_replace_group \
	*replace_to; \
  struct group_replace_group \
	*replacer_of; \
  struct replaced_list \
	*replaced_items; \
  GRECT_LIST *free_list; \
  BORDER_FLAGS border; \
  int background_color_index
typedef struct group {
  GROUP_STRUCT;
} GROUP;
typedef struct replaced_list {
  struct replaced_list *next;
  ITEM *entry;
  GROUP *group;
} REPLACED_LIST;
typedef struct group_replace_group {
  struct group_replace_group *next;
  GROUP *entry;
} GROUP_REPLACE_GROUP;
#define LAYER_HEAD_STRUCT \
  GROUP_STRUCT
typedef struct layer_head {
  LAYER_HEAD_STRUCT;
} LAYER_HEAD;
#define LAYER_STRUCT \
  GROUP_STRUCT; \
  struct layer *under; \
  struct layer *over; \
  INTERACTIVE *creator; \
  int new_position; \
  G_HANDLE_FLAGS layer_flags; \
  double last_size_x, last_size_y; \
  LAYER_HEAD *title
typedef struct layer {
  LAYER_STRUCT;
} LAYER;
#define RADIO_STRUCT \
  GROUP_STRUCT; \
  BUTTON *pressed_button
typedef struct radio {
  RADIO_STRUCT;
} RADIO;
#define SELECTOR_STRUCT \
  RADIO_STRUCT; \
  GROUP *selected_group
typedef struct selector {
  SELECTOR_STRUCT;
} SELECTOR;
typedef enum orientations {
  orHorizontal, orVertical
} ORIENTATIONS;
typedef enum bartypes {
  btRuler, btSlider, btBoundedRuler, btFunctionRuler, btScrollBar
} BARTYPES;
typedef unsigned int CHECKFIELD_VAR;
typedef enum {
  spUndef   = (int)0x00000000,
  spLoaded  = (int)0x00000001,
  spChanged = (int)0x00000002,
  spMode    = (int)0x00000004,
  spLinear  = (int)0x00000004,
  spNormal  = (int)0x00000000
} SPLINE_STATUS;
typedef enum {
  nsNothing = 0,
  nsFixed = 1
} NODE_STATUS;
#define SPLINE1D_STRUCT \
  INSTANCE_STRUCT; \
  int degree, max_degree; \
  int num_of_intervals, max_num_of_intervals; \
  double *u, *f, *b, *tang; \
  int *node_status; \
  SPLINE_STATUS status
typedef struct spline1d {
  SPLINE1D_STRUCT;
} SPLINE1D;
double g_spline1d_eval (SPLINE1D *, double);
double g_spline1d_inv_eval (SPLINE1D *, double);
typedef struct {
  int degree, max_degree;
  double *u, *b;
} BEZIER1D;
#define SPLINE_EDITOR_STRUCT \
  GROUP_STRUCT; \
  struct puresplineeditor *pure
typedef struct spline_editor {
  SPLINE_EDITOR_STRUCT;
} SPLINE_EDITOR;
#define pseXCoordFixed 1
#define pseYCoordFixed 2
#define pseLinearMode  4
#define pseDrawNodes   8
#define PURESPLINEEDITOR_STRUCT \
  INTERACTIVE_STRUCT; \
  double positionx, positiony; \
  double graph_win_xmin, graph_win_xmax, graph_win_ymin, graph_win_ymax; \
  double umin, umax, fmin, fmax; \
  double mouse_radius; \
  int draw_discr; \
  double unit; \
  double size; \
  double tang_length; \
  SPLINE1D *spline1d; \
  int      active_node, active_part; \
  int      active_action; \
  int recompute_window; \
  CHECKFIELD_VAR status; \
  double old_zoom_factor, zoom_factor
typedef struct puresplineeditor {
  PURESPLINEEDITOR_STRUCT;
} PURESPLINEEDITOR;
#define CHECKBOX_STRUCT \
  BUTTON_STRUCT; \
  int *the_flag; \
  struct checkfield *checkfield; \
  CHECKFIELD_VAR checkfield_check_and_mask, checkfield_check_xor_mask; \
  CHECKFIELD_VAR checkfield_uncheck_and_mask, checkfield_uncheck_xor_mask; \
  CHECKFIELD_VAR checkfield_mask
typedef struct checkbox {
  CHECKBOX_STRUCT;
} CHECKBOX;
#define CHECKFIELD_STRUCT \
  GROUP_STRUCT; \
  CHECKFIELD_VAR *varp; \
  CHECKFIELD_VAR used_numbers; \
  int mask_mode; \
  CHECKFIELD_VAR checkfield_check_and_mask, checkfield_check_xor_mask; \
  CHECKFIELD_VAR checkfield_uncheck_and_mask, checkfield_uncheck_xor_mask
typedef struct checkfield {
  CHECKFIELD_STRUCT;
} CHECKFIELD;
#define PURERULER_STRUCT \
  INTERACTIVE_STRUCT; \
  double position; \
  VEC3   bcolor; \
  int 	 bcolor_index
typedef struct pureruler {
  PURERULER_STRUCT;
} PURERULER;
#define PURESLIDER_STRUCT \
  PURERULER_STRUCT
typedef struct pureslider {
  PURESLIDER_STRUCT;
} PURESLIDER;
#define PURESCROLLBAR_STRUCT \
  PURESLIDER_STRUCT; \
  double bar_size
typedef struct purescrollbar {
  PURESCROLLBAR_STRUCT;
} PURESCROLLBAR;
#define BAR1D_STRUCT \
  GROUP_STRUCT; \
  int has_spline_editor; \
  int has_arrows; \
  int has_prompt; \
  int has_layer; \
  ORIENTATIONS orientation; \
  BARTYPES type_of_ruler; \
  PURERULER *ruler; \
  double (*eval)(double); \
  double (*inv_eval)(double); \
  char *value_changed; \
  VHDL var; \
  double offset; \
  double step_size; \
  double scale; \
  double min_value, \
	 max_value; \
  struct layer *config_layer; \
  G_HANDLE_FLAGS bar1d_flags
typedef struct bar1d {
  BAR1D_STRUCT;
} BAR1D;
#define RULER_STRUCT \
  BAR1D_STRUCT
typedef struct ruler {
  RULER_STRUCT;
} RULER;
typedef struct rulerconfig {
  double offset;
  double scale;
  double min, max;
  double step_width;
  int fixmin;
  int fixmax;
} RULERCONFIG;
RULERCONFIG *g_rulerconfig_new (void);
void g_rulerconfig_free (RULERCONFIG *);
RULERCONFIG *g_rulerconfig_hardcopy (RULERCONFIG *);
RULERCONFIG *g_rulerconfig_softcopy (RULERCONFIG *, RULERCONFIG *);
#define SLIDER_STRUCT \
  RULER_STRUCT
typedef struct slider {
  SLIDER_STRUCT;
} SLIDER;
#define SCROLLBAR_STRUCT \
  BAR1D_STRUCT; \
  double visible, gesamt
typedef struct scrollbar {
  SCROLLBAR_STRUCT;
} SCROLLBAR;
#define FUNCTION_BAR1D_STRUCT \
  SLIDER_STRUCT; \
  SPLINE1D *spline; \
  LAYER *edit_layer; \
  BUTTON *edit_button; \
  double *function_arg; \
  int effect_on_off; \
  int last_on_off; \
  double last_val
typedef struct function_bar1d {
  FUNCTION_BAR1D_STRUCT;
} FUNCTION_BAR1D;
#define FUNCTION_RULER_STRUCT \
  FUNCTION_BAR1D_STRUCT
typedef struct function_ruler {
  FUNCTION_RULER_STRUCT;
} FUNCTION_RULER;
#define FUNCTION_SLIDER_STRUCT \
  FUNCTION_BAR1D_STRUCT
typedef struct function_slider {
  FUNCTION_SLIDER_STRUCT;
} FUNCTION_SLIDER;
#define BOUNDED_RULER_STRUCT \
  RULER_STRUCT
typedef struct bounded_ruler {
  BOUNDED_RULER_STRUCT;
} BOUNDED_RULER;
typedef enum sort_method {
  smUnsorted,
  smAlphabetic,
  smFileList,
  smMethodList
} SORT_METHOD;
#define XLIST_STRUCT \
  GROUP_STRUCT; \
  PURELIST *list; \
  SCROLLBAR *scrollbar; \
  int  no_visible; \
  char *chosen; \
  char *edt_txt; \
  int  edt_key, chosen_key; \
  SORT_METHOD sorting
typedef struct xlist {
  XLIST_STRUCT;
} XLIST;
typedef enum open_mode {
  omNone,
  omRead,
  omWrite,
  omWriteRead,
  omCompress
} OPEN_MODE;
#define FILELIST_STRUCT \
  XLIST_STRUCT; \
  char *home_dir; \
  char **actuell_dir; \
  char *own_dir; \
  char *wildcard; \
  char *last_dir; \
  char *filter; \
  OPEN_MODE open_mode; \
  int  compress
typedef struct filelist {
  FILELIST_STRUCT;
} FILELIST;
#define METHLIST_STRUCT \
  XLIST_STRUCT; \
  CLASS *current_class; \
  CLASS *initial_class; \
  char *meth_end; \
  int no_of_adds; \
  char **adds
typedef struct methlist {
  METHLIST_STRUCT;
} METHLIST;
typedef enum {
  mltDisplay = 1,
  mltSend    = 2,
  mltAny     = 4
} METHLAYER_TYPE;
#define METHLAYER_STRUCT \
  LAYER_STRUCT; \
  METHLAYER_TYPE type
typedef struct methlayer {
  METHLAYER_STRUCT;
} METHLAYER;
#define PLANE_STRUCT \
  INTERACTIVE_STRUCT; \
  char *evaluation_method; \
  char *inv_evaluation_method; \
  void *varx, *vary; \
  double tmp_varx, tmp_vary; \
  double offsetx, offsety; \
  double positionx, positiony; \
  int wrapping; \
  DECLARATION_FORMAT type; \
  LAYER *config_layer; \
  double xscale, yscale; \
  double xmin, xmax; \
  double ymin, ymax; \
  double mousex, mousey
typedef struct plane {
  PLANE_STRUCT;
} PLANE;
#define COLOR_SEL_STRUCT \
  GROUP_STRUCT; \
  char *evaluation_method; \
  char *inv_evaluation_method; \
  double *rgb_value; \
  VEC3 tmp_var, last_rgb_value; \
  BAR1D *component[3]; \
  BAR1D *hsv_component[3]; \
  BAR1D *rgb_component[3]; \
  int color_model
typedef struct color_sel {
  COLOR_SEL_STRUCT;
} COLOR_SEL;
#define COLORALPHA_SEL_STRUCT \
  COLOR_SEL_STRUCT; \
  BAR1D *opacity_ruler
typedef struct coloralpha_sel {
  COLORALPHA_SEL_STRUCT;
} COLORALPHA_SEL;
#define SPHERE_STRUCT \
  INTERACTIVE_STRUCT; \
  char *evaluation_method; \
  char *inv_evaluation_method; \
  double *varx, *vary; \
  double tmp_varx, tmp_vary; \
  double offsetx, offsety; \
  double positionx, positiony; \
  double centerx, centery, centerz
typedef struct sphere {
  SPHERE_STRUCT;
} SPHERE;
#define GD_SPHERE_STRUCT \
  SPHERE_STRUCT
typedef struct gd_sphere {
  GD_SPHERE_STRUCT;
} GD_SPHERE;
typedef struct Mat_Edt_vals {
  double trans[3];
  double scale_dist;
  double rot[3];
  double spx, spy;
  VEC3 point;
  double plxy[2];
  double non_u_scale[3];
} MAT_EDT_VALS;
typedef enum {
  mefScale = 0x00000001,
  mefDist  = 0x00000002,
  mefJustRot = 0x00000004
} MAT_EDIT_FLAGS;
#define MATRIX_EDIT_STRUCT \
  GROUP_STRUCT; \
  VEC4 *matrix; \
  MAT_EDT_VALS new_vals; \
  MAT_EDT_VALS old_vals; \
  MAT_EDIT_FLAGS tflags; \
  GROUP *trans_ruls; \
  RULER *scale_dist_rul; \
  GROUP *rot_ruls; \
  GROUP *rots; \
  SELECTOR *trans_sel; \
  BUTTON *reset_butt; \
  SPHERE *sphere; \
  LAYER *non_uniform
typedef struct matrix_edit {
  MATRIX_EDIT_STRUCT;
} MATRIX_EDIT;
#define CAMERA_STRUCT \
  INSTANCE_STRUCT; \
  VEC3 eyepoint; \
  VEC3 lookpoint; \
  VEC3 up; \
  double focal; \
  double far,near
typedef struct camera {
  CAMERA_STRUCT;
} CAMERA;
#define ICONDESCR_STRUCT \
  VEC2 border; \
  VEC2 pborder; \
  double aspect; \
  int number_of_shapes; \
  struct iconshape *shape
typedef struct icondescr {
  ICONDESCR_STRUCT;
} ICONDESCR;
#define ICONBUTTON_STRUCT \
  BUTTON_STRUCT; \
  ICONDESCR icondescr
typedef struct iconbutton {
  ICONBUTTON_STRUCT;
} ICONBUTTON;
#define ICONIZE_BUTTON_STRUCT \
  BUTTON_STRUCT; \
  ICONDESCR icondescr
typedef struct iconize_button {
  ICONIZE_BUTTON_STRUCT;
} ICONIZE_BUTTON;
#define LAYER_FINDER_STRUCT \
  COMBOBUTTON_STRUCT
typedef struct layer_finder {
  LAYER_FINDER_STRUCT;
} LAYER_FINDER;
#define FOREGROUND_LAYER_STRUCT \
  LAYER_STRUCT; \
  double want_posx, want_posy
typedef struct foreground_layer {
  FOREGROUND_LAYER_STRUCT;
} FOREGROUND_LAYER;
extern double g_maintime;
extern int g_batch_mode;
void g_hide_layer (ITEM *);
int g_msgbox (char *, char *, MSGBOX_FLAGS);
int g_dialogbox (char *title, ITEM *dialog,\
                 double size_x, double size_y, MSGBOX_FLAGS buttons);
#define msgbox g_msgbox
void g_infobox (char *, char *);
#define infobox g_infobox
void g_errorbox (char *, char *, int, char *);
double g_eval_ident_fn (double x);
double g_eval_angle_fn (double x);
double g_eval_exp_fn (double x);
double g_eval_log_fn (double x);
double g_eval_exp10_fn (double x);
double g_eval_log10_fn (double x);
extern int *g_empty_layer;
void mgr_disp_item_reset(MANAGER *, GRAPHICDEVICE *);
void mgr_disp_item_clean(MANAGER *);
typedef enum g_flag_modifier {
  G_FLAG_NONE =0,
  G_FLAG_SET = 1,
  G_FLAG_UNSET = 2,
  G_FLAG_SWAP = 3
} G_FLAG_MODIFIER;
typedef enum pmrvflags {
  pmrvNONE = 0,
  pmrvACTIVE = 1,
  pmrvVISIBLE = 2,
  pmrvDRAWABLE = 4,
  pmrvACTIVATABLE = 8,
  pmrvDEACTIVATABLE = 16,
  pmrvREMOVABLE = 32,
  pmrvCHANGABLE = 64,
  pmrvPASSGLOBALMETHOD = 128,
  pmrvMULTIRULER
  = pmrvDRAWABLE | pmrvACTIVATABLE | pmrvDEACTIVATABLE | pmrvCHANGABLE,
  pmrvMULTIEDITOR
  = pmrvMULTIRULER | pmrvREMOVABLE
} PMRVFLAGS;
typedef enum pmrflags {
  pmrNONE =0,
  pmrSHOW =1,
  pmrACTIVATE =2,
  pmrCREATE =4,
  pmrREMOVE =8,
  pmrCHANGE =16,
  pmrSHOWSCALE = 32,
  pmrSHOWSCALELABEL = 64,
  pmrSHOWLABEL = 128,
  pmrMULTIRULER
  = pmrSHOW | pmrACTIVATE | pmrCHANGE | pmrSHOWSCALE | pmrSHOWSCALELABEL |
    pmrSHOWLABEL,
  pmrMULTIEDITOR
  = pmrMULTIRULER | pmrCREATE | pmrREMOVE
} PMRFLAGS;
typedef enum pmrmode {
  pmrmdVALUE =0,
  pmrmdSCALE =1
} PMRMODE;
typedef struct pmrvmsginterface {
  int id;
  double value;
} PMRMSGINTERFACE;
typedef enum pmrmsgflags {
  pmrmsgNONE = 0,
  pmrmsgVALUECREATED =1,
  pmrmsgVALUEACTIVATED =2,
  pmrmsgVALUECHANGED =4,
  pmrmsgVALUEREMOVED =8,
  pmrmsgVALUEDEACTIVATED = 16,
  pmrmsgRESIZED =32,
  pmrmsgREPOSITIONED =64,
  pmrmsgMODECHANGED =128,
  pmrmsgMOUSESET= 256
} PMRMSGFLAGS;
typedef enum pmrscflags {
  pmrscNONE =0,
  pmrscSHOWDIST= 1,
  pmrscSHOWLABEL= 2
} PMRSCFLAGS;
#define PUREMULTIRULER_STRUCT \
  INTERACTIVE_STRUCT; \
  int         flags; \
  double      vismin, vismax; \
  struct pmrsc_descr *scaling; \
  int         mode; \
  struct fam  *fam; \
  struct pmrvdescr *focus; \
  int         default_pmrvflags; \
  VEC3        bcolor; \
  int         bcolor_index
typedef struct puremultiruler {
  PUREMULTIRULER_STRUCT;
} PUREMULTIRULER;
typedef enum mrvflags {
  mrvNONE = 0,
  mrvDRAWABLE = 1,
  mrvACTIVATABLE = mrvDRAWABLE << 1,
  mrvDEACTIVATABLE = mrvACTIVATABLE << 1,
  mrvCHANGABLE = mrvDEACTIVATABLE << 1,
  mrvREMOVABLE = mrvCHANGABLE << 1,
  mrvRENAMABLE = mrvREMOVABLE << 1,
  mrvGLOBALRULERCONFIG = mrvRENAMABLE << 1 ,
  mrvLOCALRULERCONFIG = mrvGLOBALRULERCONFIG << 1,
  mrvFIXRULERCONFIG = mrvLOCALRULERCONFIG << 1,
  mrvPASSLOCALMETHOD = mrvFIXRULERCONFIG << 1,
  mrvPASSGLOBALMETHOD = mrvPASSLOCALMETHOD << 1,
  mrvACTION
  = mrvDRAWABLE | mrvACTIVATABLE | mrvDEACTIVATABLE | mrvCHANGABLE |
    mrvREMOVABLE,
  mrvMULTIRULER
  = mrvDRAWABLE | mrvACTIVATABLE | mrvDEACTIVATABLE | mrvCHANGABLE |
    mrvPASSGLOBALMETHOD,
  mrvMULTIEDITOR
  = mrvMULTIRULER | mrvREMOVABLE | mrvRENAMABLE,
  mrvLAST = mrvPASSGLOBALMETHOD
} MRVFLAGS;
#define MRVINTERFACE_STRUCT \
  char *name; \
  int flags; \
  void *ptr; \
  DECLARATION_FORMAT df; \
  INSTANCE *inst;  \
  char *method;  \
  RULERCONFIG *rc
typedef struct mrvinterface {
  MRVINTERFACE_STRUCT;
} MRVINTERFACE;
#define  MRVINTERFACE_TERMINATOR \
   { NULL, 0, NULL, dfInt, NULL, NULL, NULL }
typedef enum mrmsg {
  mrmsgNONE =0,
  mrmsgACTIVATED = 1,
  mrmsgDEACTIVATED = mrmsgACTIVATED << 1,
  mrmsgCHANGED = mrmsgDEACTIVATED << 1,
  mrmsgLAST = mrmsgCHANGED
} MRMSG;
#define MRMSGINTERFACE_STRUCT \
  unsigned int id
typedef struct mrmsginterface {
  MRMSGINTERFACE_STRUCT;
} MRMSGINTERFACE;
typedef enum mrscaling {
  mrNOSCALING =0,
  mrSCALING =1,
  mrLABELEDSCALING=2
} MRSCALING;
typedef enum mrflags {
  mrNONE =0,
  mrFOLLOWFOCUS = 1,
  mrCENTERFOCUS = mrFOLLOWFOCUS << 1,
  mrMULTIRULER = mrFOLLOWFOCUS,  mrMULTIEDITOR = mrFOLLOWFOCUS,
  mrLAST = mrMULTIRULER
} MRFLAGS;
#define MULTIRULER_STRUCT \
  GROUP_STRUCT; \
  struct fam *fam; \
  struct mrvdescr *mfocus; \
  MRMSGINTERFACE *interface; \
  PUREMULTIRULER *pmr; \
  int flags; \
  GROUP *value_grp; \
  GROUP *buttons_grp; \
  GROUP *zoom_grp; \
  RULER *pos_rul; \
  RULER *value_rul; \
  XLIST *selector_list; \
  LAYER *selector_layer; \
  LAYER *config_layer; \
  int mode; \
  double zoom, pos; \
  double dummy; \
  RULERCONFIG *rc
typedef struct multiruler {
  MULTIRULER_STRUCT;
} MULTIRULER;
typedef enum meflags {
  meNONE =0,
  meDEFNAME = mrLAST << 1,
  meMULTIEDITOR = mrMULTIEDITOR | meNONE,
  meLAST = meDEFNAME
} MEFLAGS;
typedef enum memsgflags {
  memsgNONE = 0,
  memsgACTIVATED = mrmsgACTIVATED,
  memsgDEACTIVATED = mrmsgDEACTIVATED,
  memsgCHANGED = mrmsgCHANGED,
  memsgCREATED = mrmsgLAST <<1,
  memsgREMOVED = memsgCREATED << 1,
  memsgLAST = memsgREMOVED
} MEMSGFLAGS;
typedef MRMSGINTERFACE MEMSGINTERFACE;
#define MECONSTRDESCR_STRUCT \
  char *name; \
  DECLARATION_FORMAT df; \
  int flags; \
  double (*eval)(double); \
  double (*inv_eval)(double); \
  INSTANCE *inst; \
  char *method
typedef struct meconstrdescr {
  MECONSTRDESCR_STRUCT;
} MECONSTRDESCR;
#define MULTIEDITOR_STRUCT \
  MULTIRULER_STRUCT; \
  INPUT *nameinput; \
  BUTTON *removebutton; \
  char new_name[MAX_STRLEN]; \
  MECONSTRDESCR *constructor
typedef struct multieditor {
  MULTIEDITOR_STRUCT;
} MULTIEDITOR;
#define PLANE_EDITOR_STRUCT \
  BUTTON_STRUCT; \
  LAYER *layer; \
  MATRIX44 matrix; \
  VEC3 plane_normal; \
  double plane_distance; \
  VEC3 *user_normal; \
  double *user_distance; \
  CHECKFIELD_VAR status; \
  INSTANCE *object; \
  VEC3 line_color; \
  INSTANCE *user_instance; \
  char *user_method; \
  int current_normal, max_normal
typedef struct plane_editor {
  PLANE_EDITOR_STRUCT;
} PLANE_EDITOR;
#define PLANE_OBJECT_STRUCT \
  TREEOBJECT_STRUCT; \
  CHECKFIELD_VAR status; \
  PLANE_EDITOR *parent; \
  VEC3 bndbox_vertex [8]; \
  VEC3 min, max, cut_vertex [8]; \
  int cut_vertices; \
  VEC3 center; \
  double grid_spacing
typedef struct plane_object {
  PLANE_OBJECT_STRUCT;
} PLANE_OBJECT;
#define CLIPOGL_STRUCT \
  LAYER_STRUCT; \
  int no_of_planes; \
  int max_no_of_planes; \
  int act_plane; \
  CLIPPLANE_DEV plane [16]
typedef struct clipogl {
  CLIPOGL_STRUCT;
} CLIPOGL;
typedef enum {
  atCutoff = 0,
  atRounded = 1,
  atArrowed,
  atMarked
} AXISENDING;
typedef struct {
  int discret;
  VEC3 direction;
  VEC3 startpos;
  double length;
  VEC3 endpos;
  double radius;
  VEC3 *normals[3];
  AXISENDING ending[2];
  double arrow_size;
  double arrow_distance;
  VEC3 *tube_circle[2];
  VEC3 *end_circle[2];
  double mark_factor;
} COORDAXIS;
typedef enum {
  aeVariable = 1,
  aeMinMin   = 2,
  aeMinMax   = 4,
  aeMaxMin   = 8,
  aeMaxMax   = 16
} AXISENABLE;
#define COORDSYS_STRUCT \
  TREEOBJECT_STRUCT; \
  VEC3 min_value; \
  VEC3 max_value; \
  AXISENABLE enable[3]; \
  AXISENABLE arrows[3]; \
  INT3 rel_is_abs; \
  VEC3 rel_position; \
  double thickness; \
  double arrow_size; \
  double arrow_distance; \
  struct layer *config; \
  struct layer *exp_config[3]; \
  COORDAXIS *main_axis[3]; \
  COORDAXIS *hlp_axis[3]; \
  AXISENDING general_ending; \
  int discret; \
  char axis_label[3][80]; \
  AXISENABLE labels[3]; \
  int nr_of_marks[3]; \
  AXISENABLE marking[3]; \
  char mark_format[3][80]; \
  double mark_factor; \
  int text_skip[3]; \
  int text_offset[3]; \
  VEC3 text_position[3]
typedef struct coordsys {
  COORDSYS_STRUCT;
} COORDSYS;
#define INSTANCEFINDER_STRUCT \
  LAYER_STRUCT; \
  char *g_class_name; \
  CLASS *g_class; \
  G_LIST *g_instance_list; \
  INSTANCE *notify_instance; \
  char *notifier; \
  GROUP *class_select_group; \
  INPUT *class_input; \
  XLIST *instance_xlist
typedef struct instancefinder {
  INSTANCEFINDER_STRUCT;
} INSTANCEFINDER;
#define INODEEDITOR_STRUCT \
  LAYER_STRUCT; \
  INSTANCEFINDER *finder; \
  INSTANCE *instance; \
  IPORT *focus_ingr, *focus_dep; \
  int tracing; \
  SELECTOR *selector; \
  BUTTON *instance_name_btn, *update_outdate_btn, *remove_inode_btn; \
  STATICTEXT *statusbar; \
  XLIST *ingr_xlist, *dep_xlist, *update_xlist, *method_xlist, \
    *remove_one_xlist, *class_method_xlist; \
  LAYER *ingr_layer, *dep_layer, *update_layer, *remove_one_layer; \
  GROUP *ingr_group, *dep_group; \
  STATICTEXT *ingr_info_text, *dep_info_text
typedef struct inodeeditor {
  INODEEDITOR_STRUCT;
} INODEEDITOR;
extern char* g_demo_filename;
#define TEXTURE_EDITOR_STRUCT \
  LAYER_STRUCT; \
  union {char c; double d; int i; CHECKFIELD_VAR l; VEC3 v;} dummy; \
  int flags; \
  int handle, old_handle; \
  ITEM *menu [4]; \
  int currmenu, oldmenu; \
  VEC4 border_color, env_color, patch_color; \
  MATRIX44 matrix
typedef struct texture_editor {
  TEXTURE_EDITOR_STRUCT;
} TEXTURE_EDITOR;
#define TUNEOGL_STRUCT \
  LAYER_STRUCT; \
  LAYER *line_layer; \
  double line_width; \
  int line_stipple; \
  int line_stipple_repeat; \
  int line_stipple_pattern; \
  int line_smooth; \
  int line_smooth_hint; \
  LAYER *zbuffer_layer; \
  int depth_test; \
  int depth_func; \
  int depth_mask; \
  double depth_range [2]; \
  int alpha_test_func; \
  double alpha_test_ref; \
  int alpha_test; \
  LAYER *color_layer; \
  int dither; \
  int redmask, greenmask, bluemask, alphamask; \
  LAYER *info_layer; \
  char infostr [2048]
typedef struct tuneogl {
  TUNEOGL_STRUCT;
} TUNEOGL;
#define RESOURCEDEV_STRUCT \
  DEVICE_STRUCT; \
  char *resource; \
  G_LIST *filenames; \
  G_LIST *rcpath
typedef struct resourcedev {
  RESOURCEDEV_STRUCT;
} RESOURCEDEV;
typedef struct g_resource_descr {
  RESOURCEDEV *dev;
  char *ident;
  void *value;
  DECLARATION_FORMAT type;
  int index;
  int count;
  int sep, last_sep;
} G_RESOURCE_DESCR;
void g_remove_resourcelist (G_LIST *);
void g_resourcelist_print (G_LIST *);
int g_resourcelist_find (G_LIST *, G_RESOURCE_DESCR *, int *);
G_LIST *g_rclist_add (G_LIST *, char *, void *,
		      DECLARATION_FORMAT);
void g_resourcedev_not_found (INSTANCE *, G_RESOURCE_DESCR *);
void g_resourcedev_parse (INSTANCE *, char *);
#define TEXTDEVICE_STRUCT \
  DEVICE_STRUCT; \
  FILE *fp; \
  int term_flags; \
  void (*query)(); \
  int (*seek ) ANSI_PARM(( long int, int )); \
  int (*tell ) ANSI_PARM(( long int * )); \
  int (*write_char   ) ANSI_PARM(( char )); \
  int (*write_bytes  ) ANSI_PARM(( size_t, void * )); \
  int (*write_string ) ANSI_PARM(( char * )); \
  int (*write_short  ) ANSI_PARM(( short int )); \
  int (*write_int    ) ANSI_PARM(( int )); \
  int (*write_long   ) ANSI_PARM(( long int )); \
  int (*write_float  ) ANSI_PARM(( double )); \
  int (*write_double ) ANSI_PARM(( double )); \
  int (*read_char   ) ANSI_PARM(( char * )); \
  int (*read_bytes  ) ANSI_PARM(( size_t, void * )); \
  int (*read_string ) ANSI_PARM(( char * )); \
  int (*read_short  ) ANSI_PARM(( short int * )); \
  int (*read_int    ) ANSI_PARM(( int * )); \
  int (*read_long   ) ANSI_PARM(( long int * )); \
  int (*read_float  ) ANSI_PARM(( float * )); \
  int (*read_double ) ANSI_PARM(( double * ))
typedef struct textdevice {
  TEXTDEVICE_STRUCT;
} TEXTDEVICE;
#define INPUTFILE_STRUCT \
  TEXTDEVICE_STRUCT
typedef struct inputfile {
  INPUTFILE_STRUCT;
} INPUTFILE;
#define OUTPUTFILE_STRUCT \
  TEXTDEVICE_STRUCT
typedef struct outputfile {
  OUTPUTFILE_STRUCT;
} OUTPUTFILE;
#define INOUTFILE_STRUCT \
  TEXTDEVICE_STRUCT
typedef struct inoutfile {
  INOUTFILE_STRUCT;
} INOUTFILE;
#define SIMPLEXGRID_STRUCT \
  TREEOBJECT_STRUCT; \
  int number_of_points; \
  int max_number_of_points; \
  double *x, *y, *z
typedef struct simplexgrid {
  SIMPLEXGRID_STRUCT;
} SIMPLEXGRID;
#define TRIANG1D_STRUCT \
  SIMPLEXGRID_STRUCT
typedef struct triang1d {
  TRIANG1D_STRUCT;
} TRIANG1D;
typedef struct {
  double x,y,z,d;
} PLANE_PARM;
#define TRIANG2D_STRUCT \
  SIMPLEXGRID_STRUCT; \
  int number_of_elements; \
  int max_number_of_elements; \
  INT3 *vertex; \
  INT3 *neighbour; \
  int data_is_borrowed
typedef struct triang2d {
  TRIANG2D_STRUCT;
} TRIANG2D;
#define FE2D_STRUCT \
  TRIANG2D_STRUCT; \
  int dimension_of_value; \
  int polynomial_order; \
  void (*f)(struct fe2d*, int, VEC3, double*); \
  int size_of_data; \
  char *data
typedef struct fe2d {
  FE2D_STRUCT;
} FE2D;
typedef void (f2_func)(FE2D*, int, double*, double*);
#define TRIANG3D_STRUCT \
  SIMPLEXGRID_STRUCT; \
  int number_of_elements; \
  int max_number_of_elements; \
  INT4 *vertex; \
  INT4 *neighbour; \
  int data_is_borrowed
typedef struct triang3d {
  TRIANG3D_STRUCT;
} TRIANG3D;
#define FE3D_STRUCT \
  TRIANG3D_STRUCT; \
  int dimension_of_value; \
  int polynomial_order; \
  void (*f)(struct fe3d *, int, VEC4, double*); \
  int size_of_data; \
  char *data
typedef struct fe3d {
  FE3D_STRUCT;
} FE3D;
typedef struct clip3d_par {
	TRIANG3D *t;
	int it;
        int n;
	VEC3 v[5];
	double bary[5][4];
	double (*f)();
	char *var;
        char *scal;
        int flag ;
} CLIP3D_PAR;
typedef void (f3_func)(FE3D*, int, double*, double*);
VEC3 *g_fe3d_gradient ANSI_PARM ((FE3D*,int,double*,int,VEC3*));
VEC3 *g_fe3d_grad ANSI_PARM ((FE3D*,int,double*,f3_func*,int,VEC3*));
typedef unsigned g_bf_some_bits;
typedef g_bf_some_bits *g_pbitfield;
#define G_BF_SOME_BITS (sizeof(g_bf_some_bits)*CHAR_BIT)
#define G_BF_LENGTH(n) (((n)+(G_BF_SOME_BITS-1))/G_BF_SOME_BITS)
#define G_BF_INDEX(n) ((n)/G_BF_SOME_BITS)
#define G_BF_BITMASK(n) (1 << ((n)%G_BF_SOME_BITS))
#define G_BITFIELD(x,n) g_bf_some_bits (x)[G_BF_LENGTH(n)]
#define G_BF_SET(x,n) ((x)[G_BF_INDEX(n)] |= G_BF_BITMASK(n))
#define G_BF_UNSET(x,n) ((x)[G_BF_INDEX(n)] &= ~G_BF_BITMASK(n))
#define G_BF_TEST(x,n) ((x)[G_BF_INDEX(n)] & G_BF_BITMASK(n))
#define G_BF_OP1(op,x,n) \
do{ int bf_i; const int bf_maxi = G_BF_LENGTH(n); \
  g_bf_some_bits *const bf_p = (x); \
  for (bf_i = 0; bf_i < bf_maxi; bf_i++) bf_p[bf_i] op; \
}while(0)
#define G_BF_OP2(op,s,d,n) \
do{ int bf_i; const int bf_maxi = G_BF_LENGTH(n); \
  g_bf_some_bits *const bf_d = (d); g_bf_some_bits *const bf_s = (s); \
  for (bf_i = 0; bf_i < bf_maxi; bf_i++) bf_d[bf_i] = bf_s[bf_i]; \
}while(0)
#define G_BF_UNSETALL(x,n) G_BF_OP1(= 0,x,n)
#define G_BF_SETALL(x,n) G_BF_OP1(= ~(g_bf_some_bits)0,x,n)
#define G_BF_INVERT(s,n) G_BF_OP1(= ~bf_s[bf_i], x, n)
#define G_BF_COPY(s,d,n) G_BF_OP2(=,s,d,n)
#define G_BF_AND(s,d,n) G_BF_OP2(&=,s,d,n)
#define G_BF_OR(s,d,n) G_BF_OP2(|=,s,d,n)
#define G_BF_XOR(s,d,n) G_BF_OP2(&=,s,d,n)
typedef struct {
    double x, y;
} COMPLEX;
typedef COMPLEX CVEC3[3];
extern COMPLEX g_CZERO;
extern COMPLEX g_CE;
extern COMPLEX g_CI;
extern COMPLEX g_CNE;
extern COMPLEX g_CNI;
extern COMPLEX g_CPI4;
extern COMPLEX g_C3PI4;
extern COMPLEX g_C5PI4;
extern COMPLEX g_C7PI4;
COMPLEX g_cadd(COMPLEX, COMPLEX);
COMPLEX g_cradd(COMPLEX, double);
COMPLEX g_csub(COMPLEX, COMPLEX);
COMPLEX g_crsub(COMPLEX, double);
COMPLEX g_cmul(COMPLEX, COMPLEX);
COMPLEX g_crmul(COMPLEX, double);
COMPLEX g_csquare(COMPLEX);
COMPLEX g_ccube(COMPLEX);
COMPLEX g_cdiv(COMPLEX, COMPLEX);
COMPLEX g_crdiv(COMPLEX, double);
COMPLEX g_cinv(COMPLEX);
COMPLEX g_cconj(COMPLEX);
COMPLEX g_cneg(COMPLEX);
double g_creal(COMPLEX);
double g_cimag(COMPLEX);
double g_cnorm(COMPLEX);
double g_carg(COMPLEX);
COMPLEX g_cmplx(double, double);
COMPLEX g_cpolar(double, double);
COMPLEX g_cexp(COMPLEX);
COMPLEX g_csin(COMPLEX);
COMPLEX g_ccos(COMPLEX);
COMPLEX g_ctan(COMPLEX);
COMPLEX g_ccot(COMPLEX);
COMPLEX g_csinh(COMPLEX);
COMPLEX g_ccosh(COMPLEX);
COMPLEX g_ctanh(COMPLEX);
COMPLEX g_ccoth(COMPLEX);
COMPLEX g_cmoebius(COMPLEX, COMPLEX, COMPLEX, COMPLEX, COMPLEX);
COMPLEX g_crmoebius(double, double, double, double, COMPLEX);
COMPLEX g_cSKP(COMPLEX[], COMPLEX[], int);
COMPLEX g_cBIL(COMPLEX[], COMPLEX[], int);
COMPLEX g_cpow(COMPLEX, COMPLEX);
COMPLEX g_crpow(COMPLEX, double);
COMPLEX g_cpower(COMPLEX, int);
COMPLEX g_csqrt(COMPLEX);
COMPLEX g_casqrt(COMPLEX, double);
COMPLEX g_croot(COMPLEX, int);
COMPLEX g_clog(COMPLEX);
COMPLEX g_cSKP3(CVEC3, CVEC3);
COMPLEX g_cBIL3(CVEC3, CVEC3);
COMPLEX g_crot(COMPLEX, double);
int g_vec3_get_normal ANSI_PARM((VEC3, CONST_ARG_VEC3,CONST_ARG_VEC3));
int g_vec3_get_normal_to_plane ANSI_PARM((VEC3, CONST_ARG_VEC3,
                                   CONST_ARG_VEC3, CONST_ARG_VEC3));
int g_vec3_get_normal_quietly (VEC3, CONST_ARG_VEC3, CONST_ARG_VEC3);
int g_vec3_get_normal_to_plane_quietly (VEC3, CONST_ARG_VEC3,
                                   CONST_ARG_VEC3, CONST_ARG_VEC3);
int g_vec3_proj_onto_line ANSI_PARM((VEC3 ,CONST_ARG_VEC3));
int g_vec3_proj_onto_plane ANSI_PARM((VEC3 , CONST_ARG_VEC3));
void g_vec_change_value_int3 ANSI_PARM((INT3 *, int, int, int));
void g_int3_assign ANSI_PARM((INT3, CONST_ARG_INT3));
void g_int3_list_assign ANSI_PARM((INT3 *, G_CONST INT3 *,
                                   const int));
void g_int4_list_assign ANSI_PARM((INT4 *, G_CONST INT4 *,
                                   const int));
void g_vec3_list_assign ANSI_PARM((VEC3 *, G_CONST VEC3 *,
                                   const int));
void g_vec4_list_assign(VEC4 *, VEC4 *, int);
#define g__vec3_set(V,A,B,C) double*const g_V=(V);g_V[0]=(A);\
g_V[1]=(B);g_V[2]=(C)
#define g__fvec3_set(V,A,B,C) float*const g_V=(V);g_V[0]=(A);\
g_V[1]=(B);g_V[2]=(C)
#define g_vec3_set(v,a,b,c) do{g__vec3_set(v,a,b,c);}while(0)
void g_vec3_invert ANSI_PARM((VEC3));
#define g_vec3_set_zero(v) g_vec3_set(v,0.0,0.0,0.0)
#define g_vec3_assign(v,w) do{double const*const g_w=(w);\
g__vec3_set (v,g_w[0],g_w[1],g_w[2]);}while(0)
#define g_vec3_cv_fvec3(v,w) do{double const*const g_w=(w);\
g__fvec3_set (v,g_w[0],g_w[1],g_w[2]);}while(0)
#define g_fvec3_cv_vec3(v,w) do{float const*const g_w=(w);\
g__vec3_set (v,g_w[0],g_w[1],g_w[2]);}while(0)
#define g_vec3_sub(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);\
g__vec3_set(u,g_v[0]-g_w[0],g_v[1]-g_w[1],g_v[2]-g_w[2]);}while(0)
#define g_vec3_add(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);\
g__vec3_set(u,g_v[0]+g_w[0],g_v[1]+g_w[1],g_v[2]+g_w[2]);}while(0)
#define g_vec3_dec(v,w) do{double*const g_v=(v);\
const double*const g_w=(w);\
g_v[0]-=g_w[0];g_v[1]-=g_w[1];g_v[2]-=g_w[2];}while(0)
#define g_vec3_inc(v,w) do{double*const g_v=(v);\
const double*const g_w=(w);\
g_v[0]+=g_w[0];g_v[1]+=g_w[1];g_v[2]+=g_w[2];}while(0)
int g_vec3_normalize(VEC3);
int g_vec3_normalize_quietly(VEC3);
int g_vec3_set_length(VEC3,const double);
#define g_vec3_crossprod(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);g__vec3_set(u,g_v[1]*g_w[2]-g_v[2]*g_w[1],\
g_v[2]*g_w[0]-g_v[0]*g_w[2],g_v[0]*g_w[1]-g_v[1]*g_w[0]);}while(0)
#define g_vec3_mult(v,d) do{double*const g_v=(v),g_d=(d);g_v[0]*=g_d;\
g_v[1]*=g_d;g_v[2]*=g_d;}while(0)
#define g_vec3_interpol(u,v,w,f) do{const double*const \
g_v=(v),*const g_w=(w),g_f=(f);\
g__vec3_set(u,G_INTERPOL(g_v[0],g_w[0],g_f),\
G_INTERPOL(g_v[1],g_w[1],g_f),G_INTERPOL(g_v[2],g_w[2],g_f));}while(0)
#define g_vec3_interpol_fac(u,fv,v,fw,w) do{const double*const \
g_v=(v),*const g_w=(w),g_fv=(fv),g_fw=(fw);\
g__vec3_set(u,g_fv*g_v[0]+g_fw*g_w[0],g_fv*g_v[1]+g_fw*g_w[1],\
g_fv*g_v[2]+g_fw*g_w[2]);}while(0)
#define g_vec3_avg(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);g__vec3_set(u,.5*(g_v[0]+g_w[0]),.5*(g_v[1]+g_w[1]),\
.5*(g_v[2]+g_w[2]));}while(0)
#define g_vec3_mid g_vec3_avg
#define g_vec3_add_scaled(u,v,s,w) do{const double*const g_v=(v),\
*const g_w=(w), g_s = (s);\
g__vec3_set(u,g_v[0]+g_s*g_w[0],g_v[1]+g_s*g_w[1],g_v[2]+g_s*g_w[2]);\
}while(0)
double g_vec3_sqrabs (CONST_ARG_VEC3 const);
#define g_vec3_sqrabs_set(set,v) do{double const*const g_v=(v);\
 (set)=g_v[0]*g_v[0]+g_v[1]*g_v[1]+g_v[2]*g_v[2];}while(0)
double g_vec3_sqrdist (CONST_ARG_VEC3 const,CONST_ARG_VEC3 const);
#define g_vec3_sqrdist_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=(g_v[0]-g_w[0])*(g_v[0]-g_w[0])+\
 (g_v[1]-g_w[1])*(g_v[1]-g_w[1])+\
 (g_v[2]-g_w[2])*(g_v[2]-g_w[2]);}while(0)
double g_vec3_abs (const double * const);
#define g_vec3_abs_set(set,v) do{double const*const g_v=(v);\
 (set)=g_sqrt(g_v[0]*g_v[0]+g_v[1]*g_v[1]+g_v[2]*g_v[2]);}while(0)
double g_vec3_skp (const double * const, const double * const);
#define g_vec3_skp_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=g_v[0]*g_w[0]+g_v[1]*g_w[1]+\
 g_v[2]*g_w[2];}while(0)
double g_vec3_dist (const double * const, const double * const);
#define g_vec3_dist_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=g_sqrt(\
  (g_v[0]-g_w[0])*(g_v[0]-g_w[0])+\
  (g_v[1]-g_w[1])*(g_v[1]-g_w[1])+\
  (g_v[2]-g_w[2])*(g_v[2]-g_w[2]));}while(0)
int g_vec3_cmp (CONST_ARG_VEC3 const, CONST_ARG_VEC3 const,
	        const double);
double g_vec3_angle ANSI_PARM((VEC3, CONST_ARG_VEC3, CONST_ARG_VEC3));
double g_vec3_ctg ANSI_PARM((CONST_ARG_VEC3, CONST_ARG_VEC3));
#define g__vec4_set(V,A,B,C,D) double*const g_V=(V);g_V[0]=(A);\
g_V[1]=(B);g_V[2]=(C);g_V[3]=(D)
#define g__fvec4_set(V,A,B,C,D) float*const g_V=(V);g_V[0]=(A);\
g_V[1]=(B);g_V[2]=(C);g_V[3]=(D)
#define g_vec4_set(v,a,b,c,d) do{g__vec4_set(v,a,b,c,d);}while(0)
#define g_vec4_set_zero(v) do{g__vec4_set(v,0.,0.,0.,0.);}while(0)
#define g_vec4_assign(v,w) do{double const*const g_w=(w);\
g__vec4_set (v,g_w[0],g_w[1],g_w[2],g_w[3]);}while(0)
#define g_vec4_cv_fvec4(v,w) do{double const*const g_w=(w);\
g__fvec4_set (v,g_w[0],g_w[1],g_w[2],g_w[3]);}while(0)
#define g_fvec4_cv_vec4(v,w) do{float const*const g_w=(w);\
g__vec4_set (v,g_w[0],g_w[1],g_w[2],g_w[3]);}while(0)
#define g_vec4_sub(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);g__vec4_set(u,g_v[0]-g_w[0],g_v[1]-g_w[1],\
g_v[2]-g_w[2],g_v[3]-g_w[3]);}while(0)
#define g_vec4_add(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);g__vec4_set(u,g_v[0]+g_w[0],g_v[1]+g_w[1],\
g_v[2]+g_w[2],g_v[3]+g_w[3]);}while(0)
#define g_vec4_dec(v,w) do{double*const g_v=(v);\
const double*const g_w=(w);\
g_v[0]-=g_w[0];g_v[1]-=g_w[1];g_v[2]-=g_w[2];g_v[3]-=g_w[3];}while(0)
#define g_vec4_inc(v,w) do{double*const g_v=(v);\
const double*const g_w=(w);\
g_v[0]+=g_w[0];g_v[1]+=g_w[1];g_v[2]+=g_w[2];g_v[3]+=g_w[3];}while(0)
int g_vec4_normalize(VEC4);
int g_vec4_set_length(VEC4 , double);
#define g_vec4_mult(v,d) do{double*const g_v=(v),g_d=(d);g_v[0]*=g_d;\
g_v[1]*=g_d;g_v[2]*=g_d;g_v[3]*=g_d;}while(0)
#define g_vec4_interpol(u,v,w,f) do{const double*const \
g_v=(v),*const g_w=(w),g_f=(f);\
g__vec4_set(u,G_INTERPOL(g_v[0],g_w[0],g_f),\
G_INTERPOL(g_v[1],g_w[1],g_f),G_INTERPOL(g_v[2],g_w[2],g_f),\
G_INTERPOL(g_v[3],g_w[3],g_f));}while(0)
#define g_vec4_interpol_fac(u,fv,v,fw,w) do{const double*const \
g_v=(v),*const g_w=(w),g_fv=(fv),g_fw=(fw);\
g__vec4_set(u,g_fv*g_v[0]+g_fw*g_w[0],g_fv*g_v[1]+g_fw*g_w[1],\
g_fv*g_v[2]+g_fw*g_w[2],g_fv*g_v[3]+g_fw*g_w[3]);}while(0)
#define g_vec4_avg(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);g__vec4_set(u,.5*(g_v[0]+g_w[0]),.5*(g_v[1]+g_w[1]),\
.5*(g_v[2]+g_w[2]),.5*(g_v[3]+g_w[3]));}while(0)
#define g_vec4_mid g_vec4_avg
#define g_vec4_add_scaled(u,v,s,w) do{const double*const g_v=(v),\
*const g_w=(w), g_s = (s);\
g__vec4_set(u,g_v[0]+g_s*g_w[0],g_v[1]+g_s*g_w[1],g_v[2]+g_s*g_w[2],\
g_v[3]+g_s*g_w[3]);}while(0)
double g_vec4_sqrabs(VEC4);
#define g_vec4_sqrabs_set(set,v) do{double const*const g_v=(v);\
 (set)=g_v[0]*g_v[0]+g_v[1]*g_v[1]+g_v[2]*g_v[2]+g_v[3]*g_v[3];}\
 while(0)
double g_vec4_sqrdist(VEC4, VEC4);
#define g_vec4_sqrdist_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=(g_v[0]-g_w[0])*(g_v[0]-g_w[0])+\
 (g_v[1]-g_w[1])*(g_v[1]-g_w[1])+(g_v[2]-g_w[2])*(g_v[2]-g_w[2])+\
 (g_v[3]-g_w[3])*(g_v[3]-g_w[3]);}while(0)
double g_vec4_abs(VEC4);
#define g_vec4_abs_set(set,v) do{double const*const g_v=(v);\
 (set)=g_sqrt(g_v[0]*g_v[0]+g_v[1]*g_v[1]+g_v[2]*g_v[2]+g_v[3]*g_v[3])\
 ;}while(0)
double g_vec4_skp(VEC4, VEC4);
#define g_vec4_skp_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=g_v[0]*g_w[0]+g_v[1]*g_w[1]+\
 g_v[2]*g_w[2]+g_v[3]*g_w[3];}while(0)
double g_vec4_dist(VEC4, VEC4);
#define g_vec4_dist_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=g_sqrt(\
  (g_v[0]-g_w[0])*(g_v[0]-g_w[0])+\
  (g_v[1]-g_w[1])*(g_v[1]-g_w[1])+\
  (g_v[2]-g_w[2])*(g_v[2]-g_w[2])+\
  (g_v[3]-g_w[3])*(g_v[3]-g_w[3]));}while(0)
double g_vec4_angle(VEC4, VEC4, VEC4, VEC4);
double g_vec4_ctg(VEC4, VEC4, VEC4, VEC4);
double g_vec4_abs_sign(VEC4, VEC4);
double g_vec4_sqrabs_sign(VEC4, VEC4);
double g_vec4_skp_sign(VEC4, VEC4, VEC4);
double g_vec4_dist_sign(VEC4, VEC4, VEC4);
double g_vec4_sqrdist_sign(VEC4, VEC4, VEC4);
int g_vec4_normalize_sign(VEC4, VEC4);
int g_vec4_set_length_sign(VEC4 , double, VEC4);
#define g_vec4_hm_interpol(el,new,parent,i) \
 do{VINHERIT const*const g_vinh=(el)->vinh+(i);int g_i;\
 const int g_maxi=g_vinh->np;\
 double g_a=0;double g_b=0;double g_c=0;double g_d=0;\
 for(g_i=0;g_i<g_maxi;g_i++){\
 double const*const g_parval=(parent)[g_vinh->pindex[g_i]];\
 const double g_weight=g_vinh->pweight[g_i];\
 g_a+=g_parval[0]*g_weight;g_b+=g_parval[1]*g_weight;\
 g_c+=g_parval[2]*g_weight;g_d+=g_parval[3]*g_weight;\
 }{g__vec4_set(new,g_a,g_b,g_c,g_d);}}while(0)
#define g_vec3_hm_interpol(el,new,parent,i) \
 do{VINHERIT const*const g_vinh=(el)->vinh+(i);int g_i;\
 const int g_maxi=g_vinh->np;\
 double g_a=0;double g_b=0;double g_c=0;for(g_i=0;g_i<g_maxi;g_i++){\
 double const*const g_parval=(parent)[g_vinh->pindex[g_i]];\
 const double g_weight=g_vinh->pweight[g_i];\
 g_a+=g_parval[0]*g_weight;g_b+=g_parval[1]*g_weight;\
 g_c+=g_parval[2]*g_weight;\
 }{g__vec3_set(new,g_a,g_b,g_c);}}while(0)
#define g_double_hm_interpol(el,new,parent,i) \
 do{VINHERIT const*const g_vinh=(el)->vinh+(i);int g_i;\
 const int g_maxi=g_vinh->np;double const*const g_parent=(parent);\
 double g_a=0;for(g_i=0;g_i<g_maxi;g_i++)\
 g_a+=g_parent[g_vinh->pindex[g_i]]*g_vinh->pweight[g_i];\
 (new)=g_a;}while(0)
#define g_euklid_norm(wert,array,dim) \
 do{int const g_dim=(dim);if(g_dim==1){(wert)=g_fabs((array)[0]);}else\
 {double const*const g_array=(array);int g_i;\
 double g_sum=0.0;for(g_i=0;g_i<g_dim;g_i++){g_sum+=g_array[g_i]*\
 g_array[g_i];}(wert)=g_sqrt(g_sum);}}while(0)
#define g_vecn_to_scalar(wert,array,dim) \
 do{int const g_dim=(dim);if(g_dim==1){(wert)=(array)[0];}else{double\
 const*const g_array=(array);int g_i;double g_sum=0.0;\
 for(g_i=0;g_i<g_dim;g_i++){g_sum+=g_array[g_i]*g_array[g_i];}\
 (wert)=g_sqrt(g_sum);}}while(0)
#define g_vec3_convex(x,a,b,l) \
 do{double const*const g_a=(a);double const*const g_b=(b);\
 double const g_l=(l);g__vec3_set(x,g_a[0]+g_l*(g_b[0]-g_a[0]),\
 g_a[1]+g_l*(g_b[1]-g_a[1]),g_a[2]+g_l*(g_b[2]-g_a[2]));}while(0)
#define g_fvec3_set(v,a,b,c) do{g__fvec3_set(v,a,b,c);}while(0)
#define g_fvec3_set_zero(v) g_fvec3_set(v,0.0,0.0,0.0)
#define g_fvec3_assign(v,w) do{const float*const g_w=(w);\
g__fvec3_set(v,g_w[0],g_w[1],g_w[2]);}while(0)
#define g_fvec3_sub(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);\
g__fvec3_set(u,g_v[0]-g_w[0],g_v[1]-g_w[1],g_v[2]-g_w[2]);}while(0)
#define g_fvec3_add(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);\
g__fvec3_set(u,g_v[0]+g_w[0],g_v[1]+g_w[1],g_v[2]+g_w[2]);}while(0)
#define g_fvec3_dec(v,w) do{float*const g_v=(v);\
const float*const g_w=(w);\
g_v[0]-=g_w[0];g_v[1]-=g_w[1];g_v[2]-=g_w[2];}while(0)
#define g_fvec3_inc(v,w) do{float*const g_v=(v);\
const float*const g_w=(w);\
g_v[0]+=g_w[0];g_v[1]+=g_w[1];g_v[2]+=g_w[2];}while(0)
#define g_fvec3_crossprod(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);g__fvec3_set(u,g_v[1]*g_w[2]-g_v[2]*g_w[1],\
g_v[2]*g_w[0]-g_v[0]*g_w[2],g_v[0]*g_w[1]-g_v[1]*g_w[0]);}while(0)
#define g_fvec3_mult(v,d) do{float*const g_v=(v),g_d=(d);g_v[0]*=g_d;\
g_v[1]*=g_d;g_v[2]*=g_d;}while(0)
#define g_fvec3_interpol_fac(u,fv,v,fw,w) do{const float*const \
g_v=(v),*const g_w=(w),g_fv=(fv),g_fw=(fw);\
g__fvec3_set(u,g_fv*g_v[0]+g_fw*g_w[0],g_fv*g_v[1]+g_fw*g_w[1],\
g_fv*g_v[2]+g_fw*g_w[2]);}while(0)
#define g_fvec3_mid(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);g__fvec3_set(u,.5*(g_v[0]+g_w[0]),.5*(g_v[1]+g_w[1]),\
.5*(g_v[2]+g_w[2]));}while(0)
float g_fvec3_abs(const float * const);
#define g_fvec3_abs_set(set,v) do{float const*const g_v=(v);\
 (set)=g_sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);}while(0)
float g_fvec3_sqrabs(const float * const);
#define g_fvec3_sqrabs_set(set,v) do{float const*const g_v=(v);\
 (set)=v[0]*v[0]+v[1]*v[1]+v[2]*v[2];}while(0)
float g_fvec3_skp(const float * const, const float * const);
#define g_fvec3_skp_set(set,v,w) do{float const*const g_v=(v);\
 float const*const g_w=(w);(set)=v[0]*w[0]+v[1]*w[1]+v[2]*w[2];\
 }while(0)
int g_fvec3_normalize(FVEC3);
int g_fvec3_set_length(FVEC3, const float);
float g_fvec3_dist(const float * const, const float * const);
#define g_fvec3_dist_set(set,v,w) do{float const*const g_v=(v);\
 float const*const g_w=(w);(set)=g_sqrt((v[0]-w[0])*(v[0]-w[0])+\
 (v[1]-w[1])*(v[1]-w[1])+(v[2]-w[2])*(v[2]-w[2]));}while(0)
float g_fvec3_sqrdist(const float * const, const float * const);
#define g_fvec3_sqrdist_set(set,v,w) do{float const*const g_v=(v);\
 float const*const g_w=(w);(set)=(v[0]-w[0])*(v[0]-w[0])+\
 (v[1]-w[1])*(v[1]-w[1])+(v[2]-w[2])*(v[2]-w[2]);}while(0)
int g_fvec3_cmp(const float*const, const float*const, const float);
#define g_fvec4_set(v,a,b,c,d) do{g__fvec4_set(v,a,b,c,d);}while(0)
#define g_fvec4_set_zero(v) do{g__fvec4_set(v,0.,0.,0.,0.);}while(0)
#define g_fvec4_assign(v,w) do{float const*const g_w=(w);\
g__fvec4_set (v,g_w[0],g_w[1],g_w[2],g_w[3]);}while(0)
#define g_fvec4_sub(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);g__fvec4_set(u,g_v[0]-g_w[0],g_v[1]-g_w[1],\
g_v[2]-g_w[2],g_v[3]-g_w[3]);}while(0)
#define g_fvec4_add(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);g__fvec4_set(u,g_v[0]+g_w[0],g_v[1]+g_w[1],\
g_v[2]+g_w[2],g_v[3]+g_w[3]);}while(0)
#define g_fvec4_dec(v,w) do{float*const g_v=(v);\
const float*const g_w=(w);\
g_v[0]-=g_w[0];g_v[1]-=g_w[1];g_v[2]-=g_w[2];g_v[3]-=g_w[3];}while(0)
#define g_fvec4_inc(v,w) do{float*const g_v=(v);\
const float*const g_w=(w);\
g_v[0]+=g_w[0];g_v[1]+=g_w[1];g_v[2]+=g_w[2];g_v[3]+=g_w[3];}while(0)
#define g_fvec4_mult(v,d) do{float*const g_v=(v),g_d=(d);g_v[0]*=g_d;\
g_v[1]*=g_d;g_v[2]*=g_d;g_v[3]*=g_d;}while(0)
#define g_fvec4_interpol(u,v,w,f) do{const float*const \
g_v=(v),*const g_w=(w),g_f=(f);\
g__fvec4_set(u,G_INTERPOL(g_v[0],g_w[0],g_f),\
G_INTERPOL(g_v[1],g_w[1],g_f),G_INTERPOL(g_v[2],g_w[2],g_f),\
G_INTERPOL(g_v[3],g_w[3],g_f));}while(0)
#define g_fvec4_interpol_fac(u,fv,v,fw,w) do{const float*const \
g_v=(v),*const g_w=(w),g_fv=(fv),g_fw=(fw);\
g__fvec4_set(u,g_fv*g_v[0]+g_fw*g_w[0],g_fv*g_v[1]+g_fw*g_w[1],\
g_fv*g_v[2]+g_fw*g_w[2],g_fv*g_v[3]+g_fw*g_w[3]);}while(0)
#define g_fvec4_avg(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);g__fvec4_set(u,.5*(g_v[0]+g_w[0]),.5*(g_v[1]+g_w[1]),\
.5*(g_v[2]+g_w[2]),.5*(g_v[3]+g_w[3]));}while(0)
#define g_fvec4_mid g_fvec4_avg
#define g_fvec4_add_scaled(u,v,s,w) do{const float*const g_v=(v),\
*const g_w=(w), g_s = (s);\
g__fvec4_set(u,g_v[0]+g_s*g_w[0],g_v[1]+g_s*g_w[1],g_v[2]+g_s*g_w[2],\
g_v[3]+g_s*g_w[3]);}while(0)
void g_swap_int ANSI_PARM((int *const, int *const));
void g_swap_double ANSI_PARM((double *const, double *const));
void g_swap_float ANSI_PARM((float *const, float *const));
void g_swap_vec3 ANSI_PARM((VEC3 , VEC3));
void g_swap_fvec3 ANSI_PARM((FVEC3 , FVEC3));
void g_swap_vec4(VEC4, VEC4);
double g_matrix33_det ANSI_PARM((CONST_ARG_MATRIX33));
void g_matrix44_set_identity ANSI_PARM((MATRIX44));
void g_matrix44_mult ANSI_PARM((MATRIX44, CONST_ARG_MATRIX44,
	                        CONST_ARG_MATRIX44));
void g_matrix44_transp ANSI_PARM((CONST_ARG_MATRIX44, MATRIX44));
void g_matrix44_assign ANSI_PARM((CONST_ARG_MATRIX44, MATRIX44));
void g_matrix44_mult_vec3 ANSI_PARM((CONST_ARG_MATRIX44, VEC3));
void g_matrix44_mult_vec3_0 ANSI_PARM((VEC3, CONST_ARG_MATRIX44,
		                       CONST_ARG_VEC3));
void g_matrix44_mult_vec3_1 ANSI_PARM((VEC3, CONST_ARG_MATRIX44,
		                       CONST_ARG_VEC3));
void g_matrix44_mult_vec4(CONST_ARG_MATRIX44, VEC4);
void g_matrix44_mult_vec4_vec4(CONST_ARG_MATRIX44, CONST_ARG_VEC4,
		               VEC4);
void g_matrix44_proj_vec3 ANSI_PARM((VEC3, CONST_ARG_MATRIX44,
				     CONST_ARG_VEC3));
double g_matrix44_det ANSI_PARM((CONST_ARG_MATRIX44));
int g_matrix44_inv ANSI_PARM((CONST_ARG_MATRIX44, MATRIX44));
int g_matrix44_invert_gauss ANSI_PARM((CONST_ARG_MATRIX44, MATRIX44));
double g_matrix22_det(CONST_ARG_MATRIX22);
void g_matrix33_set_identity(MATRIX33);
void g_matrix22_set_identity(MATRIX22);
void g_matrixnn_set_identity(const int, MATRIXNN);
void g_matrix33_assign(CONST_ARG_MATRIX33, MATRIX33);
void g_matrix22_assign(CONST_ARG_MATRIX22, MATRIX22);
void g_matrixnn_assign(const int, G_CONST_ARG_MATRIXNN, MATRIXNN);
MATRIXNN g_matrixnn_alloc (const int);
MATRIXNN g_matrixnn_free (const int, MATRIXNN);
int g_matrix33_invert_gauss(CONST_ARG_MATRIX33, MATRIX33);
int g_matrixnn_invert_gauss(const int, G_CONST_ARG_MATRIXNN, MATRIXNN);
int g_vec_cmp_double ANSI_PARM((double*, double*, int, const double));
void g_vec_change_int3 ANSI_PARM((INT3 *, int, int *, int *, int));
void g_vec_change_int ANSI_PARM((int *, int, int *, int *, int));
void g_vec_change_value_int ANSI_PARM((int *, int, int, int));
int g_get_vecpos_int ANSI_PARM((int, int *, const int));
double g_vec_max_double ANSI_PARM((double *const, int));
double g_vec_min_double ANSI_PARM((double *const, int));
int g_vec_max_int ANSI_PARM((int *const, int));
int g_vec_min_int ANSI_PARM((int *const, int));
void g_get_vecpos ANSI_PARM ((double G_CONST*const, const int,
                       const double, int *const , double *const));
typedef struct famheader {
  unsigned int id;
  struct famheader *next;
  struct famheader *prev;
  void *object;
} FAMHEADER;
typedef struct fam {
  unsigned int noe;
  FAMHEADER *front, *end;
  FAMHEADER **linear;
  FAMHEADER *current;
} FAM;
FAM *g_fam_new(void);
void g_fam_free(FAM *);
void g_fam_add(FAM *, void *, unsigned int *);
void *g_fam_remove_id(FAM *, unsigned int );
unsigned int g_fam_remove_object(FAM *, void *);
void *g_fam_get_object(FAM *, unsigned int );
void *g_fam_get_first_object(FAM *);
void *g_fam_get_next_object(FAM *);
unsigned int g_fam_get_number_of_entries(FAM *self);
typedef struct {
  unsigned code;
  unsigned op;
} T_FUN_CODE;
#define T_FUN_STRUCT \
  INSTANCE_STRUCT; \
  char *funstr; \
  int nvar; \
  char **var; \
  int ncon; \
  double *con; \
  int clen; \
  T_FUN_CODE *code; \
  int slen; \
  double *stack; \
  double (*evaluate)(struct t_fun *, double *)
typedef struct t_fun {
  T_FUN_STRUCT;
} T_FUN;
T_FUN **t_fun_p_alloc(size_t);
T_FUN **t_fun_p_free(T_FUN **, size_t);
double tfun_min(T_FUN *, double, double);
double tfun_max(T_FUN *, double, double);
double g_vec2_dist (CONST_ARG_VEC2, CONST_ARG_VEC2);
#define g_vec2_dist_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=g_sqrt(\
  (g_v[0]-g_w[0])*(g_v[0]-g_w[0])+\
  (g_v[1]-g_w[1])*(g_v[1]-g_w[1]));}while(0)
double g_vec2_sqrdist (CONST_ARG_VEC2, CONST_ARG_VEC2);
#define g_vec2_sqrdist_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=(g_v[0]-g_w[0])*(g_v[0]-g_w[0])+\
 (g_v[1]-g_w[1])*(g_v[1]-g_w[1]);}while(0)
double g_vec2_sqrabs (CONST_ARG_VEC2);
#define g_vec2_sqrabs_set(set,v) do{double const*const g_v=(v);\
 (set)=g_v[0]*g_v[0]+g_v[1]*g_v[1];}while(0)
#define g__vec2_set(V,A,B) double*const g_V=(V);g_V[0]=(A);\
g_V[1]=(B)
#define g__fvec2_set(V,A,B) float*const g_V=(V);g_V[0]=(A);\
g_V[1]=(B)
#define g_vec2_set(v,a,b) do{g__vec2_set(v,a,b);}while(0)
#define g_vec2_set_zero(v) g_vec2_set(v,0.0,0.0)
#define g_vec2_assign(v,w) do{double const*const g_w=(w);\
g__vec2_set (v,g_w[0],g_w[1]);}while(0)
#define g_vec2_cv_fvec2(v,w) do{double const*const g_w=(w);\
g__fvec2_set (v,g_w[0],g_w[1]);}while(0)
#define g_fvec2_cv_vec2(v,w) do{float const*const g_w=(w);\
g__vec2_set (v,g_w[0],g_w[1]);}while(0)
#define g_vec2_sub(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);\
g__vec2_set(u,g_v[0]-g_w[0],g_v[1]-g_w[1]);}while(0)
#define g_vec2_add(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);\
g__vec2_set(u,g_v[0]+g_w[0],g_v[1]+g_w[1]);}while(0)
#define g_vec2_dec(v,w) do{double*const g_v=(v);\
const double*const g_w=(w);\
g_v[0]-=g_w[0];g_v[1]-=g_w[1];}while(0)
#define g_vec2_inc(v,w) do{double*const g_v=(v);\
const double*const g_w=(w);\
g_v[0]+=g_w[0];g_v[1]+=g_w[1];}while(0)
#define g_vec2_mult(v,d) do{double*const g_v=(v),g_d=(d);g_v[0]*=g_d;\
g_v[1]*=g_d;}while(0)
#define g_vec2_interpol(u,v,w,f) do{const double*const \
g_v=(v),*const g_w=(w),g_f=(f);\
g__vec2_set(u,G_INTERPOL(g_v[0],g_w[0],g_f),\
G_INTERPOL(g_v[1],g_w[1],g_f));\
}while(0)
#define g_vec2_interpol_fac(u,fv,v,fw,w) do{const double*const \
g_v=(v),*const g_w=(w),g_fv=(fv),g_fw=(fw);\
g__vec2_set(u,g_fv*g_v[0]+g_fw*g_w[0],g_fv*g_v[1]+g_fw*g_w[1]);\
}while(0)
#define g_vec2_avg(u,v,w) do{const double*const g_v=(v),\
*const g_w=(w);g__vec2_set(u,.5*(g_v[0]+g_w[0]),.5*(g_v[1]+g_w[1]));\
}while(0)
#define g_vec2_mid g_vec2_avg
#define g_vec2_add_scaled(u,v,s,w) do{const double*const g_v=(v),\
*const g_w=(w), g_s = (s);\
g__vec2_set(u,g_v[0]+g_s*g_w[0],g_v[1]+g_s*g_w[1]);}while(0)
#define g_fvec2_assign(v,w) do{const float*const g_w=(w);\
g__fvec2_set(v,g_w[0],g_w[1]);}while(0)
#define g_fvec2_sub(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);\
g__fvec2_set(u,g_v[0]-g_w[0],g_v[1]-g_w[1]);}while(0)
#define g_fvec2_mid(u,v,w) do{const float*const g_v=(v),\
*const g_w=(w);g__fvec2_set(u,.5*(g_v[0]+g_w[0]),.5*(g_v[1]+g_w[1]));\
}while(0)
#define g_vec2_rot90(v,w) do{double const*const g_w=(w);\
g__vec2_set (v,-g_w[1],g_w[0]);}while(0)
double g_vec2_skp (CONST_ARG_VEC2, CONST_ARG_VEC2);
#define g_vec2_skp_set(set,v,w) do{double const*const g_v=(v);\
 double const*const g_w=(w);(set)=g_v[0]*g_w[0]+g_v[1]*g_w[1];}while(0)
double g_vec2_abs (CONST_ARG_VEC2);
#define g_vec2_abs_set(set,v) do{double const*const g_v=(v);\
 (set)=g_sqrt(g_v[0]*g_v[0]+g_v[1]*g_v[1]);}while(0)
double g_vec2_det (CONST_ARG_VEC2, CONST_ARG_VEC2);
double g_vec2_sub_skp (CONST_ARG_VEC2, CONST_ARG_VEC2, CONST_ARG_VEC2);
#define g_vec2_sub_skp_set(set,v,w,n) do{double const*const g_v=(v);\
 double const*const g_w=(w);double const*const g_n=(n);\
 (set)=(g_v[0]-g_w[0])*g_n[0]+(g_v[1]-g_w[1])*g_n[1];}while(0)
int g_vec2_normalize (VEC2);
int g_vec2_set_length (VEC2, const double);
int g_vec2_get_normal (VEC2, CONST_ARG_VEC2, CONST_ARG_VEC2);
double g_abs2 (const double, const double);
double g_sqrabs2 (const double, const double);
void g_vec2_rotate (VEC2, CONST_ARG_VEC2, const double);
double g_vec2_angle (CONST_ARG_VEC2, CONST_ARG_VEC2);
#define g_vec2_hm_interpol(el,new,parent,i) \
 do{VINHERIT const*const g_vinh=(el)->vinh+(i);int g_i;\
 const int g_maxi=g_vinh->np;\
 double g_a=0;double g_b=0;for(g_i=0;g_i<g_maxi;g_i++){\
 double const*const g_parval=(parent)[g_vinh->pindex[g_i]];\
 const double g_weight=g_vinh->pweight[g_i];\
 g_a+=g_parval[0]*g_weight;g_b+=g_parval[1]*g_weight;\
 }{g__vec2_set(new,g_a,g_b);}}while(0)
#define g_vec2_convex(x,a,b,l) \
 do{double const*const g_a=(a);double const*const g_b=(b);\
 double const g_l=(l);g__vec2_set(x,g_a[0]+g_l*(g_b[0]-g_a[0]),\
 g_a[1]+g_l*(g_b[1]-g_a[1]));}while(0)
int g_gcd ANSI_PARM((int , int));
double g_vec3_circle ANSI_PARM((VEC3 center, G_CONST VEC3 p[3]));
#ifndef G_MAX
#define G_MAX(A,B)        ( (A) > (B) ? (A) : (B) )
#endif
#ifndef G_MIN
#define G_MIN(A,B)        ( (A) < (B) ? (A) : (B) )
#endif
#ifndef G_ABS
#define G_ABS(A)        ( 0 < (A) ? (A) : -(A) )
#endif
#ifndef G_SGN
#define G_SGN(A)       ( (A) < 0 ? -1 : 1 )
#endif
#define G_INTERPOL(a,b,i) ((i)*((b)-(a))+(a))
#ifndef G_CHECK_BOUNDS
#define G_CHECK_BOUNDS(A,MIN,MAX) \
 do{if((A)<(MIN))(A)=(MIN);else if((A)>(MAX))(A)=(MAX);}while(0)
#endif
#define G_LOWER_BOUND(x,b) if ((x) >= (b)) ; else (x) = (b)
#define G_UPPER_BOUND(x,b) if ((x) <= (b)) ; else (x) = (b)
#ifndef M_PI
#define M_PI 3.14159265358979323846
#define M_PI_2 1.570796326794896619
#endif
#ifndef M_E
#define M_E 2.7182818284590452354
#endif
#ifdef G_CPP
#define G_VOID_P_TO_ANY_P(p) (*(void **)&(p))
#define G_ANY_P_TO_VOID_P(p) ((void *)(p))
#else
#define G_VOID_P_TO_ANY_P(p) (p)
#define G_ANY_P_TO_VOID_P(p) (p)
#endif
#define G_ALIGN_SIZE(s) offsetof(struct{char g_c; s g_s;}, g_s)
#define G_CEIL_SIZE(s,a) (((s)+((a) - 1)) & (~((a) - 1)))
#define G_ALIGN_TO(s,stru) G_CEIL_SIZE(s,G_ALIGN_SIZE(stru))
#define G_REP_SIZE(stru,last,n) \
 G_ALIGN_TO(offsetof(stru,last[0])+ \
 sizeof(((stru*)NULL)->last[0])*(n), stru)
#define G__ARRAYCOPY_A(dest,source,size,al) {union g_s{char c[sizeof(\
size)];al s;};(*(union g_s*)(dest)=*(union g_s*)(source));}
#define G_ARRAYCOPY(dest,source,size,base_type) do{\
if(G_ALIGN_SIZE(base_type)>=sizeof(void *)) \
 G__ARRAYCOPY_A(dest,source,size,void *) \
else if(G_ALIGN_SIZE(base_type)>=sizeof(double)) \
 G__ARRAYCOPY_A(dest,source,size,double) \
else if(G_ALIGN_SIZE(base_type)>=sizeof(float)) \
 G__ARRAYCOPY_A(dest,source,size,float) \
else if(G_ALIGN_SIZE(base_type)>=sizeof(int)) \
 G__ARRAYCOPY_A(dest,source,size,int) \
else if(G_ALIGN_SIZE(base_type)>=sizeof(short)) \
 G__ARRAYCOPY_A(dest,source,size,short) \
else G__ARRAYCOPY_A(dest,source,size,char);}while(0)
#define G_MEM_REALLOC(p,old,new) \
  mem_realloc(G_ANY_P_TO_VOID_P(p),(old)*sizeof*(p),(new)*sizeof*(p))
#define G_MEM_REALLOC_SET(p,old,new) \
  ((void)(G_VOID_P_TO_ANY_P(p) = G_MEM_REALLOC(p,old,new)))
#define G_MEM_ALLOC(p,size) \
  (G_VOID_P_TO_ANY_P(p) = mem_alloc((size)*sizeof(*(p))))
#define G_MEM_FREE(p,size) do{ \
  mem_free(G_ANY_P_TO_VOID_P(p),(size)*sizeof(*(p)));(p)=NULL;}while(0)
void *g_smart_mem_realloc ANSI_PARM((void *, size_t, size_t, size_t));
double *double_alloc ANSI_PARM((size_t));
double *double_free  ANSI_PARM((double *, size_t));
double *double_realloc ANSI_PARM((double *, size_t, size_t));
double *g_smart_double_realloc ANSI_PARM((double *, size_t, \
	size_t, size_t));
double **double_p_alloc ANSI_PARM((size_t));
double **double_p_free  ANSI_PARM((double **, size_t));
double **double_p_realloc ANSI_PARM((double **, size_t, size_t));
char *char_alloc ANSI_PARM((size_t));
char *char_free  ANSI_PARM((char *, size_t));
char *char_realloc ANSI_PARM((char *, size_t, size_t));
char *g_smart_char_realloc ANSI_PARM((char *, size_t, size_t, size_t));
char **char_p_alloc ANSI_PARM((size_t));
char **char_p_free  ANSI_PARM((char **, size_t));
char **char_p_realloc ANSI_PARM((char **, size_t, size_t));
int *int_alloc ANSI_PARM((size_t));
int *int_free  ANSI_PARM((int *, size_t));
int *int_realloc ANSI_PARM((int *, size_t, size_t));
int *g_smart_int_realloc ANSI_PARM((int *, size_t, size_t, size_t));
int **int_p_alloc ANSI_PARM((size_t));
int **int_p_free  ANSI_PARM((int **, size_t));
int **int_p_realloc ANSI_PARM((int **, size_t, size_t));
INT2 *int2_alloc ANSI_PARM((size_t));
INT2 *int2_free  ANSI_PARM((INT2 *, size_t));
INT2 *int2_realloc ANSI_PARM((INT2 *, size_t, size_t));
INT2 *g_smart_int2_realloc ANSI_PARM((INT2 *, size_t, size_t, size_t));
INT2 **int2_p_alloc ANSI_PARM((size_t));
INT2 **int2_p_free  ANSI_PARM((INT2 **, size_t));
INT2 **int2_p_realloc ANSI_PARM((INT2 **, size_t, size_t));
INT3 *int3_alloc ANSI_PARM((size_t));
INT3 *int3_free  ANSI_PARM((INT3 *, size_t));
INT3 *int3_realloc ANSI_PARM((INT3 *, size_t, size_t));
INT3 *g_smart_int3_realloc ANSI_PARM((INT3 *, size_t, size_t, size_t));
INT3 **int3_p_alloc ANSI_PARM((size_t));
INT3 **int3_p_free  ANSI_PARM((INT3 **, size_t));
INT3 **int3_p_realloc ANSI_PARM((INT3 **, size_t, size_t));
INT4 *int4_alloc ANSI_PARM((size_t));
INT4 *int4_free  ANSI_PARM((INT4 *, size_t));
INT4 *int4_realloc ANSI_PARM((INT4 *, size_t, size_t));
INT4 *g_smart_int4_realloc ANSI_PARM((INT4 *, size_t, size_t, size_t));
INT4 **int4_p_alloc ANSI_PARM((size_t));
INT4 **int4_p_free  ANSI_PARM((INT4 **, size_t));
INT4 **int4_p_realloc ANSI_PARM((INT4 **, size_t, size_t));
VEC2 *vec2_alloc ANSI_PARM((size_t));
VEC2 *vec2_free  ANSI_PARM((VEC2 *, size_t));
VEC2 *vec2_realloc ANSI_PARM((VEC2 *, size_t, size_t));
VEC2 *g_smart_vec2_realloc ANSI_PARM((VEC2 *, size_t, size_t, size_t));
VEC2 **vec2_p_alloc ANSI_PARM((size_t));
VEC2 **vec2_p_free  ANSI_PARM((VEC2 **, size_t));
VEC2 **vec2_p_realloc ANSI_PARM((VEC2 **, size_t, size_t));
VEC3 *vec3_alloc ANSI_PARM((size_t));
VEC3 *vec3_free  ANSI_PARM((VEC3 *, size_t));
VEC3 *vec3_realloc ANSI_PARM((VEC3 *, size_t, size_t));
VEC3 *g_smart_vec3_realloc ANSI_PARM((VEC3 *, size_t, size_t, size_t));
VEC3 **vec3_p_alloc ANSI_PARM((size_t));
VEC3 **vec3_p_free  ANSI_PARM((VEC3 **, size_t));
VEC3 **vec3_p_realloc ANSI_PARM((VEC3 **, size_t, size_t));
VEC4 *vec4_alloc ANSI_PARM((size_t));
VEC4 *vec4_free  ANSI_PARM((VEC4 *, size_t));
VEC4 *vec4_realloc ANSI_PARM((VEC4 *, size_t, size_t));
VEC4 *g_smart_vec4_realloc ANSI_PARM((VEC4 *, size_t, size_t, size_t));
VEC4 **vec4_p_alloc ANSI_PARM((size_t));
VEC4 **vec4_p_free  ANSI_PARM((VEC4 **, size_t));
VEC4 **vec4_p_realloc ANSI_PARM((VEC4 **, size_t, size_t));
typedef double (*g_double_function)();
g_double_function *dfnp_alloc ANSI_PARM((size_t));
g_double_function *dfnp_free  ANSI_PARM((g_double_function*, size_t));
g_double_function *dfnp_realloc ANSI_PARM((g_double_function*,size_t,size_t));
INSTANCE **instance_p_alloc ANSI_PARM((size_t));
INSTANCE **instance_p_free  ANSI_PARM((INSTANCE **, size_t));
INSTANCE **instance_p_realloc ANSI_PARM((INSTANCE **, size_t, size_t));
CHAIN **chain_p_alloc ANSI_PARM((size_t));
CHAIN **chain_p_free  ANSI_PARM((CHAIN **, size_t));
CHAIN **chain_p_realloc ANSI_PARM((CHAIN **, size_t, size_t));
SPLINE1D **spline1d_p_alloc ANSI_PARM((size_t));
SPLINE1D **spline1d_p_free  ANSI_PARM((SPLINE1D **, size_t));
SPLINE1D **spline1d_p_realloc ANSI_PARM((SPLINE1D **, size_t, size_t));
TRIANG1D **triang1d_p_alloc ANSI_PARM((size_t));
TRIANG1D **triang1d_p_free  ANSI_PARM((TRIANG1D **, size_t));
TRIANG1D **triang1d_p_realloc ANSI_PARM((TRIANG1D **, size_t, size_t));
TRIANG2D **triang2d_p_alloc ANSI_PARM((size_t));
TRIANG2D **triang2d_p_free  ANSI_PARM((TRIANG2D **, size_t));
TRIANG2D **triang2d_p_realloc ANSI_PARM((TRIANG2D **, size_t, size_t));
TRIANG1D ***triang1d_pp_alloc ANSI_PARM((size_t));
TRIANG1D ***triang1d_pp_free  ANSI_PARM((TRIANG1D ***, size_t));
TRIANG1D ***triang1d_pp_realloc ANSI_PARM((TRIANG1D ***, size_t, size_t));
TRIANG2D ***triang2d_pp_alloc ANSI_PARM((size_t));
TRIANG2D ***triang2d_pp_free  ANSI_PARM((TRIANG2D ***, size_t));
TRIANG2D ***triang2d_pp_realloc ANSI_PARM((TRIANG2D ***, size_t, size_t));
TRIANG1D ****triang1d_ppp_alloc ANSI_PARM((size_t));
TRIANG1D ****triang1d_ppp_free  ANSI_PARM((TRIANG1D ****, size_t));
TRIANG1D ****triang1d_ppp_realloc ANSI_PARM((TRIANG1D ****, size_t, size_t));
TRIANG2D ****triang2d_ppp_alloc ANSI_PARM((size_t));
TRIANG2D ****triang2d_ppp_free  ANSI_PARM((TRIANG2D ****, size_t));
TRIANG2D ****triang2d_ppp_realloc ANSI_PARM((TRIANG2D ****, size_t, size_t));
FUNCTION_RULER **function_ruler_p_alloc ANSI_PARM((size_t));
FUNCTION_RULER **function_ruler_p_free  ANSI_PARM((FUNCTION_RULER **, size_t));
FUNCTION_RULER **function_ruler_p_realloc ANSI_PARM((FUNCTION_RULER **, size_t, size_t));
BOUNDED_RULER **bounded_ruler_p_alloc ANSI_PARM((size_t));
BOUNDED_RULER **bounded_ruler_p_free ANSI_PARM((BOUNDED_RULER **, size_t));
BOUNDED_RULER **bounded_ruler_p_realloc ANSI_PARM((BOUNDED_RULER **, size_t, size_t));
RULER **ruler_p_alloc ANSI_PARM((size_t));
RULER **ruler_p_free  ANSI_PARM((RULER **, size_t));
RULER **ruler_p_realloc ANSI_PARM((RULER **, size_t, size_t));
typedef struct {
  struct g_vmm_block {
    size_t size, free, max;
    struct g_vmm_block *next;
    union {
      union {
	double d;
	void *vp;
	long l;
	int i;
	size_t s;
	void (*fp)();
      } align;
      char start;
    } data;
  } *block;
  size_t alloc_n;
} *G_VMM;
G_VMM g_vmm_new (size_t);
G_VMM g_vmm_set_alloc_size (G_VMM, size_t);
void *g_vmm_alloc_block (G_VMM, size_t);
void g_vmm_free_block (G_VMM, size_t);
void g_vmm_destroy (G_VMM);
#define g_vmm_alloc(vmm,n) ( \
  ((vmm)->block->free < (n)) ? g_vmm_alloc_block (vmm,n) : \
  (void *)(&(vmm)->block->data.start + ((vmm)->block->free -= (n))) \
)
#define g_vmm_free(vmm, n) do { \
  size_t g_n = (n); \
  if ((vmm)->block->free == (vmm)->block->max) \
    g_vmm_free_block (vmm, g_n); \
  { \
    struct g_vmm_block *const block = (vmm)->block; \
    block->free += g_n; \
    if (block->free <= block->max) \
      break; \
    g_n = block->free - block->max; \
    block->free = block->max; \
  } \
} while (1)
#define G_VMM_ALLOC(p,vmm,size) \
  (G_VOID_P_TO_ANY_P(p)=g_vmm_alloc(vmm,(size)*sizeof(*(p))))
#define G_VMM_FREE(p,vmm,size) do{ \
  g_vmm_free(vmm,(size)*sizeof(*(p)));(p)=NULL;}while(0)
#define G_VMM_ALLOC_MIXED(p,vmm,size,align) \
  (G_VOID_P_TO_ANY_P(p)= \
        g_vmm_alloc(vmm,G_ALIGN_TO((size)*sizeof(*(p)),align)))
#define G_VMM_FREE_MIXED(p,vmm,size,align) do{ \
  g_vmm_free(vmm,G_ALIGN_TO((size)*sizeof(*(p)),align)); \
  (p)=NULL;}while(0)
void g_s3_left2coord(VEC4, MATRIX44, VEC3);
void g_s3_coord2left(VEC3, MATRIX44, VEC4);
void g_s3_matrix_trans2orig(MATRIX44, VEC4);
void g_s3_matrix_trans2pnt(MATRIX44, VEC4);
void g_s3_matrix_trans(MATRIX44, VEC4, VEC4);
void g_s3_matrix_rot3(MATRIX44, VEC4);
void g_s3_matrix_rot2(MATRIX44, VEC4);
void g_s3_matrix_rotate(MATRIX44, VEC4, VEC4);
void g_s3_matrix_reflect(MATRIX44, VEC4, VEC4, VEC4);
double g_h3_dist(VEC4, VEC4);
int g_h3_tangent(VEC4, VEC4, VEC4);
int g_h3_matrix_trans2orig(MATRIX44, VEC4);
int g_h3_matrix_trans2pnt(MATRIX44, VEC4);
int g_h3_matrix_trans(MATRIX44, VEC4, VEC4);
int g_h3_matrix_rotate_orig(MATRIX44, VEC4, double);
int g_h3_matrix_rotate(MATRIX44, VEC4, VEC4, double);
int g_h3_matrix_reflect_orig(MATRIX44, VEC4, VEC4);
int g_h3_matrix_reflect(MATRIX44, VEC4, VEC4, VEC4);
int g_h3_matrix_invert(MATRIX44, VEC4);
void g_show_bnd_box(INSTANCE *);
void g_make_header ANSI_PARM ((INSTANCE*, char*, TEXTDEVICE*, long*));
void g_make_bottom ANSI_PARM ((TEXTDEVICE *, long));
int g_position ANSI_PARM ((char *, TEXTDEVICE *));
int g_vec3_get_arbitr_normal ANSI_PARM ((VEC3 , VEC3));
int g_vec3_assign_triang_node ANSI_PARM ((VEC3 , TRIANG2D *, int));
int g_get_triangle_with_edge ANSI_PARM ((TRIANG2D *,int , int ));
int g_get_opposite_vertex ANSI_PARM ((TRIANG2D *, int , int ));
int g_get_opp_vertex ANSI_PARM ((INT3 , int , int ));
int g_get_opp_vertex_ind ANSI_PARM ((INT3 , int , int ));
int g_triang2d_point_equal ANSI_PARM ((TRIANG2D *, int , int ,double));
int g_triang2d_get_cls_pnt ANSI_PARM ((TRIANG2D *, VEC3));
double g_triang2d_get_size ANSI_PARM ((TRIANG2D *));
double g_triang2d_point_sqrdist	ANSI_PARM ((TRIANG2D *, int , int ));
double g_triang2d_get_edge_length ANSI_PARM ((TRIANG2D *, int , int ));
double g_triang2d_get_vertex_angle ANSI_PARM ((TRIANG2D*, int , int ));
int g_line_plane_intersect ANSI_PARM ((TRIANG2D *, int, int, int,
				       int, int, VEC3));
TRIANG2D *get_icosaeder ANSI_PARM ((double *));
double g_triang1d_get_length ANSI_PARM ((TRIANG1D *));
int g_triang1d_get_vec ANSI_PARM ((TRIANG1D *, int, VEC3));
int g_line_reflect ANSI_PARM ((VEC3 [], MATRIX44));
int g_line_rotate ANSI_PARM ((VEC3 [], double, MATRIX44));
int g_plane_reflect ANSI_PARM ((VEC3 [], MATRIX44));
int g_point_reflect ANSI_PARM ((VEC3 , MATRIX44));
int g_translate ANSI_PARM ((VEC3 , MATRIX44));
int g_circle ANSI_PARM ((VEC3, VEC3, VEC3, VEC3, double, VEC3 *));
int g_helix ANSI_PARM ((VEC3, VEC3, VEC3, VEC3, double, VEC3 *));
void g_draw_circle(VEC3, double, VEC3, int, GRAPHICDEVICE *);
void g_draw_circle_orient(VEC3, double, VEC3, int, GRAPHICDEVICE *);
int g_draw_cyl(VEC3*,VEC3*,VEC3*,VEC3*,int,int,int,VEC3,
	       GRAPHICDEVICE*);
int g_draw_arrow(VEC3,VEC3,double,int,int,int,VEC3,GRAPHICDEVICE*);
void g_draw_tube(INSTANCE*,int,int(*)(VEC3,INSTANCE*,int),int,double);
int g_solve4 ANSI_PARM ((CONST_ARG_MATRIX44, CONST_ARG_VEC4, VEC4));
int g_solve3 ANSI_PARM ((CONST_ARG_MATRIX33, CONST_ARG_VEC3, VEC3));
int g_solve2 ANSI_PARM ((CONST_ARG_MATRIX22, CONST_ARG_VEC2, VEC2));
void g_go_back3(CONST_ARG_MATRIX33, VEC3, VEC3, CONST_ARG_INT3);
void g_gauss3(MATRIX33, VEC3, VEC3, INT3);
char *g_strdup ANSI_PARM ((const char *));
char *g_strfree ANSI_PARM ((char *));
char *g_strchange ANSI_PARM ((char *, const char *));
char *g_strcat ANSI_PARM ((char *, const char *));
char *g_strcut ANSI_PARM ((char *, size_t));
int g_strempty ANSI_PARM ((const char *));
int g_wildcard_match (const char *, const char *);
void g_check_bounds (double *, const double, const double);
#define NONE (-1)
int g_grdev_transform_pickpos(GRAPHICDEVICE *, double, double,
			      VEC3, VEC3);
int g_get_line_plane_intersection(VEC3, VEC3, VEC3, VEC3, VEC3, VEC3);
int g_proj_klein(VEC3, VEC4);
int g_proj_klein_inv(VEC4, VEC3);
int g_proj_dklein_inv(double[4][3], VEC3);
int g_proj_poinc(VEC3, VEC4);
int g_proj_poinc_inv(VEC4, VEC3);
int g_proj_dpoinc_inv(double[4][3], VEC3);
int g_proj_uhm(VEC3, VEC4);
int g_proj_uhm_inv(VEC4, VEC3);
int g_proj_poinc2klein(VEC3, VEC3);
int g_proj_klein2poinc(VEC3, VEC3);
int g_proj_poinc2uhm(VEC3, VEC3);
int g_proj_uhm2poinc(VEC3, VEC3);
int g_proj_klein2uhm(VEC3, VEC3);
int g_proj_uhm2klein(VEC3, VEC3);
int g_proj_stereo(VEC3, VEC4);
int g_proj_stereo_inv(VEC4, VEC3);
int g_proj_dstereo(double[3][4], VEC4);
int g_proj_dstereo_inv(double[4][3], VEC3);
#define LENS_STRUCT \
  INSTANCE_STRUCT; \
  VEC3   coord; \
  double h_max; \
  double h_min; \
  double scale; \
  double intermediate_zone; \
  double show_threshold; \
  int show; \
  struct group* control; \
  int size_of_data; \
  double* lens_data
typedef struct lens {
  LENS_STRUCT;
} LENS;
#define LIST_OF_INT_STRUCT \
  INSTANCE_STRUCT; \
  int num_of_int; \
  int max_num_of_int; \
  int *flags; \
  int *vec
typedef struct list_of_int {
  LIST_OF_INT_STRUCT;
} LIST_OF_INT;
#define LIST_OF_VEC3_STRUCT \
  INSTANCE_STRUCT; \
  int num_of_vec3; \
  int max_num_of_vec3; \
  int *flags; \
  VEC3 *vec
typedef struct list_of_vec3 {
  LIST_OF_VEC3_STRUCT;
} LIST_OF_VEC3;
#define LIST_OF_INST_STRUCT \
  TREEOBJECT_STRUCT; \
  int num_of_objects; \
  int max_num_of_objects; \
  int *flags; \
  INSTANCE **objects
typedef struct list_of_inst {
  LIST_OF_INST_STRUCT;
} LIST_OF_INST;
LIST_OF_INST **list_of_inst_p_alloc ANSI_PARM((size_t));
LIST_OF_INST **list_of_inst_p_free  ANSI_PARM((LIST_OF_INST **,\
size_t));
LIST_OF_INST **list_of_inst_p_realloc ANSI_PARM((LIST_OF_INST **,\
size_t, size_t));
#define GENDATA_STRUCT \
  TREEOBJECT_STRUCT; \
  int (*get_dimension_of_value)(struct gendata *); \
  int (*get_number_of_values)(struct gendata *); \
  int (*set_number_of_values)(struct gendata *, int); \
  int (*get_value)(struct gendata *, int, double *); \
  int (*set_value)(struct gendata *, int, double *); \
  double (*get_comp)(struct gendata *, int, int); \
  int (*set_comp)(struct gendata *, int, int, double); \
  double (*get_nth_val)(struct gendata *, int); \
  int (*set_nth_val)(struct gendata *, int, double); \
  int sizeof_comp; \
  int dimension_of_value; \
  int number_of_values; \
  int max_number_of_values
typedef struct gendata {
  GENDATA_STRUCT;
} GENDATA;
#define FLOATDATA_STRUCT \
  GENDATA_STRUCT; \
  float *value
typedef struct floatdata {
  FLOATDATA_STRUCT;
} FLOATDATA;
#define CHARDATA_STRUCT \
  GENDATA_STRUCT; \
  unsigned char *value
typedef struct chardata {
  CHARDATA_STRUCT;
} CHARDATA;
#define LIST_OF_VEC4_STRUCT \
  INSTANCE_STRUCT; \
  int *flag; \
  int max_num_of_vec4; \
  int num_of_vec4; \
  VEC4 *vec
typedef struct list_of_vec4 {
  LIST_OF_VEC4_STRUCT;
} LIST_OF_VEC4;
#define G_PE_MAX_FACTOR 30
#define G_PE_MAX_SPLAT_ELEMENT_VERTEX (1*G_PE_MAX_FACTOR)
#define G_PE_MAX_SPLAT_FACE (3*G_PE_MAX_FACTOR)
#define G_PE_MAX_SPLAT_VERTEX (3*G_PE_MAX_FACTOR)
#define G_PE_MAX_SPLAT_EDGE (2*2*G_PE_MAX_FACTOR)
#define G_PE_MAX_SPLAT_TMP_FACE (4*G_PE_MAX_FACTOR)
#define G_PE_MAX_SPLAT_FACE_VERTEX (2*G_PE_MAX_FACTOR)
#define G_PE_MAX_SPLAT_TMP_VERTEX (4*G_PE_MAX_FACTOR)
#define G_PE_MAX_SPLAT_TMP_EDGE (2*G_PE_MAX_FACTOR)
typedef struct {
  int number_of_vertices;
  double const*const*pos;
  double const*const*ppos;
  int number_of_polygons;
  int const*polygon_length;
  int const*const*polygon_vertex;
  int number_of_edges;
  INT2 const*edge_vertex;
  int const*const*vertex_edge;
} element_to_project;
typedef struct {
  int number_of_vertices;
  struct shape_image_patch_vertex {
    VEC3 p;
    double height;
    VEC2 pp;
    int number_of_parents;
    struct shape_image_patch_vertex_parent {
      int index;
      double weight;
      INT3 baryindex;
      VEC3 baryweight;
      int in_front;
    } parent [G_PE_MAX_SPLAT_ELEMENT_VERTEX];
  } vertex [G_PE_MAX_SPLAT_VERTEX];
  int number_of_patches;
  struct shape_image_patch {
    int number_of_vertices;
    int vertex[G_PE_MAX_SPLAT_VERTEX];
  } patch [G_PE_MAX_SPLAT_FACE];
} projected_element_image;
#define G_PROJECT_ELEMENT_AS_VOXEL 1
#define G_PROJECT_ELEMENT_MERGE_POLYGONS 2
#define G_PROJECT_ELEMENT_COMPATIBLE_FACES 4
void g_project_element (projected_element_image *,
                        element_to_project *, unsigned);
#define G_SCALAR_STRUCT \
  INSTANCE_STRUCT; \
  unsigned flags; \
  char *print_format
typedef struct g_scalar {
  G_SCALAR_STRUCT;
} G_SCALAR;
#define G_NUMBER_STRUCT \
  G_SCALAR_STRUCT
typedef struct g_number {
  G_NUMBER_STRUCT;
} G_NUMBER;
#define G_FLOAT_STRUCT \
  G_NUMBER_STRUCT; \
  float value
typedef struct g_float {
  G_FLOAT_STRUCT;
} G_FLOAT;
#define G_DOUBLE_STRUCT \
  G_NUMBER_STRUCT; \
  double value
typedef struct g_double {
  G_DOUBLE_STRUCT;
} G_DOUBLE;
#define G_INT_STRUCT \
  G_NUMBER_STRUCT; \
  int value
typedef struct g_int {
  G_INT_STRUCT;
} G_INT;
#define G_UINT_STRUCT \
  G_NUMBER_STRUCT; \
  unsigned int value
typedef struct g_uint {
  G_UINT_STRUCT;
} G_UINT;
#define G_LONG_STRUCT \
  G_NUMBER_STRUCT; \
  long value
typedef struct g_long {
  G_LONG_STRUCT;
} G_LONG;
#define G_ULONG_STRUCT \
  G_NUMBER_STRUCT; \
  unsigned long value
typedef struct g_ulong {
  G_ULONG_STRUCT;
} G_ULONG;
#define G_STRING_STRUCT \
  G_SCALAR_STRUCT; \
  char *value
typedef struct g_string {
  G_STRING_STRUCT;
} G_STRING;
#define G_METHODSTRING_STRUCT \
  G_STRING_STRUCT
typedef struct g_methodstring {
  G_METHODSTRING_STRUCT;
} G_METHODSTRING;
#define G_VEC3_STRUCT \
  G_SCALAR_STRUCT; \
  VEC3 value
typedef struct g_vec3 {
  G_VEC3_STRUCT;
} G_VEC3;
#define ARRAY_STRUCT \
  INSTANCE_STRUCT; \
  int num; \
  int max; \
  char *data
typedef struct array {
  ARRAY_STRUCT;
} ARRAY;
bool_t g_xdr_instance(XDR *, INSTANCE **);
bool_t g_xdr_superclass(XDR *, INSTANCE *);
int g_xdr_add_type(char *, int, xdrproc_t);
#define g_add_array_type g_xdr_add_type
bool_t g_xdr_array(XDR *, void **, int, int, char *);
bool_t g_xdr_string(XDR *, char **);
bool_t g_xdr_version(XDR *, int *);
int g_xdr_get_version(void);
int g_xdr_get_revision(void);
int g_xdr_start(XDR *);
XDR *g_xdr_open_file(char *, OPEN_MODE);
int g_xdr_end(void);
int g_xdr_close_file(XDR *);
bool_t g_xdr_int2(XDR *, INT2);
bool_t g_xdr_int3(XDR *, INT3);
bool_t g_xdr_int4(XDR *, INT4);
bool_t g_xdr_vec2(XDR *, VEC3);
bool_t g_xdr_vec3(XDR *, VEC3);
bool_t g_xdr_vec4(XDR *, VEC4);
bool_t g_xdr_fvec2(XDR *, FVEC3);
bool_t g_xdr_fvec3(XDR *, FVEC3);
bool_t g_xdr_fvec4(XDR *, FVEC3);
bool_t g_xdr_matrix22(XDR *, MATRIX22);
bool_t g_xdr_matrix33(XDR *, MATRIX33);
bool_t g_xdr_matrix44(XDR *, MATRIX44);
bool_t g_xdr_method(XDR *, char **);
typedef enum colorbar_flags {
  cbfNONE =0,
  cbfFIXMODULE =1,
  cbfFIXMODULEINST =2
} COLORBAR_FLAGS;
typedef enum colorbar_display {
  cbdOFF =0,
  cbdON =1,
  cbdOPAC =2
} COLORBAR_DISPLAY;
typedef enum colorbar_scalemode {
  cbscNONE =0,
  cbscMINMAX =1,
  cbscSCALE =2,
  cbscLABEL =4,
  cbscDYNAMICCOLOR =8
} COLORBAR_SCALEMODE;
typedef enum colorbar_boxmode {
  cbbmOFF =0,
  cbbmGRID =1,
  cbbmON =2
} COLORBAR_BOXMODE;
typedef enum colorbar_orientation {
  cboVERTICAL =0,
  cboHORIZONTAL =1
} COLORBAR_ORIENTATION;
typedef enum colorbar_oormode {
  cboormNONE_TCLAMP = 0,
  cboormNONE_TREPEAT = 1,
  cboormNONE_TMINMAX = 2,
  cboormCLAMP = 3,
  cboormREPEAT = 4,
  cboormMINMAX = 5
} COLORBAR_OORMODE;
typedef enum colorbar_valueprop {
  cbvpSTANDARD =0,
  cbvpACTIVE =1,
  cbvpARROW =2,
  cbvpNAME =4,
  cbvpCOLOR =8
} COLORBAR_VALUEPROP;
typedef enum colorbar_texture_flag {
  cbtfNONE =0,
  cbtfTEXTUREOUTOFDATE =1,
  cbtfMATRIXOUTOFDATE =2,
  cbtfFILTER_NEAREST_MODE =4,
  cbtfNO_BORDER_MODE =8
} COLORBAR_TEXTURE_FLAG;
typedef enum {
  ctetNONE = 0,
  ctetEXPAND_TEXEL,
  ctetEXPAND_TEXEL_VAL
} COLORBAR_TEXTURE_EXTENSION_TYPE;
typedef struct colorbar_texture_extension {
  COLORBAR_TEXTURE_EXTENSION_TYPE type;
  int origin, dimensions;
  INT2 width;
  VEC2 offset, scale;
  union {
    void *any;
    void (*expand_texel)(FVEC4*, int, struct colorbar_texture_extension *);
    void (*expand_texel_val)(FVEC4*, int,
			     struct colorbar_texture_extension *, double);
  } function;
} COLORBAR_TEXTURE_EXTENSION;
typedef struct colorbar_value_descr {
  unsigned int me_id;
  VEC3 color;
  double opacity;
  unsigned long prop;
  double arrow_length;
  double text_pos;
} COLORBAR_VALUE_DESCR;
typedef enum colorbar_tag {
  CB_End,
  CB_Display,
  CB_BoxMode,
  CB_OutofRangeMode,
  CB_Resolution,
  CB_TextureResolution,
  CB_Orientation,
  CB_Position,
  CB_Size,
  CB_Width,
  CB_Height,
  CB_DisplayOpacity,
  CB_Superarea,
  CB_Subarea,
  CB_LineStart,
  CB_LineDistance,
  CB_MinMax,
  CB_Min,
  CB_Max,
  CB_MinMaxColor,
  CB_MinColor,
  CB_MinOpacity,
  CB_MaxColor,
  CB_MaxOpacity,
  CB_ArrowColor,
  CB_TextColor,
  CB_LineColor,
  CB_LineOpacity,
  CB_BoxColor,
  CB_AddModule,
  CB_AddModuleList,
  CB_Module,
  CB_ModuleInst,
  CB_FixModule,
  CB_FixModuleInst,
  CB_Value,
  CB_Scale
} COLORBAR_TAG;
typedef enum colorbarmodule_flags {
  cbmfNONE= 0,
  cbmfNOREPEAT =1,
  cbmfNORMALIZEDVALUES =2
} COLORBARMODULE_FLAGS;
typedef struct colorbarmodule_descr {
  CLASS *class;
  char *name;
  COLORBARMODULE_FLAGS flags;
  INTERACTIVE *(*get_gui)();
  int (*get_color)();
  int (*get_opacity)();
  int (*get_rgba)();
} COLORBARMODULE_DESCR;
typedef struct colorbarmodule_handler {
  CLASS *class;
  CYCLE_LABEL *label;
} COLORBARMODULE_HANDLER;
#define COLORBARMODULE_GUI_WIDTH MENU_MAX_SIZE
#define COLORBARMODULE_GUI_HEIGHT MENU_MAX_SIZE
#define COLORBAR_STRUCT \
  INSTANCE_STRUCT; \
  INSTANCE (*funct)(); \
  INSTANCE *object; \
  char *name_of_function; \
  COLORBAR_FLAGS flags; \
  G_LIST *lo_modules; \
  struct colorbarmodule *module; \
  COLORBARMODULE_DESCR *module_descr; \
  COLORBAR_OORMODE oormode; \
  int texture_handle; \
  int texture_resolution; \
  COLORBAR_TEXTURE_FLAG texture_flag; \
  int texture_extensions; \
  COLORBAR_TEXTURE_EXTENSION *texture_extension; \
  char cmdline [MAX_STRLEN]; \
  double min,max; \
  VEC3 max_color, min_color; \
  double max_opacity, min_opacity; \
  int display_on_off; \
  VEC3 xyz; \
  double display_opacity; \
  double height; \
  double width; \
  int resolution; \
  int direction; \
  int box_mode; \
  double superarea, subarea; \
  char double_display[MAX_STRLEN]; \
  double g_cb_sc_label_width; \
  double g_cb_sc_width; \
  double g_cb_sc_begin; \
  double g_cb_sc_dist; \
  int g_cb_sc_labels; \
  char g_cb_sc_format[MAX_STRLEN]; \
  unsigned long g_cb_sc_flags; \
  VEC3 scale_text_color; \
  VEC3 box_color, text_color; \
  double start_eps; \
  double eps; \
  int no_discrpoints; \
  double *discrpoints; \
  int number_of_values; \
  double *values; \
  COLORBAR_VALUE_DESCR *value_descr; \
  VEC3 arrow_color, line_color; \
  double line_opacity; \
  int has_isoline_support; \
  int has_opacity_support; \
  struct button *button; \
  struct group *group; \
  struct layer *layer_options; \
  struct layer *layer_values; \
  struct layer *layer_modules; \
  struct multieditor *vme; \
  struct color_sel *vcs; \
  struct slider *vos; \
  struct checkfield *vcbpropchf; \
  struct ruler *vcbarrowlenrul; \
  struct ruler *vcbtextposrul; \
  struct interactive *module_interactive; \
  struct group *module_grp; \
  struct combobutton *module_sel; \
  double color; \
  double offset
typedef struct colorbar {
  COLORBAR_STRUCT;
} COLORBAR;
int g_get_rgba_for_value (COLORBAR *, double, VEC4);
int g_get_color_for_value (COLORBAR *, double, VEC3);
int g_get_opacity_for_value (COLORBAR *, double, double *);
int g_get_colorbar_value (COLORBAR *, int, double *);
int g_get_rgba_for_index (COLORBAR *, int, int, VEC4);
int g_get_color_for_index (COLORBAR *, int, int, VEC3);
int g_get_opacity_for_index (COLORBAR *, int, int, double *);
int g_get_colorbar_line_value (COLORBAR *, int, double *);
int g_get_rgba_for_line (COLORBAR *, int , VEC3 );
int g_get_color_for_line (COLORBAR *, int , VEC3 );
int g_get_opacity_for_line (COLORBAR *, int , double * );
int g_get_colorbar_scale_value (COLORBAR *, int, double *);
int g_get_rgba_for_scale (COLORBAR *, int , VEC3 );
int g_get_color_for_scale (COLORBAR *, int , VEC3 );
int g_get_opacity_for_scale (COLORBAR *, int , double *);
int g_colorbar_get_texture(COLORBAR *, GRAPHICDEVICE *);
void g_colorbar_get_texture_matrix(COLORBAR *,\
				   GRAPHICDEVICE*, MATRIX44 );
int g_colorbar_get_texture_coord(COLORBAR *, GRAPHICDEVICE *,\
                                 double, VEC3);
void g_colorbar_update_texture(COLORBAR *, GRAPHICDEVICE *);
void g_colorbar_update_tmatrix(COLORBAR *, GRAPHICDEVICE *) ;
void g_colorbar_item_set_user_level(ITEM *, int);
#define g_colorbar_get_display(cb,value) value = cb->display_on_off
#define g_colorbar_get_flags(cb,value) value = cb->flags
#define g_colorbar_get_resolution(cb,value) value = cb->resolution
#define g_colorbar_get_orientation(cb,value) value = cb->direction
#define g_colorbar_get_position(cb,value) g_vec3_assign(value, cb->xyz)
#define g_colorbar_get_width(cb,value) value = cb->width
#define g_colorbar_get_height(cb,value) value = cb->height
#define g_colorbar_get_displayopacity(cb,value) \
		                   value = cb->display_opacity
#define g_colorbar_get_line_start(cb,value) value = cb->start_eps
#define g_colorbar_get_line_distance(cb,value) value = cb->eps
#define g_colorbar_get_min(cb,value) value = cb->min
#define g_colorbar_get_max(cb,value) value = cb->max
#define g_colorbar_get_boxmode(cb,value) value = cb->box_mode
#define g_colorbar_get_oormode(cb,value) value = cb->oormode
#define g_colorbar_get_mincolor(cb,value) \
  g_vec3_assign(value, cb->min_color)
#define g_colorbar_get_minopacity(cb,value) value = cb->min_opacity
#define g_colorbar_get_maxcolor(cb,value) \
  g_vec3_assign(value, cb->max_color)
#define g_colorbar_get_maxopacity(cb,value) value = cb->max_opacity
#define g_colorbar_get_arrowcolor(cb,value) \
  g_vec3_assign(value, cb->arrow_color)
#define g_colorbar_get_textcolor(cb,value) \
  g_vec3_assign(value, cb->text_color)
#define g_colorbar_get_boxcolor(cb,value) \
  g_vec3_assign(value, cb->box_color)
#define g_colorbar_get_linecolor(cb,value) \
  g_vec3_assign(value, cb->line_color)
#define g_colorbar_get_lineopacity(cb,value) value = cb->line_opacity
#define g_colorbar_get_superarea(cb,value) \
  value = cb->superarea
#define g_colorbar_get_subarea(cb,value) \
  value = cb->subarea
#define g_colorbar_get_texture_resolution(cb,value) \
  value = cb->texture_resolution
#define g_colorbar_get_module(cb, value) \
  value = cb->module
#define g_colorbar_get_module_descr(cb, value) \
  value = cb->module_descr
#define g_colorbar_has_isoline_support(cb, value) \
  if( cb->has_isoline_support ) value=0; else value=1;
#define g_colorbar_has_opacity_support(cb, value) \
  if( cb->has_opacity_support ) value=0; else value=1;
#define g_colorbar_outdate(cb) \
 do {cb->texture_flag |= cbtfTEXTUREOUTOFDATE; \
     cb->texture_flag |= cbtfMATRIXOUTOFDATE;} \
 while(0)
#define g_colorbar_outdate_texture(cb) \
  cb->texture_flag |= cbtfTEXTUREOUTOFDATE
#define g_colorbar_outdate_tmatrix(cb) \
  cb->texture_flag |= cbtfMATRIXOUTOFDATE
#define g_colorbar_refresh(cb, grdev) \
 do {if( cb->texture_flag & cbtfTEXTUREOUTOFDATE ) \
       g_colorbar_update_texture(cb,grdev); \
     if( cb->texture_flag & cbtfMATRIXOUTOFDATE )\
       g_colorbar_update_tmatrix(cb, grdev); } \
 while(0)
#define COLORBARMODULE_STRUCT \
  INSTANCE_STRUCT; \
  COLORBAR *colorbar
typedef struct colorbarmodule {
  COLORBARMODULE_STRUCT;
} COLORBARMODULE;
#define g_colorbarmodule_colorbar(module) module->colorbar
#define g_colorbarmodule_get_colorbar(module, cb) cb = module->colorbar
#define g_colorbarmodule_set_colorbar(module, cb) module->colorbar = cb
#define g_colorbarmodule_set_descr(descr,cl,n,fl,gg,gc,go,gr) \
  do {descr->class =cl; descr->name = g_strdup(n); \
      descr->flags =fl; descr->get_gui =gg; \
      descr->get_color=gc; descr->get_opacity=go; descr->get_rgba=gr;}\
  while(0)
#define CBM1C_STRUCT \
  COLORBARMODULE_STRUCT; \
  INTERACTIVE *interactives; \
  VEC3 color; \
  double opacity
typedef struct cbm1c {
  CBM1C_STRUCT;
} CBM1C;
#define CBMUNI_STRUCT \
  CBM1C_STRUCT
typedef struct cbmuni {
  CBMUNI_STRUCT;
} CBMUNI;
#define CBM2CI_STRUCT \
  COLORBARMODULE_STRUCT; \
  INTERACTIVE *interactives; \
  VEC3 min_color; \
  double min_opacity; \
  VEC3 max_color; \
  double max_opacity
typedef struct cbm2ci {
  CBM2CI_STRUCT;
} CBM2CI;
#define CBMIBI_STRUCT \
  CBM2CI_STRUCT
typedef struct cbmibi {
  CBMIBI_STRUCT;
} CBMIBI;
typedef enum cbmhsv_mode {
  cbmhsvSTANDARD =0,
  cbmhsvUSESPLINE =1
} CBMHSV_MODE;
#define CBMHSV_STRUCT \
  COLORBARMODULE_STRUCT; \
  int mode; \
  SPLINE1D *spline; \
  GROUP *interactives; \
  SPLINE_EDITOR *editor; \
  double offset; \
  double range; \
  double saturation; \
  double value
typedef struct cbmhsv {
  CBMHSV_STRUCT;
} CBMHSV;
typedef struct cbmxci_icolor_descr {
  unsigned int me_id;
  double value;
  VEC3 color;
  double opacity;
} CBMXCI_ICOLOR_DESCR;
typedef enum cbmxci_mode {
  cbmmimONCE =0,
  cbmmimREPEAT =1,
  cbmmimMIRROR =2
} CBMXCI_MODE;
#define CBMXCI_STRUCT \
  COLORBARMODULE_STRUCT; \
  GROUP *interactives; \
  int mode; \
  int number_of_icolors; \
  CBMXCI_ICOLOR_DESCR *icolor_descr; \
  MULTIEDITOR *me; \
  COLOR_SEL *cs; \
  SLIDER *sl
typedef struct cbmxci {
  CBMXCI_STRUCT;
} CBMXCI;
#define CBMXCIN_STRUCT \
  CBMXCI_STRUCT
typedef struct cbmxcin {
  CBMXCIN_STRUCT;
} CBMXCIN;
#define CBMMIPOL_STRUCT \
  CBMXCI_STRUCT
typedef struct cbmmipol {
  CBMMIPOL_STRUCT;
} CBMMIPOL;
#define CBMMIPOLN_STRUCT \
  CBMXCIN_STRUCT
typedef struct cbmmipoln {
  CBMMIPOLN_STRUCT;
} CBMMIPOLN;
typedef struct cbmpart_area_descr {
  unsigned int me_id;
  double value;
  COLORBARMODULE *module;
  COLORBARMODULE_DESCR *module_descr;
  INTERACTIVE *module_interactive;
} CBMPART_AREA_DESCR;
typedef enum cbmpart_orienrtation {
  cbmpartoRIGHT =0,
  cbmpartoLEFT =1
} CBMPART_ORIENTATION;
typedef enum cbmpart_mode {
  cbmpartmONCE =0,
  cbmpartmREPEAT =1,
  cbmpartmMIRROR =2
} CBMPART_MODE;
#define CBMPART_STRUCT \
  COLORBARMODULE_STRUCT; \
  GROUP *interactives; \
  int mode; \
  int area_orientation; \
  int min_id, max_id; \
  int number_of_areas; \
  CBMPART_AREA_DESCR *area_descr; \
  CBMPART_AREA_DESCR *current; \
  MULTIEDITOR *me; \
  COMBOBUTTON *module_sel; \
  GROUP *module_grp; \
  G_LIST *lo_modules
typedef struct cbmpart {
  CBMPART_STRUCT;
} CBMPART;
#define CBMPARTN_STRUCT \
  COLORBARMODULE_STRUCT; \
  GROUP *interactives; \
  int area_orientation; \
  int min_id, max_id; \
  int number_of_areas; \
  CBMPART_AREA_DESCR *area_descr; \
  CBMPART_AREA_DESCR *current; \
  MULTIEDITOR *me; \
  COMBOBUTTON *module_sel; \
  GROUP *module_grp; \
  G_LIST *lo_modules
typedef struct cbmpartn {
  CBMPARTN_STRUCT;
} CBMPARTN;
#define CBMSI_STRUCT \
  CBMPART_STRUCT
typedef struct cbmsi {
  CBMSI_STRUCT;
} CBMSI;
#define CBMSINO_STRUCT \
  CBMPARTN_STRUCT
typedef struct cbmsino {
  CBMSINO_STRUCT;
} CBMSINO;
#define CBMHSVOLD_STRUCT \
  COLORBARMODULE_STRUCT; \
  GROUP *interactives; \
  double saturation; \
  double value
typedef struct cbmhsvold {
  CBMHSVOLD_STRUCT;
} CBMHSVOLD;
#define CLOCK_STRUCT \
  TREEOBJECT_STRUCT; \
   double t; \
   double t_start; \
   double t_end; \
   int    sync; \
   int    ana_active; \
   VEC3   ana_pos; \
   VEC3   ana_color; \
   double wavlen; \
   double r; \
   int    disc; \
   VEC3*  tab; \
   int    bar_active; \
   VEC3   bar_pos; \
   VEC3   bar_color; \
   double width, height; \
   int   dig_active; \
   VEC3  dig_pos; \
   VEC3  dig_color; \
   char* formatstring; \
   char* font
typedef struct clock {
  CLOCK_STRUCT;
} CLOCK;
#define TIMESCENE_STRUCT \
  SCENE_STRUCT; \
        double time,object_time; \
        G_SCENE_OBJECT *dynamic; \
	char *dynamic_method_name; \
	int sync
typedef struct timescene {
  TIMESCENE_STRUCT;
} TIMESCENE;
#define TIMESTEP_STRUCT \
  TREEOBJECT_STRUCT; \
        double time; \
        struct timestep *pre_step,*post_step; \
        G_SCENE_OBJECT *pre_object,*post_object
typedef struct timestep {
  TIMESTEP_STRUCT;
} TIMESTEP;
typedef enum {
  ieNothing      = 0,
  ieNeedFilename = 1,
  ieCanCompress  = 2
} IMPORT_EXPORT_FLAGS;
#define IMPORT_EXPORT_STRUCT \
  INSTANCE_STRUCT; \
  INSTANCE *import_instance; \
  char *import_method; \
  INSTANCE *export_instance; \
  char *export_method; \
  IMPORT_EXPORT_FLAGS flags; \
  char *extension; \
  char *filename
typedef struct import_export {
  IMPORT_EXPORT_STRUCT;
} IMPORT_EXPORT;
typedef enum {
  I_End = -99999,
  I_Name,
  I_Size,
  I_SizeX,
  I_SizeY,
  I_RSize,
  I_RSizeX,
  I_RSizeY,
  I_Pos,
  I_PosX,
  I_PosY,
  I_Color,
  I_ColorRGB,
  I_ColorIndex,
  I_TextcolorIndex,
  I_FillMode,
  I_AddAction,
  I_Expert,
  I_DrawMethod,
  I_State,
  I_Align,
  I_Text,
  I_Action,
  I_Instance,
  I_Self,
  I_Method,
  I_Label,
  I_LabelList,
  I_HelpText,
  I_Redraw,
  I_Inactive,
  I_SideEffect,
  I_BarColor,
  I_BarColorRGB,
  I_BarColorIndex,
  I_EvalFn,
  I_MinMax,
  I_Min,
  I_Max,
  I_FixMinMax,
  I_Offset,
  I_Scale,
  I_StepSize,
  I_ValueChanged,
  I_BarSize,
  I_TotalSize,
  I_PrintFormat,
  I_Var,
  I_DefaultValue,
  I_TabAction,
  I_Eval,
  I_Type,
  I_Item,
  I_Border,
  I_ButtonList,
  I_RulerList,
  I_SliderList,
  I_FixSize,
  I_Effect,
  I_Spline,
  I_FunctionArg,
  I_MaskMode,
  I_NewBox
} ITEM_TAG;
ITEM *new_item(CLASS *, ...);
typedef enum {
  P_End = -88888,
  P_Project,
  P_ProjectList,
  P_Class,
  P_ClassList,
  P_ClassCN,
  P_UseAddon,
  P_UseAddonN,
  P_Addon,
  P_AddonCN,
  P_SubAddon,
  P_Method,
  P_MethodList,
  P_MethodCN,
  P_Item,
  P_ItemOpt,
  P_ButtonList,
  P_RulerList,
  P_SliderList,
  P_InitMethod,
  P_ExitMethod,
  P_AddMethod,
  P_UpdateUifMethod,
  P_Version,
  P_Date,
  P_Author
} PROJECT_TAG;
typedef struct {
  char *name;
  char *setup;
  void *(*func)();
  int hidden;
} PRTYPE;
typedef struct {
  char *name;
} PROJECT_DESCR;
typedef struct {
  CLASS **superclass;
  CLASS **class;
  char *name;
  int size;
} CLASS_DESCR;
typedef struct {
  CLASS **class;
  char *name;
  void *(*func)();
} METHOD_DESCR;
typedef struct {
  char *methname;
  INSTANCE **obj;
  char *txt;
  double l, h, x, y;
  int optmenu;
} BUTTON_DESCR;
typedef struct {
  void *var;
  char *txt;
  double x, y;
  char *action;
  int type;
  int optmenu;
} RULER_DESCR;
typedef struct {
  void *var;
  char *txt;
  double x, y;
  char *action;
  int type;
  int optmenu;
} SLIDER_DESCR;
#define PROJECT_STRUCT \
  INSTANCE_STRUCT; \
  int status; \
  char *setup; \
  int used; \
  int added; \
  G_LIST *projects; \
  G_LIST *classes; \
  G_LIST *addons; \
  G_LIST *methods; \
  G_LIST *items; \
  char *init; \
  char *exit; \
  char *add; \
  char *update_uif; \
  TREEOBJECT *object; \
  char *path; \
  int version; \
  char *date; \
  char *author; \
  void *load_descr
typedef struct project {
  PROJECT_STRUCT;
} PROJECT;
void g_project_include(PRTYPE *);
PROJECT *g_project_use(char *, int);
PROJECT *g_project_unuse(char *);
PROJECT *g_project_add(char *);
PROJECT *g_project_remove(char *);
#define REFINE 1
#define COARSE 2
#define G_REFINE 0x1
#define G_COARSE 0x2
#define G_MOVE   0x4
#define G_DELETE 0x8
#define G_NOT_REFINE 0x10
#define G_NOT_COARSE 0x20
#define G_MOVED   0x40
#define G_DELETED 0x80
#define G_NOEDGE 0x18
#define restrict restrictor
typedef struct bnd_function {
  char *name;
  double (*g)(double, double, double, void *, INSTANCE *);
  size_t size_of_par;
  void *par;
} BND_FUNCTION;
#define G_MAX_BND_FUNCTIONS 0x10000
typedef struct refine2d {
  unsigned char refine;
  unsigned char edge;
  unsigned char friend;
  unsigned char level;
  unsigned char vtx_level[3];
} REFINE2D;
#define ADAPT2D_STRUCT \
  FE2D_STRUCT; \
        REFINE2D *refine; \
        int number_of_bnd_functions; \
        int max_number_of_bnd_functions; \
        BND_FUNCTION *bnd_function; \
        void (*interpol)(), (*restrict)(); \
        void (*element_compress)(), (*point_compress)()
typedef struct adapt2d {
  ADAPT2D_STRUCT;
} ADAPT2D;
bool_t g_xdr_refine2d(XDR *, REFINE2D *);
int g_a2_refine_edge(ADAPT2D *, int);
typedef struct refine3d {
        char refine;
        char level[4];
        char edge[4];
} REFINE3D;
#define ADAPT3D_STRUCT \
  FE3D_STRUCT; \
  REFINE3D *refine; \
  int number_of_boundaries, max_number_of_boundaries; \
  BND_FUNCTION *bnd_function; \
  void (*interpol)(),(*restrict)(); \
  void (*element_compress)(),(*point_compress)()
typedef struct adapt3d {
  ADAPT3D_STRUCT;
} ADAPT3D;
bool_t g_xdr_refine3d(XDR *, REFINE3D *);
void g_mark_triangle(TRIANG2D *, int, VEC3);
void g_mark_boundary(TRIANG2D *, int, int, VEC3);
void g_mark_point(VEC3, VEC3);
void g_add_bnd_descrition(int, char *);
void g_del_bnd_descrition(int);
typedef struct optipar {
  double (*F1)(),(*DF1)(),(*F2)(),(*DF2)();
  double (*concentration)();
  int   itmax;
  double eps;
} OPTIPAR;
#define FL_NOT_CLOSED   1
#define FL_CLOSED       2
#define FL_BOUNDARY     3
#define FL_ZEROFIELD    4
#define FIELDLINE_STRUCT \
  TRIANG1D_STRUCT; \
  int type
typedef struct fieldline {
  FIELDLINE_STRUCT;
} FIELDLINE;
typedef struct magnet_line_info{
  struct fieldline *fl;
  double dt, T, TOL, time;
  double max_time;
  double max_eps;
  CHECKFIELD_VAR flag;
  int    number_of_steps;
  VEC3   start_point;
  VEC3   x;
  int    type;
  int    done;
  int    criterion_active;
  double dist, old_dist;
}MAGNET_LINE_INFO;
typedef enum {
  hefNone           = 0,
  hefVertex         = 1<<0,
  hefVindex         = 1<<1,
  hefVinh           = 1<<2,
  hefAll            = 1<<0 | 1<<1 | 1<<2
} MESH_ELEMENT_FLAGS;
typedef enum {
  mafNone           = 0,
  mafSorted         = 1<<0,
  mafBoundary       = 1<<1
} MESH_ACCESS_FLAGS;
typedef enum {
  gffNone           = 0,
  gffUpToDate       = 1<<0
} GENMESH_FUNCTION_FLAGS;
#define GENMESH_FDATA_STRUCT \
  char     *name;               \
  struct genmesh_fdata *last, *next;  \
  int      dimension_of_value;  \
  int      continuous_data;     \
  void    *function_data
typedef struct genmesh_fdata {
  GENMESH_FDATA_STRUCT;
} GENMESH_FDATA;
#define GENMESH_STRUCT \
  TREEOBJECT_STRUCT; \
  int           max_dimension_of_coord; \
  int           max_eindex; \
  int           max_vindex; \
  int           max_dindex; \
  int           max_number_of_vertices; \
  int max_level; \
  int level_of_interest; \
  G_LIST        *synthetic_functions; \
  G_LIST        *valid_functions; \
  GENMESH_FUNCTION_FLAGS function_flags; \
  G_LIST        *current_function; \
  MESH_ACCESS_FLAGS access_mode; \
  MESH_ACCESS_FLAGS access_capability; \
  GENMESH_FDATA *f_data; \
  void          *user_data
typedef struct genmesh {
  GENMESH_STRUCT;
} GENMESH;
typedef struct {
  struct genmesh_synthetic_function *synthetic;
  GENMESH_FDATA *fdata;
} GENMESH_FUNCTION;
#define GENMESH_SYNTHETIC_FUNCTION_STRUCT \
  GENMESH_FDATA *fdata; \
  void (*init)(GENMESH *, struct genmesh_synthetic_function*); \
  void (*free)(struct genmesh_synthetic_function*)
typedef struct genmesh_synthetic_function {
  GENMESH_SYNTHETIC_FUNCTION_STRUCT;
} genmesh_synthetic_function;
typedef struct genmesh_mscalar_function {
  GENMESH_SYNTHETIC_FUNCTION_STRUCT;
  int number_of_input_functions;
  struct genmesh_mscalar_input_function {
    GENMESH_FDATA *fdata;
  } *input_function;
  G_LIST *components;
} genmesh_mscalar_function;
#define USERMESH_STRUCT \
  char *filename
typedef struct usermesh {
  USERMESH_STRUCT;
} USERMESH;
#define MESH2D_MAX_VERTEX  20
#define MESH2D_MAX_EDGE 20
typedef struct {
  int np;
  int G_CONST*pindex;
  double G_CONST*pweight;
} VINHERIT;
#define MESH2D_ELEMENT2D_STRUCT \
  struct genmesh2d      *mesh;  \
  double G_CONST*G_CONST*vertex;\
  int            G_CONST*vindex;\
  int                   eindex; \
  struct element2d_description G_CONST*descr; \
  MESH_ELEMENT_FLAGS    present;\
                                \
                                \
  void              *user_data; /* optional: pointer to user's       \
                                   data of this element           */ \
  struct element2d    *parent;  \
  VINHERIT     G_CONST*vinh;    \
  int                 ref_rule;  \
  int 		      level;  \
  int                 has_children
typedef struct element2d {
MESH2D_ELEMENT2D_STRUCT;
} ELEMENT2D;
#define HMESH2D_HELEMENT2D_STRUCT MESH2D_ELEMENT2D_STRUCT
#define HELEMENT2D ELEMENT2D
typedef struct element2d_description {
  int       dindex;
  int       number_of_vertices;
  int       dimension_of_coord;
  double    G_CONST*G_CONST*coord;
  int       parametric_degree;
  int       (*world_to_coord)(ELEMENT2D *,double G_CONST*, double *);
  void      (*coord_to_world)(ELEMENT2D *,double G_CONST*, double *);
  int       (*check_inside)(ELEMENT2D *,double G_CONST*);
  ELEMENT2D *(*neighbour)(ELEMENT2D *, int, int, double *, double *,
			  MESH_ELEMENT_FLAGS);
  int       (*boundary)(ELEMENT2D *, int);
  void      (*coord_of_parent)(ELEMENT2D *,double *, double *);
} ELEMENT2D_DESCRIPTION;
#define HELEMENT2D_DESCRIPTION ELEMENT2D_DESCRIPTION
typedef struct {
  int           polynomial_degree;
} F_EL_INFO2D;
#define F_HEL_INFO2D F_EL_INFO2D
#define MESH2D_FDATA_STRUCT \
  GENMESH_FDATA_STRUCT; \
  void (*f)(ELEMENT2D *, int,  \
	    double G_CONST *, double[], void *); \
  void (*f_el_info)(ELEMENT2D *, F_EL_INFO2D *, \
		    void *);  \
		      \
  void (*get_bounds)(ELEMENT2D *, \
 	             double* ,double*, void *function_data); \
  void (*get_vertex_estimate)(ELEMENT2D *, double *, \
			      void *function_data); \
                               \
  double (*get_element_estimate)(ELEMENT2D *, \
				 void *function_data); \
  double threshold;  \
  double hp_threshold;  \
  int hp_maxlevel
typedef struct f_data2d {
 MESH2D_FDATA_STRUCT;
} F_DATA2D;
#define F_HDATA2D F_DATA2D
#define HMESH2D_FDATA_STRUCT MESH2D_FDATA_STRUCT
#define GENMESH2D_STRUCT \
  GENMESH_STRUCT; \
  int        dimension_of_world; \
  ELEMENT2D  *(*first_macro)(struct genmesh2d *, MESH_ELEMENT_FLAGS); \
  ELEMENT2D  *(*next_macro)(ELEMENT2D *, MESH_ELEMENT_FLAGS); \
  ELEMENT2D  *(*first_child)(ELEMENT2D *, MESH_ELEMENT_FLAGS); \
  ELEMENT2D  *(*next_child)(ELEMENT2D *, MESH_ELEMENT_FLAGS); \
  ELEMENT2D  *(*copy_element)(ELEMENT2D *, MESH_ELEMENT_FLAGS); \
  void       (*free_element)(ELEMENT2D *); \
  ELEMENT2D  *(*complete_element)(ELEMENT2D *, MESH_ELEMENT_FLAGS); \
  ELEMENT2D  *(*select_child)(ELEMENT2D *,double *, double *, \
				 MESH_ELEMENT_FLAGS); \
  int        (*set_time)(struct genmesh2d *, double); \
  int        (*get_time)(struct genmesh2d *, double *, double *, double *); \
  void       (*get_geometry_vertex_estimate)(ELEMENT2D *,double *); \
  double     (*get_geometry_element_estimate)(ELEMENT2D *); \
  double     (*get_lens_element_estimate)(ELEMENT2D *,double *); \
  double     threshold
typedef struct genmesh2d {
  GENMESH2D_STRUCT;
} GENMESH2D;
#define MESH2D_STRUCT \
  GENMESH2D_STRUCT; \
  USERMESH usermesh; \
  ELEMENT2D *(*first_element)(struct mesh2d *, MESH_ELEMENT_FLAGS); \
  ELEMENT2D *(*next_element)(ELEMENT2D *, MESH_ELEMENT_FLAGS)
typedef struct mesh2d {
  MESH2D_STRUCT;
} MESH2D;
#define HMESH2D_STRUCT \
  GENMESH2D_STRUCT; \
  USERMESH usermesh
typedef struct hmesh2d {
  HMESH2D_STRUCT;
} HMESH2D;
#define G_HM_SEARCH_MAX_CHILDREN 10
#define G_HM_SEARCH_TOTAL_CHILD_COORD 100
typedef struct {
  int pc_blocks[G_HM_SEARCH_MAX_CHILDREN],number_of_children,
    pc_offsets[G_HM_SEARCH_MAX_CHILDREN], ref_rule, number_of_pc_rows,
    number_of_cp_rows, number_of_pc_columns[G_HM_SEARCH_TOTAL_CHILD_COORD],
    number_of_cp_columns[G_HM_SEARCH_TOTAL_CHILD_COORD],
    pc_index[G_HM_SEARCH_TOTAL_CHILD_COORD][G_HM_SEARCH_MAX_CHILDREN],
    cp_index[G_HM_SEARCH_TOTAL_CHILD_COORD][G_HM_SEARCH_MAX_CHILDREN],
    cp_offsets[G_HM_SEARCH_MAX_CHILDREN],
    pc_vector_indices[G_HM_SEARCH_TOTAL_CHILD_COORD],
    cp_vector_indices[G_HM_SEARCH_TOTAL_CHILD_COORD];
  double pc_val[G_HM_SEARCH_TOTAL_CHILD_COORD][G_HM_SEARCH_MAX_CHILDREN],
    cp_val[G_HM_SEARCH_TOTAL_CHILD_COORD][G_HM_SEARCH_MAX_CHILDREN];
} HMESH_SEARCH_MATRIX;
#define G_HM_SEARCH_CHILD_AND_PARENT_COORD 110
typedef struct {
  int calculated[G_HM_SEARCH_CHILD_AND_PARENT_COORD];
  double coord[G_HM_SEARCH_CHILD_AND_PARENT_COORD];
}G_HM_SEARCH_COORD_VECT;
ELEMENT2D *g_genmesh2d_def_select_child (ELEMENT2D *,
                                         double *parent_coord,
                                         double *child_coord,
                                         MESH_ELEMENT_FLAGS);
void g_genmesh2d_def_coord_of_parent(ELEMENT2D *, double *child_coord,
                                     double *parent_coord);
void g_search_calculate_coord(int ,HMESH_SEARCH_MATRIX *);
void g_search_filter_zeros(HMESH_SEARCH_MATRIX *);
int g_search_fill_pc_blocks(HMESH_SEARCH_MATRIX *,int );
void g_search_sort_rows(HMESH_SEARCH_MATRIX *);
void g_search_find_dependencies(HMESH_SEARCH_MATRIX *,int);
void g_search_order_mat(HMESH_SEARCH_MATRIX *);
int g_hm2_search_get_selected_child(ELEMENT2D *,HMESH_SEARCH_MATRIX *,
                            double *parent_coord, double *child_coord);
void g_hm2_search_get_coord_of_parent(ELEMENT2D *,
HMESH_SEARCH_MATRIX *,int,double *child_coord,double *parent_coord);
#define INSIDE -1
#define EXACT_NEIGHBOUR -1
#define FIRST_NEIGHBOUR 0
#define NEXT_NEIGHBOUR  1
#define G_LEAVES  1
#define G_PREFIX  2
#define G_POSTFIX 3
#define G_INFIX   4
#define G_HM_ABORT    (-1)
#define G_HM_NOACTION 0
#define G_HM_ACTION   1
#define G_HM_PROCEED  2
typedef struct {
  struct graphicdevice *dev;
  struct colorbar*colorbar;
  struct mesh2d_lens*lens;
  F_DATA2D *f_data2d;
  F_DATA2D G_CONST*dat_set;
} M2_GENERAL;
#define HM2_GENERAL M2_GENERAL
int g_traverse_mesh2d(
 GENMESH2D* mesh,
 M2_GENERAL* general,
 int traverse_mode,
 int level_of_interest,
 int (*projection)       (ELEMENT2D*,M2_GENERAL*,
                          void*,void*),
 int (*test_if_proceed)  (ELEMENT2D*,M2_GENERAL*,
                          void*),
 int (*action_on_element)(ELEMENT2D*,M2_GENERAL*,
                          void*,void*),
 void**   element_data,
 void*    action_arg,
 MESH_ELEMENT_FLAGS mesh_element_flag);
#define g_traverse_hmesh2d g_traverse_mesh2d
#define HT_GENERAL(dim) HM##dim##_GENERAL
#define HT_ELEMENT(dim) ELEMENT##dim##D
#define CHMESH_TRAV_CALL(fun) do{fun;}while(0)
#define HMESH_TRAV_NEW_ELEMENT(el) \
do { \
  ht_cur_info->ht_element = (el); \
  ht_cur_info->ht_first_visit = TRUE; \
} while (0)
#define HMESH_TRAV_END_ELEMENT(mode, ht_action_on_element) \
do { \
  if (mode == G_PREFIX && ht_cur_info->ht_proceed != G_HM_NOACTION) \
    CHMESH_TRAV_CALL(ht_action_on_element \
		     (ht_cur_info->ht_element, ht_general, \
		      ht_cur_info->ht_element_data, \
		      ht_action_arg)); \
} while (0)
#define HMESH_RECURSIVE_TRAVERSE(dim, el, mode, \
				 ht_projection, ht_test_if_proceed, \
				 ht_action_on_element) \
do { \
  HMESH_TRAV_NEW_ELEMENT (el); \
  do { \
    if (ht_cur_info->ht_first_visit) { \
      HT_ELEMENT(dim) *const ht_element = ht_cur_info->ht_element; \
      void *const ht_element_data = ht_cur_info->ht_element_data; \
      HT_ELEMENT(dim) *ht_child; \
      \
      ht_projection (ht_element, ht_general, ht_element_data, \
		     ht_cur_info->ht_parent_data); \
      \
      ht_test_if_proceed (ht_cur_info->ht_proceed, ht_element, \
                          ht_general, ht_element_data); \
      \
      if (ht_cur_info->ht_proceed != G_HM_ABORT) { \
	if (mode == G_POSTFIX && \
            ht_cur_info->ht_proceed != G_HM_NOACTION) \
	  ht_action_on_element (ht_element, ht_general, \
                                ht_element_data, \
				ht_action_arg); \
	 \
	if ( ht_cur_level < ht_level_of_interest && \
	    ht_cur_info->ht_proceed == G_HM_PROCEED && \
	    (ht_child = ht_first_child(ht_element, ht_required))) { \
	  ht_cur_info->ht_first_visit = FALSE; \
	  ht_cur_info++, ht_cur_level++; \
	  HMESH_TRAV_NEW_ELEMENT (ht_child); \
	} else { \
	  if (mode == G_LEAVES && \
              ht_cur_info->ht_proceed != G_HM_NOACTION) \
	    ht_action_on_element (ht_element, ht_general, \
                                  ht_element_data, \
				  ht_action_arg); \
	  HMESH_TRAV_END_ELEMENT (mode, ht_action_on_element); \
	  ht_cur_info--, ht_cur_level--; \
	} \
      } else { \
	do { \
	  ht_free_element((HT_ELEMENT(dim)*)ht_cur_info->ht_element); \
	  ht_cur_info--, ht_cur_level--; \
	} while (ht_cur_level >= 0); \
	ht_macro = NULL; \
      } \
    } else { \
      HT_ELEMENT(dim) *ht_child; \
      if ((ht_child = ht_next_child(ht_cur_info[1].ht_element, \
				    ht_required))) { \
	ht_cur_info++, ht_cur_level++; \
	HMESH_TRAV_NEW_ELEMENT (ht_child); \
      } else { \
	HMESH_TRAV_END_ELEMENT (mode, ht_action_on_element); \
	ht_cur_info--, ht_cur_level--; \
      } \
    } \
  } while (ht_cur_level >= 0); \
} while (0)
#define G_TRAVERSE_MESH(dim, hmesh, \
			general, traverse_mode, level_of_interest, \
			ht_projection, ht_test_if_proceed, \
			ht_action_on_element, element_data, \
			action_arg, aborted, mesh_element_flag) \
do { \
  const int ht_level_of_interest = level_of_interest; \
  const int ht_max_level = level_of_interest; \
  HT_ELEMENT(dim) *(*const ht_next_macro) \
			    (HT_ELEMENT(dim) *, MESH_ELEMENT_FLAGS) \
    = (hmesh)->next_macro; \
  HT_ELEMENT(dim) *(*const ht_first_child) \
			    (HT_ELEMENT(dim) *, MESH_ELEMENT_FLAGS) \
    = (hmesh)->first_child; \
  HT_ELEMENT(dim) *(*const ht_next_child) \
			    (HT_ELEMENT(dim) *, MESH_ELEMENT_FLAGS) \
    = (hmesh)->next_child; \
  void (*const ht_free_element)(HT_ELEMENT(dim) *) \
    = (hmesh)->free_element; \
  const HT_GENERAL(dim) *ht_general \
    = (const HT_GENERAL(dim) *)general; \
  const void *const ht_action_arg = (const void *)action_arg; \
  const MESH_ELEMENT_FLAGS ht_required = mesh_element_flag; \
  \
  struct { \
    int ht_first_visit, ht_proceed; \
    HT_ELEMENT(dim) *ht_element; \
    void *ht_parent_data, *ht_element_data; \
  } *ht_level_info, *ht_cur_info; \
  int ht_cur_level = 0; \
  \
  HT_ELEMENT(dim) *ht_macro; \
  \
  G_MEM_ALLOC (ht_level_info, ht_max_level+1); \
  \
  { \
    int ht_i; \
    for (ht_i = 0; ht_i <= ht_max_level; ht_i++) { \
      ht_level_info[ht_i].ht_element_data = element_data [ht_i]; \
      ht_level_info[ht_i].ht_parent_data = \
                            ht_i ? element_data [ht_i-1] : NULL; \
    } \
  } \
  \
  (aborted) = FALSE; \
  \
  for (ht_macro = (hmesh)->first_macro((hmesh), ht_required); \
       ht_macro; \
       ht_macro = ht_next_macro (ht_macro, ht_required)) { \
    \
    ht_cur_info = ht_level_info; \
    ht_cur_level = 0; \
    \
    switch (traverse_mode){ \
    case G_LEAVES: \
      HMESH_RECURSIVE_TRAVERSE (dim, ht_macro, G_LEAVES, \
				ht_projection, ht_test_if_proceed, \
				ht_action_on_element); \
      break; \
    case G_POSTFIX: \
      HMESH_RECURSIVE_TRAVERSE (dim, ht_macro, G_POSTFIX, \
				ht_projection, ht_test_if_proceed, \
				ht_action_on_element); \
      break; \
    case G_PREFIX: \
      HMESH_RECURSIVE_TRAVERSE (dim, ht_macro, G_PREFIX, \
				ht_projection, ht_test_if_proceed, \
				ht_action_on_element); \
      break; \
    } \
    if (!ht_macro) { \
       (aborted) = TRUE; \
       break; \
    } \
  } \
  \
  G_MEM_FREE (ht_level_info, ht_max_level+1); \
} while (0)
#define G_TRAVERSE_HMESH G_TRAVERSE_MESH
#ifdef G_TRAVERSE_FUNCTION
#define HMESH_TRAV_DEF_TIP(a,b,c,d) (a) = ht_test_if_proceed_fun(b,c,d)
#define g_traverse_mesh(dim, hmesh, \
			general, traverse_mode, level_of_interest, \
			ht_projection, ht_test_if_proceed, aborted, \
			ht_action_on_element, \
			element_data, action_arg, mesh_element_flag) \
do { \
  int (*ht_test_if_proceed_fun)(HT_ELEMENT(dim)*, \
				HT_GENERAL(dim)*,void*) = \
    ht_test_if_proceed; \
  G_TRAVERSE_MESH(dim, hmesh, \
		  general, traverse_mode, level_of_interest, \
		  ht_projection, HMESH_TRAV_DEF_TIP, aborted, \
		  ht_action_on_element, \
		  element_data, action_arg, mesh_element_flag)
} while (0)
#else
#define g_traverse_mesh(dim, hmesh, \
			general, traverse_mode, level_of_interest, \
			ht_projection, ht_test_if_proceed, aborted, \
			ht_action_on_element, \
			element_data, action_arg, mesh_element_flag) \
  (aborted) = !g_traverse_mesh ## dim ## d \
    (hmesh, general, traverse_mode, \
     level_of_interest, ht_projection, ht_test_if_proceed, \
     ht_action_on_element, \
     element_data, action_arg, mesh_element_flag)
#endif
typedef struct hm2_coord_data {
  VEC3 vertex_coord[MESH2D_MAX_VERTEX];
  int  in_lens_area;
} HM2_COORD_DATA;
typedef struct hm2_scalar_fct_data {
  double vertex_value[MESH2D_MAX_VERTEX];
  int    in_lens_area;
} HM2_SCALAR_FCT_DATA;
typedef struct hm2_vec_fct_data {
  VEC3 vertex_coord[MESH2D_MAX_VERTEX];
  VEC3 vertex_value[MESH2D_MAX_VERTEX];
  int    in_lens_area;
} HM2_VEC_FCT_DATA;
typedef struct hm2_coord_color_data {
  VEC3 vertex_coord[MESH2D_MAX_VERTEX];
  VEC3 vertex_color[MESH2D_MAX_VERTEX];
  int  in_lens_area;
} HM2_COORD_COLOR_DATA;
typedef struct hm2_coord_color_fct_data {
  VEC3   vertex_coord[MESH2D_MAX_VERTEX];
  VEC3   vertex_color[MESH2D_MAX_VERTEX];
  double vertex_value[MESH2D_MAX_VERTEX];
  int    in_lens_area;
} HM2_COORD_COLOR_FCT_DATA;
int hm2_geom_simpl_test_if_proceed(ELEMENT2D*,HM2_GENERAL*,void*);
int hm2_geom_lens_test_if_proceed(ELEMENT2D*,HM2_GENERAL*,void*);
int hm2_fct_simpl_test_if_proceed(ELEMENT2D*,HM2_GENERAL*,void*);
int hm2_fct_lens_test_if_proceed (ELEMENT2D*,HM2_GENERAL*,void*);
int hm2_geom_fct_simpl_test_if_proceed(ELEMENT2D*,HM2_GENERAL*,void*);
int hm2_test_if_proceed(ELEMENT2D*,HM2_GENERAL*,void*);
int hm2_coord_simpl_projection(ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_coord_lens_projection (ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_coord_color_simpl_projection(ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_coord_color_lens_projection (ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_scalar_fct_simpl_projection
        (ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_scalar_fct_lens_projection
 	(ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_vec2scal_fct_simpl_projection
        (ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_vec2scal_fct_lens_projection
 	(ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_vec_fct_simpl_projection
        (ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_vec_fct_lens_projection
 	(ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_coord_color_fct_simpl_projection
        (ELEMENT2D*,HM2_GENERAL*,void*,void*);
int hm2_coord_color_fct_lens_projection
        (ELEMENT2D*,HM2_GENERAL*,void*,void*);
#define HTP_HMESH(dim) GENMESH##dim##D
#define HTP_ELEMENT(dim) ELEMENT##dim##D
#define HTP_ELEMENT_DESCRIPTION(dim) ELEMENT##dim##D_DESCRIPTION
#define HTP_MESH_MAX_VERTEX(dim) MESH##dim##D_MAX_VERTEX
#define HTP_LOCAL_NODE_LOOP \
int local_node_number; \
for (local_node_number=0; local_node_number<max_local_node_number; \
local_node_number++)
#define HTP_LENS_TYPE(dim) MESH##dim##D_LENS
#define HTP_FHDATA_TYPE(dim) F_DATA##dim##D
#define HTP_FHDATA_VAR(dim) f_data##dim##d
#define HTP_F_EL_INFO(dim) F_EL_INFO##dim##D
#define HTP_MAKE_ALL_PROJECT(dim, fhdata, element, parent_data, \
			     get_data, interpol_data, \
			     get_interpol_vertex, interpol_vertex, \
			     interpol_without_vertex, \
			     inherit_data, do_inherit_data, \
			     lens, geo_adaptive, erraction) \
do { \
  HTP_ELEMENT(dim) *const htp_element = (element); \
  HTP_HMESH(dim)*const htp_hmesh = \
    (HTP_HMESH(dim)*)htp_element->mesh; \
  HTP_ELEMENT_DESCRIPTION(dim)const* const htp_descr = \
    (HTP_ELEMENT_DESCRIPTION(dim)const*)htp_element->descr; \
  const int max_local_node_number = htp_descr->number_of_vertices; \
  if (!(parent_data) || !(do_inherit_data) || !htp_element->vinh) { \
    HTP_LOCAL_NODE_LOOP { \
      get_data; \
    } \
  } else { \
    HTP_LENS_TYPE(dim) *const htp_lens = (lens); \
    HTP_FHDATA_TYPE(dim) G_CONST*const htp_fhdata = (fhdata); \
    double vertex_geo_estimates [HTP_MESH_MAX_VERTEX(dim)]; \
    double vertex_fct_estimates [HTP_MESH_MAX_VERTEX(dim)]; \
    double lens_estimates [HTP_MESH_MAX_VERTEX(dim)]; \
    double geo_threshold, fct_threshold; \
    if (geo_adaptive) { \
      if (htp_hmesh->get_geometry_vertex_estimate) { \
        htp_hmesh->get_geometry_vertex_estimate \
          (htp_element, vertex_geo_estimates); \
        geo_threshold = htp_hmesh->threshold; \
      } else { \
        HTP_LOCAL_NODE_LOOP \
	  vertex_geo_estimates[local_node_number] = 0; \
        geo_threshold = 1; \
      } \
    } \
    if (htp_lens) \
      ((HTP_LENS_TYPE(dim)*)(lens))->get_lens_vertex_estimates \
        (htp_element, lens_estimates, \
	 ((HTP_LENS_TYPE(dim)*)(lens))->lens_data); \
    if (htp_fhdata) { \
      if (htp_fhdata->get_vertex_estimate) { \
	htp_fhdata->get_vertex_estimate(htp_element, \
					vertex_fct_estimates, \
				        htp_fhdata->function_data); \
	fct_threshold = htp_fhdata->threshold; \
      } else { \
	HTP_LOCAL_NODE_LOOP \
	  vertex_fct_estimates[local_node_number] = 1; \
	fct_threshold = 0; \
      } \
    } \
    { \
      HTP_LOCAL_NODE_LOOP { \
	if (htp_element->vinh[local_node_number].np == 1) { \
	  inherit_data; \
	} else if (((geo_adaptive) && \
                    (vertex_geo_estimates[local_node_number] >= \
		     geo_threshold)) || \
		   (htp_fhdata && \
		    (vertex_fct_estimates[local_node_number] >= \
		     fct_threshold))) { \
	  get_data; \
	} else if (htp_lens) { \
	  get_interpol_vertex; \
	  if (lens_estimates[local_node_number] >= \
	      ((HTP_LENS_TYPE(dim)*)(lens))-> \
                get_lens_vertex_threshold(interpol_vertex, \
						  htp_lens)) { \
	    get_data; \
	  } else { \
	    interpol_without_vertex; \
	  } \
	} else { \
	  interpol_data; \
	} \
      } \
    } \
  } \
} while (0)
#define MAKE_PROJECT(dim, element, parent_data, get_data, \
		     interpol_data, get_interpol_vertex, \
		     interpol_vertex, interpol_without_vertex, \
		     inherit_data, do_inherit_data, lens, erraction) \
HTP_MAKE_ALL_PROJECT(dim, NULL, element, \
		     parent_data, get_data, interpol_data, \
		     get_interpol_vertex, interpol_vertex, \
		     interpol_without_vertex, \
		     inherit_data, do_inherit_data, lens, FALSE, \
                     erraction)
#define MAKE_SIMPL_PROJECT(dim, element, parent_data, get_data, \
			   interpol_data, inherit_data, \
			   do_inherit_data, erraction) \
MAKE_PROJECT(dim, element, parent_data, get_data, interpol_data, \
	     ;, NULL, ;, inherit_data, do_inherit_data, \
	     NULL, erraction)
#define MAKE_FCT_PROJECT(dim, fhdata, element, parent_data, \
			 get_data, interpol_data, \
			 get_interpol_vertex, interpol_vertex, \
			 interpol_without_vertex, inherit_data, \
			 do_inherit_data, lens, erraction) \
HTP_MAKE_ALL_PROJECT(dim, fhdata, element, parent_data, get_data, \
		     interpol_data, get_interpol_vertex, \
		     interpol_vertex, interpol_without_vertex, \
		     inherit_data, do_inherit_data, lens, FALSE, \
                     errraction)
#define MAKE_SIMPL_FCT_PROJECT(dim, fhdata, element, parent_data, \
			       get_data, interpol_data, inherit_data, \
			       do_inherit_data, erraction) \
MAKE_FCT_PROJECT(dim, fhdata, element, parent_data, get_data, \
		 interpol_data, ;, NULL, ;, inherit_data, \
		 do_inherit_data, NULL, erraction)
#define HM_ALL_TEST_IF_PROCEED(dim, result, element, geo_adaptive, \
			       fdata, lens, dat_set, dat_test, grdev) \
do { \
  GRAPHICDEVICE G_CONST*const tip_grdev = (grdev); \
  if ((tip_grdev) && G_USER_BREAK(tip_grdev)) \
    (result) = G_HM_ABORT; \
  else { \
    HTP_ELEMENT(dim) *const tip_element = (element); \
    HTP_HMESH(dim) G_CONST*const tip_hmesh = \
      (HTP_HMESH(dim) *)tip_element->mesh;  \
    HTP_FHDATA_TYPE(dim) G_CONST*const tip_fdata = (fdata); \
    HTP_LENS_TYPE(dim) *const tip_lens = (lens); \
     \
    if ((!((geo_adaptive) &&  \
	   tip_hmesh->get_geometry_element_estimate) || \
	 (tip_hmesh->get_geometry_element_estimate(tip_element) < \
	  tip_hmesh->threshold)) && \
	((tip_fdata && ((HTP_FHDATA_TYPE(dim)*)(fdata))->get_element_estimate) && \
	 (((HTP_FHDATA_TYPE(dim)*)(fdata))->get_element_estimate(tip_element, \
					  ((HTP_FHDATA_TYPE(dim)*)(fdata))->function_data) < \
	  ((HTP_FHDATA_TYPE(dim)*)(fdata))->threshold)) && \
	((tip_lens && tip_hmesh->get_lens_element_estimate) && \
	 (tip_hmesh->get_lens_element_estimate(tip_element, \
					       tip_lens->lens_data) < \
	  tip_lens->get_lens_element_threshold(tip_element, tip_lens))) \
	) \
      (result) = G_HM_ACTION; \
    else if (tip_element->level >= tip_hmesh->level_of_interest || \
	     !tip_element->has_children) \
      (result) = G_HM_ACTION; \
    else \
      (result) = G_HM_PROCEED; \
          \
    if ((dat_set)) { \
      HTP_FHDATA_TYPE(dim) G_CONST*const tip_dat_set = (dat_set); \
      if ((result) == G_HM_PROCEED) { \
	double dat_min, dat_max; \
	tip_dat_set->get_bounds (tip_element, &dat_min, &dat_max, \
				 tip_dat_set->function_data); \
	if (dat_max < 0.0) \
	  (result) = G_HM_NOACTION; \
      } else if (dat_test) {  \
	double arg; \
	tip_dat_set->f ((HTP_ELEMENT(dim)*)tip_element, 0, NULL, \
			&arg, tip_dat_set->function_data); \
	if (arg < 0.0) \
	  (result) = G_HM_NOACTION; \
      } \
    } \
  } \
} while (0)
#define M_TEST_IF_PROCEED_DAT(dim, result, element, general, \
			      dat_test) \
  HM_ALL_TEST_IF_PROCEED(dim, result, element, TRUE, \
  (general)->HTP_FHDATA_VAR(dim), (general)->lens, \
  (general)->dat_set, dat_test, (general)->dev)
#define M_TEST_IF_PROCEED(dim, result, element, general) \
  HM_TEST_IF_PROCEED_DAT(dim, result, element, general, TRUE)
#define HM_TEST_IF_PROCEED M_TEST_IF_PROCEED
#define HM_TEST_IF_PROCEED_DAT M_TEST_IF_PROCEED_DAT
#define HPMESH2D_FDATA_STRUCT \
 HMESH2D_FDATA_STRUCT; \
 int (*get_element_p_estimates)(ELEMENT2D *el, double *est, \
                                 void *function_data); \
 int (*get_edge_p_estimates)(ELEMENT2D *el, int ed, \
                  double *edge_est,void *function_data)
typedef struct {
  HPMESH2D_FDATA_STRUCT;
} F_HPDATA2D;
#define HPMESH2D_STRUCT \
  HMESH2D_STRUCT
typedef struct hpmesh2d {
  HPMESH2D_STRUCT;
} HPMESH2D;
#define MESH2D_LENS_STRUCT \
  LENS_STRUCT; \
  void   (*get_lens_vertex_estimates)(ELEMENT2D*,double*,double*); \
  double (*get_lens_vertex_threshold)(CONST_ARG_VEC3,struct mesh2d_lens*); \
  double (*get_lens_element_threshold)(ELEMENT2D*,struct mesh2d_lens*)
typedef struct mesh2d_lens {
  MESH2D_LENS_STRUCT;
} MESH2D_LENS;
#define HMESH2D_LENS MESH2D_LENS
#define HMesh2d_Lens Mesh2d_Lens
struct functinfo {
	char	*name;
	int	dimension_of_value;
	int	is_continuous_data;
	int	polynomial_order;
	void 	*funct;
};
int g_dbl_normal_to_plane(VEC3 , FVEC3 , FVEC3 , FVEC3 );
#define g_fvec3_to_vec3(f, d) \
  (d)[0]=(double)(f)[0]; (d)[1]=(double)(f)[1]; (d)[2]=(double)(f)[2];
#define MESH3D_MAX_VERTEX 20
#define MESH3D_MAX_EDGE 20
#define MESH3D_MAX_EDGE_PER_VERTEX 20
#define MESH3D_MAX_FACE 20
#define MESH3D_MAX_DIMENSION_OF_VALUE 10
#define MESH3D_MAX_LEVEL 100
#define HMESH3D_MAX_LEVEL MESH3D_MAX_LEVEL
#define MESH3D_MAX_LOCAL_COORD 12
#define MESH3D_ELEMENT3D_STRUCT \
  struct genmesh3d      *mesh;    \
  double                G_CONST*G_CONST*vertex; \
                                  \
  int                   G_CONST*vindex;  \
  int                   eindex;   \
  struct element3d_description G_CONST*descr;   \
  MESH_ELEMENT_FLAGS    present; \
                                 \
                                 \
                                  \
  void      *user_data;           \
                                  \
  struct element3d     *parent;   \
  VINHERIT     G_CONST*vinh;     \
  int          	      ref_rule;  \
  int		      level;   \
  int                 has_children
typedef struct element3d {
MESH3D_ELEMENT3D_STRUCT;
} ELEMENT3D;
#define HELEMENT3D ELEMENT3D
#define HMESH3D_HELEMENT3D_STRUCT MESH3D_ELEMENT3D_STRUCT
typedef struct element3d_description
{
  int       dindex;
  int       number_of_vertices;
  int       number_of_polygons;
  int       G_CONST*polygon_length;
  int       G_CONST*G_CONST*polygon_vertex;
  int       G_CONST*G_CONST*polygon_neighbour;
  int       dimension_of_coord;
  double    G_CONST*G_CONST*coord;
  int       parametric_degree;
  int       (*world_to_coord)(ELEMENT3D *,double G_CONST*, double *);
  void      (*coord_to_world)(ELEMENT3D *,double G_CONST*, double *);
  int       (*check_inside)(ELEMENT3D *,double *);
  ELEMENT3D *(*neighbour)(ELEMENT3D *, int, int, double *, double *,
			  MESH_ELEMENT_FLAGS);
  int       (*boundary)(ELEMENT3D *,  int);
  void      (*get_boundary_vertex_estimate)(ELEMENT3D *, double *, int );
  double    (*get_boundary_face_estimate)(ELEMENT3D *, int );
  void	    (*coord_of_parent)(ELEMENT3D *,double *, double *);
} ELEMENT3D_DESCRIPTION;
#define HELEMENT3D_DESCRIPTION ELEMENT3D_DESCRIPTION
typedef struct {
  int           polynomial_degree;
} F_EL_INFO3D;
#define F_HEL_INFO3D F_EL_INFO3D
#define MESH3D_FDATA_STRUCT \
  GENMESH_FDATA_STRUCT; \
  void (*f)(ELEMENT3D *, int,  \
	    double G_CONST *, double[], void *);  \
  void (*f_el_info)(ELEMENT3D *, F_EL_INFO3D *, \
		    void *);  \
                         \
 void (*get_bounds)(ELEMENT3D *, \
		    double* ,double*, void *function_data); \
 void (*get_vertex_estimate)(ELEMENT3D *, double *, \
			     void *function_data); \
                              \
 double (*get_element_estimate)(ELEMENT3D *, \
 		                void *function_data); \
 double threshold;  \
 double geometry_threshold; \
 double hp_threshold;  \
 int hp_maxlevel
typedef struct f_data3d {
  MESH3D_FDATA_STRUCT;
} F_DATA3D;
#define F_HDATA3D F_DATA3D
#define HMESH3D_FDATA_STRUCT MESH3D_FDATA_STRUCT
#define GENMESH3D_STRUCT \
  GENMESH_STRUCT; \
  ELEMENT3D *(*first_macro)(struct genmesh3d *, MESH_ELEMENT_FLAGS); \
  ELEMENT3D *(*next_macro)(ELEMENT3D *, MESH_ELEMENT_FLAGS); \
  ELEMENT3D *(*first_child)(ELEMENT3D *, MESH_ELEMENT_FLAGS); \
  ELEMENT3D *(*next_child)(ELEMENT3D *, MESH_ELEMENT_FLAGS); \
  ELEMENT3D *(*select_child)(ELEMENT3D *,double *, double *, \
	MESH_ELEMENT_FLAGS); \
  void       (*get_geometry_vertex_estimate)(ELEMENT3D *,double *); \
  double     (*get_geometry_element_estimate)(ELEMENT3D *); \
  double (*get_lens_element_estimate)(ELEMENT3D *,double *); \
  double threshold; \
  ELEMENT3D     *(*copy_element)(ELEMENT3D *, MESH_ELEMENT_FLAGS); \
  void          (*free_element)(ELEMENT3D *); \
  ELEMENT3D     *(*complete_element)(ELEMENT3D *, MESH_ELEMENT_FLAGS); \
  int           (*set_time)(struct genmesh3d *, double t); \
  int           (*get_time)(struct genmesh3d *, double *t, \
			    double *tminus, double *tplus)
typedef struct genmesh3d {
  GENMESH3D_STRUCT;
} GENMESH3D;
#define MESH3D_STRUCT \
  GENMESH3D_STRUCT; \
  USERMESH usermesh; \
  ELEMENT3D     *(*first_element)(struct mesh3d *, MESH_ELEMENT_FLAGS); \
  ELEMENT3D     *(*next_element)(ELEMENT3D *, MESH_ELEMENT_FLAGS)
typedef struct mesh3d {
  MESH3D_STRUCT;
} MESH3D;
#define HMESH3D_STRUCT \
  GENMESH3D_STRUCT; \
  USERMESH usermesh
typedef struct hmesh3d {
  HMESH3D_STRUCT;
} HMESH3D;
extern void g_remove_tree(GENMESH3D *,ELEMENT3D *);
ELEMENT3D *g_hmesh3d_def_select_child (ELEMENT3D *,
				       double *parent_coord,
				       double *child_coord,
				       MESH_ELEMENT_FLAGS);
void g_genmesh3d_def_coord_of_parent(ELEMENT3D *, double *child_coord,
				     double *parent_coord);
int g_hm3_search_get_selected_child(ELEMENT3D *,
        HMESH_SEARCH_MATRIX *search_matrix, double *parent_coord,
	double *child_coord);
void g_hm3_search_get_coord_of_parent(ELEMENT3D *,
	HMESH_SEARCH_MATRIX *search_matrix,int ,
      	double *child_coord, double *parent_coord);
typedef struct m3_general{
  struct graphicdevice *dev;
  struct colorbar*colorbar;
  struct mesh3d_lens *lens;
  F_DATA3D *f_data3d;
  F_DATA3D G_CONST*dat_set;
} M3_GENERAL;
#define HM3_GENERAL M3_GENERAL
void g_traverse_mesh3d(
 GENMESH3D* hmesh,
 M3_GENERAL* general,
 int traverse_mode,
 int level_of_interest,
 int (*projection)       (ELEMENT3D*,M3_GENERAL*,
                          void*,void*),
 int (*test_if_proceed)  (ELEMENT3D*,M3_GENERAL*,
                          void*),
 int (*action_on_element)(ELEMENT3D*,M3_GENERAL*,
                          void*,void*),
 void**   element_data,
 void*    action_arg,
 MESH_ELEMENT_FLAGS mesh_element_flag);
typedef struct hm3_coord_data {
  VEC3 vertex_coord[MESH3D_MAX_VERTEX];
  int  in_lens_area;
} HM3_COORD_DATA;
typedef struct hm3_scalar_fct_data {
  double vertex_value[MESH3D_MAX_VERTEX];
  int    in_lens_area;
} HM3_SCALAR_FCT_DATA;
typedef struct hm3_vec_fct_data {
  VEC3 vertex_coord[MESH3D_MAX_VERTEX];
  VEC3 vertex_value[MESH3D_MAX_VERTEX];
  int    in_lens_area;
} HM3_VEC_FCT_DATA;
typedef struct hm3_coord_color_data {
  VEC3 vertex_coord[MESH3D_MAX_VERTEX];
  VEC3 vertex_color[MESH3D_MAX_VERTEX];
  int  in_lens_area;
} HM3_COORD_COLOR_DATA;
typedef struct hm3_coord_color_fct_data {
  VEC3   vertex_coord[MESH3D_MAX_VERTEX];
  VEC3   vertex_color[MESH3D_MAX_VERTEX];
  double vertex_value[MESH3D_MAX_VERTEX];
  int    in_lens_area;
} HM3_COORD_COLOR_FCT_DATA;
int hm3_coord_simpl_projection(ELEMENT3D*,HM3_GENERAL*,void*,void*);
int hm3_coord_color_fct_lens_projection
        (ELEMENT3D*,HM3_GENERAL*,void*,void*);
int hm3_coord_lens_projection(ELEMENT3D*,HM3_GENERAL*,void*,void*);
#define MESH3D_LENS_STRUCT \
  LENS_STRUCT; \
  void   (*get_lens_vertex_estimates)(ELEMENT3D*,double*,double*); \
  double (*get_lens_vertex_threshold)(CONST_ARG_VEC3,struct mesh3d_lens*); \
  double (*get_lens_element_threshold)(ELEMENT3D*,struct mesh3d_lens*)
typedef struct mesh3d_lens {
  MESH3D_LENS_STRUCT;
} MESH3D_LENS;
#define HMesh3d_Lens Mesh3d_Lens
#define HMESH3D_LENS MESH3D_LENS
#define BNDMESH2D_STRUCT \
  GENMESH2D_STRUCT; \
  GENMESH3D *client
typedef struct bndmesh2d {
  BNDMESH2D_STRUCT;
} BNDMESH2D;
#define CLIPM3D_PAR_STRUCT					\
ELEMENT3D *e;         				\
 int n;                	\
 VEC3 *v;              /* vektor mit den punkten des Schnitts [1..n]\
                        * punkt [0] ist ein sichtbarer Punkt	\
                        */					\
 double *coord;        	\
 double *fval;         /* die lokalen Werte der FEM Funktion in [1..n]\
                        */					\
 double (*f)(CONST_ARG_VEC3, char *); /* die clip funktion f(x,var) \
                              * > 0 sichtbar ; < 0 unsichtbar	\
                              */				\
 char *var;            	\
 char *scal;           /* parameter zur skalierung in der jeweiligen\
                          draw_clip funktion        */		\
 int flag ;            \
 int dimension_of_value  	
#define HM3_CLIP_PAR_STRUCT \
CLIPM3D_PAR_STRUCT;	    \
VEC3* f_interpol_color
typedef struct clipm3d_par {
CLIPM3D_PAR_STRUCT;
} CLIPM3D_PAR;
typedef struct hm3_clip_par{
HM3_CLIP_PAR_STRUCT;
} HM3_CLIP_PAR;
#define CLIPMESH2D_STRUCT \
  GENMESH2D_STRUCT; \
  PLANE_EDITOR* pled; \
  GENMESH3D*    client; \
  VEC3          normal; \
  double        dist
typedef struct clipmesh2d {
  CLIPMESH2D_STRUCT;
} CLIPMESH2D;
typedef struct surfmeshpatch SURFMESHPATCH;
typedef struct surfmeshcorner SURFMESHCORNER;
typedef struct surfmeshmemblock SURFMESHMEMBLOCK;
typedef struct surfmeshvertex SURFMESHVERTEX;
typedef struct surfmeshpostprocess SURFMESHPOSTPROCESS;
struct surfmeshpatch {
  SURFMESHPATCH *next;
  SURFMESHCORNER *corner;
};
struct surfmeshvertex {
  SURFMESHVERTEX *next,*hnext;
  SURFMESHCORNER *corner;
  VEC3 x,n;
};
struct surfmeshcorner {
  SURFMESHVERTEX *vertex;
  SURFMESHCORNER *pred,*succ,*next;
};
struct surfmeshmemblock {
  SURFMESHMEMBLOCK *next;
  int size;
  char *data;
};
struct surfmeshpostprocess {
  char *name;
  SURFMESHPATCH *(*operation)(SURFMESHPATCH *,void **,void *);
  void *par;
  SURFMESHPOSTPROCESS *next;
};
#define SURFMESH_STRUCT \
  TREEOBJECT_STRUCT; \
  SURFMESHVERTEX *VertexList; \
  SURFMESHPATCH *PatchList; \
  SURFMESHMEMBLOCK *MemBlock; \
  SURFMESHPOSTPROCESS *PostProcess
typedef struct surfmesh {
  SURFMESH_STRUCT;
} SURFMESH;
#define DAT_COMM_MAX_ARGS 8
#define DAT_COMM_ARB_ARGS -101
#define DAT_EL_COMM_MAX_STRLEN 12
#define DAT_ARB_DIM -201
#define DAT_ARB_EQ_DIM -202
#define DAT_SUM_DIM -203
#define DAT_COMP_EQ_DIM -1000
#define DAT_BOUNDS_MIN -1.0e37
#define DAT_BOUNDS_MAX  1.0e37
typedef enum {
C_UNKNOWN =   0,
              FUNCTION  = 101,
              SET       = 102,
              FUNCSET   = 103
} DAT_COMM_TYPE;
typedef enum {
A_UNKNOWN =   0,
              CONSTANT  = 201,
              DATAFUNC  = 202,
              COMMAND   = 203
} DAT_ARG_TYPE;
typedef enum {
O_UNKNOWN =   0,
              O_MESH2D  = 322,
              O_MESH3D  = 332
} DAT_OBJ_TYPE;
typedef enum {
DRAW      = 401,
              DRAW_NOT  = 402,
              DRAW_PART = 403
} DAT_DRAW_TYPE;
typedef struct dat_comm_str_tree {
  char command_string[MAX_STRLEN];
  char command[DAT_EL_COMM_MAX_STRLEN + 1];
  int number_of_arguments;
  char arg[DAT_COMM_MAX_ARGS][MAX_STRLEN];
  struct dat_comm_str_tree *arg_cst[DAT_COMM_MAX_ARGS];
} DAT_COMM_STR_TREE;
typedef struct dat_comm_fct_tree {
  char command_string[MAX_STRLEN];
  void (*command)(double *const[DAT_COMM_MAX_ARGS],
                  int const[DAT_COMM_MAX_ARGS],
                  int const,int *,double *);
  void (*calc_bounds)(VEC2 [DAT_COMM_MAX_ARGS],int const,double *,double *);
  void (*calc_error)(double [DAT_COMM_MAX_ARGS],double [DAT_COMM_MAX_ARGS],
                     int const,double *,double *);
  int dimension_of_value,number_of_arguments;
  int dimension_of_arguments[DAT_COMM_MAX_ARGS];
  DAT_ARG_TYPE arg_type[DAT_COMM_MAX_ARGS];
  double constant[DAT_COMM_MAX_ARGS];
  void *data_func[DAT_COMM_MAX_ARGS];
  struct dat_comm_fct_tree *arg_cft[DAT_COMM_MAX_ARGS];
} DAT_COMM_FCT_TREE;
typedef struct dat_el_comm {
  char name[DAT_EL_COMM_MAX_STRLEN + 1];
  void (*command)(double *const[DAT_COMM_MAX_ARGS],
                  int const[DAT_COMM_MAX_ARGS],
                  int const,int *,double *);
  int number_of_arguments;
  int dim_args[DAT_COMM_MAX_ARGS];
  int dim_value;
  void (*calc_bounds)(VEC2 [DAT_COMM_MAX_ARGS],int const,double *,double *);
  void (*calc_error)(double [DAT_COMM_MAX_ARGS],double [DAT_COMM_MAX_ARGS],
                     int const,double *,double *);
  DAT_COMM_TYPE type;
  char info[MAX_STRLEN];
} DAT_EL_COMM;
typedef struct dat_usr_func {
  char *name;
  char *command_string;
} DAT_USR_FUNC;
#define DAT_STRUCT \
  TREEOBJECT_STRUCT; \
  TREEOBJECT *object,*basis_object; \
  DAT_OBJ_TYPE object_type,basis_object_type; \
  char function_str[MAX_STRLEN],set_str[MAX_STRLEN]; \
  char basis_function_str[MAX_STRLEN]; \
  void *function,*set; \
  DAT_COMM_FCT_TREE *function_cft,*set_cft; \
  DAT_EL_COMM *elementary_comm; \
  G_LIST *data_func; \
  DAT_USR_FUNC *usr_func; \
  int use_calc_bounds,use_calc_error; \
  LAYER *layer,*help_layer,*usr_func_layer,*switches_layer; \
  COMBOBUTTON *el_comm_button,*func_button,*usr_func_button; \
  int el_comm_index,func_index,usr_func_index
typedef struct dat {
  DAT_STRUCT;
} DAT;
DAT_DRAW_TYPE g_dat_check_draw_element2d(F_DATA2D *, ELEMENT2D *);
#define G_TIME_ADAPTIVE   1
#define G_FIRST_ORDER     2
#define G_SECOND_ORDER    4
typedef struct trace_info{
struct trace *tr;
double dt,T,TOL,end_t,start_t,mesh_time,ref_eps;
CHECKFIELD_VAR flag;
int number_of_steps,nb;
VEC3 x;
}TRACE_INFO;
#define TRIANG0D_STRUCT \
  TREEOBJECT_STRUCT; \
  double x,y,z
typedef struct triang0d {
  TRIANG0D_STRUCT;
} TRIANG0D;
#define TRACE_STRUCT \
  TRIANG1D_STRUCT; \
  double *t
typedef struct trace {
  TRACE_STRUCT;
} TRACE;
#define STREAKLINE_STRUCT \
  TRACE_STRUCT; \
  int number_of_steps; \
  int max_number_of_steps
typedef struct streakline {
  STREAKLINE_STRUCT;
} STREAKLINE;
#define CLOUD_STRUCT \
  TREEOBJECT_STRUCT; \
  int number_of_points; \
  VEC3 *x
typedef struct cloud {
  CLOUD_STRUCT;
} CLOUD;
#define PARCLOUD_STRUCT \
  CLOUD_STRUCT; \
  double par
typedef struct parcloud {
  PARCLOUD_STRUCT;
} PARCLOUD;
typedef struct mpoint{
  double *x,*y,*z;
  int it,old_it;
  double bary[4];
} MPOINT;
typedef struct moving_info{
  int maxn,n,i;
  INSTANCE **pre,**post;
  int *new_discr;
  double *time;
  int dim,space;
  int nsteps;
  double rulstime,ruletime;
  double runge_delta;
  double rulstreaktime;
  double stime,etime;
  double ctime,ntime;
  double step_delta;
  int maxnop,nop;
  MPOINT *p;
  int (*global_search)(),(*local_search)();
  double smu,cmu;
  void (*f)();
  double ref_eps ;
  double vertical_texture ;
  double horizontal_texture ;
} MOVING_INFO;
extern int   g_probe_fineness;
extern char* g_curve_tab_name;
#define PTS_STRUCT \
  TREEOBJECT_STRUCT; \
  int dim; \
  int nop; \
  FVEC3 *pos
typedef struct pts {
  PTS_STRUCT;
} PTS;
#define PTSC_STRUCT \
  PTS_STRUCT; \
  int *data
typedef struct ptsc {
  PTSC_STRUCT;
} PTSC;
typedef enum {
  gfActive   =  1,
  gfDisplay  =  2,
  gfUserNorm =  4,
  gfDispBnd  =  8,
  gfDispHor  = 16,
  gfDispVer  = 32
} GEOM2D_FLAG;
#define GEOM2D_STRUCT \
  ADAPT2D_STRUCT; \
  GEOM2D_FLAG flag; \
  VEC3 *normal; \
  VEC3 *color_vertex; \
  VEC3 *color_patch; \
  LIST_OF_INST *bnd_curve; \
  CHAIN *hor, *ver
typedef struct geom2d {
  GEOM2D_STRUCT;
} GEOM2D;
typedef struct {
  int bndindex1;
  int bndindex2;
  double period;
} G2PERIOD;
#define G2PERIODS_STRUCT \
  INSTANCE_STRUCT; \
  GEOM2D *geom2d; \
  int numperiods; \
  G2PERIOD *periods
typedef struct g2periods {
  G2PERIODS_STRUCT;
} G2PERIODS;
#define CONS_STRUCT \
  TREEOBJECT_STRUCT; \
    TRIANG2D *geom; \
    int number_of_points; \
    int max_number_of_points; \
    int *vertex; \
    int flag
typedef struct cons {
  CONS_STRUCT;
} CONS;
typedef enum {
  brtCurve = -1,
  brtCircle,
  brtPlane,
  brtS3Plane,
  brtStraight,
  brtS3Line,
  brtHelix = 1000,
  brtSpline
} BND_RTYPE;
#define BND_CURVE_STRUCT \
  TRIANG1D_STRUCT; \
    int flag; \
    TRIANG2D *geom; \
    int *vertex; \
    int *neighbour; \
    struct { \
	BND_RTYPE type; \
	int size; \
	double *data; \
    } restrict
typedef struct bnd_curve {
  BND_CURVE_STRUCT;
} BND_CURVE;
#define TIME_PARM_STRUCT \
  INSTANCE_STRUCT; \
    RULER **int_rul; \
    FUNCTION_RULER **dbl_rul; \
    int num_int_parm; \
    int num_double_parm; \
    int *int_parm; \
    double *double_parm
typedef struct time_parm {
  TIME_PARM_STRUCT;
} TIME_PARM;
int g_time_parm_get_var_list(TIME_PARM *, char *);
void g_time_parm_get_var_values(TIME_PARM *, double, double *);
typedef enum {
  tskGeometry  = 0x00000001,
  tskGauss     = 0x00000002,
  tskConjugate = 0x00000004,
  tskDomain    = 0x00000008,
  tskNewton    = 0x00000010,
  tskExplicit  = 0x00000020,
  tskAny       = 0x000000ff
} TASK_TYPE;
#define TIME_OBJECT_STRUCT \
  TREEOBJECT_STRUCT; \
  TASK_TYPE task, task_mask; \
  int frame, num_of_frames; \
  double *time; \
  TIME_PARM *time_parm; \
  CHAIN *geometry, *inter; \
  SCENE *tree
typedef struct time_object {
  TIME_OBJECT_STRUCT;
} TIME_OBJECT;
TASK_TYPE g_read_task(FILE *, int);
char *g_task_name(TASK_TYPE);
T_FUN *get_t_fun(char *, FILE *);
#define REFLECTION_CONTROL_STRUCT \
  INSTANCE_STRUCT; \
    int type; \
    int obj; \
    int last_obj_index; \
    int object_index, bdy_index, bdy2_index
typedef struct reflection_control {
  REFLECTION_CONTROL_STRUCT;
} REFLECTION_CONTROL;
#define SURFACE_STRUCT \
  TIME_OBJECT_STRUCT; \
  CHAIN *model, *domain, *gauss, *conjugate, *conj_inter; \
  double *asso; \
  REFLECTION_CONTROL *reflect
typedef struct surface {
  SURFACE_STRUCT;
} SURFACE;
typedef struct domain_parm_rul {
    FUNCTION_RULER **u_min;
    FUNCTION_RULER **v_min;
    FUNCTION_RULER **u_max;
    FUNCTION_RULER **v_max;
    FUNCTION_RULER **u_dstrbn;
    FUNCTION_RULER **v_dstrbn;
} DOMAIN_PARM_RUL;
#define DOMAIN_PARM_STRUCT \
  INSTANCE_STRUCT; \
    DOMAIN_PARM_RUL rul; \
    int num_parts; \
    int max_parts; \
    int *flag; \
    int *num_u_lines; \
    int *num_v_lines; \
    int *num_u_sub; \
    int *num_v_sub; \
    SPLINE1D **u_dstrbn; \
    SPLINE1D **v_dstrbn; \
    T_FUN **u_min; \
    T_FUN **v_min; \
    T_FUN **u_max; \
    T_FUN **v_max; \
    double **u_min_d; \
    double **v_min_d; \
    double **u_max_d; \
    double **v_max_d
typedef struct domain_parm {
  DOMAIN_PARM_STRUCT;
} DOMAIN_PARM;
#define EXPLICIT_STRUCT \
  SURFACE_STRUCT; \
  DOMAIN_PARM *domain_parm; \
  COMPLEX (*compute_arg)(); \
  struct { \
    T_FUN *x, *y, *z; \
  } coord_f
typedef struct explicit {
  EXPLICIT_STRUCT;
} EXPLICIT;
typedef struct cnode {
    VEC3 xyz;
    VEC3 normal;
    COMPLEX z, w, gauss;
    CVEC3 cinti, cintj;
    int np;
    int i, j;
    int ipoints;
} CNODE;
#define AMANDUS_STRUCT \
  EXPLICIT_STRUCT; \
    CHAIN *newton; \
    struct { \
        int type; \
	COMPLEX (*x)(COMPLEX), (*y)(COMPLEX), (*z)(COMPLEX); \
	COMPLEX (*g)(), (*dh)(), (*dg)(); \
	COMPLEX (*poly) (COMPLEX, COMPLEX); \
	COMPLEX (*dwpoly) (COMPLEX, COMPLEX); \
	COMPLEX (*dzpoly) (COMPLEX, COMPLEX); \
	COMPLEX (*newton_init) (COMPLEX); \
	void (*correct)(); \
    } weier_f; \
    CNODE *cnode, *icnode
typedef struct amandus {
  AMANDUS_STRUCT;
} AMANDUS;
#define	KARL		37
#define	HERMANN		38
#define ORBIT_STRUCT \
  TRIANG1D_STRUCT; \
  double time; \
  double length; \
  int ind; \
  double ind_pos
typedef struct orbit {
  ORBIT_STRUCT;
} ORBIT;
#define UFO_STRUCT \
  TREEOBJECT_STRUCT; \
  VEC3 mid
typedef struct ufo {
  UFO_STRUCT;
} UFO;
#define DUAL_DEF
#define CONTROLPS_STRUCT \
  CONTROLDEVICE_STRUCT; \
  void (*write_header) (double, double, double, double, double)
typedef struct controlps {
  CONTROLPS_STRUCT;
} CONTROLPS;
#define G_DSO_HANDLER_INIT g_scan_libs ()
typedef void *LIB_HANDLE;
#define G_ASSURE_CLASS(class, class_struct) \
ASSURE (sizeof (class_struct) == (class)->isize,\
        "Class " #class " has changed! Can't install DSO.",\
        return 0);
void *g_dlsym(LIB_HANDLE, char *);
#define G_GET_VALUE(x, old) \
{\
   void *oldpos = g_dlsym ((old), (#x)); \
     if (oldpos && &(x)) memcpy (&(x), oldpos, sizeof (x)); \
}
#define G_GET_SYM(x, handle) g_dlsym ((handle), (#x))
#define G_GET_FP(x, handle) ((void *(*)()) G_GET_SYM (x, handle))
extern void *(*g_get_fp_safe (LIB_HANDLE, char *))();
#define G_GET_FP_SAFE(x, handle) g_get_fp_safe ((handle), (#x))
#define G_LIB_IS_VALID    extern const long g_DSO_version = 1; \
extern const char g_DSO_file[] = __FILE__; \
extern const char g_DSO_version_id[] = G_VERSION_ID; \
extern const long g_DSO_header_timestamp = G_HEADER_TIMESTAMP; \
extern const long g_DSO_header_code = G_HEADER_CODE; \
static LIB_HANDLE g_DSO_my_handle; \
int g_DSO_standard_checkings (LIB_HANDLE handle) \
{ \
  g_DSO_my_handle = handle; \
  if (&g_DSO_header_code != \
      (const long *)g_dlsym (handle,"g_DSO_header_code")) { \
    fprintf (stderr, \
             "g_DSO_standard_checkings: found %p, should be %p\n",\
             &g_DSO_header_code, g_dlsym(handle,"g_DSO_header_code"));\
    return 2;\
  }\
  G_ASSURE_CLASS (Root, INSTANCE); \
  G_ASSURE_CLASS (Project, PROJECT); \
  G_ASSURE_CLASS (Item, ITEM); \
  return 1; \
} \
char g_DSO
#define G_LIB_PROJECT          extern const char g_DSO_project = 0
#define G_LIB_PROJECT_HIDDEN\
	extern const char g_DSO_project_hidden = 0
#define G_LIB_PROJECT_NAME(x)\
	extern const char *g_DSO_projectname = (x)
#define G_LIB_PROJECT_DECL(x)\
	extern const PRTYPE *g_DSO_project_decl = (x)
#define G_LIB_AUTOLOAD         extern const char g_DSO_autoload = 0
#define G_LIB_AUTOINCLUDE      extern const char g_DSO_autoinclude = 0
#define G_LIB_AUTOADD          extern const char g_DSO_autoadd = 0
#define G_LIB_AUTOUSE          extern const char g_DSO_autouse = 0
#define G_LIB_CAN_EXIT         extern const char g_DSO_exit = 0
#define G_LIB_ACTION           extern const char g_DSO_action = 0
#define G_LIB_CAN_REPLACE      extern const char g_DSO_replace = 0
#define G_LIB_REPLACABLE       extern const char g_DSO_replacable = 0
#define G_LIB_REPLACE          G_LIB_CAN_REPLACE; G_LIB_REPLACABLE
#define G_LIB_AUTO_REPLACE_PROJECT\
	extern const char g_DSO_auto_replace_pj=0
#define G_LIB_SETUP_REPLACE_PROJECT\
	extern const char g_DSO_setup_replace_pj=0
#define G_LIB_RESETUP_PRESERVES_ITEMS\
	extern const char g_DSO_resetup_preserve_items=0
#define G_LIB_STATIC(x)\
	extern const struct {size_t size; void *data;}\
        g_DSO_struct_replace = {sizeof (x), &(x)}
#define G_LIB_ZSTATIC(x)\
	extern const struct {size_t size; void *data;}\
	g_DSO_0_struct_replace = {sizeof (x), &(x)}
#define G_LIB_IDENT(x)\
	extern const char *g_DSO_ident = (x)
#define G_LIB_DESCRIPTION(x)\
	extern const char *g_DSO_description = (x)
#define G_LIB_VERSION(x,y)\
	extern const struct{unsigned short major,minor;}\
	g_DSO_user_version = {(x), (y)}
#define G_LIB_DEPENDS_ON(x)\
	extern const char *g_DSO_depends_on[] = {x}; \
size_t g_DSO_dependency_count=(sizeof(g_DSO_depends_on)/sizeof(char*))
#define G_LIB_NEXTDEP(x,y)   x,y
#define G_MY(x)              g_dlsym (g_DSO_my_handle, #x)
#define G_GZIP
extern int g_gzip;
void g_launch_pipe_server (void);
void g_kill_pipe_server (void);
FILE *g_fopen (const char *, const char *);
int g_fclose (FILE *);
int g_open (const char *, int, ...);
int g_close (int);
void g_set_filter_commands (char *, char *, char *, char *, int);
void g_query_pack_filter (char *, size_t);
void g_select_pack_filter (char *);
void g_delete_pack_filter (char *);
#define G_GZIP_HANDLER_INIT g_launch_pipe_server()
extern char *g_output_envar;
void g_default_graphicdevice( CLASS **, char **);
#define GRAPHICX11_STRUCT \
  GRAPHICDEVICE_STRUCT
typedef struct graphicx11 {
  GRAPHICX11_STRUCT;
} GRAPHICX11;
void g_default_controldevice( CLASS **, char ** );
#define CONTROLX11_STRUCT \
  CONTROLDEVICE_STRUCT
typedef struct controlx11 {
  CONTROLX11_STRUCT;
} CONTROLX11;
#define GRAPHICOGL_STRUCT \
  GRAPHICDEVICE_STRUCT
typedef struct graphicogl {
  GRAPHICOGL_STRUCT;
} GRAPHICOGL;
#define G_IMAGES_TYPE_RGBA8 1
#define G_IMAGES_TYPE_RGBA16 2
struct g_images_rgba8 {
  unsigned char r, g, b, a;
};
struct g_images_rgba16 {
  unsigned short r, g, b, a;
};
#ifndef G_IMAGES_PIXELS_TYPE
#define G_IMAGES_PIXELS_TYPE
typedef struct g_images_rgba8 G_IMAGES_RGBA8;
typedef struct g_images_rgba16 G_IMAGES_RGBA16;
union g_images_pixels {
  unsigned char *bytes;
  G_IMAGES_RGBA8 *rgba8;
  G_IMAGES_RGBA16 *rgba16;
};
typedef union g_images_pixels G_IMAGES_PIXELS;
#endif
typedef enum {
  imgDirLeftToRight = 0,
  imgDirRightToLeft = 1,
  imgDirBottomToTop = 0,
  imgDirTopToBottom = 2
} G_IMG_DIRECTION;
#define IMGFILE_STRUCT \
  INSTANCE_STRUCT; \
  char  *filename, *extension; \
  int   single_picture_files; \
  int   filenumber; \
  FILE  *current_file; \
  char  *current_filename; \
  int   sizex, sizey; \
  int   pixeltype, pixelsize, compsize
typedef struct imgfile {
  IMGFILE_STRUCT;
} IMGFILE;
#define G_READDISPLAY_MAGIC 98476132
#define G_READDISPLAY_CMD_INIT 4357
#define G_READDISPLAY_CMD_DONE 4654
#define G_READDISPLAY_CMD_QUERY 4568
#define G_READDISPLAY_CMD_QUERY_FOR_PREVIEW 4569
#ifndef G_IMAGES_PIXELS_TYPE
#define G_IMAGES_PIXELS_TYPE
typedef struct g_images_rgba8 G_IMAGES_RGBA8;
typedef struct g_images_rgba16 G_IMAGES_RGBA16;
union g_images_pixels {
  unsigned char *bytes;
  G_IMAGES_RGBA8 *rgba8;
  G_IMAGES_RGBA16 *rgba16;
};
typedef union g_images_pixels G_IMAGES_PIXELS;
#endif
typedef struct g_read_info {
  long magic;
  int cmd;
  int pixeltype, pixelsize;
  int border_width;
  int disable_blanking;
  INT2 image_size;
  INT2 rect_size;
  INT2 max_rect_size;
  INT2 wnd_org, wnd_size, old_org, old_size;
  unsigned long flags;
  int old_timeout;
  GRAPHICDEVICE *grdev;
  size_t (*readdisplay) (int, int, int, int, G_IMAGES_PIXELS,
			 struct g_read_info *);
} G_READ_INFO;
#define ZERO_MACHINE 1.e-10
#define g_sqrt(x)	sqrt(x)
#define g_fabs(x)	fabs(x)
#define g_pow(x,y)	pow(x,y)
#define g_cos(x)	cos(x)
#define g_sin(x)	sin(x)
#define g_tan(x)	tan(x)
#define g_acos(x)	acos(x)
#define g_asin(x)	asin(x)
#define g_atan(x)	atan(x)
#define g_atan2(y,x)	atan2(y,x)
#define g_floor(x)	floor(x)
#define g_fmod(x,y)	fmod(x,y)
#define g_ceil(x)	ceil(x)
#define g_exp(x)	exp(x)
#define g_log(x)	log(x)
#define g_log10(x)	log10(x)
#define g_sqrtf(x)	(float)sqrt((double)x)
#define g_fabsf(x)	(float)fabs((double)x)
#define g_powf(x,y)	(float)pow((double)x,(double)y)
#define g_cosf(x)	(float)cos((double)x)
#define g_sinf(x)	(float)sin((double)x)
#define g_tanf(x)	(float)tan((double)x)
#define g_acosf(x)	(float)acos((double)x)
#define g_asinf(x)	(float)asin((double)x)
#define g_atanf(x)	(float)atan((double)x)
#define g_atan2f(y,x)	(float)atan2((double)y,(double)x)
#define g_floorf(x)	(float)floor((double)x)
#define g_fmodf(x,y)	(float)fmod((double)x,(double)y)
#define g_ceilf(x)	(float)ceil((double)x)
#define g_expf(x)	(float)exp((double)x)
#define g_logf(x)	(float)log((double)x)
#define g_log10f(x)	(float)log10((double)x)
unsigned long g_time_usec (void);
unsigned long g_usertime_usec (void);
#define g_sleep_usec usleep
#define G_INIT_MACHINE g_init_machine()
extern volatile unsigned long g_time;
#define G_TIME g_time
#define G_SIGALRM 0
#define G_SIGINT 1
#define G_SIGHUP 2
#define G_SIGPIPE 3
#define G_SIGQUIT 4
#define G_SIGFLAG_NONE 0
#define G_SIGFLAG_RESTART 1
void (*g_signal (int, void(*)(int), int))(int);
int g_raise (int);
extern CLASS *Adapt2d;
extern CLASS *Adapt3d;
extern CLASS *Addon;
extern CLASS *Amandus;
extern CLASS *Array;
extern CLASS *Bar1d;
extern CLASS *Bigbutton;
extern CLASS *BndMesh2d;
extern CLASS *Bnd_Curve;
extern CLASS *Bounded_Ruler;
extern CLASS *Button;
extern CLASS *Camera;
extern CLASS *Cbm1c;
extern CLASS *Cbm2ci;
extern CLASS *CbmHsv;
extern CLASS *CbmHsvOld;
extern CLASS *CbmIbi;
extern CLASS *CbmMipol;
extern CLASS *CbmMipolN;
extern CLASS *CbmPart;
extern CLASS *CbmPartn;
extern CLASS *CbmSI;
extern CLASS *CbmSINO;
extern CLASS *CbmUni;
extern CLASS *CbmXci;
extern CLASS *CbmXcin;
extern CLASS *Chain;
extern CLASS *CharData;
extern CLASS *CheckField;
extern CLASS *Checkbox;
extern CLASS *ClipMesh2d;
extern CLASS *ClipOgl;
extern CLASS *Clock;
extern CLASS *Cloud;
extern CLASS *ColorAlpha_Sel;
extern CLASS *Color_Sel;
extern CLASS *Colorbar;
extern CLASS *ColorbarModule;
extern CLASS *ComboButton;
extern CLASS *ComboList;
extern CLASS *Cons;
extern CLASS *ControlDevice;
extern CLASS *ControlPS;
extern CLASS *ControlX11;
extern CLASS *CoordSys;
extern CLASS *Cycle_Button;
extern CLASS *Dat;
extern CLASS *Device;
extern CLASS *Domain_Parm;
extern CLASS *Explicit;
extern CLASS *Fe2d;
extern CLASS *Fe3d;
extern CLASS *Fieldline;
extern CLASS *FileList;
extern CLASS *FloatData;
extern CLASS *Foreground_Layer;
extern CLASS *Function_Bar1d;
extern CLASS *Function_Ruler;
extern CLASS *Function_Slider;
extern CLASS *G2Periods;
extern CLASS *G_Double;
extern CLASS *G_Float;
extern CLASS *G_Int;
extern CLASS *G_List;
extern CLASS *G_Long;
extern CLASS *G_MethodString;
extern CLASS *G_Number;
extern CLASS *G_Scalar;
extern CLASS *G_String;
extern CLASS *G_UInt;
extern CLASS *G_ULong;
extern CLASS *G_Vec3;
extern CLASS *Gd_Sphere;
extern CLASS *GenData;
extern CLASS *GenMesh;
extern CLASS *GenMesh2d;
extern CLASS *GenMesh3d;
extern CLASS *Geom2d;
extern CLASS *GraphicDevice;
extern CLASS *GraphicOgl;
extern CLASS *GraphicPs;
extern CLASS *GraphicRay;
extern CLASS *GraphicX11;
extern CLASS *Group;
extern CLASS *HMesh2d;
extern CLASS *HMesh3d;
extern CLASS *HPMesh2d;
extern CLASS *IconButton;
extern ADDON *IconDescr;
extern CLASS *Iconize_Button;
extern CLASS *Imgfile;
extern CLASS *Import_Export;
extern CLASS *InOutFile;
extern CLASS *InodeEditor;
extern CLASS *Input;
extern CLASS *InputFile;
extern CLASS *InstanceFinder;
extern CLASS *Interactive;
extern CLASS *Item;
extern CLASS *Layer;
extern CLASS *Layer_Finder;
extern CLASS *Layer_Head;
extern CLASS *Lens;
extern CLASS *Line;
extern CLASS *List_Of_Inst;
extern CLASS *List_Of_Int;
extern CLASS *List_Of_Vec3;
extern CLASS *List_Of_Vec4;
extern CLASS *Manager;
extern CLASS *Matrix_Edit;
extern CLASS *Mesh2d;
extern CLASS *Mesh2d_Lens;
extern CLASS *Mesh3d;
extern CLASS *Mesh3d_Lens;
extern CLASS *MethLayer;
extern CLASS *MethList;
extern CLASS *MultiEditor;
extern CLASS *MultiRuler;
extern CLASS *Orbit;
extern CLASS *OutputFile;
extern CLASS *Parcloud;
extern CLASS *Plane;
extern CLASS *Plane_Editor;
extern CLASS *Plane_Object;
extern CLASS *Project;
extern CLASS *Prompt;
extern CLASS *Pts;
extern CLASS *Ptsc;
extern CLASS *PureList;
extern CLASS *PureMultiRuler;
extern CLASS *PureRuler;
extern CLASS *PureScrollbar;
extern CLASS *PureSlider;
extern CLASS *PureSplineEditor;
extern CLASS *Radio;
extern CLASS *Rectangle;
extern CLASS *Reflection_Control;
extern CLASS *ResourceDev;
extern CLASS *Root;
extern CLASS *Ruler;
extern CLASS *Scene;
extern CLASS *Scrollbar;
extern CLASS *Selector;
extern CLASS *SimplexGrid;
extern CLASS *Slider;
extern CLASS *Sphere;
extern CLASS *Spline1d;
extern CLASS *Spline_Editor;
extern CLASS *StaticText;
extern CLASS *Step_Button;
extern CLASS *StreakLine;
extern CLASS *Suprop;
extern CLASS *SurfMesh;
extern CLASS *Surface;
extern CLASS *T_Fun;
extern CLASS *TextDevice;
extern CLASS *Textmessage;
extern CLASS *Texture_Editor;
extern CLASS *TimeScene;
extern CLASS *TimeStep;
extern CLASS *Time_Object;
extern CLASS *Time_Parm;
extern CLASS *Trace;
extern CLASS *TreeObject;
extern CLASS *Triang0d;
extern CLASS *Triang1d;
extern CLASS *Triang2d;
extern CLASS *Triang3d;
extern CLASS *TuneOgl;
extern CLASS *Ufo;
extern ADDON *UserMesh;
extern CLASS *XList;
extern CLASS *XList_Button;
