/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
#include "feins_macros.h"
#include "datastruc.h"
#include "mesh.h"
#include "assembly.h"
#include "sparse.h"
#include "lin_solver.h"
#include "gen_aux.h"


int main()
{
  char solver[50]="no_solver_set";
  struct sparse *Ks;
  struct vector rhs, x;
  struct mesh msh1, msh2;
  struct projector1 P;

  struct multilvl ml;
  struct mgdata mg;

  int  err, iter, lmax;
  FIDX i, level;

  double resi, nodeerrors, pointerror;
  
  lmax=6;

  /* allocate memory for the sparse matrices */
  TRY_MALLOC( Ks,  lmax+1, struct sparse, main);


  err=mesh_read_file_t1( &msh1, "Ldomain.f1m" ); /* */
  FUNCTION_FAILURE_HANDLE( err, mesh_read_file_t1, main);

  for (level=0; level<=lmax; level ++)
    { 
      
      
      if (level != 0)
	{
	  err=mesh_refine_uniform_t1( &msh1 );
	  FUNCTION_FAILURE_HANDLE( err, mesh_refine_uniform_t1, main);
	}

      sparse_alloc( &Ks[level], msh1.vx_nr, 9);
      vector_alloc( &rhs, msh1.vx_nr );
      vector_alloc( &x, msh1.vx_nr );
      projector1_alloc( &P, msh1.vx_nr );

      err=assem_poison_t1( &Ks[level], &rhs, &x, &P, &msh1 );
      FUNCTION_FAILURE_HANDLE( err, assem_poison_t1, main);


      /* define the multigrid data */
      err=multilvl_init_tx( &msh1, 1, &ml, 1);
      FUNCTION_FAILURE_HANDLE( err, multilvl_init_tx, main);

      err=mg_init_tx( Ks, &msh1, &ml, &mg, &P);
      FUNCTION_FAILURE_HANDLE( err, mg_init_tx, main);

      /* define solver parameter for the V-cycle */
      mg.vcycles=1;
      mg.smooths=1;
      mg.CGC_scale=1.0;

      /* linear solver */
      /* strcpy(solver,"PCG_no");
         err=PCG( 10000, 2, 1e-14, 1, &x, &resi, &iter, sparse_mul_mat_vec, 
	 projector1_no_precon, &Ks[level], &rhs, &P );
	 FUNCTION_FAILURE_HANDLE( err, PCG, main); /* */

      strcpy(solver,"PCG_MG");
      err=PCG( 10000, 2, 1e-8, 1, &x, &resi, &iter, sparse_mul_mat_vec, 
	       gen_proj_MG_tx, &Ks[level], &rhs, &mg );
      FUNCTION_FAILURE_HANDLE( err, PCG, main); /* */
      
      /* strcpy(solver,"PCR_no");
	 err=PCR( 10000, 2, 1e-14, 1, &x, &resi, &iter, sparse_mul_mat_vec, 
	 projector1_no_precon, &Ks[level], &rhs, &P );
	 FUNCTION_FAILURE_HANDLE( err, PCR, main); /* */

      /*  nodeerrors=0.0;
	  for (i=0; i<x.len; i++)
	  {
	  double lx;
	  lx=msh1.vertex[i*msh1.vx_w+MCT1VXSTRT  ];
	  nodeerrors+=fabs(1.5*lx-0.5*lx*lx - x.V[i]);
	  }
	  nodeerrors*=1.0/x.len; /* */
       
      if (x.len>16)
	{
	  pointerror= x.V[16]; /* */
	  /*pointerror= fabs(x.V[16]-1.0); /* */
	}
      else
	{
	  pointerror=0.0;
	}

      printf("%s: %4d iterations, |res|=%8.2e, vx_nr= %9d,  u_16=%16.9e\n",
	     solver, iter, resi, (int) msh1.vx_nr, pointerror); /* */

      /* printf("solution:\n");
	 for (i=0; i<x.len; i++)
	 printf("%7f\n", x.V[i]); /* */
      
      /* err= mesh_write_solution_exp_t1(&msh1,&x,1,15,"visual/2d_mesh" );
      FUNCTION_FAILURE_HANDLE( err, mesh_write_solution_exp_t2, main);/* */

      err= mesh_write_solution_femplot_t1(&msh1,&x,1,15,"visual/poisson" );
      FUNCTION_FAILURE_HANDLE( err, mesh_write_solution_exp_t2, main);/* */

      
      mg_free(&mg);
      multilvl_free(&ml);


      vector_free(&rhs);
      vector_free(&x);
      projector1_free(&P);

    } /* */

  for (level=lmax; level>=0; level--)
    sparse_free(&Ks[level]);
  free(Ks);

  mesh_free(&msh1);

  return 1;
}
