/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
navsto_solver.h
*/
#ifndef __NAVSTO_SOLVER_H__
#define __NAVSTO_SOLVER_H__ 1


int navsto_solver(struct mesh *msh1, FIDX lvl_max,
		  struct vector *solref,
		  struct vector *pccrit,
		  struct vector *DIDF
/* the outer solver loop, controlls refinement, Reynolds number besed
   on the mesh Peclet number, mesh deformation, adjoint solve
   
   goal is to solve the discrete Navier-Stokes equations on uniformly
   refined, deformed T2 versions of the T1 mesh msh1, evaluate the
   performance criteria, solve the adjoint equations and evaluate the
   derivatives wrt to the shape parameters

   Input:  msh1    - the coarse mesh (T1),  hierarchy has to be reset,
                     i.e. msh1.edge[j*msh1.eg_w+MCT1EGLVL]=-1
		     for all j
           lvl_max - the desired refinement level
           
   In/Out: solref  - reference solution on the finest mesh, if
                     solref.len==0, this is initialised here,
                     otherwise it is used as initial solution for
                     Newtons method to solve the nonlinear flow
                     equations, or an error is returned if it is of
                     wrong size

   Output: pccrit  - vector of performance criteria, length
                     msh1.pc_nr, if pccrit==NULL it is not used
	   DIDF    - array of msh1.pc_nr vectors of length msh1.sp_nr,
	             containing the derivatives of the pccrit wrt the
	             shape paramters, not used if 
	             DIDF==NULL, the DIDF[i] are initialised here
	             otherwise

   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid */);
#endif
