/*
navsto_ad_derivs.h
*/
#ifndef __NAVSTO_AD_DERIVS_H__
#define __NAVSTO_AD_DERIVS_H__ 1



#include "datastruc.h"
#include "sparse_struct.h"
#include "stokes_struct.h"
#include "navsto_struct.h"


int navsto_ad_dRdF_t21(double *resnorm, double *dRdF, int nF, int nR, 
		       struct vector *sol, struct navsto_projector *P,
		       struct navsto_matrix *Mat, struct mesh *m
/* evaluates the derivative of the residual with respect to the
   position of the marked shape defining nodes using automatic
   differentiation from the adlo-c package, the residual is defined as
   the finite element discretisation (with P2-P1 triangles) of the
   Newton-method linearization of the Navier-Stokes equation 

         -nu Laplace(u) + u * grad u + grad p = f
                                        div u = 0

   with boundary conditions as given in P

   Input:  nF      - number of shape parameters, (= number of shape
                     defining points times spacial dimension)
	   nR      - number of residual lines, (= lenght of sol)
	   sol     - the solution vector of the NS-system (where the
                     system is to be linearized)
	   P       - the stokes projector struct, used for the
	             boundary conditions 
	   Mat     - the Navier-Stokes matrix struct, used to get the 
	             pressure dofs
	   m       - the mesh, the shape defining node positions are
	             marked in there as well

   Output: resnorm - (2-)norm of the residual vector for the given
                     solution vector 
           dRdF    - jacobian matrix of the residual with respect to
                     the shape defining node positions, such that
                     dRdF(i,j*d+k) is the derivative of the i-th
                     row of the residual with respect to the k-th
                     component of the j-th shape defining point, where
                     d is the spacial dimension, the array has to be
                     provided such that it can hold the nF*nR entries


   Return: SUCCESS - success
           FAIL    - failure, see error message, output will not be
                     valid
*/);

int navsto_ad_perfcrit_t21( struct mesh *m, struct stokes_matrix *K,
			    struct vector *sol,
			    int nF, int pc_nr, double *pcvec, double *dIdsol,
			    double *dIdF
/*for test only
*/);
#endif
