/* this file contains the definitions of the positions of data objects
   within the arrays of the mesh data structure */

/* don't do anything if allready included */
#ifndef MESHDETAILS_H
#define MESHDETAILS_H

/* Here we define an awful lot of text macros, which then define
   details of the mesh datastructure in a flexible way. To protect us
   from confusion we introduce the following NAMING CONVENTION:

   positions of mesh data:

   MCxxyyzzzz
   read:
    MC   - Mesh Constant (to constrain the name space)
    xx   - element type + subtype, i.e.
	   XX     - all meshses
	   2X     - all 2d meshes
	   3X     - all 3d meshes
           T*     - Triangles   (2d)
	   Q*     - Quadrangles (2d)
	   E*     - tEtrahedra  (3d)
	   H*     - Hexahedra   (3d)
	   P*     - Pyramids    (3d)

	   e.g. 
           T1, T2 - linea resp. quadratic triangles
	   Q1, Q2 - bilinear resp. biquadratic quadrangles
	   E1, E2 - linear resp. quadratic tetrahedra
	   H1, H2 - trilinear resp. triquadratic hexahedra
    yy   - concerned part of the mesh data, i.e.
           VX - concerning vertex
	   EL - concerning element
	   EG - concerning edge
	   FC - concerning face
	   VO - concerning volume
	   HI - concerning edgewise hierarchy
	   EH - concerning elementwise hierarchy
	   BD - concerning boundary
	   PS - concerning performance criteria surface markers
	   PV - concerning performance criteria volume markers
	   PC - concerning performance criteria descriptor
	   FU - concerning functions
	   PA - concerning parameters
	   SG - concerning shape segments
	   SP - concerning shape parameters
    zzzz - specifier of purpose (to your choice, up to 4 charakters),
           e.g. NOD1 for the position of the first node, LN for the
           overal length of an entry

    !all in CAPITAL letters! (to highlight as macro constants)

    example: MCT1EGNOD1 - position of the first node in the edge data
                          of linear triangles
*/

/********************************************************************/
/*                                                                  */
/*       Definitions for XX (valid, for all meshes)                 */
/*                                                                  */
/********************************************************************/

/*   pcsurf */
#define MCXXPSSURF 0              /* corresponding surface element,
				     edge in 2d, face in 3d */
#define MCXXPSVOLE (MCXXPSSURF+1) /* id of the volume elements (there
				     can be two if it is no boundary
				     surface), pointer into the
				     element part of the mesh,
				     if the second entry is ==-1 then
				     there is only one element
				     connected to this surface
				  */
#define MCXXPSCRIT (MCXXPSVOLE+2) /* id of the criterion, pointer into
				     the pccrit part of the mesh
				  */
#define MCXXPSORIE (MCXXPSCRIT+1) /* orinetation of the corresponding
				     surface element, scalar= 1 or -1
				     describing how to define the
				     normal vector of the surface
				     element, ==1 usual way, ==-1
				     negative of the usual normal
				     vector 
				  */
#define MCXXPSLN   (MCXXPSORIE+1) /* length of one pcsurf entry */


/*   pcvol */
#define MCXXPVVOLM 0              /* corresponding volume element */
#define MCXXPVCRIT (MCXXPVVOLM+1) /* id of the criterion, pointer into
				     the pccrit part of the mesh
				  */
#define MCXXPVLN   (MCXXPVCRIT+1) /* length of one pcvol entry */


/*   pccrit */
#define MCXXPCTYPE 0              /* type of the performance function
					  described,
				     if type
                                     ==   0.0, squared deviation from
                                               given function,
				       data= cmp_nr, func
				         cmp_nr - the component for
				                  which the square
				                  deviation is to be
				                  considered 
				         func   - the reference
        				          function, pointer
        				          into the function
        				          block of the mesh
				     ==   1.0, surface force
				        (combinations of drag and
				        lift),

				       data= w_0, ..., w_dim
				         w_i - weight for the i-th
				               component of the force
				               vector, e.g. if the
				               weight vector is
				               orthogonal to the
				               mainstream velocity
				               this is +-lift, if it
				               is parallel it is
				               +-drag 
				     ==   2.0, energy disipation,
				          no data
				     ==   3.0, mesh volume,
				          no data
                                     ==   4.0, mean value,
				        data= cmp_nr, coef
				         cmp_nr - the component for
				                  which the mean value
				                  is to be considered 
				         coef   - coefficient which
				                  by which the mean
				                  value is to be
				                  multiplied 
                                     ==   5.0, square deviation from
                                          mean value,
				        data= cmp_nr, coef
				         cmp_nr - the component for
				                  which the mean value
				                  and square deviation
				                  are to be considered 
				         coef   - coefficient which
				                  by which it is
				                  to be multiplied 
                                     ==   6.0, square deviation from
                                          mesh based reference
                                          solution, in this case no
                                          shape gradient can be computed 
				        data= cmp_nr1, cmp_nr2 
				         cmp_nr*- the square deviation
				                  is to be considered
				                  for the solution components
						  cmp_nr1 to cmp_nr2,
						  e.g. "0,1" for the
						  first two velocity components
				  */
#define MCXXPCDAT1 (MCXXPCTYPE+1) /* begin of data */
#define MCXXPCDATX 6              /* maximal length of a data block */
#define MCXXPCLN   (MCXXPCDAT1+MCXXPCDATX)
                                  /* length of one pccrit entry */


/********************************************************************/
/*                                                                  */
/*       Definitions for 2X (valid, for all 2d meshes)              */
/*                                                                  */
/********************************************************************/

/*   function */
#define MC2XFUTYPE 0              /* type of the function described,
				     <  100.0, for scalar valued,
				     >= 100.0, for vector valued, then
				               FUDAT2 is valid and
				               used just as FUDAT1
				     if type or (type-100)
				     ==   0.0, constant function,
           			          FUDAT1 holds the constant,
				     ==   1.0, linear function,
				          FUDAT1 is the begin of a
				          vector of coefficients c[i]
				          such that
				          f(x,y)=c[0]x+c[1]y+c[2]
				     ==   2.0, quadratic function,
				          FUDAT1 is the begin of a
				          vector of coefficients c[i]
				          such that
				          f(x,y)=c[0]x^2+c[1]y^2+c[2]xy
					         +c[3]x+c[4]y+c[5]
				     ==  10.0, compound function 1 /
 				         distinguished at a hyperplane
				         FUDAT1 ist the begin of a
				         vector parameters c[i]
				         such that
					 if (c[0]x+c[1]y+c[2])>=0
					   f(x,y)= the value the
					     function with id c[3] has,
					 if (c[0]x+c[1]y+c[2])<0
					   f(x,y)= the value the
					     function with id c[4] has,
					 note: the function pointed
  					       to has to be non
  					       vector type, since
  					       this is done for the
  					       components seperately
				  */
#define MC2XFUDAT1 (MC2XFUTYPE+1) /* begin of function data for first
				     or only component */
#define MC2XFUDATX 6              /* length of function parameter
				     (data) blocks, 1 such block for
				     each component of a vector valued
				     function */
#define MC2XFUDAT2 (MC2XFUDAT1+MC2XFUDATX) 
                                  /* begin of function data for second
				     component */
#define MC2XFULN   (MC2XFUDAT2+MC2XFUDATX)
                                  /* length of one function entry */


/*   parameter data */
#define MC2XPANUPO 0              /* position of the scaling parameter
				     for the flow within the para field
				  */
#define MC2XPALN   (MC2XPANUPO+1) /* length of the parameter field */


/*   shape segment data */
#define MC2XSGTYPE 0              /* position of the type */
#define MC2XSGNOD1 (MC2XSGTYPE+1) /* name of the first node of the
				     segment, required to order the
				     nodes of the segment to reproduce
				     the inherent paramter t=0..1 */
#define MC2XSGPAR1 (MC2XSGNOD1+1) /* position of the first parameter */
#define MC2XSGPMAX 8              /* maximum number of parameters for
				     the defined types */
#define MC2XSGLN   (MC2XSGPAR1+MC2XSGPMAX)
                                  /* length of the shape segment field */


/*   shape parameter data */
#define MC2XSPDATA 0              /* position of the data */
#define MC2XSPLN   (MC2XSPDATA+1) /* length of the shape paramter field */



/********************************************************************/
/*                                                                  */
/*       Definitions for T1 (linear triangles)                      */
/*                                                                  */
/********************************************************************/

/*   vertices */
#define MCT1VXSTRT 0              /* begin of component values, there
				     are 2 components */
#define MCT1VXLN   (MCT1VXSTRT+2) /* length of one vertex entry */

/*   elements */
#define MCT1ELNOD1 0              /* first node of the element   */
#define MCT1ELLN   (MCT1ELNOD1+4) /* length of one element entry */

/*   edges */
#define MCT1EGNOD1 0              /* first node of the edge, there are
				     2 nodes */
#define MCT1EGCHL1 (MCT1EGNOD1+2) /* child data, =-1 <=> no childs,
				     other <=> they are childs (there
				     are 2 childs) */
#define MCT1EGBND  (MCT1EGCHL1+2) /* is boundary? =-1 is not,
				     other is the boundary data number
				     for this edge */
#define MCT1EGLVL  (MCT1EGBND +1) /* refinement level this edge
				     belongs to */
#define MCT1EGPCSU (MCT1EGLVL +1) /* is performance criterion surface?
				     =-1 is not,
				     other is the pcsurf data number
				     for this edge */
#define MCT1EGLN   (MCT1EGPCSU+1) /* length of one edge entry */

/*   faces */
#define MCT1FCEDG1 0              /* first edge of the face, there are
				     3 edges */
#define MCT1FCRHSF (MCT1FCEDG1+3) /* righthand side function, 
				     if =-1 then rhs=0,
				     else index into function field */ 
#define MCT1FCPCVL (MCT1FCRHSF+1) /* corresponding performance
				     criterion volume entry, 
				     if =-1 then ther is no pcvol
				     associated, else index into pcvol
				     field */  
#define MCT1FCLN   (MCT1FCPCVL+1) /* length of one face entry */

/*   volumes */
#define MCT1VOLN   0              /* length of one volume entry,
				     no volume data in 2d */

/*   edge hierarchy */
#define MCT1HICHLD 0              /* child node in this hierarchy
				     entry */
#define MCT1HIFAT1 (MCT1HICHLD+1) /* first father node in this
				     hierarchy entry , there are 2
				     fathers for each child */
#define MCT1HILVL  (MCT1HIFAT1+2) /* refinement level this entry
				     belongs to */
#define MCT1HILN   (MCT1HILVL +1) /* length of one hierarchy entry */

/*   element oriented hierarchy */
#define MCT1EHLN   (0)            /* not used for linear elements, 
				     length of one hierarchy entry */


/*   boundary */
#define MCT1BDEDGE 0              /* corresponding edge */
#define MCT1BDTYPE (MCT1BDEDGE+1) /* type of the boundary condition,
				     -1= no BC (but shape segment),
				     1= Dirichlet (e.g. noslip),
				     2= Neumann,
				     3= no stress
				  */
#define MCT1BDFNCT (MCT1BDTYPE+1) /* function for boundary condition 
				     (if applicable), points into the
				     function field */
#define MCT1BDORIE (MCT1BDFNCT+1) /* orinetation of the corresponding
				     edge, scalar= 1 or -1 such that
				     ORIE*[0,-1;1,0]*(node2-node1)
				     is a OUTward vector */
#define MCT1BDSSEG (MCT1BDORIE+1) /* marks the shape segement entry
				     of this edge, 
				     ==-1 not variable segment,
				     >=0  defines a pointer into sseg */
#define MCT1BDLN   (MCT1BDSSEG+1) /* length of one boundary entry */




/********************************************************************/
/*                                                                  */
/*       Definitions for T2 (quadratic triangles)                   */
/*                                                                  */
/********************************************************************/

/*   vertices */
#define MCT2VXSTRT 0              /* begin of component values, there
				     are 2 components */
#define MCT2VXLN   (MCT2VXSTRT+2) /* length of one vertex entry */

/*   elements */
#define MCT2ELNOD1 0              /* first node of the element,
				     6 nodes per element, numbered as:

				     2
				     |\
				     5 4
				     |  \
				     0-3-1
				  */
#define MCT2ELLN   (MCT2ELNOD1+6) /* length of one element entry */

/*   edges */
#define MCT2EGNOD1 0              /* first node of the edge, there are
				     2 nodes + */
#define MCT2EGNODM (MCT2EGNOD1+2) /* the midnode of the edge, 1 entry */
#define MCT2EGCHL1 (MCT2EGNODM+1) /* child data, =-1 <=> no childs,
				     other <=> they are childs (there
				     are 2 childs) */
#define MCT2EGBND  (MCT2EGCHL1+2) /* is boundary? =-1 is not,
				     other is the boundary data number
				     for this edge */
#define MCT2EGLVL  (MCT2EGBND +1) /* refinement level this edge
				     belongs to */
#define MCT2EGPCSU (MCT2EGLVL +1) /* is performance criterion surface?
				     =-1 is not,
				     other is the pcsurf data number
				     for this edge */
#define MCT2EGLN   (MCT2EGPCSU+1) /* length of one edge entry */

/*   faces */
#define MCT2FCEDG1 0              /* first edge of the face, there are
				     3 edges */
#define MCT2FCRHSF (MCT2FCEDG1+3) /* righthand side function, 
				     if =-1 then rhs=0,
				     else index into function field */ 
#define MCT2FCPCVL (MCT2FCRHSF+1) /* corresponding performance
				     criterion volume entry, 
				     if =-1 then ther is no pcvol
				     associated, else index into pcvol
				     field */  
#define MCT2FCLN   (MCT2FCPCVL+1) /* length of one face entry */

/*   volumes */
#define MCT2VOLN   0              /* length of one volume entry,
				     no volume data in 2d */

/*   edge hierarchy */
#define MCT2HICHLD 0              /* child node in this hierarchy
				     entry */
#define MCT2HIFAT1 (MCT2HICHLD+1) /* first father node in this
				     hierarchy entry , there are 2
				     fathers for each child */
#define MCT2HILVL  (MCT2HIFAT1+2) /* refinement level this entry
				     belongs to */
#define MCT2HIBDMK (MCT2HILVL +1) /* marks if the entry makes use of
				     dirichlet nodes (yes==1, no==0) */
#define MCT2HILN   (MCT2HIBDMK+1) /* length of one hierarchy entry */

/*   element oriented hierarchy */
#define MCT2EHFAT1 0              /* father nodes (T2 => 6),
				     numbered as: 

				     2
				     |\
				     5 4
				     |  \
				     0-3-1
				  */
#define MCT2EHCHL1 (MCT2EHFAT1+6) /* child nodes (T2 => 9),
				     numbered as: (F marks fahter nodes)

				     F2
				     | \
				     6  8
				     |   \
				     F5-7-F4
				     | \  | \
				     2  1 4  3
				     |   \|   \
				     F0-0-F4-5-F1
				  */
#define MCT2EHLVL  (MCT2EHCHL1+9) /* refinement level this entry
				     belongs to */
#define MCT2EHLN   (MCT2EHLVL +1) /* length of one hierarchy entry */


/*   boundary */
#define MCT2BDEDGE 0              /* corresponding edge */
#define MCT2BDTYPE (MCT2BDEDGE+1) /* type of the boundary condition,
				     -1= no BC (but shape segment),
				     1= Dirichlet (e.g. noslip),
				     2= Neumann,
				     3= no stress
				  */
#define MCT2BDFNCT (MCT2BDTYPE+1) /* function for boundary condition 
				     (if applicable), points into the
				     function field */
#define MCT2BDORIE (MCT2BDFNCT+1) /* orinetation of the corresponding
				     edge, scalar= 1 or -1 such that
				     ORIE*[0,-1;1,0]*(node2-node1)
				     is a OUTward vector */
#define MCT2BDSSEG (MCT2BDORIE+1) /* marks the shape segement entry
				     of this edge, 
				     ==-1 not variable segment,
				     >=0  defines a pointer into sseg */
#define MCT2BDLN   (MCT2BDSSEG+1) /* length of one boundary entry */




#endif
