% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************

function [crit,dcrit]=lid_driv_channel_eval(par);
%
% evaluates the criterion for the cavity with obstacle problem
%
% if par is empty a setup step is done instead, setting global
% variables: par0, Aspar, bspar, Cpar, dpar
%

% problem defining globals, don't change
global nu; global level;
global Aspar; global bspar; global Cpar; global dpar;
global par0;
global histfile;

% changing globals
global last_c; global last_dc;


if isempty(par)
  init=1;

  %level=4;  nu=0.1;
  %level=4;  nu=0.05;
  %level=4;  nu=0.01;
  %level=5;  nu=0.005;
  level,nu
  
  par0=[0.25;0.25];
  
  % for paramters see sketch of mesh, (dx, dy, dy+0.5, dx+0.5, 0.0, 1.0)
  Aspar=[
    1, 0
    0, 1
    0  1
    1, 0
    0, 0
    0, 0];
  bspar=[
    0
    0
    0.5
    0.5
    0
    1];
  
  % upper+lower bound dx, upper+lower bound dy
  Cpar=[
    -1, 0
    +1, 0
    0, -1
    0, +1];
  dpar=[
    0.45
    -0.05
    0.45
    -0.05];
  
  par=par0;
  
  histfile=sprintf('lid_channel_eval_hist_%d_%f.mat',level,nu);
  
  if (exist(histfile,'file'))
    load(histfile);
  else
    par_evals    = zeros(length(par0),0);
    crit_evals   = cell(10,1);
    dcrit_evals  = cell(10,1);
    save(histfile,'-MAT','par_evals','crit_evals','dcrit_evals');
  end

  [crit,dcrit]=internal_eval(par);
else
  init=0;
  
  % before we do an eval, test if the constraints are in their
  % tollerances
  gin=Cpar*par+dpar;
  if sum(gin<-1e-3)>0
    disp('constraints violation, penalisation')
    
    crit=last_c+abs(last_c);
    dcrit=-last_dc;
    return;
  end

  
    
  % evaluation
  [crit,dcrit]=internal_eval(par);
end
  

f_eval=crit
dcrit=dcrit';

% save last successful eval;
last_c  = crit;
last_dc = dcrit;

return




function [crit,dcrit]=internal_eval(par);

global histfile;
global nu; global level;
global Aspar; global bspar; 

load(histfile);
nth=size(par_evals,2);
found=-1;

for i=1:nth
  if (norm(par-par_evals(:,i))<1e-13)
    found=i;
  end
end

if (found==-1)
  % new eval
  
  % generate mesh
  pfile=fopen('visual/lid_channel_eval_par.txt','w');
  fprintf(pfile,'%18.15f \n %18.15f \n %21.15e\n',par(1),par(2),nu);
  fclose(pfile);
  !(cd visual/; cat lid_channel_eval_par.txt |xargs ./lid_driv_channel.f1m_sh; cd ..)

  args=fopen('visual/lid_channel_eval_args.txt','w');
  fprintf(args,'%d \n',1+level); fclose(args);

  % solve
  !cat visual/lid_channel_eval_args.txt | xargs ./test_navsto_solver_running visual/lid_driv_channel.f1m 1 >>visual/solver_out|| rm visual/lid_driv_channel.f1m_[cg]*
  
  % see if this was successful
  if (~exist('visual/lid_driv_channel.f1m_crit','file'))
    par
    error('the solver failed for par, see above');
  else
    % new evaluation
    crit=load('visual/lid_driv_channel.f1m_crit');

    dc_dspar=load('visual/lid_driv_channel.f1m_grad');
    
    dcrit = Aspar'*dc_dspar;
  end

  % build and maintain a database of successful evaluations
  par_evals    = [par_evals,    par    ];

  nth=size(par_evals,2);
  crit_evals{nth}  = crit;
  dcrit_evals{nth} = dcrit;

  save(histfile,'-MAT','par_evals','crit_evals','dcrit_evals');
else
  % been there, done that
  disp('use old, avoid evaluation')
  crit    = crit_evals{found};
  dcrit   = dcrit_evals{found};
end

return;
