/**********************************************************/
/*                                                        */
/*                                                        */
/*                                                        */
/*                                                        */
/*  this demo shows how to include timedependent          */
/*  adaptive finite element in 2d                         */
/*  (the under lying data is a sequence of pre            */
/*   and post geometries)                                 */
/*                                                        */
/*                                                        */
/**********************************************************/

#include "grape.h"
#include <stdlib.h>

static MATRIX44 perspec = {{1.0,0.0,0.0,0.0},
		           {0.0,1.0,0.0,0.0},
		           {0.0,0.0,1.0,0.0},
		           {0.0,0.0,0.0,1.0}};


main()
     
{ 

  extern FE2D *fe2d_read_ebsel_2d();

  TIMESCENE *tsc,*tsc2;
  SCENE *s1,*s2;
  FE2D *fe_post,*fe_pre,*fe_h;
  int start_time,frac_time,end_time;
  float main_time,zrange,fact;
  char czrange[10],cfact[10],path[50];
  char name_pre[50],name_post[50];  

/*  staticvect3.rgbdegfine float white[3] = {1.0,1.0,1.0}; */

  MANAGER *mgr;
  BUTTON *butpv;
  GRAPHICDEVICE *dev;


/*  printf("z range : ");
  scanf("%c",czrange); 
  if(czrange[0] != '\n'){
    gets(czrange+1); 
    zrange=atof(czrange);
  }       
  else zrange=4; */
  zrange = 4;
  perspec[2][2] = 1/zrange;
  printf("\n");
  /* printf("file format : dir/flow_pre?.dat dir/flow_post?.dat\n");
     printf("path <dir/flow_> : ");
     scanf("%c",path);
     if(path[0] != '\n') gets(path+1); 
     else /* */
  strcpy(path, "visual/2d_mesh_grape_");
  printf("\n");
  fact=1;
  printf("\n");
  start_time=0.0; end_time=0.0;
  /*   printf("start time , end time :");
       scanf("%d %d", &start_time, &end_time);*/
  printf("\n");

  
  GRAPE(Fe2d,"add-method")("read-ebsel-2d",fe2d_read_ebsel_2d);
  
  tsc = (TIMESCENE *)GRAPE(TimeScene,"new-instance")("tsc test");
  for(frac_time = start_time;frac_time<=end_time;frac_time++) {

    main_time = fact * (frac_time - start_time);
    sprintf(name_pre,"%spre%d.dat",path,frac_time);
    sprintf(name_post,"%spost%d.dat",path,frac_time);
    printf("read %s %s\n",name_pre,name_post);

    if(frac_time == start_time) {
      printf("read %s\n",name_post);
      fe_h = fe_post = (FE2D *)GRAPE(Fe2d,"read-ebsel-2d")
	                            ("fe2d-post",name_post,1);
      ASSURE(fe_post,"can't read ebsel 2d fe",exit(1));
      tsc->dynamic = (INSTANCE *)GRAPE(TimeStep,"put")
	                              (fe_post,fe_post,main_time);
      /*GRAPE(fe_post, "vect-disp")(); /* no idea where this should go */ 
    }
    else {
      if(frac_time == end_time) {
	printf("read %s\n",name_pre);
	fe_pre = (FE2D *)GRAPE(Fe2d,"read-ebsel-2d") 
	  ("fe2d-pre",name_pre,0);
	ASSURE(fe_pre,"can't read ebsel 2d fe",exit(1));
	fe_pre->x = fe_h->x;
	fe_pre->y = fe_h->y;
	fe_pre->vertex = fe_h->vertex;
	fe_pre->neighbour = fe_h->neighbour;
	tsc->dynamic = (INSTANCE *)GRAPE(tsc->dynamic,"put")
	  (fe_pre,fe_pre,main_time);

	
      }
      else {
	printf("read %s %s\n",name_pre,name_post);
	fe_pre = (FE2D *)GRAPE(Fe2d,"read-ebsel-2d") 
	  ("fe2d-pre",name_pre,0);
	fe_pre->x = fe_h->x;
	fe_pre->y = fe_h->y;

	fe_pre->vertex = fe_h->vertex;
	fe_pre->neighbour = fe_h->neighbour;
	ASSURE(fe_pre,"can't read ebsel 2d fe",exit(1));
	fe_h = fe_post = (FE2D *)GRAPE(Fe2d,"read-ebsel-2d")
	  ("fe2d-post",name_post,1);
	ASSURE(fe_post,"can't read ebsel 2d fe",exit(1));

	printf("nop,not (pre , post) : (%d , %d) (%d , %d)\n",
	       fe_pre->number_of_points,
	       fe_post->number_of_points,
	       fe_pre->number_of_elements,
	       fe_post->number_of_elements);

	tsc->dynamic = (INSTANCE *)GRAPE(tsc->dynamic,"put")
	  (fe_pre,fe_post,main_time);
	
      }
    }
  } 


  dev = (GRAPHICDEVICE *)GRAPE(GraphicDevice,"get-stddev")();
  mgr = (MANAGER *)GRAPE(Manager,"get-stdmgr")();

  GRAPE(mgr,"handle")(tsc) ; 



}
