/***********************************************************************

    This file is part of
    FEINS, Finite Element Incompressible Navier-Stokes solver,
    which is expanding to a more general FEM solver and toolbox,
    Copyright (C) 2003--2008, Rene Schneider 
    <rene.schneider@mathematik.tu-chemnitz.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.

    Minor contributions to this program (for example bug-fixes and
    minor extensions) by third parties automatically transfer the
    copyright to the general author of FEINS, to maintain the
    possibility of commercial re-licensing. If you contribute but wish
    to keep the copyright of your contribution, make that clear in
    your contribution!

    Non-GPL licenses to this program are available upon request from
    the author.

************************************************************************/
/*
gen_aux.h
*/
#ifndef __GEN_AUX_H__
#define __GEN_AUX_H__ 1



#include "feins_macros.h"

#include "sparse_struct.h"


int gen_proj_bpx_tx(void *notused, struct vector *in,
		    void *arg3, struct vector *out
/* performs boundary condition projection and BPX preconditioning 
     out = P*C^{-1}*P^T in
   where C^{-1} is the BPX preconditioner sum(l=level)Q_l*D_l*Q_l^T 
   and P a project
   
   Input:  notused - well, it is not used but in the interface to
                     allow this function to be used as a
                     preconditioner
           in      - input vector
	   arg3=
           bpx     - struct bpxdata containing pointers to the mesh
                     a multilevel struct, a multilevel help vector,
		     and a projector1

   Output: out    - (given by reference), P*P^T* in

   Return: SUCCESS - success,
           FAIL    - failure, see error message
*/);

int gen_proj_MG_tx(void *arg1, struct vector *in,
		   void *arg3, struct vector *out
/* performs the boudary condition projection and multigrid
   preconditioning, 
     out = P*C^-1*P^T * in
   where P projects the velocity components of boundary nodes to zero,
   (such that addition of a projected vector doesn't change the
   velocity there), and C^-1 repressents the action of the multigrid
   preconditioning, that is one V cycle
   
   Input:  arg1    - not used, in the interface for compatibility reasons
           in      - input vector
	   arg3=
	   mg      - mgdata struct, containing everything needed for
	             the projection and multigrid

   Output: out    - (given by reference), P*C^-1P^T* in

   Return: SUCCESS - success,
           FAIL    - failure, see error message
*/);
#endif
