#ifndef FEINS_LAPACK_H
#define FEINS_LAPACK_H

extern "C" {
/* BLAS stuff: */
void dgemm_ ( char *transa, char *transb, int *m, int *n, int *k,
	      double *alpha,  double *a,  int *lda,
	      double *b,  int *ldb,
	      double *beta, double *c, int *ldc );

/* LAPACK stuff: */

void dpbtrf_ ( char *UPLO, int *N, int *KD, double *AB, int *LDAB,
	       int *INFO );

void dpbtrs_ ( char *UPLO, int *N, int *KD, int *NRHS,
	       double *AB, int *LDAB, double *B, int *LDB, int *INFO );

void dgbtrf_ ( int *M, int *N, int *KL, int *KU, double *AB, int *LDAB,
	       int *IPIV, int *INFO );

void dgbtrs_ ( char *TRANS, int *N, int *KL, int *KU, int *NRHS,
	       double *AB, int *LDAB, int *IPIV, double *B, int *LDB,
	       int *INFO );

/* DGESV( N, NRHS, A, LDA, IPIV, B, LDB, INFO ) */
void dgesv_( int* N, int* NRHS, double* A, int* LDA, int* IPIV,
	     double* B, int* LDB, int* INFO );

}

#endif
