% ***********************************************************************
%
%    This file is part of
%    FEINS, Finite Element Incompressible Navier-Stokes solver,
%    which is expanding to a more general FEM solver and toolbox,
%    Copyright (C) 2003--2008, Rene Schneider 
%    <rene.schneider@mathematik.tu-chemnitz.de>
% 
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
% 
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
% 
%    You should have received a copy of the GNU General Public License
%    along with this program. If not, see <http://www.gnu.org/licenses/>.
%
%    Minor contributions to this program (for example bug-fixes and
%    minor extensions) by third parties automatically transfer the
%    copyright to the general author of FEINS, to maintain the
%    possibility of commercial re-licensing. If you contribute but wish
%    to keep the copyright of your contribution, make that clear in
%    your contribution!
% 
%    Non-GPL licenses to this program are available upon request from
%    the author.
%
% ***********************************************************************

%elements:
el=0;
elem=[ 0,0,0, 0,0,0];
% loop rows, collums
for i=0:3
  for j=0:3
    type=1;
    if i>=2
      type=-type;
    end
    if j>=2
      type=-type;
    end

    ij=i*5+j;
    if type==1
      el1=[ij, ij+1, ij+6];
      el2=[ij, ij+5, ij+6];
    else
      el1=[ij, ij+1, ij+5];
      el2=[ij+1, ij+5, ij+6];
    end
    
    elem=[elem;[el, 1, -1, el1]]; el=el+1;
    elem=[elem;[el, 1, -1, el2]]; el=el+1;
  end
end
%disp(elem);

%points:
eps=0.25e-1;
p=[ 0, eps, 0.5, 1-eps, 1];

vx=0;
for i=1:5
  for j=1:5
    disp(sprintf('  %2d     %e   %e', vx, p(j), 1-p(i)));
    vx=vx+1;
  end
end

%>> pcvol=[0:31;zeros(1,32); 0:31]'
